/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GradleReRunBuildFilter
implements Filter {
    protected final String myBuildWorkingDir;
    private String line;
    private List<Filter.ResultItem> links;
    private int lineStart;

    public GradleReRunBuildFilter(String buildWorkingDir) {
        this.myBuildWorkingDir = buildWorkingDir;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        if (line == null) {
            return null;
        }
        this.line = line;
        this.lineStart = entireLength - line.length();
        this.links = new ArrayList<Filter.ResultItem>();
        String trimLine = line.trim();
        if (!trimLine.contains("Run with --") || !trimLine.endsWith("option to get the stack trace.") && !trimLine.endsWith("option to get more log output.")) {
            return null;
        }
        this.addLinkIfMatch("Run with --stacktrace", "--stacktrace");
        this.addLinkIfMatch("Run with --info", "--info");
        this.addLinkIfMatch("Run with --debug option", "--debug");
        this.addLinkIfMatch("--debug option", "--debug");
        if (this.links.isEmpty()) {
            return null;
        }
        return new Filter.Result(this.links);
    }

    @NotNull
    protected abstract HyperlinkInfo getHyperLinkInfo(List<String> var1);

    private void addLinkIfMatch(@NotNull String text, @NotNull String option) {
        int index;
        if (text == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(0);
        }
        if (option == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(1);
        }
        if ((index = this.line.indexOf(text)) != -1) {
            this.links.add(this.createLink(this.lineStart + index, this.lineStart + index + text.length(), option));
        }
    }

    @NotNull
    private Filter.ResultItem createLink(int start, int end, @NotNull String option) {
        if (option == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(2);
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add(option);
        Filter.ResultItem resultItem = new Filter.ResultItem(start, end, this.getHyperLinkInfo(options));
        if (resultItem == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(3);
        }
        return resultItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/filters/GradleReRunBuildFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/filters/GradleReRunBuildFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLinkIfMatch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLink";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

