/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Bytecode;
import com.intellij.zkm.bytecode.ClassProvider;
import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.InvocationReader;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.SignatureReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class BytecodeImpl
implements Bytecode {
    private final ClassProvider myClassProvider;
    private final SignatureReader mySignatureReader;
    private final InvocationReader myInvocationReader;
    private final Map<String, Map<Integer, Set<Signature>>> mySignaturesCache;
    private final Map<String, Map<String, Map<Integer, Map<Signature, Set<Invocation>>>>> myInvocationsCache;

    BytecodeImpl(@NotNull ClassProvider classProvider, @NotNull SignatureReader signatureReader, @NotNull InvocationReader invocationReader) throws IOException {
        if (classProvider == null) {
            BytecodeImpl.$$$reportNull$$$0(0);
        }
        if (signatureReader == null) {
            BytecodeImpl.$$$reportNull$$$0(1);
        }
        if (invocationReader == null) {
            BytecodeImpl.$$$reportNull$$$0(2);
        }
        this.mySignaturesCache = new HashMap<String, Map<Integer, Set<Signature>>>();
        this.myInvocationsCache = new HashMap<String, Map<String, Map<Integer, Map<Signature, Set<Invocation>>>>>();
        this.myClassProvider = classProvider;
        this.mySignatureReader = signatureReader;
        this.myInvocationReader = invocationReader;
    }

    @Override
    public boolean contains(@NotNull String className) {
        if (className == null) {
            BytecodeImpl.$$$reportNull$$$0(3);
        }
        return this.mySignaturesCache.containsKey(className) || this.myInvocationsCache.containsKey(className) || this.myClassProvider.contains(className);
    }

    @Override
    @NotNull
    public Set<Signature> getSignaturesAt(@NotNull String className, int lineNumber) throws IOException {
        Map<Integer, Set<Signature>> lineToSignatures;
        if (className == null) {
            BytecodeImpl.$$$reportNull$$$0(4);
        }
        if ((lineToSignatures = this.mySignaturesCache.get(className)) == null) {
            lineToSignatures = this.readSignatures(className);
            this.mySignaturesCache.put(className, lineToSignatures);
        }
        Set<Signature> set = Collections.unmodifiableSet(lineToSignatures.getOrDefault(lineNumber, Collections.emptySet()));
        if (set == null) {
            BytecodeImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    private Map<Integer, Set<Signature>> readSignatures(String className) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(this.myClassProvider.getInputStream(className));){
            Map<Integer, Set<Signature>> map = this.mySignatureReader.read(stream);
            return map;
        }
    }

    @Override
    @NotNull
    public Map<Signature, Set<Invocation>> getInvocationsAt(@NotNull String className, @NotNull String methodName, int lineNumber) throws IOException {
        Map lineToInvocations;
        Map<Signature, Set<Invocation>> invocations;
        if (className == null) {
            BytecodeImpl.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            BytecodeImpl.$$$reportNull$$$0(7);
        }
        if ((invocations = (Map<Signature, Set<Invocation>>)(lineToInvocations = this.myInvocationsCache.computeIfAbsent(className, k -> new HashMap()).computeIfAbsent(methodName, k -> new HashMap())).get(lineNumber)) == null) {
            invocations = this.readInvocationsAt(className, methodName, lineNumber);
            lineToInvocations.put(lineNumber, invocations);
        }
        Map<Signature, Set<Invocation>> map = Collections.unmodifiableMap(invocations);
        if (map == null) {
            BytecodeImpl.$$$reportNull$$$0(8);
        }
        return map;
    }

    private Map<Signature, Set<Invocation>> readInvocationsAt(@NotNull String className, @NotNull String methodName, int lineNumber) throws IOException {
        if (className == null) {
            BytecodeImpl.$$$reportNull$$$0(9);
        }
        if (methodName == null) {
            BytecodeImpl.$$$reportNull$$$0(10);
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.myClassProvider.getInputStream(className));){
            Map<Signature, Set<Invocation>> map = this.myInvocationReader.read(stream, methodName, lineNumber);
            return map;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationReader";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/BytecodeImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/BytecodeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesAt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvocationsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesAt";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInvocationsAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readInvocationsAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

