/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.Modifier;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.TypeFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class BytecodeReader {
    private final TypeFactory myTypes;

    protected BytecodeReader(@NotNull TypeFactory types) {
        if (types == null) {
            BytecodeReader.$$$reportNull$$$0(0);
        }
        this.myTypes = types;
    }

    protected Invocation createInvocation(String owner, String name, String description) {
        String ownerType = jdk.internal.org.objectweb.asm.Type.getObjectType(owner).getClassName();
        String returnType = jdk.internal.org.objectweb.asm.Type.getReturnType(description).getClassName();
        List<Type> parameterTypes = Arrays.stream(jdk.internal.org.objectweb.asm.Type.getArgumentTypes(description)).map(jdk.internal.org.objectweb.asm.Type::getClassName).map(this.myTypes::create).collect(Collectors.toList());
        return new Invocation(this.myTypes.create(ownerType), this.myTypes.create(returnType), name, parameterTypes);
    }

    protected Signature createSignature(int access, @NotNull String name, @NotNull String desc) {
        if (name == null) {
            BytecodeReader.$$$reportNull$$$0(1);
        }
        if (desc == null) {
            BytecodeReader.$$$reportNull$$$0(2);
        }
        String returnType = jdk.internal.org.objectweb.asm.Type.getReturnType(desc).getClassName();
        List<Type> parameterTypes = Arrays.stream(jdk.internal.org.objectweb.asm.Type.getArgumentTypes(desc)).map(jdk.internal.org.objectweb.asm.Type::getClassName).map(this.myTypes::create).collect(Collectors.toList());
        return new Signature(BytecodeReader.createModifier(access), this.myTypes.create(returnType), name, parameterTypes);
    }

    private static Set<Modifier> createModifier(int access) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if ((access & 1) != 0) {
            result.add(Modifier.PUBLIC);
        }
        if ((access & 2) != 0) {
            result.add(Modifier.PRIVATE);
        }
        if ((access & 4) != 0) {
            result.add(Modifier.PROTECTED);
        }
        if ((access & 8) != 0) {
            result.add(Modifier.STATIC);
        }
        if ((access & 0x10) != 0) {
            result.add(Modifier.FINAL);
        }
        if ((access & 0x20) != 0) {
            result.add(Modifier.SYNCHRONIZED);
        }
        if ((access & 0x400) != 0) {
            result.add(Modifier.ABSTRACT);
        }
        if ((access & 0x1000) != 0) {
            result.add(Modifier.SYNTHETIC);
        }
        if ((access & 0x40) != 0) {
            result.add(Modifier.BRIDGE);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/zkm/bytecode/BytecodeReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

