/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.FormatException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Line {
    private String myClassName;
    private String mySourceFile;
    private String myMethodName;
    private int myLineNumber;

    Line(@NotNull String className, @Nullable String sourceFile, @NotNull String methodName, int lineNumber) {
        if (className == null) {
            Line.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            Line.$$$reportNull$$$0(1);
        }
        this.myClassName = className;
        this.mySourceFile = sourceFile;
        this.myMethodName = methodName;
        this.myLineNumber = lineNumber;
    }

    @NotNull
    String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            Line.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    String getSourceFile() {
        return this.mySourceFile;
    }

    @NotNull
    String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            Line.$$$reportNull$$$0(3);
        }
        return string;
    }

    int getLineNumber() {
        return this.myLineNumber;
    }

    @NotNull
    String format() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tat ");
        builder.append(this.myClassName);
        builder.append('.');
        builder.append(this.myMethodName);
        if (this.mySourceFile != null) {
            builder.append('(');
            builder.append(this.mySourceFile);
            if (this.myLineNumber >= 0) {
                builder.append(':');
                builder.append(this.myLineNumber);
            }
            builder.append(')');
        }
        String string = builder.toString();
        if (string == null) {
            Line.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    static Line parse(@NotNull String s) throws FormatException {
        int indent;
        if (s == null) {
            Line.$$$reportNull$$$0(5);
        }
        if (Line.contains(s, indent = Line.indentOf(s), "at ")) {
            int lineNumber;
            String sourceFile;
            int closeParenIndex = s.charAt(s.length() - 1) == ')' ? s.length() - 1 : -1;
            int openParenIndex = closeParenIndex == -1 ? -1 : s.lastIndexOf(40, closeParenIndex - 1);
            int colonIndex = closeParenIndex == -1 ? -1 : s.indexOf(58, openParenIndex + 1);
            int lastDotIndex = s.lastIndexOf(46, openParenIndex == -1 ? s.length() : openParenIndex - 1);
            if (lastDotIndex == -1) {
                throw new FormatException("Cannot find class / method separator dot: " + s);
            }
            String className = s.substring(indent + 3, lastDotIndex);
            String methodName = s.substring(lastDotIndex + 1, openParenIndex == -1 ? s.length() : openParenIndex);
            String string = openParenIndex == -1 ? null : (sourceFile = s.substring(openParenIndex + 1, colonIndex == -1 ? closeParenIndex : colonIndex));
            if (colonIndex == -1) {
                lineNumber = -1;
            } else {
                String number = s.substring(colonIndex + 1, closeParenIndex);
                try {
                    lineNumber = Integer.parseInt(number);
                }
                catch (NumberFormatException e) {
                    throw new FormatException("Cannot parse line number: " + number);
                }
            }
            return new Line(className, sourceFile, methodName, lineNumber);
        }
        return null;
    }

    private static int indentOf(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }

    private static boolean contains(String line, int i, String s) {
        return line.length() >= i + s.length() && line.substring(i, i + s.length()).equals(s);
    }

    public String toString() {
        return this.format();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/Line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/Line";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

