/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Bytecode;
import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ClassData;
import com.intellij.zkm.bytecode.FormatException;
import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.Line;
import com.intellij.zkm.bytecode.Named;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.TranslationException;
import com.intellij.zkm.bytecode.Translator;
import com.intellij.zkm.bytecode.Utilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

class TranslatorImpl
implements Translator {
    private static final String AT_PREFIX = "\tat ";
    private static final String CAUSED_BY_PREFIX = "Caused by: ";
    private static final String LAMBDA_NAME_PREFIX = "lambda$";
    private static final String METHOD_SEPARATOR = "|";
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r?\n");
    private final Changelog myChangelog;
    private final Bytecode myBytecode;
    private final boolean myCombineNames;

    TranslatorImpl(@NotNull Changelog changelog, @NotNull Bytecode bytecode) {
        if (changelog == null) {
            TranslatorImpl.$$$reportNull$$$0(0);
        }
        if (bytecode == null) {
            TranslatorImpl.$$$reportNull$$$0(1);
        }
        this(changelog, bytecode, true);
    }

    TranslatorImpl(@NotNull Changelog changelog, @NotNull Bytecode bytecode, boolean combineNames) {
        if (changelog == null) {
            TranslatorImpl.$$$reportNull$$$0(2);
        }
        if (bytecode == null) {
            TranslatorImpl.$$$reportNull$$$0(3);
        }
        this.myChangelog = changelog;
        this.myBytecode = bytecode;
        this.myCombineNames = combineNames;
    }

    @Override
    @NotNull
    public String translate(@NotNull String stacktrace) throws TranslationException {
        if (stacktrace == null) {
            TranslatorImpl.$$$reportNull$$$0(4);
        }
        String[] input = Utilities.split(stacktrace, LINE_SEPARATOR_PATTERN);
        LineData[] output = new LineData[input.length];
        this.translateExceptionClassNames(input);
        try {
            for (int i = 0; i < input.length; ++i) {
                Line line = Line.parse(input[i]);
                if (line == null) continue;
                output[i] = this.translate(line);
            }
            this.narrow(output);
        }
        catch (FormatException | IOException e) {
            throw new TranslationException(e);
        }
        String string = TranslatorImpl.format(input, output);
        if (string == null) {
            TranslatorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void translateExceptionClassNames(String[] lines) {
        boolean atLine = false;
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (line.startsWith(AT_PREFIX)) {
                atLine = true;
                continue;
            }
            if (!atLine) continue;
            String translation = this.translateExceptionClassName(line);
            if (translation != null) {
                lines[i] = translation;
            }
            atLine = false;
        }
    }

    private String translateExceptionClassName(String line) {
        String className;
        String prefix = line.startsWith(CAUSED_BY_PREFIX) ? line.substring(0, 11) : "";
        int colonIndex = line.indexOf(58, prefix.length() + 1);
        String string = className = colonIndex == -1 ? line.substring(prefix.length()) : line.substring(prefix.length(), colonIndex);
        if (className.contains(" ")) {
            return null;
        }
        ClassData data = this.myChangelog.getClassData(className);
        if (data == null || data.getClassName() == null) {
            return null;
        }
        String suffix = colonIndex == -1 ? "" : line.substring(colonIndex);
        return prefix + data.getClassName() + suffix;
    }

    private LineData translate(Line line) throws IOException {
        ClassData data = this.myChangelog.getClassData(line.getClassName());
        if (data != null) {
            Set<Signature> intersection;
            Set<Signature> bytecodeSignatures;
            int lineNumber;
            int dataLineNumber = data.getLineNumber(line.getLineNumber());
            String className = data.getClassName() == null ? line.getClassName() : data.getClassName();
            Set<Signature> signatures = data.getSignatures(line.getMethodName());
            String sourceFile = data.getSourceFile() == null ? line.getSourceFile() : data.getSourceFile();
            int n = lineNumber = dataLineNumber == -1 ? line.getLineNumber() : dataLineNumber;
            if (signatures.size() > 1 && this.myBytecode.contains(className) && lineNumber >= 0 && (bytecodeSignatures = this.myBytecode.getSignaturesAt(className, lineNumber)).size() > 0 && (intersection = Utilities.intersection(signatures, bytecodeSignatures)).size() > 0) {
                signatures = intersection;
            }
            return signatures.size() == 0 ? new LineData(className, line.getMethodName(), sourceFile, lineNumber) : new LineData(className, signatures, sourceFile, lineNumber);
        }
        return new LineData(line.getClassName(), line.getMethodName(), line.getSourceFile(), line.getLineNumber());
    }

    private void narrow(LineData[] lines) throws IOException {
        HashSet<Integer> indices = new HashSet<Integer>(lines.length);
        IntStream.range(0, lines.length).forEach(indices::add);
        while (!indices.isEmpty()) {
            LineData nextLine;
            LineData previousLine;
            int i = (Integer)indices.iterator().next();
            indices.remove(i);
            LineData line = i >= 0 && i < lines.length ? lines[i] : null;
            if (line == null || !line.isAmbiguous()) continue;
            boolean neighborsAdded = false;
            LineData lineData = previousLine = i < lines.length - 1 ? lines[i + 1] : null;
            if (previousLine != null && line.narrowByPreviousLine(previousLine)) {
                indices.add(i - 1);
                indices.add(i + 1);
                neighborsAdded = true;
            }
            if (!line.isAmbiguous() || (nextLine = i > 0 ? lines[i - 1] : null) == null || !line.narrowByNextLine(nextLine) || neighborsAdded) continue;
            indices.add(i - 1);
            indices.add(i + 1);
        }
    }

    @NotNull
    private static String format(String[] input, LineData[] output) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (output[i] != null) {
                result.append(output[i].toLine().format());
            } else {
                result.append(input[i]);
            }
            result.append('\n');
        }
        String string = result.toString();
        if (string == null) {
            TranslatorImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelog";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytecode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/TranslatorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/TranslatorImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LineData {
        private final boolean myScrambled;
        private final String myClassName;
        private final String myMethodName;
        private final Set<Signature> mySignatures;
        private final String mySourceFile;
        private final int myLineNumber;

        LineData(String className, String methodName, String sourceFile, int lineNumber) {
            this.myScrambled = false;
            this.myClassName = className;
            this.myMethodName = methodName;
            this.mySignatures = new HashSet<Signature>();
            this.mySourceFile = sourceFile;
            this.myLineNumber = lineNumber;
        }

        LineData(String className, Set<Signature> signatures, String sourceFile, int lineNumber) {
            this.myScrambled = true;
            this.myClassName = className;
            this.myMethodName = null;
            this.mySignatures = new HashSet<Signature>(signatures);
            this.mySourceFile = sourceFile;
            this.myLineNumber = lineNumber;
        }

        boolean isAmbiguous() {
            return this.myScrambled && this.mySignatures.size() > 1;
        }

        boolean hasBytecode() {
            return TranslatorImpl.this.myBytecode.contains(this.myClassName);
        }

        private Set<Signature> getSignatures() throws IOException {
            return this.myScrambled ? this.mySignatures : TranslatorImpl.this.myBytecode.getSignaturesAt(this.myClassName, this.myLineNumber);
        }

        private Set<String> getMethodNames() {
            return this.myScrambled ? this.mySignatures.stream().map(Signature::getName).collect(Collectors.toSet()) : Collections.singleton(this.myMethodName);
        }

        Map<Signature, Set<Invocation>> getInvocations() throws IOException {
            ArrayList invocations = new ArrayList();
            for (String methodName : this.getMethodNames()) {
                invocations.add(TranslatorImpl.this.myBytecode.getInvocationsAt(this.myClassName, methodName, this.myLineNumber));
            }
            return Utilities.merge(invocations).entrySet().stream().filter(this.myScrambled ? entry -> this.mySignatures.contains(entry.getKey()) : entry -> true).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        boolean narrowByPreviousLine(LineData previousLine) throws IOException {
            return this.narrow(previousLine.narrowNextSignatures(this.mySignatures));
        }

        boolean narrowByNextLine(LineData nextLine) throws IOException {
            if (!this.hasBytecode()) {
                return false;
            }
            Map<Signature, Set<Invocation>> invocations = this.getInvocations();
            HashSet<Signature> signatures = new HashSet<Signature>();
            for (Map.Entry<Signature, Set<Invocation>> entry : invocations.entrySet()) {
                if (nextLine.narrowPreviousInvocations(entry.getValue()).isEmpty()) continue;
                signatures.add(entry.getKey());
            }
            return this.narrow(signatures);
        }

        private boolean narrow(Set<Signature> signatures) {
            if (signatures.size() > 0 && signatures.size() < this.mySignatures.size()) {
                this.mySignatures.retainAll(signatures);
                return true;
            }
            return false;
        }

        private Set<Signature> narrowNextSignatures(Set<Signature> signatures) throws IOException {
            if (this.hasBytecode()) {
                Set unmatchedInvocations;
                Set invocations = Utilities.flatten(this.getInvocations().values());
                Set<Signature> matchedSignatures = signatures.stream().filter(signature -> invocations.stream().anyMatch(invocation -> invocation.conforms((Signature)signature))).collect(Collectors.toSet());
                Set<Signature> lambdaSignatures = this.filterLambdaSignatures(signatures);
                if (!lambdaSignatures.isEmpty() && !(unmatchedInvocations = invocations.stream().filter(invocation -> signatures.stream().noneMatch(invocation::conforms)).collect(Collectors.toSet())).isEmpty()) {
                    matchedSignatures.addAll(lambdaSignatures);
                }
                return matchedSignatures;
            }
            return signatures;
        }

        private Set<Invocation> narrowPreviousInvocations(Set<Invocation> invocations) throws IOException {
            if (this.myScrambled || this.hasBytecode()) {
                Set<Signature> signatures = this.getSignatures();
                Set<Invocation> matchedInvocations = invocations.stream().filter(invocation -> signatures.stream().anyMatch(invocation::conforms)).collect(Collectors.toSet());
                if (!this.filterLambdaSignatures(signatures).isEmpty()) {
                    Set unmatchedInvocations = invocations.stream().filter(invocation -> signatures.stream().noneMatch(invocation::conforms)).collect(Collectors.toSet());
                    matchedInvocations.addAll(unmatchedInvocations);
                }
                return matchedInvocations;
            }
            Set<Invocation> matchedInvocations = invocations.stream().filter(invocation -> invocation.conforms(this.myMethodName)).collect(Collectors.toSet());
            if (this.isLambdaName(this.myMethodName)) {
                Set unmatchedInvocations = invocations.stream().filter(invocation -> !invocation.conforms(this.myMethodName)).collect(Collectors.toSet());
                matchedInvocations.addAll(unmatchedInvocations);
            }
            return matchedInvocations;
        }

        private Set<Signature> filterLambdaSignatures(Set<Signature> signatures) {
            return signatures.stream().filter(signature -> this.isLambdaName(signature.getName())).collect(Collectors.toSet());
        }

        private boolean isLambdaName(String methodName) {
            return methodName.startsWith(TranslatorImpl.LAMBDA_NAME_PREFIX);
        }

        Line toLine() {
            if (this.myScrambled) {
                String names = (TranslatorImpl.this.myCombineNames ? new HashSet<String>(Named.namesOf(this.mySignatures)) : Named.namesOf(this.mySignatures)).stream().sorted().collect(Collectors.joining(TranslatorImpl.METHOD_SEPARATOR));
                return new Line(this.myClassName, this.mySourceFile, names, this.myLineNumber);
            }
            return new Line(this.myClassName, this.mySourceFile, this.myMethodName, this.myLineNumber);
        }
    }
}

