/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.utils.PlayBundle;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class PlayParser
implements PsiParser {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == PlayElementTypes.TAG_START) {
                this.parseTag(builder);
            } else if (builder.getTokenType() == PlayElementTypes.END_TAG_START) {
                builder.advanceLexer();
                if (builder.getTokenType() == PlayElementTypes.TAG_NAME) {
                    builder.error(PlayBundle.message("play.parser.start.tag.required", builder.getTokenText()));
                } else {
                    builder.error(PlayBundle.message("play.parser.tag.name.expected", new Object[0]));
                }
            }
            builder.advanceLexer();
        }
        marker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            PlayParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private void parseTag(PsiBuilder builder) {
        this.parseTag(builder, (Stack<String>)new Stack());
    }

    private void parseTag(PsiBuilder builder, @NotNull Stack<String> tagNames) {
        if (tagNames == null) {
            PlayParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker tagMarker = builder.mark();
        if (!this.parseTagName(builder, tagNames)) {
            tagMarker.drop();
            return;
        }
        while (builder.getTokenType() != PlayElementTypes.TAG_END && builder.getTokenType() != PlayElementTypes.CLOSE_TAG && !builder.eof()) {
            if (builder.getTokenType() == PlayElementTypes.ATTR_NAME) {
                this.parseNameValuePair(builder);
                continue;
            }
            if (builder.getTokenType() == PlayElementTypes.TAG_START) {
                builder.error(PlayBundle.message("play.parser.expected.tag.closing.element", tagNames.peek()));
                tagMarker.drop();
                this.parseTag(builder);
                return;
            }
            builder.advanceLexer();
        }
        if (builder.getTokenType() == PlayElementTypes.CLOSE_TAG) {
            this.doneTage(builder, tagNames, tagMarker);
        } else if (builder.getTokenType() == PlayElementTypes.TAG_END) {
            this.parseTagContent(builder, tagNames, tagMarker);
        } else {
            builder.error(PlayBundle.message("play.parser.expected.tag.closing.element", tagNames.peek()));
            tagMarker.drop();
        }
    }

    private void parseTagContent(PsiBuilder builder, Stack<String> tagNames, PsiBuilder.Marker tagMarker) {
        builder.advanceLexer();
        while (!builder.eof()) {
            if (builder.getTokenType() == PlayElementTypes.TAG_START) {
                this.parseTag(builder, tagNames);
                continue;
            }
            if (builder.getTokenType() == PlayElementTypes.END_TAG_START) {
                builder.advanceLexer();
                this.parseClosingTag(builder, tagNames, tagMarker);
                return;
            }
            if (builder.getTokenType() == PlayElementTypes.TAG_END || builder.getTokenType() == PlayElementTypes.CLOSE_TAG) {
                builder.error(PlayBundle.message("play.parser.unexpected.token", new Object[0]));
                tagMarker.drop();
                return;
            }
            builder.advanceLexer();
        }
        builder.error(PlayBundle.message("play.parser.expected.closing.tag", tagNames.peek()));
        tagMarker.drop();
    }

    private boolean parseClosingTag(PsiBuilder builder, Stack<String> tagNames, PsiBuilder.Marker tagMarker) {
        String requiredTagName = (String)tagNames.peek();
        if (builder.getTokenType() == PlayElementTypes.TAG_NAME) {
            if (requiredTagName.equals(builder.getTokenText())) {
                builder.advanceLexer();
                while (builder.getTokenType() != PlayElementTypes.TAG_END && !builder.eof()) {
                    if (builder.getTokenType() != PlayElementTypes.WHITE_SPACE) {
                        builder.error(PlayBundle.message("play.parser.expected.tag.closing.element", requiredTagName));
                        tagMarker.drop();
                        return false;
                    }
                    builder.advanceLexer();
                }
                if (builder.getTokenType() == PlayElementTypes.TAG_END) {
                    this.doneTage(builder, tagNames, tagMarker);
                    return true;
                }
            }
        } else {
            if (builder.getTokenType() == PlayElementTypes.TAG_END) {
                this.doneTage(builder, tagNames, tagMarker);
                return true;
            }
            builder.error(PlayBundle.message("play.parser.closing.tag.name.expected", requiredTagName));
            tagMarker.drop();
            return false;
        }
        builder.error(PlayBundle.message("play.parser.expected.tag.closing.element", requiredTagName));
        tagMarker.drop();
        return false;
    }

    private boolean parseTagName(PsiBuilder builder, Stack<String> tagNames) {
        builder.advanceLexer();
        if (builder.getTokenType() == PlayElementTypes.TAG_NAME && !StringUtil.isEmptyOrSpaces((String)builder.getTokenText())) {
            tagNames.push((Object)builder.getTokenText());
            builder.advanceLexer();
            return true;
        }
        builder.error(PlayBundle.message("play.parser.tag.name.expected", new Object[0]));
        return false;
    }

    private void doneTage(PsiBuilder builder, Stack<String> tagNames, PsiBuilder.Marker tagMarker) {
        if (!tagNames.empty()) {
            builder.advanceLexer();
            tagMarker.done(PlayElementTypes.TAG);
            tagNames.pop();
        } else {
            tagMarker.drop();
        }
    }

    private void parseNameValuePair(PsiBuilder builder) {
        PsiBuilder.Marker nameValueMarker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != PlayElementTypes.COLON) {
            builder.error(PlayBundle.message("play.parser.colon.required", new Object[0]));
            this.dropNameValuePair(builder, nameValueMarker);
            return;
        }
        builder.advanceLexer();
        if (builder.getTokenType() == PlayElementTypes.TAG_EXPRESSION) {
            this.doneNameValuePair(builder, nameValueMarker);
        } else if (builder.getTokenType() == PlayElementTypes.AT) {
            builder.advanceLexer();
            if (builder.getTokenType() == PlayElementTypes.ACTION_SCRIPT) {
                this.doneNameValuePair(builder, nameValueMarker);
            } else {
                this.dropNameValuePair(builder, nameValueMarker);
            }
        } else {
            this.dropNameValuePair(builder, nameValueMarker);
        }
    }

    private void dropNameValuePair(PsiBuilder builder, PsiBuilder.Marker nameValueMarker) {
        builder.error(PlayBundle.message("play.parser.groovy.expression.required", new Object[0]));
        nameValueMarker.drop();
    }

    private void doneNameValuePair(PsiBuilder builder, PsiBuilder.Marker nameValueMarker) {
        builder.advanceLexer();
        nameValueMarker.done(PlayElementTypes.NAME_VALUE_PAIR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/language/PlayParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/language/PlayParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

