/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.rename;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PlayViewControllerRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PlayViewControllerRenameProcessor.$$$reportNull$$$0(0);
        }
        return this.isRenaming(element);
    }

    public boolean isRenaming(PsiElement psiElement) {
        return PlayUtils.hasSecondaryElements(psiElement);
    }

    public void prepareRenaming(PsiElement psiElement, String newName, Map<PsiElement, String> allRenames) {
        if (psiElement instanceof PsiClass) {
            PsiDirectory directory = PlayPathUtils.getCorrespondingDirectory((PsiClass)psiElement);
            if (directory != null) {
                allRenames.put((PsiElement)directory, newName);
            }
        } else if (psiElement instanceof PsiMethod) {
            PsiFile view = PlayPathUtils.getCorrespondingView((PsiMethod)psiElement);
            if (view != null) {
                allRenames.put((PsiElement)view, newName + "." + FileUtilRt.getExtension((String)view.getName()));
            }
        } else if (psiElement instanceof PlayPsiFile) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = PlayPathUtils.getCorrespondingControllerMethods((PsiFile)psiElement)) {
                allRenames.put((PsiElement)method, FileUtil.getNameWithoutExtension((String)newName));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/rename/PlayViewControllerRenameProcessor", "canProcessElement"));
    }
}

