/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebflowIdentifiedGotoSymbolProvider
extends GoToSymbolProvider {
    private static final Function<Flow, Collection<? extends Identified>> IDENTIFIED_ELEMENTS_FUNCTION = flow -> ContainerUtil.concat((List[])new List[]{flow.getActionStates(), flow.getDecisionStates(), flow.getEndStates(), flow.getInlineFlows(), flow.getSubflowStates(), flow.getViewStates()});

    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(0);
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            result.add(identified.getId().getStringValue());
            return true;
        });
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(1);
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            if (Comparing.strEqual((String)name, (String)identified.getId().getStringValue())) {
                result.add(WebflowIdentifiedGotoSymbolProvider.createNavigationItem((DomElement)identified));
            }
            return true;
        });
    }

    protected boolean acceptModule(Module module) {
        return WebflowUtil.isWebFlowAvailable(module);
    }

    private static List<Identified> getIdentifiedElements(Module module) {
        List<Flow> flows = WebflowUtil.getAllFlows(module, Collections.emptyList());
        return ContainerUtil.concat(flows, IDENTIFIED_ELEMENTS_FUNCTION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/webflow/navigation/WebflowIdentifiedGotoSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

