/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HelperFilesLocator {
    private static final String HELPERS_DIR = "helpers";

    @NotNull
    public static File getBundledHelpersDir() {
        String srcDir;
        String jarPath = PathUtil.getJarPathForClass(HelperFilesLocator.class);
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("Not a file (" + jarFile.getAbsolutePath() + ")");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            File file = new File(pluginBaseDir, HELPERS_DIR);
            if (file == null) {
                HelperFilesLocator.$$$reportNull$$$0(0);
            }
            return file;
        }
        if (ApplicationManager.getApplication().isInternal() && new File(srcDir = jarPath.replace("/out/classes/production/JavaScriptLanguage", "/plugins/JavaScriptLanguage/src")).isDirectory()) {
            jarPath = srcDir;
        }
        File file = new File(jarPath, HELPERS_DIR);
        if (file == null) {
            HelperFilesLocator.$$$reportNull$$$0(1);
        }
        return file;
    }

    @NotNull
    public static File getFileRelativeToHelpersDir(@NotNull String relativePath) throws IOException {
        String systemDependentRelativePath;
        File jsDir;
        File file;
        if (relativePath == null) {
            HelperFilesLocator.$$$reportNull$$$0(2);
        }
        if (!(file = new File(jsDir = HelperFilesLocator.getBundledHelpersDir(), systemDependentRelativePath = FileUtil.toSystemDependentName((String)relativePath))).isFile()) {
            throw new IOException("Cannot find " + relativePath + ", not a file " + file.getAbsolutePath());
        }
        File file2 = file;
        if (file2 == null) {
            HelperFilesLocator.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public static String resolvePathForExecution(@NotNull String relativePath) throws ExecutionException {
        String string;
        if (relativePath == null) {
            HelperFilesLocator.$$$reportNull$$$0(4);
        }
        try {
            File file = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath);
            string = file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot locate " + relativePath, (Throwable)e);
        }
        if (string == null) {
            HelperFilesLocator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/HelperFilesLocator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledHelpersDir";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/HelperFilesLocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileRelativeToHelpersDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePathForExecution";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileRelativeToHelpersDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathForExecution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

