/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSCompletionContributor
extends CompletionContributor {
    private static final Logger LOGGER = Logger.getInstance(FlowJSCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(1);
        }
        PsiFile originalFile = parameters.getOriginalFile();
        Project project = originalFile.getProject();
        if (!FlowJSSettingsManager.areOtherServicesEnabled(originalFile)) {
            return;
        }
        FlowJSServerService service = FlowJSServerManager.getService(originalFile);
        if (service == null) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        List<Document> toSave = FlowJSServerService.getUnsavedFlowDocuments(originalFile);
        if (!toSave.isEmpty()) {
            if (FlowJSSettingsManager.isAutoSaveEnabled(project)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FlowJSServerService.saveFiles(toSave);
                    CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                    if (completion != null) {
                        completion.scheduleRestart();
                    }
                });
            }
            return;
        }
        List<JsonObject> requestAnswer = service.getCompletionOfElement(parameters.getOriginalFile(), document, parameters, parameters.getPosition().getContainingFile().getText());
        Map<String, String> names = FlowJSCompletionContributor.parseCompletionAnswer(requestAnswer);
        java.util.HashSet entrySet = ContainerUtil.newHashSet();
        resultSet.runRemainingContributors(parameters, result2 -> entrySet.add(result2.getLookupElement()));
        HashMap entryMap = ContainerUtil.newHashMap();
        entrySet.forEach(element -> entryMap.put(element.getLookupString(), element));
        HashSet elementsToAdd = new HashSet();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            LookupElement element2 = (LookupElement)entryMap.get(entry.getKey());
            if (element2 != null) {
                if (element2 instanceof MutableLookupElement) {
                    ((MutableLookupElement)element2).setBold();
                    ((MutableLookupElement)element2).setPriority((double)JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY.getPriorityValue());
                }
                elementsToAdd.add(element2);
                entryMap.remove(entry.getKey());
                entrySet.remove(element2);
                continue;
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)entry.getKey()).withTypeText(entry.getValue(), false).bold();
            elementsToAdd.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY.getPriorityValue()));
        }
        elementsToAdd.addAll(entrySet);
        FlowJSCompletionContributor.removeIncorrectCompletionElements(parameters.getPosition(), (Set<LookupElement>)elementsToAdd);
        resultSet.addAllElements((Iterable)elementsToAdd);
        resultSet.stopHere();
    }

    private static Map<String, String> parseCompletionAnswer(List<JsonObject> requestAnswer) {
        HashMap<String, String> names = new HashMap<String, String>();
        try {
            JsonObject parse = new JsonObject();
            if (requestAnswer.size() > 0) {
                parse = requestAnswer.get(0).get("result");
            }
            if (parse instanceof JsonArray) {
                for (JsonElement e : (JsonArray)parse) {
                    if (!(e instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)e;
                    names.put(object.get("name").getAsString(), object.get("type").getAsString());
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e);
        }
        return names;
    }

    private static void removeIncorrectCompletionElements(@NotNull PsiElement element, @NotNull Set<LookupElement> results) {
        PsiElement importKeyword;
        if (element == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(2);
        }
        if (results == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((importKeyword = FlowJSCompletionContributor.checkImport(element)) != null) {
            if (ES6ReferenceExpressionsInfo.isTypeImport(importKeyword)) {
                FlowJSCompletionContributor.removeImportSuggestions(results, true);
            } else {
                FlowJSCompletionContributor.removeImportSuggestions(results, false);
            }
        }
    }

    private static void removeImportSuggestions(@NotNull Set<LookupElement> results, boolean isType) {
        if (results == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(4);
        }
        HashSet copyOfSet = new HashSet(results);
        results.forEach(arg_0 -> FlowJSCompletionContributor.lambda$removeImportSuggestions$3(isType, (Set)copyOfSet, arg_0));
        results.clear();
        results.addAll((Collection<LookupElement>)copyOfSet);
    }

    @Nullable
    private static PsiElement checkImport(@NotNull PsiElement element) {
        PsiElement importKeyWord;
        PsiElement importElement;
        if (element == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((importElement = PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class)) != null && (importKeyWord = importElement.getFirstChild()).getNode().getElementType() == JSTokenTypes.IMPORT_KEYWORD) {
            return importKeyWord;
        }
        return null;
    }

    private static /* synthetic */ void lambda$removeImportSuggestions$3(boolean isType, Set copyOfSet, LookupElement element) {
        PsiElement psiElement = element.getPsiElement();
        if (psiElement != null) {
            if (isType) {
                if (!(psiElement instanceof TypeScriptCompileTimeType) && !(psiElement instanceof ES6Class)) {
                    copyOfSet.remove(element);
                }
            } else if (psiElement instanceof TypeScriptTypeAlias) {
                copyOfSet.remove(element);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flow/FlowJSCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIncorrectCompletionElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeImportSuggestions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

