/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestPackageVersionUtil {
    private static final Logger LOG = Logger.getInstance(JestPackageVersionUtil.class);
    private static final Map<String, TimestampedVersion> PACKAGE_VERSION_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, TimestampedVersion>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimestampedVersion> eldest) {
            return this.size() > 10;
        }
    });

    private JestPackageVersionUtil() {
    }

    @Nullable
    public static SemVer getPackageVersion(@NotNull Project project, @NotNull NodePackage pkg) {
        if (project == null) {
            JestPackageVersionUtil.$$$reportNull$$$0(0);
        }
        if (pkg == null) {
            JestPackageVersionUtil.$$$reportNull$$$0(1);
        }
        File packageJsonIoFile = new File(pkg.getSystemDependentPath(), "package.json");
        String path = packageJsonIoFile.getAbsolutePath();
        if (!packageJsonIoFile.isFile()) {
            LOG.info("No such file " + path);
            return null;
        }
        TimestampedVersion data = PACKAGE_VERSION_CACHE.get(path);
        long timestamp = packageJsonIoFile.lastModified();
        if (data == null || data.getTimestamp() != timestamp) {
            SemVer version = JestPackageVersionUtil.calcVersion(project, packageJsonIoFile);
            data = new TimestampedVersion(timestamp, version);
            PACKAGE_VERSION_CACHE.put(path, data);
        }
        return data.getVersion();
    }

    @Nullable
    private static SemVer calcVersion(@NotNull Project project, @NotNull File packageJsonIoFile) {
        VirtualFile packageJson;
        if (project == null) {
            JestPackageVersionUtil.$$$reportNull$$$0(2);
        }
        if (packageJsonIoFile == null) {
            JestPackageVersionUtil.$$$reportNull$$$0(3);
        }
        if (!PackageJsonUtil.isPackageJsonFile(packageJson = LocalFileSystem.getInstance().findFileByIoFile(packageJsonIoFile))) {
            LOG.info("Cannot find virtual file by " + packageJsonIoFile.getAbsolutePath());
            return null;
        }
        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
        if ("jest".equals(data.getName()) || "jest-cli".equals(data.getName())) {
            LOG.info(data.getName() + " version: " + data.getVersion());
            return data.getVersion();
        }
        PackageJsonDependencies deps = PackageJsonDependencies.getOrCreate(project, packageJson);
        if (deps != null) {
            String version = deps.getDependencies().get("jest");
            SemVer semver = SemVer.parseFromText((String)version);
            LOG.info(data.getName() + " has jest dependency version: " + version + " -> " + semver);
            return semver;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonIoFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/jest/JestPackageVersionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TimestampedVersion {
        private final long myTimestamp;
        private final SemVer myVersion;

        private TimestampedVersion(long timestamp, @Nullable SemVer version) {
            this.myTimestamp = timestamp;
            this.myVersion = version;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        @Nullable
        public SemVer getVersion() {
            return this.myVersion;
        }
    }
}

