/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeJsLocalInterpreters", storages={@Storage(file="other.xml", roamingType=RoamingType.DISABLED)})
public class NodeJsLocalInterpreterManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(NodeJsLocalInterpreterManager.class);
    private static final String LOCAL_INTERPRETERS_TAG_NAME = "local-interpreters";
    private static final String LOCAL_INTERPRETER_TAG_NAME = "local-interpreter";
    private static final String PATH_ATTR_NAME = "path";
    public static final String VERSION_CACHE_TAG_NAME = "version-cache";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String VERSION_LAST_MODIFIED_ATTR_NAME = "last-modified";
    private static final String NPM_TAG_NAME = "npm-package";
    private static final String EXCLUDED_ATTR_NAME = "excluded";
    private final ExecutorService myExecutorService;
    private final ConcurrentMap<String, TimestampedSemVer> myVersionCache;
    private final ConcurrentMap<String, Future<SemVer>> myRunningFetches;
    private Set<String> myDetectedInterpreterPaths;
    private List<NodeJsLocalInterpreter> myInterpreters;
    private Set<String> myExcludedInterpreterPaths;
    private volatile Ref<NodeJsLocalInterpreter> myInterpreterFromPathRef;

    public NodeJsLocalInterpreterManager(@NotNull FrameStateManager frameStateManager) {
        if (frameStateManager == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(0);
        }
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeJsLocalInterpreter pool", (int)1);
        this.myVersionCache = ContainerUtil.newConcurrentMap();
        this.myRunningFetches = ContainerUtil.newConcurrentMap();
        this.myExcludedInterpreterPaths = Collections.emptySet();
        frameStateManager.addListener((FrameStateListener)new FrameStateListener.Adapter(){

            public void onFrameDeactivated() {
                NodeJsLocalInterpreterManager.this.myInterpreterFromPathRef = null;
            }
        });
    }

    @NotNull
    public static NodeJsLocalInterpreterManager getInstance() {
        NodeJsLocalInterpreterManager nodeJsLocalInterpreterManager = (NodeJsLocalInterpreterManager)ServiceManager.getService(NodeJsLocalInterpreterManager.class);
        if (nodeJsLocalInterpreterManager == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(1);
        }
        return nodeJsLocalInterpreterManager;
    }

    @Nullable
    public Ref<SemVer> getCachedVersion(@NotNull NodeJsLocalInterpreter interpreter) {
        String interpreterPath;
        TimestampedSemVer tsv;
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(2);
        }
        if ((tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterPath = interpreter.getInterpreterSystemIndependentPath())) != null) {
            File file = new File(interpreterPath);
            if (file.lastModified() == tsv.myLastModified) {
                if (tsv.myVersion == null && tsv.myLoadedFromXml) {
                    this.fetchVersion(interpreter, null);
                }
                return Ref.create((Object)tsv.myVersion);
            }
            this.myVersionCache.remove(interpreterPath);
        }
        return null;
    }

    public void fetchVersion(@NotNull NodeJsLocalInterpreter interpreter, @Nullable NullableConsumer<SemVer> consumer) {
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(3);
        }
        Future<SemVer> future = this.getOrCreateFetch(interpreter);
        if (consumer != null) {
            this.myExecutorService.submit(() -> {
                SemVer version = null;
                try {
                    version = (SemVer)future.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Fetch failed", (Throwable)e);
                }
                consumer.consume((Object)version);
            });
        }
    }

    @NotNull
    private Future<SemVer> getOrCreateFetch(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(4);
        }
        FutureTask<SemVer> newFetch = new FutureTask<SemVer>(() -> {
            if (interpreter == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(31);
            }
            SemVer version = null;
            File file = new File(interpreter.getInterpreterSystemDependentPath());
            try {
                if (!NodeJsLocalInterpreterManager.isElectronApp(interpreter.getInterpreterSystemIndependentPath(), file)) {
                    version = NodeJsLocalInterpreterManager.doFetchVersion(file);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to fetch version for " + interpreter.getInterpreterSystemDependentPath(), t);
            }
            finally {
                TimestampedSemVer result2 = new TimestampedSemVer(version, file.lastModified(), false);
                this.myVersionCache.put(interpreter.getInterpreterSystemIndependentPath(), result2);
                this.myRunningFetches.remove(interpreter.getInterpreterSystemIndependentPath());
            }
            return version;
        });
        Future running = this.myRunningFetches.putIfAbsent(interpreter.getInterpreterSystemIndependentPath(), newFetch);
        if (running != null) {
            Future future = running;
            if (future == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(5);
            }
            return future;
        }
        this.myExecutorService.submit(newFetch);
        FutureTask<SemVer> futureTask = newFetch;
        if (futureTask == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(6);
        }
        return futureTask;
    }

    private static boolean isElectronApp(@NotNull String interpreterSystemIndependentPath, @NotNull File interpreter) {
        String osxSuffix;
        int osxInd;
        if (interpreterSystemIndependentPath == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(7);
        }
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(8);
        }
        if ((osxInd = interpreterSystemIndependentPath.lastIndexOf(osxSuffix = "/Contents/MacOS/")) >= 0 && interpreterSystemIndependentPath.indexOf(47, osxInd + osxSuffix.length()) == -1) {
            return true;
        }
        File parentDir = interpreter.getParentFile();
        if (parentDir == null) {
            return false;
        }
        File resourcesDir = new File(parentDir, "resources");
        if (!resourcesDir.isDirectory()) {
            return false;
        }
        return new File(resourcesDir, "electron.asar").isFile() || new File(resourcesDir, "app.asar").isFile();
    }

    @Nullable
    private static SemVer doFetchVersion(@NotNull File interpreter) {
        ProcessOutput output;
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(9);
        }
        if (!interpreter.exists()) {
            LOG.warn("No version for non-existent file " + interpreter.getAbsolutePath());
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(interpreter.getAbsolutePath());
        commandLine.addParameter("--version");
        try {
            output = NodeCommandLineUtil.execute(commandLine, 5000L);
        }
        catch (com.intellij.execution.ExecutionException e) {
            LOG.warn("Cannot fetch version (" + commandLine.getCommandLineString() + ")", (Throwable)e);
            return null;
        }
        if (output.isTimeout()) {
            LOG.warn("Cannot fetch version: timed out (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Cannot fetch version: non-zero exit code " + output.getExitCode() + " (" + commandLine.getCommandLineString() + "), stdout: " + output.getStdout() + ", stderr: " + output.getStderr());
            return null;
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            LOG.warn("Cannot parse version: expected single line, actual lines " + stdout + " (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        SemVer version = NodeJsLocalInterpreterManager.parseSemVer((String)stdout.get(0));
        if (version == null) {
            LOG.warn("Cannot parse version from '" + (String)stdout.get(0) + "' (" + commandLine.getCommandLineString() + ")");
        }
        return version;
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String str) {
        if (str == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(10);
        }
        return SemVer.parseFromText((String)StringUtil.trimStart((String)str, (String)"v"));
    }

    @Nullable
    public Element getState() {
        List<NodeJsLocalInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            return null;
        }
        Element parent = new Element(LOCAL_INTERPRETERS_TAG_NAME);
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, interpreter.getInterpreterSystemIndependentPath());
            this.addVersionCacheElementIfNeeded(interpreterElement, interpreter.getInterpreterSystemIndependentPath());
            String npmPackage = interpreter.getNpmPackageDirNoDetection();
            if (StringUtil.isNotEmpty((String)npmPackage)) {
                JDOMExternalizerUtil.writeCustomField((Element)interpreterElement, (String)NPM_TAG_NAME, (String)FileUtil.toSystemIndependentName((String)npmPackage));
            }
            parent.addContent(interpreterElement);
        }
        Set<String> excludedInterpreterPaths = this.updateExcludedInterpreterPaths(this.myInterpreters);
        for (String excludedInterpreterPath : excludedInterpreterPaths) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, excludedInterpreterPath);
            interpreterElement.setAttribute(EXCLUDED_ATTR_NAME, Boolean.toString(true));
            parent.addContent(interpreterElement);
        }
        return parent;
    }

    private void addVersionCacheElementIfNeeded(@NotNull Element parent, @NotNull String interpreterSystemIndependentPath) {
        TimestampedSemVer tsv;
        if (parent == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(11);
        }
        if (interpreterSystemIndependentPath == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(12);
        }
        if ((tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterSystemIndependentPath)) != null) {
            SemVer version = tsv.myVersion;
            Element versionElement = new Element(VERSION_CACHE_TAG_NAME);
            if (version != null) {
                versionElement.setAttribute(VERSION_ATTR_NAME, version.getRawVersion());
            }
            versionElement.setAttribute(VERSION_LAST_MODIFIED_ATTR_NAME, String.valueOf(tsv.myLastModified));
            parent.addContent(versionElement);
        }
    }

    @NotNull
    private Set<String> getDetectedInterpreterPaths() {
        List<File> interpreters = NodeJsLocalInterpreterUtil.detectAllLocalInterpreters();
        HashSet interpreterPaths = ContainerUtil.newHashSet((int)interpreters.size());
        for (File interpreter : interpreters) {
            interpreterPaths.add(FileUtil.toSystemIndependentName((String)interpreter.getAbsolutePath()));
        }
        this.myDetectedInterpreterPaths = interpreterPaths;
        HashSet hashSet = interpreterPaths;
        if (hashSet == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    public void loadState(Element state) {
        List children = state.getChildren(LOCAL_INTERPRETER_TAG_NAME);
        HashSet excludedInterpreterPaths = ContainerUtil.newHashSet();
        ArrayList interpreters = ContainerUtil.newArrayList();
        for (Element interpreterElement : children) {
            String interpreterPath = interpreterElement.getAttributeValue(PATH_ATTR_NAME);
            if (interpreterPath == null) continue;
            interpreterPath = FileUtil.toSystemIndependentName((String)interpreterPath);
            boolean excluded = Boolean.parseBoolean(interpreterElement.getAttributeValue(EXCLUDED_ATTR_NAME));
            if (excluded) {
                excludedInterpreterPaths.add(interpreterPath);
                continue;
            }
            TimestampedSemVer version = NodeJsLocalInterpreterManager.parseVersionCache(interpreterElement);
            if (version != null) {
                this.myVersionCache.putIfAbsent(interpreterPath, version);
            }
            String npmPackageDirPath = JDOMExternalizerUtil.readCustomField((Element)interpreterElement, (String)NPM_TAG_NAME);
            NodeJsLocalInterpreter interpreter = new NodeJsLocalInterpreter(interpreterPath, npmPackageDirPath);
            interpreters.add(interpreter);
        }
        this.myInterpreters = interpreters;
        this.myExcludedInterpreterPaths = excludedInterpreterPaths;
    }

    @Nullable
    private static TimestampedSemVer parseVersionCache(@NotNull Element interpreterElement) {
        Element versionCacheElement;
        if (interpreterElement == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(14);
        }
        if ((versionCacheElement = interpreterElement.getChild(VERSION_CACHE_TAG_NAME)) == null) {
            return null;
        }
        long lastModified = StringUtil.parseLong((String)versionCacheElement.getAttributeValue(VERSION_LAST_MODIFIED_ATTR_NAME), (long)-1L);
        if (lastModified >= 0L) {
            String versionStr = versionCacheElement.getAttributeValue(VERSION_ATTR_NAME);
            SemVer version = SemVer.parseFromText((String)StringUtil.notNullize((String)versionStr));
            return new TimestampedSemVer(version, lastModified, true);
        }
        return null;
    }

    @NotNull
    private List<NodeJsLocalInterpreter> sortInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(15);
        }
        ArrayList pairs = ContainerUtil.newArrayListWithCapacity((int)interpreters.size());
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            SemVer version = (SemVer)Ref.deref(this.getCachedVersion(interpreter));
            if (version == null) {
                version = NodeJsLocalInterpreterManager.guessVersionByPath(interpreter);
            }
            pairs.add(new InterpreterWithVersion(interpreter, version));
        }
        Collections.sort(pairs);
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)interpreters.size());
        for (InterpreterWithVersion pair : pairs) {
            result2.add(pair.myInterpreter);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static SemVer guessVersionByPath(@NotNull NodeJsLocalInterpreter interpreter) {
        int sepInd2;
        String path;
        int sepInd1;
        if (interpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(17);
        }
        if ((sepInd1 = (path = interpreter.getInterpreterSystemIndependentPath()).lastIndexOf(47)) > 0 && (sepInd1 = path.lastIndexOf(47, sepInd1 - 1)) > 0 && (sepInd2 = path.lastIndexOf(47, sepInd1 - 1)) > 0) {
            String str = path.substring(sepInd2 + 1, sepInd1);
            return NodeJsLocalInterpreterManager.parseSemVer(str);
        }
        return null;
    }

    public void setInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(18);
        }
        this.myInterpreters = ContainerUtil.newArrayList(interpreters);
        this.myExcludedInterpreterPaths = this.updateExcludedInterpreterPaths(interpreters);
    }

    @NotNull
    private Set<String> updateExcludedInterpreterPaths(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        Set<String> detectedInterpreterPaths;
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(19);
        }
        if ((detectedInterpreterPaths = this.myDetectedInterpreterPaths) == null) {
            Set<String> set = this.myExcludedInterpreterPaths;
            if (set == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(20);
            }
            return set;
        }
        HashSet result2 = ContainerUtil.newHashSet(detectedInterpreterPaths);
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            result2.remove(interpreter.getInterpreterSystemIndependentPath());
        }
        this.myExcludedInterpreterPaths = result2;
        HashSet hashSet = result2;
        if (hashSet == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @NotNull
    public List<NodeJsLocalInterpreter> getInterpreters() {
        HashSet detectedPaths = ContainerUtil.newHashSet(this.getDetectedInterpreterPaths());
        List<Object> result2 = ContainerUtil.newArrayList((Iterable)ContainerUtil.notNullize(this.myInterpreters));
        for (NodeJsLocalInterpreter nodeJsLocalInterpreter : result2) {
            detectedPaths.remove(nodeJsLocalInterpreter.getInterpreterSystemIndependentPath());
        }
        detectedPaths.removeAll(this.myExcludedInterpreterPaths);
        for (String string : detectedPaths) {
            result2.add(new NodeJsLocalInterpreter(string, null));
        }
        result2 = this.sortInterpreters((List<NodeJsLocalInterpreter>)result2);
        this.myInterpreters = ContainerUtil.newArrayList((Iterable)result2);
        List<Object> list = result2;
        if (list == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<NodeJsLocalInterpreter> suggestToAddInterpreters() {
        HashSet all = ContainerUtil.newHashSet(this.myExcludedInterpreterPaths);
        all.addAll(this.getDetectedInterpreterPaths());
        if (ContainerUtil.isEmpty((Collection)all)) {
            List<NodeJsLocalInterpreter> list = Collections.emptyList();
            if (list == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList interpreters = ContainerUtil.newArrayListWithCapacity((int)all.size());
        for (String interpreterPath : all) {
            File file = new File(interpreterPath);
            if (!file.isFile() || !file.canExecute()) continue;
            interpreters.add(new NodeJsLocalInterpreter(file.getAbsolutePath(), null));
        }
        List<NodeJsLocalInterpreter> list = this.sortInterpreters(interpreters);
        if (list == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    public NodeJsLocalInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(25);
        }
        if (NodeJsLocalInterpreterType.isNodeFromPathRef(referenceName)) {
            Ref cached = this.myInterpreterFromPathRef;
            if (cached == null) {
                this.myInterpreterFromPathRef = cached = Ref.create((Object)this.detectMostRelevant());
            }
            return (NodeJsLocalInterpreter)cached.get();
        }
        if (StringUtil.isEmptyOrSpaces((String)referenceName) || !FileUtil.isAbsolutePlatformIndependent((String)referenceName)) {
            return null;
        }
        List<NodeJsLocalInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            interpreters = this.getInterpreters();
        }
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            if (!interpreter.getReferenceName().equals(referenceName)) continue;
            return interpreter;
        }
        String interpreterPath = NodeJsLocalInterpreterManager.resolveInterpreterPath(referenceName);
        return new NodeJsLocalInterpreter(interpreterPath, null);
    }

    @NotNull
    private static String resolveInterpreterPath(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(26);
        }
        if (SystemInfo.isWindows) {
            String fileWithExePath = referenceName + ".exe";
            File fileWithExe = new File(fileWithExePath);
            if (fileWithExe.isFile()) {
                String string = fileWithExePath;
                if (string == null) {
                    NodeJsLocalInterpreterManager.$$$reportNull$$$0(27);
                }
                return string;
            }
            File file = new File(referenceName);
            if (file.isFile()) {
                String string = referenceName;
                if (string == null) {
                    NodeJsLocalInterpreterManager.$$$reportNull$$$0(28);
                }
                return string;
            }
            String string = fileWithExePath;
            if (string == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = referenceName;
        if (string == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    public NodeJsLocalInterpreter detectMostRelevant() {
        File interpreterFile = NodeJsLocalInterpreterUtil.findInterpreterInPath();
        if (interpreterFile == null) {
            return null;
        }
        String path = FileUtil.toSystemDependentName((String)interpreterFile.getAbsolutePath());
        List interpreters = ContainerUtil.notNullize(this.myInterpreters);
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            if (!interpreter.getInterpreterSystemDependentPath().equals(path)) continue;
            return interpreter;
        }
        return new NodeJsLocalInterpreter(path, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameStateManager";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterSystemIndependentPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterElement";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFetch";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedInterpreterPaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sortInterpreters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "updateExcludedInterpreterPaths";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestToAddInterpreters";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFetch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElectronApp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFetchVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseSemVer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addVersionCacheElementIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionCache";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortInterpreters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessVersionByPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateExcludedInterpreterPaths";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveInterpreterPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateFetch$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InterpreterWithVersion
    implements Comparable<InterpreterWithVersion> {
        private final NodeJsLocalInterpreter myInterpreter;
        private final SemVer myVersion;

        public InterpreterWithVersion(@NotNull NodeJsLocalInterpreter interpreter, @Nullable SemVer version) {
            if (interpreter == null) {
                InterpreterWithVersion.$$$reportNull$$$0(0);
            }
            this.myInterpreter = interpreter;
            this.myVersion = version;
        }

        @Override
        public int compareTo(InterpreterWithVersion other) {
            SemVer version1 = this.myVersion;
            SemVer version2 = other.myVersion;
            String path1 = this.myInterpreter.getInterpreterSystemIndependentPath();
            String path2 = other.myInterpreter.getInterpreterSystemIndependentPath();
            if (version1 != null && version2 != null) {
                int res = version2.compareTo(version1);
                if (res == 0) {
                    res = path1.compareTo(path2);
                }
                return res;
            }
            if (version1 == null && version2 == null) {
                return path1.compareTo(path2);
            }
            return version1 == null ? -1 : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$InterpreterWithVersion", "<init>"));
        }
    }

    private static class TimestampedSemVer {
        private final SemVer myVersion;
        private final long myLastModified;
        private final boolean myLoadedFromXml;

        public TimestampedSemVer(@Nullable SemVer version, long lastModified, boolean loadedFromXml) {
            this.myVersion = version;
            this.myLastModified = lastModified;
            this.myLoadedFromXml = loadedFromXml;
        }
    }
}

