/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.frameworks.jquery.JQueryCssLanguage;
import com.intellij.lang.javascript.inject.JSRegexpLanguage;
import com.intellij.lang.javascript.inject.JSUnicodeRegexpLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSLanguageInjector
implements MultiHostInjector,
JSTargetedInjector {
    @NonNls
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    private static final Language jsCssLanguage = JQueryCssLanguage.INSTANCE;
    private static final boolean regexpEnabled = LanguageParserDefinitions.INSTANCE.findSingle((Object)JSRegexpLanguage.INSTANCE) != null;
    private static final Pattern EXAMPLE_FILE_PATTERN = Pattern.compile("name=['\"](\\S+)['\"]");
    private static final Key<ParameterizedCachedValue<Boolean, Language>> CONCATENATION_RESULT_CACHE_KEY = new Key("JSLanguageInjector.Concatenation.Injection.Result");
    @NonNls
    private static final String regExpMethodName = "RegExp";

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JSLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!JSInheritedLanguagesHelper.supportsJavaScriptInjections(host)) {
            return;
        }
        if (host instanceof XmlAttributeValue) {
            PsiElement attribute = host.getParent();
            PsiElement tag = attribute.getParent();
            if (attribute instanceof XmlAttribute && tag instanceof XmlTag) {
                String value;
                if (host.getTextLength() == 0) {
                    return;
                }
                String attrName = ((XmlAttribute)attribute).getName();
                String tagName = ((XmlTag)tag).getName();
                if (tag instanceof HtmlTag) {
                    attrName = attrName.toLowerCase();
                    tagName = tagName.toLowerCase();
                }
                if (("href".equals(attrName) && "a".equals(tagName) || "action".equals(attrName) && "form".equals(tagName)) && (value = ((XmlAttributeValue)host).getValue()) != null && StringUtil.startsWithIgnoreCase((String)value, (String)JAVASCRIPT_PREFIX)) {
                    JSLanguageInjector.injectJSIntoAttributeValue(registrar, (XmlAttributeValue)host, true);
                }
            }
        } else if (host instanceof XmlText) {
            String name;
            XmlTag tag;
            String localName;
            PsiElement _tag = host.getParent();
            if (_tag instanceof XmlTag && "attribute".equals(localName = (tag = (XmlTag)_tag).getLocalName()) && JSP_URI.equals(tag.getNamespace()) && (name = tag.getAttributeValue("name")) != null && name.startsWith("on")) {
                JavascriptLanguage language = JavascriptLanguage.INSTANCE;
                JSLanguageInjector.injectToXmlText(registrar, host, (Language)language, null, null);
            }
        } else if (host instanceof JSLiteralExpression && host instanceof PsiLanguageInjectionHost) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)host;
            if (!JSLanguageInjector.injectRegularExpression(registrar, literalExpression) && literalExpression.isQuotedLiteral()) {
                JSLanguageInjector.handleStringLiteral(registrar, literalExpression);
            }
        } else if (host instanceof JSDocComment) {
            int exampleStart;
            String text = host.getText();
            int exampleEnd = 0;
            do {
                exampleStart = text.indexOf("<example", exampleEnd);
                exampleEnd = text.indexOf("</example>", exampleStart);
                int i = exampleStart;
                while (i < exampleEnd && i > 0) {
                    int fileEnd;
                    int fileStart = text.indexOf("<file", i);
                    int n = fileEnd = fileStart > 0 ? text.indexOf("</file>", fileStart) : -1;
                    if (fileStart > 0 && fileEnd > 0) {
                        String startLine;
                        Matcher matcher;
                        int headerLineEnd = text.indexOf(10, fileStart);
                        int headerLineOffset = fileStart - text.lastIndexOf(10, fileStart);
                        if (headerLineEnd > 0 && headerLineEnd < fileEnd && (matcher = EXAMPLE_FILE_PATTERN.matcher(startLine = text.substring(fileStart, headerLineEnd))).find()) {
                            String filename = matcher.group(1);
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
                            if (fileType instanceof LanguageFileType) {
                                registrar.startInjecting(((LanguageFileType)fileType).getLanguage());
                                int lineEnd = headerLineEnd;
                                while (lineEnd < fileEnd) {
                                    int startOffset = lineEnd + headerLineOffset;
                                    if (startOffset <= text.indexOf(10, lineEnd + 1)) {
                                        int endOffset = Math.min(text.indexOf(10, startOffset), fileEnd);
                                        TextRange range = new TextRange(startOffset, Math.max(startOffset, endOffset));
                                        registrar.addPlace("", "\n", (PsiLanguageInjectionHost)host, range);
                                    }
                                    lineEnd = text.indexOf(10, lineEnd + 1);
                                }
                                registrar.doneInjecting();
                            }
                        }
                    }
                    i = fileEnd;
                }
            } while (exampleStart >= 0 && exampleEnd >= 0);
        }
    }

    private static boolean injectRegularExpression(@NotNull MultiHostRegistrar registrar, @NotNull JSLiteralExpression expression) {
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            JSLanguageInjector.$$$reportNull$$$0(3);
        }
        if (!regexpEnabled) {
            return false;
        }
        if (expression.isRegExpLiteral()) {
            JSLanguageInjector.injectInRegexLiteral(registrar, (PsiElement)expression);
            return true;
        }
        if (!expression.isQuotedLiteral()) {
            return false;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof JSArgumentList)) {
            return false;
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        if (arguments.length == 0 || arguments.length > 2) {
            return false;
        }
        JSReferenceExpression call = JSUtils.getMethodNameIfInsideCall(parent);
        if (call == null || call.getQualifier() != null || !(call.getParent() instanceof JSNewExpression)) {
            return false;
        }
        if (!regExpMethodName.equals(call.getReferenceName())) {
            return false;
        }
        boolean shouldUseUnicode = false;
        if (arguments.length == 2) {
            if (arguments[0] != expression) {
                return false;
            }
            JSExpression secondArgument = arguments[1];
            if (!(secondArgument instanceof JSLiteralExpression) || !((JSLiteralExpression)secondArgument).isQuotedLiteral()) {
                return false;
            }
            Object value = ((JSLiteralExpression)secondArgument).getValue();
            if (!(value instanceof String)) {
                return false;
            }
            shouldUseUnicode = JSLanguageInjector.hasUnicodeFlag((String)value, 0);
        }
        if (!JSInjectionController.hasOuterLanguage((PsiElement)expression)) {
            JSInjectionController.injectInQuotedLiteral(registrar, shouldUseUnicode ? JSUnicodeRegexpLanguage.INSTANCE : JSRegexpLanguage.INSTANCE, expression, null, null);
            return true;
        }
        return false;
    }

    private static void handleStringLiteral(@NotNull MultiHostRegistrar registrar, @NotNull JSLiteralExpression literalExpression) {
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(4);
        }
        if (literalExpression == null) {
            JSLanguageInjector.$$$reportNull$$$0(5);
        }
        if (JSInjectionController.willInjectJs((PsiElement)literalExpression)) {
            JSInjectionController.injectInQuotedLiteral(registrar, (Language)JavascriptLanguage.INSTANCE, literalExpression, null, null);
            return;
        }
        PsiElement topElement = JSInjectionController.getTopElement((PsiLanguageInjectionHost)literalExpression);
        if (JSLanguageInjector.willInjectInConcatenation(topElement, (Language)HTMLLanguage.INSTANCE, JSInjectionController::willInjectHtml)) {
            List<JSLiteralExpression> parts = JSInjectionController.getConcatenationParts(topElement);
            int placesCount = JSInjectionController.concatenationAwareInject(registrar, (Language)HTMLLanguage.INSTANCE, parts, (PsiElement)literalExpression, null, null).size();
            InjectedLanguageUtil.putInjectedFileUserData((PsiElement)literalExpression, (Language)HTMLLanguage.INSTANCE, (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)(placesCount > 1 ? 1 : 0));
            return;
        }
        if (JSInjectionController.willInjectCss((PsiElement)literalExpression) && !JSInjectionController.hasOuterLanguage((PsiElement)literalExpression)) {
            JSInjectionController.injectInQuotedLiteral(registrar, jsCssLanguage, literalExpression, null, "{}");
        }
    }

    private static boolean hasUnicodeFlag(String value, int offset) {
        int indexOfU = value.indexOf(117, offset);
        if (indexOfU < 0) {
            return false;
        }
        if (indexOfU == 0) {
            return true;
        }
        char prev = value.charAt(indexOfU - 1);
        if (prev != '\\') {
            return true;
        }
        indexOfU = value.indexOf(117, indexOfU + 1);
        while (indexOfU > 0) {
            prev = value.charAt(indexOfU - 1);
            if (prev != '\\') {
                return true;
            }
            indexOfU = value.indexOf(117, indexOfU + 1);
        }
        return value.indexOf("\\u0075", offset) >= 0;
    }

    private static boolean willInjectInConcatenation(@NotNull PsiElement topElement, @NotNull Language language, @NotNull JSConcatenationInjector injector) {
        if (topElement == null) {
            JSLanguageInjector.$$$reportNull$$$0(6);
        }
        if (language == null) {
            JSLanguageInjector.$$$reportNull$$$0(7);
        }
        if (injector == null) {
            JSLanguageInjector.$$$reportNull$$$0(8);
        }
        return Boolean.TRUE == CachedValuesManager.getManager((Project)topElement.getProject()).getParameterizedCachedValue((UserDataHolder)topElement, CONCATENATION_RESULT_CACHE_KEY, theLanguage -> {
            if (injector == null) {
                JSLanguageInjector.$$$reportNull$$$0(12);
            }
            if (topElement == null) {
                JSLanguageInjector.$$$reportNull$$$0(13);
            }
            boolean shouldInject = injector.shouldInject(topElement);
            return new CachedValueProvider.Result((Object)shouldInject, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false, (Object)language);
    }

    public static void injectInRegexLiteral(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        String text;
        int offset;
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(9);
        }
        if (host == null) {
            JSLanguageInjector.$$$reportNull$$$0(10);
        }
        if ((offset = (text = host.getText()).lastIndexOf(47)) > 1) {
            TextRange range = new TextRange(1, offset);
            registrar.startInjecting(JSLanguageInjector.hasUnicodeFlag(text, offset) ? JSUnicodeRegexpLanguage.INSTANCE : JSRegexpLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, range).doneInjecting();
        }
    }

    public static void injectToXmlText(MultiHostRegistrar registrar, PsiElement host, Language language, String prefix, String suffix) {
        TextRange range = new TextRange(0, host.getTextLength());
        registrar.startInjecting(language).addPlace(prefix, suffix, (PsiLanguageInjectionHost)host, range).doneInjecting();
    }

    public static void injectJSIntoAttributeValue(MultiHostRegistrar registrar, XmlAttributeValue host, boolean startsWithPrefix) {
        PsiElement valueChild;
        PsiElement[] myChildren = host.getChildren();
        int valueIndex = myChildren.length - 2;
        int valueTokenNumber = 1;
        if (valueIndex < 0) {
            valueIndex = 0;
            valueTokenNumber = 0;
        }
        if ((valueChild = myChildren[valueIndex]) instanceof XmlToken && ((XmlToken)valueChild).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            SmartList ownTextRanges = new SmartList();
            TextRange range = new TextRange(valueTokenNumber + (startsWithPrefix ? JAVASCRIPT_PREFIX.length() : 0), host.getTextLength() - valueTokenNumber);
            if (range.getLength() < 0) {
                return;
            }
            ownTextRanges.add(range);
            if (valueIndex != valueTokenNumber) {
                int hostOffset = host.getTextRange().getStartOffset();
                for (int i = valueTokenNumber; i < valueIndex; ++i) {
                    TextRange rightRange;
                    PsiElement currentElement = myChildren[i];
                    if (!(currentElement instanceof OuterLanguageElement)) continue;
                    TextRange currentElementRange = currentElement.getTextRange().shiftRight(-hostOffset);
                    TextRange lastRange = (TextRange)ownTextRanges.remove(ownTextRanges.size() - 1);
                    TextRange leftRange = new TextRange(lastRange.getStartOffset(), currentElementRange.getStartOffset());
                    if (leftRange.getLength() > 0) {
                        ownTextRanges.add(leftRange);
                    }
                    if ((rightRange = new TextRange(currentElementRange.getEndOffset(), lastRange.getEndOffset())).getLength() <= 0) continue;
                    ownTextRanges.add(rightRange);
                }
            }
            JavascriptLanguage language = JavascriptLanguage.INSTANCE;
            registrar.startInjecting((Language)language);
            for (TextRange textRange : ownTextRanges) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, textRange);
            }
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlText.class, XmlAttributeValue.class, JSLiteralExpression.class, JSDocComment.class);
        if (list == null) {
            JSLanguageInjector.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injector";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSLanguageInjector";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "injectRegularExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleStringLiteral";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "willInjectInConcatenation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "injectInRegexLiteral";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$willInjectInConcatenation$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface JSConcatenationInjector {
        public boolean shouldInject(@NotNull PsiElement var1);
    }
}

