/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashSet;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExternalLibraryDocBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String BUNDLE = "com.intellij.lang.javascript.documentation.JSExternalLibraryDoc";
    @NonNls
    private static final String BASE_URL = "baseUrl";
    @NonNls
    private static final String RULES = "rules";
    @NonNls
    private static final String PREFIX = "prefix";
    @NonNls
    private static final String ELEMENT = "element";
    @NonNls
    private static final String PATTERNS = "patterns";
    @NonNls
    private static final String LOWER_CASE = "lowerCase";
    @NonNls
    private static final String OFFLINE_DOC_URL = "offlineDocUrl";
    @NonNls
    private static final String OFFLINE_DOC_EXT = "offlineDocExt";
    @NonNls
    private static final String OFFLINE_DOC_PROVIDER = "offlineDocProvider";
    @NonNls
    private static final String LIBRARY_NAME = "name";
    @NonNls
    private static final String VERSION_MATCHER = "versionMatcher";

    private JSExternalLibraryDocBundle() {
    }

    @Nullable
    public static String getBaseURLKey(String baseUrl) {
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            if (!key.endsWith(BASE_URL) || !baseUrl.startsWith(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key))) continue;
            return key.replace(".baseUrl", "");
        }
        return null;
    }

    @Nullable
    public static String getBaseKey(String name, String version) {
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleName;
            if (!key.endsWith(LIBRARY_NAME) || (bundleName = JSExternalLibraryDocBundle.getBundle().getString(key)) == null || !bundleName.equals(name)) continue;
            String baseKey = key.replace(".name", "");
            if (version == null) {
                return baseKey;
            }
            String versionMatcher = JSExternalLibraryDocBundle.getBundle().getString(baseKey + "." + VERSION_MATCHER);
            if (versionMatcher == null || !version.matches(versionMatcher)) continue;
            return baseKey;
        }
        return null;
    }

    @NotNull
    public static String getRules(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(0);
        }
        String rules = JSExternalLibraryDocBundle.getProperty(baseKey, RULES, true);
        assert (rules != null);
        String string = rules;
        if (string == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getPrefix(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(2);
        }
        String prefix = JSExternalLibraryDocBundle.getProperty(baseKey, PREFIX, true);
        assert (prefix != null);
        String string = prefix;
        if (string == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getBaseUrl(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(4);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, BASE_URL, false);
    }

    @Nullable
    public static String getPatterns(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(5);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, PATTERNS, false);
    }

    @Nullable
    public static String getOfflineDocProvider(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(6);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_PROVIDER, false);
    }

    @Nullable
    public static String getLibraryName(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(7);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, LIBRARY_NAME, false);
    }

    @Nullable
    public static String getVersionMatcher(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(8);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, VERSION_MATCHER, false);
    }

    public static boolean isLowerCase(@NotNull String baseKey) {
        String lowerCase;
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(9);
        }
        if ((lowerCase = JSExternalLibraryDocBundle.getProperty(baseKey, LOWER_CASE, false)) == null) {
            return false;
        }
        return Boolean.parseBoolean(lowerCase);
    }

    @Nullable
    private static String getProperty(@NotNull String baseKey, String propertyName, boolean notNull) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(10);
        }
        String prefixKey = baseKey + "." + propertyName;
        ResourceBundle bundle = JSExternalLibraryDocBundle.getBundle();
        return bundle.containsKey(prefixKey) ? bundle.getString(prefixKey) : (notNull ? "" : null);
    }

    @Nullable
    public static String getElementUrl(@NotNull String baseKey, @NotNull String elementFQN) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(11);
        }
        if (elementFQN == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(12);
        }
        String elementKey = baseKey + "." + ELEMENT + "." + elementFQN;
        if (!JSExternalLibraryDocBundle.getBundle().containsKey(elementKey)) {
            return null;
        }
        return JSExternalLibraryDocBundle.getBundle().getString(elementKey);
    }

    @Nullable
    public static String getOfflineDocUrl(@NotNull String baseKey) {
        if (baseKey == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(13);
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_URL, false);
    }

    @NotNull
    public static String getOfflineDocExt(@NotNull String offlineDocUrl) {
        if (offlineDocUrl == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(14);
        }
        String baseKey = null;
        String ext = null;
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            if (!key.endsWith(OFFLINE_DOC_URL) || !offlineDocUrl.equals(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key))) continue;
            baseKey = key.replace(".offlineDocUrl", "");
            break;
        }
        if (baseKey != null) {
            ext = JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_EXT, true);
        }
        String string = ext == null ? "" : ext;
        if (string == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static String findMatchingDocKey(@NotNull String filePath) {
        if (filePath == null) {
            JSExternalLibraryDocBundle.$$$reportNull$$$0(16);
        }
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            String targetName;
            if (!key.endsWith(OFFLINE_DOC_URL) || !filePath.contains(targetName = JSLibraryUtil.makeUniqueFileName(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key), false))) continue;
            return key.replace(".offlineDocUrl", "");
        }
        return null;
    }

    public static Set<String> getBasePatternKeys() {
        ResourceBundle bundle = JSExternalLibraryDocBundle.getBundle();
        HashSet patternKeys = new HashSet();
        for (String key : bundle.keySet()) {
            if (!key.endsWith(PATTERNS)) continue;
            patternKeys.add(key.replace(".patterns", ""));
        }
        return patternKeys;
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseKey";
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFQN";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = OFFLINE_DOC_URL;
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOfflineDocExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPatterns";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOfflineDocProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVersionMatcher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLowerCase";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementUrl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOfflineDocUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOfflineDocExt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingDocKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

