/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuickNavigateBuilder {
    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(PsiElement element, PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        if (element instanceof JSFunction) {
            return this.createQuickNavigateForFunction((JSFunction)element, originalElement);
        }
        if (element instanceof JSClass) {
            return this.createQuickNavigateForJSClass((JSClass)element, originalElement);
        }
        if (element instanceof JSFieldVariable) {
            return this.createQuickNavigateForVariableOrField((JSFieldVariable)element, originalElement);
        }
        if (element instanceof JSProperty) {
            return this.createQuickNavigateForProperty((JSProperty)element, originalElement);
        }
        if (element instanceof XmlToken) {
            String xmlAttributeDoc = JSQuickNavigateBuilder.checkAndGetXmlAttributeQuickNavigate(element);
            if (xmlAttributeDoc != null) {
                return xmlAttributeDoc;
            }
            JSTagContextBuilder builder = new JSTagContextBuilder(element, "XmlTag");
            return StringUtil.unquoteString((String)element.getText()) + ":" + builder.typeName;
        }
        return null;
    }

    @Nullable
    public final String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        return element == null ? null : this.getQuickNavigateInfoForNavigationElement(element.getNavigationElement(), originalElement);
    }

    @Nullable
    protected final String createQuickNavigateForProperty(@NotNull JSProperty element, @NotNull PsiElement originalElement) {
        String name;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if ((name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element, true)) == null) {
            return null;
        }
        JSQualifiedNamedElement parent = JSQuickNavigateBuilder.getPropertyParent(element);
        StringBuilder text = new StringBuilder();
        if (parent != null) {
            text.append(parent.getQualifiedName()).append(".");
        }
        text.append(name);
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)element, originalElement);
        String typeText = this.getTypeTextForQuickNavigate(this.getPropertyTypeText(element), substitutor);
        this.appendEscapedType((PsiElement)element, typeText, text);
        JSExpression value = element.getValue();
        ObjectKind kind = value instanceof JSFunctionExpression ? ObjectKind.FUNCTION : ObjectKind.PROPERTY;
        return JSQuickNavigateBuilder.buildResult(kind, text.toString(), false, (PsiElement)element, originalElement);
    }

    @Nullable
    protected JSType getPropertyTypeText(@NotNull JSProperty element) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        return JSTypeUtils.widenLiteralTypes(element.getType());
    }

    @Nullable
    private static JSQualifiedNamedElement getPropertyParent(@NotNull JSProperty property) {
        PsiElement literalContainer;
        PsiElement parent;
        if (property == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if ((parent = property.getParent()) instanceof JSObjectLiteralExpression && (literalContainer = parent.getParent()) instanceof JSVariable) {
            return (JSVariable)literalContainer;
        }
        return null;
    }

    protected static boolean isFileNameRequired(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        return elementFile == null || !elementFile.equals(originalFile);
    }

    @Nullable
    protected String createQuickNavigateForFunction(@NotNull JSFunction function, PsiElement originalElement) {
        boolean isGetterOrSetter;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        StringBuilder result2 = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)function, originalElement);
        this.appendFunctionAttributesAndName(function, parent, result2, substitutor);
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        boolean bl = isGetterOrSetter = get || set;
        if (!isGetterOrSetter) {
            this.appendParameterList(function, result2, substitutor);
        }
        String varType = this.getReturnTypeTextForQuickNavigate(function, get, set, substitutor);
        this.appendEscapedType((PsiElement)function, varType, result2);
        ObjectKind kind = isGetterOrSetter ? ObjectKind.PROPERTY : ObjectKind.SIMPLE_DECLARATION;
        return JSQuickNavigateBuilder.buildResult(kind, result2.toString(), false, (PsiElement)function, originalElement);
    }

    private void appendParameterList(@NotNull JSFunction function, @NotNull StringBuilder result2, @NotNull JSTypeSubstitutor substitutor) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        result2.append('(');
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null) {
            int start = result2.length();
            for (JSParameterListElement p : jsParameterList.getParameters()) {
                String typeText;
                if (start != result2.length()) {
                    result2.append(", ");
                }
                result2.append(p.getName());
                if (p.isOptional()) {
                    result2.append("?");
                }
                if ((typeText = this.getTypeTextForQuickNavigate(p.getType(), substitutor)) == null) continue;
                this.appendEscapedType((PsiElement)p, typeText, result2);
            }
        }
        result2.append(')');
    }

    protected static String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, boolean isInferred, @NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (objectText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        boolean needFileName = JSQuickNavigateBuilder.isFileNameRequired(element, originalElement);
        if (!isInferred && !needFileName) {
            return "<div align=\"center\">" + kind.toPrefix() + objectText + "</div>";
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        assert (file != null);
        String inferredText = isInferred ? "inferred" : "";
        String fileNameText = needFileName ? "(" + file.getName() + ")" : "";
        String kindText = kind.toPrefix();
        return "<div align=\"center\">" + kindText + objectText + JSQuickNavigateBuilder.buildAdditionalInformationText(inferredText, true) + JSQuickNavigateBuilder.buildAdditionalInformationText(fileNameText, false) + "</div>";
    }

    protected final String createQuickNavigateForVariableOrField(@NotNull JSFieldVariable variableOrField, PsiElement originalElement) {
        String parentInfo;
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder result2 = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)variableOrField, originalElement);
        this.appendAttrList((JSAttributeListOwner)variableOrField, result2);
        if (variableOrField instanceof JSVariable) {
            result2.append(this.getVarPrefix((JSVariable)variableOrField));
        }
        if (!StringUtil.isEmpty((String)(parentInfo = this.getParentInfo(parent, (PsiNamedElement)variableOrField, substitutor)))) {
            result2.append(parentInfo).append(".");
        }
        result2.append(variableOrField.getName());
        String variableOrFieldTypeText = this.getTypeTextForQuickNavigate(this.getVariableOrFieldType((JSTypeDeclarationOwner)variableOrField), substitutor);
        String inferredType = this.getVariableOrFieldInferredTypeText((JSElement)variableOrField, originalElement, substitutor);
        if (variableOrFieldTypeText != null) {
            this.appendEscapedType((PsiElement)variableOrField, inferredType != null ? inferredType : variableOrFieldTypeText, result2);
        }
        if (variableOrField instanceof JSVariable && ((JSVariable)variableOrField).hasInitializer()) {
            this.appendVariableInitializer((JSVariable)variableOrField, result2);
        }
        boolean isInferredType = inferredType != null && !inferredType.equals(variableOrFieldTypeText);
        ObjectKind kind = variableOrField instanceof JSParameter ? ObjectKind.PARAMETER : ObjectKind.SIMPLE_DECLARATION;
        return JSQuickNavigateBuilder.buildResult(kind, result2.toString(), isInferredType, (PsiElement)variableOrField, originalElement);
    }

    private static String buildAdditionalInformationText(@NotNull String text, boolean italic) {
        if (text == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        Color color = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getDefaultAttributes().getForegroundColor();
        StringBuilder result2 = new StringBuilder();
        result2.append(" <span");
        result2.append(" style=\"");
        Font font = UIUtil.getLabelFont();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (font != null) {
                result2.append("font-size:").append(font.getSize()).append("pt").append(";");
            }
            if (color != null) {
                result2.append("color:").append(ColorUtil.toHex((Color)color)).append(";");
            }
        }
        if (italic) {
            result2.append("font-style:italic");
        }
        result2.append("\">");
        result2.append(text);
        result2.append("</span>");
        return result2.toString();
    }

    @Nullable
    protected String createQuickNavigateForJSClass(@NotNull JSClass jsClass, PsiElement originalElement) {
        String qName;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if ((qName = jsClass.getQualifiedName()) == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result2.append(packageName).append("\n");
        }
        this.appendClassAttributesAndName(jsClass, originalElement, result2);
        this.appendClassExtendsAndImplements(jsClass, packageName, result2);
        return JSQuickNavigateBuilder.buildResult(ObjectKind.SIMPLE_DECLARATION, result2.toString(), false, (PsiElement)jsClass, originalElement);
    }

    @Nullable
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (parent instanceof JSClass) {
            return StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
        }
        return "";
    }

    @Nullable
    private static String checkAndGetXmlAttributeQuickNavigate(PsiElement element) {
        PsiElement xmlAttribute;
        String xmlAttributeDoc = null;
        Object object = element.getParent() instanceof XmlAttribute ? element.getParent() : (xmlAttribute = element.getParent() instanceof XmlAttributeValue && element.getParent().getParent() instanceof XmlAttribute ? element.getParent().getParent() : null);
        if (xmlAttribute != null) {
            String value = StringUtil.unquoteString((String)StringUtil.notNullize((String)((XmlAttribute)xmlAttribute).getValue()));
            xmlAttributeDoc = ((XmlAttribute)xmlAttribute).getName() + " " + value;
        }
        return xmlAttributeDoc;
    }

    @Nullable
    protected String getReturnTypeTextForQuickNavigate(@NotNull JSFunction function, boolean get, boolean set, @NotNull JSTypeSubstitutor substitutor) {
        JSParameterListElement[] jsParameters;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (get || !set) {
            JSType type = function.getReturnType();
            if (!JSSymbolPresentationUtils.isPossiblyPresentableType(type, (PsiElement)function, true)) {
                return null;
            }
            return this.getTypeTextForQuickNavigate(type, substitutor);
        }
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null && (jsParameters = jsParameterList.getParameters()).length > 0) {
            return this.getTypeTextForQuickNavigate(jsParameters[0].getType(), substitutor);
        }
        return null;
    }

    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        JSType type;
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        return (type = JSTypeUtils.applyGenericArguments(rawType, (Map<String, JSType>)substitutor)) != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
    }

    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @Nullable PsiElement parent, @NotNull StringBuilder result2, @NotNull JSTypeSubstitutor substitutor) {
        String parentInfo;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        this.appendAttrList((JSAttributeListOwner)function, result2);
        if (this.shouldAppendFunctionKeyword(function, parent)) {
            result2.append("function ");
        }
        if (!StringUtil.isEmpty((String)(parentInfo = this.getParentInfo(parent, (PsiNamedElement)function, substitutor)))) {
            result2.append(parentInfo).append(".");
        }
        result2.append(StringUtil.notNullize((String)function.getName(), (String)"<unknown>"));
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunction function, @Nullable PsiElement parent) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        return !JSPsiImplUtils.isGetterOrSetter(function) && !(parent instanceof JSClass);
    }

    protected void appendAttrList(JSAttributeListOwner owner, StringBuilder result2) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            JSVisibilityUtil.PresentableAccessModifier modifier;
            JSQuickNavigateBuilder.appendModifier(result2, attributeList, JSAttributeList.ModifierType.OVERRIDE);
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null && (modifier = JSVisibilityUtil.getPresentableAccessModifier((JSElement)owner)) != null) {
                ns = modifier.getText();
            }
            if (ns != null) {
                result2.append(ns);
                result2.append(" ");
            }
            JSQuickNavigateBuilder.appendModifier(result2, attributeList, JSAttributeList.ModifierType.STATIC);
            JSQuickNavigateBuilder.appendModifier(result2, attributeList, JSAttributeList.ModifierType.FINAL);
            JSQuickNavigateBuilder.appendModifier(result2, attributeList, JSAttributeList.ModifierType.DYNAMIC);
            JSQuickNavigateBuilder.appendModifier(result2, attributeList, JSAttributeList.ModifierType.NATIVE);
        }
    }

    @Nullable
    protected String getVariableOrFieldInferredTypeText(@NotNull JSElement resolved, @NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        if (resolved == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        return null;
    }

    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        return variable.getType();
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        if (el == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        return jSTypeSubstitutor;
    }

    protected void appendEscapedType(@NotNull PsiElement context, @Nullable String varType, @NotNull StringBuilder builder) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (!StringUtil.isEmpty((String)varType)) {
            builder.append(JSSymbolPresentationProvider.getDefaultTypeSeparator(context)).append(StringUtil.escapeXml((String)varType));
        }
    }

    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, PsiElement originalElement, StringBuilder result2) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        this.appendAttrList((JSAttributeListOwner)jsClass, result2);
        if (jsClass.isInterface()) {
            result2.append("interface");
        } else {
            result2.append("class");
        }
        result2.append(" ").append(jsClass.getName());
    }

    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        String implementsList;
        String extendsList;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (packageNameOrEmptyString == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if ((extendsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getExtendsList(), packageNameOrEmptyString)) == null && this.isIncludeObjectInExtendsList() && !"Object".equals(jsClass.getName())) {
            extendsList = "Object";
        }
        if (extendsList != null) {
            result2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getImplementsList(), packageNameOrEmptyString)) != null) {
            result2.append("\nimplements ").append(implementsList);
        }
    }

    protected boolean isIncludeObjectInExtendsList() {
        return false;
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result2 = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result2 == null) {
                result2 = new StringBuilder();
            } else {
                result2.append(",");
            }
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result2.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result2 == null ? null : result2.toString();
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        JSVarStatement.VarKeyword keyword = (statement = variable.getStatement()) != null ? statement.getVarKeyword() : null;
        String string = keyword != null ? keyword.getText() + " " : "";
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        return string;
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        JSExpression initializer;
        String initializerText;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(43);
        }
        if ((initializerText = variable.getLiteralOrReferenceInitializerText()) == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            int maxInitStringLengthToShow = 50;
            if (initializerText.length() > maxInitStringLengthToShow) {
                initializerText = initializerText.substring(0, maxInitStringLengthToShow) + "...";
            }
            result2.append(" = ").append(StringUtil.escapeXml((String)initializerText));
        }
    }

    protected static void appendModifier(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(44);
        }
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        if (modifier == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        if (attributeList.hasModifier(modifier)) {
            result2.append(modifier.keyword).append(" ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 32: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 32: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 13: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 23: 
            case 38: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 29: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyTypeText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameRequired";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterList";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForVariableOrField";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildAdditionalInformationText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeTextForQuickNavigate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppendFunctionKeyword";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldInferredTypeText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 32: 
            case 41: {
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateReferenceTargetList";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appendModifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 32: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum ObjectKind {
        SIMPLE_DECLARATION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$1", "toPrefix"));
            }
        }
        ,
        PROPERTY{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(property) " == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "(property) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$2", "toPrefix"));
            }
        }
        ,
        PARAMETER{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(parameter) " == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "(parameter) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$3", "toPrefix"));
            }
        }
        ,
        FUNCTION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(function) " == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "(function) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$4", "toPrefix"));
            }
        };


        @NotNull
        public abstract String toPrefix();
    }
}

