/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptQuickNavigateBuilder
extends JSQuickNavigateBuilder {
    @Override
    @Nullable
    protected String getVariableOrFieldInferredTypeText(@NotNull JSElement resolved, @NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        JSType narrowType;
        if (resolved == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        String name = resolved.getName();
        originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParent(originalElement);
        if (name != null && originalElement instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference((JSExpression)originalElement) && (narrowType = JSResolveUtil.getExpressionJSType((JSExpression)originalElement)) != null && (narrowType.getSource().isTypeScript() || narrowType.getSource().isStrict())) {
            return this.getTypeTextForQuickNavigate(narrowType, substitutor);
        }
        return super.getVariableOrFieldInferredTypeText(resolved, originalElement, substitutor);
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        if (el == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.isTypeScript((PsiElement)el)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
            }
            return jSTypeSubstitutor;
        }
        if (JavaScriptQuickNavigateBuilder.isElementFromTSSources(el, originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParent(originalElement))) {
            el = JavaScriptQuickNavigateBuilder.getOriginalResolvedElement(el, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(el, originalElement);
        if (jSTypeSubstitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        ResolveResult[] results;
        List<PsiElement> resolvedElements;
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if ((resolvedElements = JSResolveResult.toElements(results = originalElement.multiResolve(false))).size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        return jSElement;
    }

    @Override
    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @Nullable PsiElement parent, @NotNull StringBuilder result2, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (function == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        super.appendFunctionAttributesAndName(function, parent, result2, substitutor);
        if (function instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics((TypeScriptTypeParameterListOwner)function, substitutor)) != null) {
            result2.append(generics);
        }
    }

    @Contract(value="!null->!null")
    protected static PsiElement getOriginalElementOrParent(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(originalElement.getNode().getElementType())) {
            originalElement = originalElement.getParent();
        }
        return originalElement;
    }

    @Nullable
    protected static String getGenerics(@NotNull TypeScriptTypeParameterListOwner owner, @NotNull JSTypeSubstitutor substitutor) {
        TypeScriptTypeParameterList list;
        if (owner == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if ((list = owner.getTypeParameterList()) == null) {
            return null;
        }
        Object[] parameters = list.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            JSType type;
            String name;
            if (substitutor == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
            }
            if ((name = el.getName()) == null) {
                name = "?";
            }
            return (type = (JSType)substitutor.get((Object)name)) == null ? name : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return StringUtil.escapeXml((String)newBuilder.toString());
    }

    @Override
    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, PsiElement originalElement, StringBuilder result2) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            this.appendAttrList((JSAttributeListOwner)jsClass, result2);
            result2.append("type ");
            result2.append(jsClass.getName());
        } else {
            super.appendClassAttributesAndName(jsClass, originalElement, result2);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics((TypeScriptTypeParameterListOwner)jsClass, substitutor = this.getTypeSubstitutor((JSElement)jsClass, originalElement))) != null) {
            result2.append(generics);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalResolvedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldInferredTypeText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromTSSources";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalResolvedElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getGenerics";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenerics$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

