/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLiteralKeyUtil {
    private static final Key<ParameterizedCachedValue<PsiElement, Pair<PsiElement, String>>> CACHE_KEY = Key.create((String)"TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression");
    private static final ParameterizedCachedValueProvider<PsiElement, Pair<PsiElement, String>> PROVIDER = new ParameterizedCachedValueProvider<PsiElement, Pair<PsiElement, String>>(){

        @NotNull
        public CachedValueProvider.Result<PsiElement> compute(Pair<PsiElement, String> p) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)TypeScriptLiteralKeyUtil.resolveElementInScopeByQualifiedName((String)p.second, (PsiElement)p.first), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptLiteralKeyUtil$1", "compute"));
        }
    };

    @Nullable
    public static JSType modifyStringLiteralTypeForTaggedLiteralType(@NotNull JSExpression rawqualifier, @NotNull JSStringLiteralTypeImpl type, @Nullable PsiElement parent) {
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(1);
        }
        if (!(parent instanceof TypeScriptStringLiteralType)) {
            return null;
        }
        return JSTaggedLiteralKeyTypeImpl.tryCreate(rawqualifier.getParent(), (TypeScriptType)parent, type.getLiteral());
    }

    private static boolean canEvaluateParameterPart(JSExpression expression) {
        JSArgumentList argumentList = (JSArgumentList)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{JSArgumentList.class});
        if (argumentList != null) {
            for (JSExpression argument : argumentList.getArguments()) {
                if (!PsiTreeUtil.isContextAncestor((PsiElement)argument, (PsiElement)expression, (boolean)false) || JSTypeEvaluator.canProcessWithEvaluationGuard((PsiElement)argument, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static JSType modifyStringLiteralTypeByContextualType(@NotNull JSExpression rawqualifier, @NotNull JSStringLiteralTypeImpl type) {
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(2);
        }
        if (type == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(3);
        }
        if (!TypeScriptLiteralKeyUtil.canEvaluateParameterPart(rawqualifier)) {
            return null;
        }
        JSType contextualType = (JSType)RecursionManager.doPreventingRecursion((Object)rawqualifier, (boolean)false, () -> {
            if (rawqualifier == null) {
                TypeScriptLiteralKeyUtil.$$$reportNull$$$0(22);
            }
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation(rawqualifier);
        });
        if (contextualType == null) {
            return null;
        }
        ArrayList types = ContainerUtil.newArrayList();
        ArrayList typesWithAliases = ContainerUtil.newArrayList();
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            JSType referencedType;
            if (t instanceof JSTypeKeyTypeImpl) {
                JSType referencedType2 = ((JSTypeKeyTypeImpl)t).getReferencedType();
                if (!types.contains(referencedType2)) {
                    types.add(referencedType2);
                }
            } else if (t instanceof TypeScriptTypeOperatorJSTypeImpl) {
                JSType referencedType3 = ((TypeScriptTypeOperatorJSTypeImpl)((Object)t)).getReferencedType();
                if (!types.contains(referencedType3)) {
                    types.add(referencedType3);
                }
            } else if (t instanceof JSTaggedLiteralKeyTypeImpl && !typesWithAliases.contains(referencedType = ((JSTaggedLiteralKeyTypeImpl)t).getReferencedType())) {
                typesWithAliases.add(referencedType);
            }
            return true;
        }), contextualType, false, true, true);
        if (types.size() > 0) {
            return new JSTypeKeyTypeImpl(type.getLiteral(), (JSType)(types.size() == 1 ? (JSType)types.get(0) : new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier), types)), type.getSource());
        }
        if (typesWithAliases.size() > 0) {
            return new JSTaggedLiteralKeyTypeImpl(type.getLiteral(), (JSType)(typesWithAliases.size() == 1 ? (JSType)typesWithAliases.get(0) : new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier), typesWithAliases)), type.getSource());
        }
        return null;
    }

    @Nullable
    private static JSType findContextualTypeForLiteralLocation(@NotNull JSExpression rawqualifier) {
        PsiElement parent;
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(4);
        }
        if ((parent = rawqualifier.getParent()) instanceof JSParenthesizedExpression) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression) {
            boolean onlyRightArgAccepted;
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            boolean bl = onlyRightArgAccepted = operationSign == JSTokenTypes.ANDAND || operationSign == JSTokenTypes.COMMA;
            if (operationSign == JSTokenTypes.OROR || onlyRightArgAccepted) {
                JSExpression lOperand = ((JSBinaryExpression)parent).getLOperand();
                JSExpression rOperand = ((JSBinaryExpression)parent).getROperand();
                if (lOperand == rawqualifier && !onlyRightArgAccepted || rOperand == rawqualifier) {
                    return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
                }
            } else if (operationSign == JSTokenTypes.EQEQ || operationSign == JSTokenTypes.EQEQEQ || operationSign == JSTokenTypes.NE || operationSign == JSTokenTypes.NEQEQ) {
                JSTypeEvaluationResult expressionType;
                JSExpression lOperand = ((JSBinaryExpression)parent).getLOperand();
                JSExpression rOperand = ((JSBinaryExpression)parent).getROperand();
                if (lOperand == rawqualifier && rOperand != null) {
                    JSTypeEvaluationResult expressionType2 = JSTypeEvaluator.getExpressionType(rOperand);
                    if (expressionType2 != null) {
                        return expressionType2.getType();
                    }
                } else if (rOperand == rawqualifier && lOperand != null && (expressionType = JSTypeEvaluator.getExpressionType(lOperand)) != null) {
                    return expressionType.getType();
                }
            }
            return JSDialectSpecificHandlersFactory.findExpectedType(rawqualifier, JSExpectedTypeKind.CONTEXTUAL);
        }
        if (parent instanceof TypeScriptCastExpression && ((TypeScriptCastExpression)parent).getExpression() == rawqualifier) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSConditionalExpression && (((JSConditionalExpression)parent).getThen() == rawqualifier || ((JSConditionalExpression)parent).getElse() == rawqualifier)) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSCaseClause) {
            JSSwitchStatement switchStatement = ((JSCaseClause)parent).getSwitchStatement();
            if (switchStatement == null) {
                return null;
            }
            JSExpression expression = switchStatement.getSwitchExpression();
            if (expression == null) {
                return null;
            }
            JSTypeEvaluationResult expressionType = JSTypeEvaluator.getExpressionType(expression);
            return expressionType == null ? null : expressionType.getType();
        }
        return JSDialectSpecificHandlersFactory.findExpectedType(rawqualifier, JSExpectedTypeKind.CONTEXTUAL);
    }

    @Nullable
    public static JSType getTypeFromComputedNameProperty(@NotNull JSType ownerType, @NotNull JSType parameterType) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(5);
        }
        if (parameterType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(6);
        }
        return (JSType)TypeScriptLiteralKeyUtil.evalForAllProperties(ownerType, (o, e, i) -> {
            if (parameterType == null) {
                TypeScriptLiteralKeyUtil.$$$reportNull$$$0(21);
            }
            return TypeScriptLiteralKeyUtil.getTypeForComputedNameMember(parameterType, o, e);
        }, false);
    }

    @Nullable
    public static <T> T evalForAllProperties(@NotNull JSType ownerType, @NotNull TripleFunction<PsiElement, PsiElement, Integer, T> func, boolean enumerateAllMatches) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(7);
        }
        if (func == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(8);
        }
        JSType finalType = ownerType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)ownerType).getType() : ownerType;
        if ((finalType = TypeScriptTypeRelations.expandTypeRecursive(finalType)) instanceof JSResolvableType) {
            T t;
            JSClass jsClass;
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)finalType).resolveType();
            JSClass jSClass = jsClass = resolvedTypeInfo == null ? null : resolvedTypeInfo.getDeclarationOfType(JSClass.class);
            if (jsClass != null && (t = TypeScriptLiteralKeyUtil.addForClass(ownerType, func, enumerateAllMatches, jsClass)) != null) {
                return t;
            }
        } else if (finalType instanceof JSSimpleRecordTypeImpl) {
            T t;
            PsiElement sourceElement = finalType.getSource().getSourceElement();
            if (sourceElement instanceof JSObjectLiteralExpression) {
                for (JSProperty member : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                    Object type = func.fun((Object)member, (Object)ownerType.getSource().getSourceElement(), (Object)0);
                    if (enumerateAllMatches || type == null) continue;
                    return (T)type;
                }
            } else if (sourceElement instanceof TypeScriptObjectType) {
                for (TypeScriptTypeMember member : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    Object type = func.fun((Object)member, (Object)ownerType.getSource().getSourceElement(), (Object)0);
                    if (enumerateAllMatches || type == null) continue;
                    return (T)type;
                }
            } else if (sourceElement instanceof JSClassExpression && (t = TypeScriptLiteralKeyUtil.addForClass(ownerType, func, enumerateAllMatches, (JSClass)((JSClassExpression)sourceElement))) != null) {
                return t;
            }
        }
        return null;
    }

    @Nullable
    private static <T> T addForClass(@NotNull JSType ownerType, @NotNull TripleFunction<PsiElement, PsiElement, Integer, T> func, boolean enumerateAllMatches, @NotNull JSClass jsClass) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(9);
        }
        if (func == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(10);
        }
        if (jsClass == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(11);
        }
        Ref ref = Ref.create(null);
        Ref depth = Ref.create((Object)-1);
        JSClassUtils.processClassesInHierarchy(jsClass, true, (c, s, fi) -> {
            if (func == null) {
                TypeScriptLiteralKeyUtil.$$$reportNull$$$0(19);
            }
            if (ownerType == null) {
                TypeScriptLiteralKeyUtil.$$$reportNull$$$0(20);
            }
            depth.set((Object)((Integer)depth.get() + 1));
            for (PsiElement member : c.getMembers()) {
                Object type = func.fun((Object)member, (Object)ownerType.getSource().getSourceElement(), depth.get());
                if (enumerateAllMatches || type == null) continue;
                if (type instanceof JSType) {
                    type = JSTypeUtils.applyGenericArguments((JSType)type, (Map<String, JSType>)s);
                }
                ref.set(type);
                return false;
            }
            return true;
        });
        Object t = ref.get();
        if (t != null) {
            return (T)t;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiElement bypassImports(@Nullable PsiElement element) {
        if (element instanceof ES6ImportSpecifier) {
            ResolveResult[] results = ((ES6ImportSpecifier)element).resolveOverAliases();
            if (results.length != 1) {
                return null;
            }
            element = results[0].getElement();
        }
        if (element instanceof ES6ImportedBinding) {
            Collection elements1 = ((ES6ImportedBinding)element).findReferencedElements();
            if (elements1.size() != 1) {
                return null;
            }
            element = (PsiElement)elements1.iterator().next();
        }
        if (element instanceof JSExportAssignment) {
            JSElement assignedElement = ((JSExportAssignment)element).getStubSafeElement();
            if (assignedElement instanceof JSLiteralExpression) {
                return assignedElement;
            }
            if (assignedElement instanceof JSReferenceExpression) {
                element = ((JSReferenceExpression)assignedElement).resolve();
            }
            if (assignedElement instanceof JSClassExpression) {
                return assignedElement;
            }
        }
        return element;
    }

    @Nullable
    private static PsiElement resolveTopLevelElement(@NotNull String name, @NotNull PsiElement context) {
        List<PsiElement> elements;
        if (name == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(13);
        }
        if ((elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, context)).size() != 1) {
            return null;
        }
        PsiElement element = elements.get(0);
        return TypeScriptLiteralKeyUtil.bypassImports(element);
    }

    private static PsiElement processModuleChain(@NotNull List<String> parts, int index, @NotNull PsiElement element) {
        if (parts == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(14);
        }
        if (element == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(15);
        }
        for (PsiElement child : element.getChildren()) {
            String part = parts.get(index);
            if (child instanceof JSVarStatement && ES6ImportHandler.isExported(child)) {
                for (JSVariable jSVariable : ((JSVarStatement)child).getVariables()) {
                    if (!part.equals(jSVariable.getName())) continue;
                    return TypeScriptLiteralKeyUtil.bypassImports((PsiElement)jSVariable);
                }
                continue;
            }
            if (child instanceof TypeScriptModule && ES6ImportHandler.isExported(child)) {
                if (index + 1 >= parts.size()) {
                    return null;
                }
                element = TypeScriptLiteralKeyUtil.processModuleChain(parts, index + 1, child);
                if (element == null) continue;
                return element;
            }
            if (index + 1 != parts.size() - 1 || !(child instanceof JSClass)) continue;
            for (JSVariable jSVariable : ((JSClass)child).getFields()) {
                if (!parts.get(index + 1).equals(jSVariable.getName()) || !TypeScriptLiteralKeyUtil.isEnumFieldOrStaticReadonly((JSField)jSVariable)) continue;
                return jSVariable;
            }
        }
        return null;
    }

    private static boolean isEnumFieldOrStaticReadonly(JSField member) {
        return member instanceof TypeScriptEnumField || JSPsiImplUtils.hasModifier((JSAttributeListOwner)member, JSAttributeList.ModifierType.READONLY) && JSPsiImplUtils.hasModifier((JSAttributeListOwner)member, JSAttributeList.ModifierType.STATIC);
    }

    private static PsiElement resolveElementInScopeByQualifiedName(@NotNull String name, @NotNull PsiElement scopeContext) {
        int indexOfDot;
        if (name == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(16);
        }
        if (scopeContext == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(17);
        }
        if ((indexOfDot = name.indexOf(46)) == -1) {
            return TypeScriptLiteralKeyUtil.resolveTopLevelElement(name, scopeContext);
        }
        String substring = name.substring(0, indexOfDot);
        PsiElement element = TypeScriptLiteralKeyUtil.resolveTopLevelElement(substring, scopeContext);
        if (element == null) {
            return null;
        }
        List parts = StringUtil.split((String)name.substring(indexOfDot + 1), (String)".");
        if (element instanceof TypeScriptModule || element instanceof JSFile) {
            element = TypeScriptLiteralKeyUtil.processModuleChain(parts, 0, element);
        } else if (parts.size() == 1 && element instanceof JSClass) {
            for (JSField member : ((JSClass)element).getFields()) {
                if (member == null || !((String)parts.get(0)).equals(member.getName()) || !TypeScriptLiteralKeyUtil.isEnumFieldOrStaticReadonly(member)) continue;
                return member;
            }
        }
        return element;
    }

    @Nullable
    public static JSType getTypeForComputedPropExpression(@NotNull ES6ComputedName computedPropertyName) {
        EnumConstantValue value;
        String name;
        if (computedPropertyName == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(18);
        }
        if ((name = computedPropertyName.getExpressionAsReferenceName()) == null) {
            return null;
        }
        PsiElement element = (PsiElement)CachedValuesManager.getManager((Project)computedPropertyName.getProject()).getParameterizedCachedValue((UserDataHolder)computedPropertyName, CACHE_KEY, PROVIDER, false, (Object)Pair.create((Object)computedPropertyName, (Object)name));
        if (element instanceof JSLiteralExpression) {
            return JSResolveUtil.getExpressionJSType((JSExpression)element);
        }
        if (element instanceof TypeScriptEnumField && (value = ((TypeScriptEnumField)element).getConstantValue()).isValid()) {
            String stringValue = value.getStringValue();
            if (stringValue != null) {
                return new JSStringLiteralTypeImpl(stringValue, true, JSTypeSourceFactory.createTypeSource(element, true));
            }
            Double numericValue = value.getNumericValue();
            if (numericValue != null) {
                return new JSNumberLiteralTypeImpl(numericValue, true, JSTypeSourceFactory.createTypeSource(element, true), value.getSerializedString());
            }
        }
        return JSTypeUtils.getTypeOfElement(element);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static JSType getTypeForComputedNameMember(@Nullable JSType parameterType, @Nullable PsiElement member, @Nullable PsiElement sourceElement) {
        JSType type;
        if (!(member instanceof ES6Property) && !(member instanceof JSField)) {
            return null;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)member).getComputedPropertyName();
        if (computedPropertyName == null) {
            return null;
        }
        JSType expressionJSType = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (!(expressionJSType instanceof JSLiteralType)) {
            return null;
        }
        if (!expressionJSType.isEquivalentTo(parameterType, null) && !((JSLiteralType)expressionJSType).copyWithStrictness(true).isEquivalentTo(parameterType, null)) {
            return null;
        }
        JSType jSType = type = member instanceof ES6Property ? ((ES6Property)member).getType() : ((JSField)member).getType();
        if (type == null) {
            return null;
        }
        if (sourceElement instanceof JSIndexedPropertyAccessExpression) {
            JSExpression qualifier = ((JSIndexedPropertyAccessExpression)sourceElement).getQualifier();
            type = qualifier == null ? type : TypeScriptGenericTypesEvaluator.getInstance().evaluateGenericsFromQualifier(type, qualifier, (JSExpression)sourceElement);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 8: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedPropertyName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptLiteralKeyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyStringLiteralTypeForTaggedLiteralType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyStringLiteralTypeByContextualType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findContextualTypeForLiteralLocation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromComputedNameProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "evalForAllProperties";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addForClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveTopLevelElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processModuleChain";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveElementInScopeByQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeForComputedPropExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addForClass$3";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getTypeFromComputedNameProperty$2";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$modifyStringLiteralTypeByContextualType$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

