/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLocalClassIndex;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedNameResolver
extends JSQualifiedNameResolver {
    private final boolean myIsTypeContext;
    private final boolean myIncludeAugmentations;
    @NotNull
    private final Set<Pair<String, PsiElement>> myVisited;

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, boolean isTypeContext, boolean includeAugmentations, @NotNull Set<Pair<String, PsiElement>> visited) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        if (visited == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        super(context);
        this.myIsTypeContext = isTypeContext;
        this.myIncludeAugmentations = includeAugmentations;
        this.myVisited = visited;
    }

    @Override
    @NotNull
    protected TypeScriptQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(2);
        }
        TypeScriptQualifiedNameResolver typeScriptQualifiedNameResolver = new TypeScriptQualifiedNameResolver(newContext, this.myIsTypeContext, this.myIncludeAugmentations, this.myVisited);
        if (typeScriptQualifiedNameResolver == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(3);
        }
        return typeScriptQualifiedNameResolver;
    }

    @Override
    protected boolean isStrictTypeContext() {
        return this.myIsTypeContext;
    }

    @Override
    @NotNull
    protected Collection<PsiElement> getTopLevelElements(@NotNull String name, boolean isQualifier) {
        PsiElement parent;
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(4);
        }
        if (!this.myVisited.add((Pair<String, PsiElement>)Pair.create((Object)name, (Object)this.myContext))) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiElement source = this.myContext;
        JSElement moduleParent = ES6PsiUtil.getNonStrictExportScope(source);
        Collection<? extends PsiElement> localClasses = TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, isQualifier, (PsiElement)moduleParent, parent = source.getParent());
        if (localClasses != null) {
            ArrayList elements = ContainerUtil.newArrayList(localClasses);
            this.addMergedAndGlobalElements(TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)moduleParent), source, elements, true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule((PsiElement)moduleParent);
        boolean isModule = moduleParent instanceof TypeScriptModule || isParentExternalFileModule;
        TypeScriptModuleDeclarationsProcessor processor = new TypeScriptModuleDeclarationsProcessor(name, this.myIsTypeContext, false);
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        JSElement module = moduleParent;
        while (module != null) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope(module, processor, source, false);
            List<PsiElement> possibleResults = processor.getResults();
            if (!possibleResults.isEmpty()) {
                if (isParentExternalFileModule) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations((PsiElement)module, possibleResults, source, processor);
                    ArrayList results = ContainerUtil.newArrayList(processor.getResults());
                    TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(source, results);
                    ArrayList arrayList = results;
                    if (arrayList == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(7);
                    }
                    return arrayList;
                }
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getLocalElements((PsiElement)module, possibleResults);
                if (!isQualifier && isModule && !ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(8);
                    }
                    return collection;
                }
                result2.addAll(possibleResults);
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)module);
            this.addMergedAndGlobalElements(qName, source, result2, false);
            if (!isQualifier && !result2.isEmpty()) break;
            module = ES6PsiUtil.getExportScope((PsiElement)module);
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Nullable
    private static Collection<PsiElement> getLocalElements(@NotNull PsiElement module, @NotNull List<? extends PsiElement> possibleResults) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(10);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        ArrayList notPublic = null;
        for (PsiElement psiElement : possibleResults) {
            JSAttributeList list;
            if (!(psiElement instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)psiElement).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, psiElement)) continue;
            if (notPublic == null) {
                notPublic = ContainerUtil.newArrayList();
            }
            notPublic.add(psiElement);
        }
        return notPublic;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSFile && ((JSFile)module).isCommonJSModule() || ES6PsiUtil.isEmbeddedModule(module);
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, boolean isQualifier, @Nullable PsiElement module, @Nullable PsiElement parent) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(13);
        }
        if (module == parent || module == source || isQualifier) {
            return null;
        }
        if (TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            return null;
        }
        Collection elements = StubIndex.getElements(TypeScriptLocalClassIndex.KEY, (Object)name, (Project)source.getProject(), (GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)source.getContainingFile()), JSQualifiedNamedElement.class);
        if (elements.size() == 0) {
            return null;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result2.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result2.add(element);
                }
            }
            if (result2.isEmpty()) continue;
            return result2;
        }
        return null;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private void addMergedAndGlobalElements(@NotNull String qName, @NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2, boolean modulesOnly) {
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(14);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(16);
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(qName, currentSource);
        Condition condition = element -> {
            if (currentSource == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(33);
            }
            if (result2 == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(34);
            }
            return TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, result2, modulesOnly);
        };
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        result2.addAll(filteredElements);
        if (this.myIncludeAugmentations) {
            TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(currentSource, result2);
        }
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull List<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor) {
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(17);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(18);
        }
        if (realPlace == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(20);
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, realPlace, false);
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2, boolean modulesOnly) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(21);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(23);
        }
        if (result2.contains(element)) {
            return false;
        }
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return true;
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptImportHandler.checkModulesAccess(currentSource, (PsiElement)element);
        }
        PsiElement externalSourceModule = ES6PsiUtil.findExternalModule(currentSource);
        if (!(TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) || TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, currentSource) || TypeScriptQualifiedNameResolver.checkGlobalAugmentation((PsiElement)element))) {
            return false;
        }
        return TypeScriptImportHandler.checkModulesAccess(currentSource, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean checkGlobalAugmentation(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        JSElement scope = ES6PsiUtil.getExportScope(element);
        while (scope instanceof TypeScriptModule && !((TypeScriptModule)scope).isGlobalScopeAugmentation()) {
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
        return scope instanceof TypeScriptModule && ((TypeScriptModule)scope).isGlobalScopeAugmentation();
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private static void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(26);
        }
        if (result2.size() > 0 && !(externalModules = TypeScriptQualifiedNameResolver.getModulesForAugmentations(result2)).isEmpty()) {
            result2.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    private static Collection<PsiElement> getModulesForAugmentations(@NotNull Collection<PsiElement> result2) {
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        ArrayList modules = ContainerUtil.newArrayList();
        for (PsiElement element : result2) {
            TypeScriptModule typeScriptModule;
            String refName;
            TypeScriptExportAssignment assignment;
            PsiElement module;
            if (ES6PsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || (module = ES6PsiUtil.findExternalModule(element)) == null || (assignment = TypeScriptPsiUtil.findExportAssignment(module)) == null || !StringUtil.equals((CharSequence)(refName = assignment.getInitializerReference()), (CharSequence)TypeScriptQualifiedNameResolver.getQualifiedNameWithoutParentModule(typeScriptModule = (TypeScriptModule)element, module))) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static String getQualifiedNameWithoutParentModule(@NotNull TypeScriptModule module, @NotNull PsiElement externalModule) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(29);
        }
        String moduleQualifiedName = module.getQualifiedName();
        if (externalModule instanceof TypeScriptModule) {
            String name = ((TypeScriptModule)externalModule).getQualifiedName();
            if (moduleQualifiedName == null || name == null) {
                return moduleQualifiedName;
            }
            int indexOfExternalModule = moduleQualifiedName.indexOf(name);
            if (indexOfExternalModule != -1) {
                int position = indexOfExternalModule + name.length() + 1;
                return position < moduleQualifiedName.length() ? moduleQualifiedName.substring(position) : moduleQualifiedName;
            }
        }
        return moduleQualifiedName;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(30);
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        PsiElement sourceContainer;
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(31);
        }
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(32);
        }
        if (TypeScriptPsiUtil.isAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || TypeScriptPsiUtil.isAugmentationModule(element) || TypeScriptPsiUtil.isAugmentationModule(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 4: 
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 15: 
            case 22: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSource";
                break;
            }
            case 16: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModule";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realPlace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedResolver";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNestedResolver";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesIfExists";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addMergedAndGlobalElements";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMergedElementsFromAugmentations";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMergeSymbol";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkGlobalAugmentation";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addAugmentationsForModuleResults";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForAugmentations";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameWithoutParentModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameForModule";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAugmentationAccess";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMergedAndGlobalElements$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

