/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveProcessor<T extends ResultSink>
extends TypeScriptQualifiedItemProcessor<T> {
    private final NullableLazyValue<List<JSType>> myArgumentTypesValue;
    private final boolean myStrictTypeContext;
    private final boolean myIncompleteCode;
    private final boolean myStrictTypeContainerContext;
    @Nullable
    private final JSCallExpression myCallExpression;
    private final NullableLazyValue<JSType> myQualifierTypeValue;

    public TypeScriptResolveProcessor(ResultSink sink, PsiFile containingFile, PsiElement _place, boolean incompleteCode) {
        super(sink, containingFile);
        PsiElement parent;
        JSReferenceExpression topRefExpression;
        this.myStrictTypeContext = _place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)_place);
        this.myIncompleteCode = incompleteCode;
        this.myStrictTypeContainerContext = !this.myStrictTypeContext ? (topRefExpression = TypeScriptResolveProcessor.getTopRefExpression(_place)) != null && JSResolveUtil.isExprInStrictTypeContext(topRefExpression) : false;
        PsiElement psiElement = parent = this.place instanceof PsiFile ? this.place : this.place.getParent();
        while (parent instanceof JSParenthesizedExpressionImpl) {
            parent = parent.getParent();
        }
        this.myCallExpression = parent instanceof JSCallExpression ? (JSCallExpression)parent : null;
        this.myArgumentTypesValue = NullableLazyValue.createValue(() -> {
            if (this.myCallExpression == null) {
                return null;
            }
            return TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(this.myCallExpression);
        });
        this.myQualifierTypeValue = NullableLazyValue.createValue(() -> {
            if (this.myCallExpression == null) {
                return null;
            }
            JSExpression expression = this.myCallExpression.getMethodExpression();
            if (!(expression instanceof JSReferenceExpression)) {
                return null;
            }
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier == null ? null : JSResolveUtil.getExpressionJSType(qualifier);
        });
    }

    public TypeScriptResolveProcessor(String referenceName, PsiFile containingFile, JSExpression _place, boolean incompleteCode) {
        this(new ResolveResultSink((PsiElement)_place, referenceName), containingFile, (PsiElement)_place, incompleteCode);
    }

    @Nullable
    private static JSReferenceExpression getTopRefExpression(@Nullable PsiElement _place) {
        JSReferenceExpression result2 = null;
        while (_place instanceof JSReferenceExpression) {
            result2 = (JSReferenceExpression)_place;
            _place = _place.getParent();
        }
        return result2;
    }

    @Override
    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        if (clazz instanceof TypeScriptModule) {
            String moduleName = ((TypeScriptModule)clazz).getName();
            String elementName = null;
            if (element instanceof PsiNamedElement) {
                elementName = ((PsiNamedElement)element).getName();
            } else if (element instanceof JSReferenceExpression) {
                elementName = ((JSReferenceExpression)element).getReferenceName();
            }
            if (Comparing.equal((String)elementName, (String)moduleName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        if (this.myStrictTypeContext || this.myStrictTypeContainerContext) {
            return TypeScriptPsiUtil.referencesNamedTypeContainer(specifier);
        }
        return super.isSpecifierAcceptable(specifier);
    }

    @NotNull
    private JSResolveResult checkParameterTypesForSignatureAndOverloads(@NotNull JSResolveResult result2) {
        if (result2 == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(0);
        }
        PsiElement element = result2.getElement();
        if (this.myIncompleteCode || this.myCallExpression == null || element == null) {
            JSResolveResult jSResolveResult = result2;
            if (jSResolveResult == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(1);
            }
            return jSResolveResult;
        }
        JSTypeSubstitutor genericsFromType = TypeScriptResolveProcessor.getExplicitTypeGenerics(result2);
        JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(element, (PsiElement)this.myCallExpression, genericsFromType);
        JSResolveResult resolveResult = TypeScriptSignatureChooser.checkParameterTypes(element, (List<JSType>)((List)this.myArgumentTypesValue.getValue()), this.myQualifierTypeValue, genericArguments, this.myCallExpression instanceof JSNewExpression);
        ES6ImportExportDeclarationPart usedImport = (ES6ImportExportDeclarationPart)ObjectUtils.coalesce((Object)result2.getES6Import(), (Object)resolveResult.getES6Import());
        if (!resolveResult.isValidResult()) {
            PsiElement elementToResolve = element;
            if (TypeScriptSignatureChooser.isOverloadImplementation(element)) {
                elementToResolve = resolveResult.getElement();
            }
            JSResolveResult jSResolveResult = new JSResolveResult(elementToResolve, (JSElement)usedImport, resolveResult.getResolveProblemKey());
            if (jSResolveResult == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(2);
            }
            return jSResolveResult;
        }
        JSResolveResult jSResolveResult = usedImport == null ? resolveResult : resolveResult.copyWithImport((JSElement)usedImport);
        if (jSResolveResult == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(3);
        }
        return jSResolveResult;
    }

    @NotNull
    private static JSTypeSubstitutor getExplicitTypeGenerics(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(4);
        }
        JSTypeSubstitutor explicitTypeGenerics = JSTypeSubstitutor.EMPTY;
        if (!(resolveResult instanceof JSResolveResult)) {
            JSTypeSubstitutor jSTypeSubstitutor = explicitTypeGenerics;
            if (jSTypeSubstitutor == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(5);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = ((JSResolveResult)resolveResult).getTypeSubstitutor();
        JSTypeSubstitutor jSTypeSubstitutor = substitutor == null ? explicitTypeGenerics : substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(6);
        }
        return jSTypeSubstitutor;
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        ResolveResult[] results = super.getResultsAsResolveResults();
        return this.myCallExpression == null ? results : this.chooseSignatures(results);
    }

    @NotNull
    public ResolveResult[] chooseSignatures(@NotNull ResolveResult[] results) {
        ResolveResult[] finalResults;
        int argumentsLength;
        List filterResult;
        TypeScriptImplicitOverloadedAliasElement element;
        if (results == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(7);
        }
        if (this.myIncompleteCode || results.length == 0) {
            if (results == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(8);
            }
            return results;
        }
        assert (this.myCallExpression != null);
        if (results.length == 1) {
            if (results == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(9);
            }
            return results;
        }
        String fakeAliasName = null;
        JSNamedElement aliasElement = null;
        if (Arrays.stream(results).allMatch(r -> r.getElement() instanceof TypeScriptImplicitOverloadedAliasElement) && (element = (TypeScriptImplicitOverloadedAliasElement)results[0].getElement()) != null) {
            fakeAliasName = element.getName();
            aliasElement = (JSNamedElement)element.getExplicitElement();
            results = TypeScriptImplicitOverloadedAliasElement.unwrapElements(results);
        }
        if ((filterResult = ContainerUtil.filter((Object[])results, arg_0 -> TypeScriptResolveProcessor.lambda$chooseSignatures$3(argumentsLength = this.myCallExpression.getArguments().length, arg_0))).size() == 1) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{(ResolveResult)filterResult.get(0)};
            if (resolveResultArray == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(10);
            }
            return resolveResultArray;
        }
        LinkedHashSet validResults = ContainerUtil.newLinkedHashSet();
        ArrayList inValidResults = ContainerUtil.newArrayList();
        List toCheck = filterResult.size() > 0 ? filterResult : ContainerUtil.newArrayList((Object[])results);
        for (ResolveResult result2 : toCheck) {
            PsiElement element2 = result2.getElement();
            if (!(result2 instanceof JSResolveResult) || !result2.isValidResult() || element2 == null) {
                AbstractCollection toAdd = result2.isValidResult() ? validResults : inValidResults;
                toAdd.add(result2);
                continue;
            }
            JSResolveResult oldResolveResult = (JSResolveResult)result2;
            JSResolveResult newResolveResult = this.checkParameterTypesForSignatureAndOverloads(oldResolveResult);
            if (newResolveResult.isValidResult()) {
                JSElement importElement = (JSElement)ObjectUtils.coalesce((Object)oldResolveResult.getES6Import(), (Object)newResolveResult.getES6Import());
                validResults.add(newResolveResult.copyWithImport(importElement));
                continue;
            }
            inValidResults.add(newResolveResult);
        }
        ResolveResult[] resolveResultArray = finalResults = validResults.size() > 0 ? TypeScriptPsiUtil.chooseOverload(validResults.toArray(ResolveResult.EMPTY_ARRAY)) : inValidResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (fakeAliasName != null && aliasElement != null) {
            finalResults = TypeScriptImplicitOverloadedAliasElement.wrapElements(finalResults, fakeAliasName, aliasElement);
        }
        if (finalResults == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(11);
        }
        return finalResults;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(12);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(13);
        }
        if (this.myStrictTypeContext && !TypeScriptPsiUtil.isNamedTypeDefinition(element)) {
            return true;
        }
        if (this.myStrictTypeContainerContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) {
            return true;
        }
        if (!(this.myStrictTypeContext || !(this.place instanceof JSReferenceExpression) || !(element instanceof TypeScriptCompileTimeType) || this.place instanceof TypeScriptModule || this.place instanceof TypeScriptEntityName || this.place instanceof TypeScriptImportStatement || this.place.getParent() instanceof JSExportAssignment)) {
            return true;
        }
        return super.execute(element, state);
    }

    public boolean isCallExpression() {
        return this.myCallExpression != null;
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(14);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(15);
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration()) {
            return true;
        }
        if (element instanceof TypeScriptIndexSignature && this.myName != null && ((TypeScriptIndexSignature)element).getIndexSignatureKind() == JSRecordType.IndexSignatureKind.STRING) {
            return ((ResultSink)this.getResultSink()).addResult(element, state, this);
        }
        return super.executeAcceptedElement(element, state);
    }

    public boolean isStrictTypeContext() {
        return this.myStrictTypeContext;
    }

    @Override
    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(16);
        }
        return element;
    }

    private static /* synthetic */ boolean lambda$chooseSignatures$3(int argumentsLength, ResolveResult el) {
        PsiElement result2 = el.getElement();
        if (result2 instanceof TypeScriptFunction) {
            JSParameterListElement[] parameters = ((TypeScriptFunction)result2).getParameters();
            int min = TypeScriptSignatureChooser.getMinArgumentCount((JSParameterItem[])parameters);
            int max = TypeScriptSignatureChooser.getMaxArgumentCount((JSParameterItem[])parameters);
            return min <= argumentsLength && argumentsLength <= max;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkParameterTypesForSignatureAndOverloads";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeGenerics";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypesForSignatureAndOverloads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeGenerics";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chooseSignatures";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

