/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.types.ES6ClassElementType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.impl.JSArgumentListImpl;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.types.TypeScriptClassElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSpacingProcessor
extends JSNodeVisitor {
    protected final ASTNode myParent;
    protected final ASTNode myChild1;
    protected final ASTNode myChild2;
    protected final CommonCodeStyleSettings mySettings;
    @NotNull
    protected final JSCodeStyleSettings myJSCodeStyleSettings;
    private static final TokenSet SEMICOLON_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.SEMICOLON});
    private static final TokenSet METHOD_LIKE_CLASS_MEMBERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.INDEX_SIGNATURE})});
    private final TokenSet FIELD_LIKE_CLASS_MEMBERS;
    protected Spacing myResult;
    protected final IElementType type1;
    protected final IElementType type2;
    public static final TokenSet NOT_A_PACKAGE_CONTENT = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PACKAGE_KEYWORD, JSElementTypes.REFERENCE_EXPRESSION, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE});
    private static final TokenSet ES6_CLASSES = TokenSet.create((IElementType[])IElementType.enumerate(type -> type instanceof ES6ClassElementType || type instanceof TypeScriptClassElementType || type == JSStubElementTypes.TYPESCRIPT_INTERFACE || type == JSStubElementTypes.TYPESCRIPT_ENUM));

    public JSSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings topSettings, Language dialect, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (jsCodeStyleSettings == null) {
            JSSpacingProcessor.$$$reportNull$$$0(0);
        }
        this.FIELD_LIKE_CLASS_MEMBERS = JSElementTypes.VAR_STATEMENTS;
        this.myParent = parent;
        this.myChild1 = child1;
        this.myChild2 = child2;
        this.type1 = child1.getElementType();
        this.type2 = child2.getElementType();
        this.mySettings = topSettings.getCommonSettings(dialect);
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
    }

    public Spacing calcSpacing() {
        if (!this.isLineCommentSpacing()) {
            this.visit(this.myParent);
        }
        return this.myResult;
    }

    private boolean isLineCommentSpacing() {
        if (JSFormatterUtil.isInlineEndOfLineComment(this.myChild2) && this.type1 != JSStubElementTypes.IMPORT_STATEMENT) {
            this.myResult = Spacing.getReadOnlySpacing();
            return true;
        }
        if (this.type1 == JSTokenTypes.END_OF_LINE_COMMENT) {
            boolean isTemplateLangRightChild;
            int blankLines = this.mySettings.KEEP_BLANK_LINES_IN_CODE;
            if (this.type2 == JSStubElementTypes.IMPORT_STATEMENT) {
                blankLines = this.mySettings.BLANK_LINES_BEFORE_IMPORTS;
            }
            int minBlankLines = (isTemplateLangRightChild = this.myChild2.getPsi() instanceof OuterLanguageElement) ? 0 : 1;
            boolean keepLineBreaks = isTemplateLangRightChild || this.mySettings.KEEP_LINE_BREAKS;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)minBlankLines, (boolean)keepLineBreaks, (int)blankLines);
            return true;
        }
        return false;
    }

    @Override
    public void visitObjectLiteralExpression(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES);
    }

    @Override
    public void visitDestructuringObject(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES);
    }

    @Override
    protected void visitDestructuringElement(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        super.visitDestructuringElement(node);
    }

    @Override
    protected void visitAssignmentProperty(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        super.visitAssignmentProperty(node);
    }

    @Override
    protected void visitDestructuringProperty(ASTNode node) {
        this.appendPropertySpacing();
        super.visitDestructuringProperty(node);
    }

    private void appendPropertySpacing() {
        if (this.type2 == JSTokenTypes.COLON) {
            int spaces = this.myJSCodeStyleSettings.SPACE_BEFORE_PROPERTY_COLON ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
        } else if (this.type1 == JSTokenTypes.COLON) {
            int spaces = this.myJSCodeStyleSettings.SPACE_AFTER_PROPERTY_COLON ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private void forceSpaceInBraces(ASTNode node, boolean needSpace) {
        this.forceSpaceInBraces(node, needSpace, (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.LBRACE), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.RBRACE), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.COMMA));
    }

    protected void forceSpaceInBraces(ASTNode node, boolean needSpace, Condition<IElementType> isLBrace, Condition<IElementType> isRBrace, Condition<IElementType> isDelimiter) {
        int spaces = needSpace ? 1 : 0;
        this.setSpaceInBraces(node, spaces, spaces, isLBrace, isRBrace, isDelimiter);
    }

    protected void setSpaceInBraces(ASTNode node, int minSpaces, int maxSpaces) {
        this.setSpaceInBraces(node, minSpaces, maxSpaces, (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.LBRACE), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.RBRACE), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.COMMA));
    }

    protected void setSpaceInBraces(ASTNode node, int minSpaces, int maxSpaces, Condition<IElementType> isLBrace, Condition<IElementType> isRBrace, Condition<IElementType> isDelimiter) {
        if (isLBrace.value((Object)this.type1) || isRBrace.value((Object)this.type2)) {
            if (isLBrace.value((Object)this.type1) && isRBrace.value((Object)this.type2)) {
                this.forceSingleSpace(false);
                return;
            }
            this.myResult = Spacing.createDependentLFSpacing((int)minSpaces, (int)maxSpaces, (TextRange)node.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (isDelimiter.value((Object)this.type1) || isDelimiter.value((Object)this.type2)) {
            this.createDelimiterSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE, isDelimiter);
        }
    }

    @Override
    public void visitES6ImportDeclaration(ASTNode node) {
        if (this.type1 == JSTokenTypes.IMPORT_KEYWORD || this.type2 == ES6ElementTypes.FROM_CLAUSE) {
            this.setSingleSpace(true);
        }
        this.createCommaSpacing(this.type1, this.type2, 0);
    }

    @Override
    protected void visitES6NamedImports(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_IMPORTS);
    }

    @Override
    public void visitES6DoExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.DO_KEYWORD && this.type2 == JSElementTypes.BLOCK_STATEMENT) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.BRACE_STYLE, null);
        } else {
            this.visitBlockStatement(node);
        }
        super.visitES6DoExpression(node);
    }

    @Override
    public void visitES6ExportDeclaration(ASTNode node) {
        if (this.type1 == JSTokenTypes.EXPORT_KEYWORD) {
            this.setSingleSpace(true);
        }
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_IMPORTS);
    }

    @Override
    protected void visitES6FromClause(ASTNode node) {
        if (this.type1 == JSTokenTypes.FROM_KEYWORD) {
            this.setSingleSpace(true);
        }
    }

    @Override
    public void visitExportDefaultAssignment(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.type1 == JSTokenTypes.EXPORT_KEYWORD || this.type1 == JSTokenTypes.DEFAULT_KEYWORD) {
            this.forceSingleSpace(true);
        }
        super.visitExportDefaultAssignment(node);
    }

    @Override
    public void visitArrayLiteralExpression(ASTNode node) {
        this.forceSpacesInBrackets(this.mySettings.SPACE_WITHIN_BRACKETS);
    }

    @Override
    public void visitDestructuringArray(ASTNode node) {
        this.forceSpacesInBrackets(this.mySettings.SPACE_WITHIN_BRACKETS);
    }

    protected void forceSpacesInBrackets(boolean spaceWithin) {
        if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            int spaces;
            if (this.type1 == JSTokenTypes.LBRACKET && this.type2 == JSTokenTypes.RBRACKET) {
                this.forceSingleSpace(false);
                return;
            }
            int n = spaces = spaceWithin ? 1 : 0;
            if (this.isArrayBracketOnAnotherLine(this.type1) || this.isArrayBracketOnAnotherLine(this.type2)) {
                TextRange parentRange = this.myParent.getTextRange();
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)parentRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                return;
            }
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    @Override
    public void visitXmlLiteralExpression(ASTNode node) {
        if (this.type2 == JSTokenTypes.XML_JS_SCRIPT) {
            this.myResult = Spacing.getReadOnlySpacing();
        } else if (this.type2 == JSElementTypes.XML_LITERAL_EXPRESSION || this.type1 == JSTokenTypes.XML_START_TAG_LIST && this.type2 != JSTokenTypes.XML_END_TAG_LIST && this.type2 != JSTokenTypes.XML_TAG_CONTENT || this.type1 == JSElementTypes.XML_LITERAL_EXPRESSION) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitAttributeList(ASTNode node) {
        if (this.type1 == JSStubElementTypes.ATTRIBUTE || this.type2 == JSStubElementTypes.ATTRIBUTE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSElementTypes.REFERENCE_EXPRESSION && this.type2 == JSTokenTypes.STATIC_KEYWORD) {
            this.setSingleSpace(true);
        } else if (JSTokenTypes.MODIFIERS.contains(this.type1) && this.type2 == JSTokenTypes.STATIC_KEYWORD) {
            this.forceSingleSpace();
        } else if (this.type1 == JSTokenTypes.AT && this.type2 == JSStubElementTypes.ES6_DECORATOR) {
            this.myResult = Spacing.getReadOnlySpacing();
        } else if (this.type1 == JSStubElementTypes.ES6_DECORATOR && (JSTokenTypes.MODIFIERS.contains(this.type2) || JSTokenTypes.MULT == this.type2)) {
            IElementType parentElementType = node.getTreeParent().getElementType();
            this.myResult = parentElementType != TypeScriptElementTypes.TYPESCRIPT_PARAMETER && !JSElementTypes.VAR_STATEMENTS.contains(parentElementType) ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (JSTokenTypes.MULT == this.type2) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_GENERATOR_MULT);
        } else if (JSTokenTypes.MULT == this.type1) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_GENERATOR_MULT);
        } else {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitEmbeddedContent(ASTNode node) {
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type2) && this.type1 != JSTokenTypes.DOT || this.type2 == JSTokenTypes.RBRACE) {
            this.visitFile(node);
        }
    }

    @Override
    protected void visitEmbeddedExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS);
        }
    }

    @Override
    public void visitParameterList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR && this.type2 == JSTokenTypes.RPAR) {
            this.forceSingleSpace(false);
        } else if (this.type1 == JSTokenTypes.LPAR) {
            this.myResult = JSSpacingProcessor.createDependentSpacingIfListWrapped(node, root -> root.getChildren(JSExtendedLanguagesTokenSetProvider.PARAMETERS), this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE && this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.myResult = JSSpacingProcessor.createDependentSpacingIfListWrapped(node, root -> root.getChildren(JSExtendedLanguagesTokenSetProvider.PARAMETERS), this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE && this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, 0);
        }
    }

    @Override
    public void visitPackageStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            this.setSpaceBeforeLBraceIfMultiline(this.mySettings.CLASS_BRACE_STYLE, this.myJSCodeStyleSettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.type1 == JSTokenTypes.LBRACE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.processBlock();
        }
    }

    @Override
    public void visitImportStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.IMPORT_KEYWORD && this.type2 == JSElementTypes.REFERENCE_EXPRESSION) {
            this.forceSingleSpace();
        }
    }

    @Override
    public void visitClass(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            TextRange range = this.getClassBodyRange();
            if (range != null) {
                this.setSpaceBeforeLBraceIfMultiline(this.mySettings.CLASS_BRACE_STYLE, this.myJSCodeStyleSettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE, range);
            }
        } else {
            this.processClassOrInterface();
        }
        this.appendSpaceBeforeGenerics();
    }

    @Override
    public void visitBlockStatement(ASTNode node) {
        this.processBlock();
    }

    @Override
    public void visitCaseClause(ASTNode node) {
        if (this.type1 == JSTokenTypes.COLON && this.type2 == JSElementTypes.BLOCK_STATEMENT) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, this.myChild2.getTextRange());
            return;
        }
        this.processBlock();
    }

    protected void processClassOrInterface() {
        if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1) && this.type2 == JSTokenTypes.CLASS_KEYWORD) {
            this.decoratorSpacing();
        } else if (this.type1 == JSTokenTypes.CLASS_KEYWORD && this.type2 == JSElementTypes.REFERENCE_EXPRESSION) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        } else if (this.type1 == JSElementTypes.REFERENCE_EXPRESSION && JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(this.type2)) {
            this.setSingleSpace(true);
        } else if (JSElementTypes.EXTENDS_LISTS.contains(this.type1) && this.type2 == JSStubElementTypes.IMPLEMENTS_LIST) {
            this.setSingleSpace(true);
        } else if (ES6_CLASSES.contains(this.myParent.getElementType())) {
            this.processClassBody(METHOD_LIKE_CLASS_MEMBERS, this.FIELD_LIKE_CLASS_MEMBERS, SEMICOLON_TOKEN_SET, this.mySettings.BLANK_LINES_AROUND_METHOD, this.mySettings.BLANK_LINES_AROUND_FIELD);
        } else {
            this.processBlock(this.mySettings.BLANK_LINES_AROUND_METHOD);
        }
    }

    protected void processClassBody(@NotNull TokenSet methodTokenSet, @NotNull TokenSet fieldTokenSet, @NotNull TokenSet delimiters, int blankLinesAroundMethod, int blankLinesAroundField) {
        if (methodTokenSet == null) {
            JSSpacingProcessor.$$$reportNull$$$0(1);
        }
        if (fieldTokenSet == null) {
            JSSpacingProcessor.$$$reportNull$$$0(2);
        }
        if (delimiters == null) {
            JSSpacingProcessor.$$$reportNull$$$0(3);
        }
        if (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE) {
            Computable bodyRangeComputable = this::getClassBodyRange;
            int blankLinesSetting = this.mySettings.KEEP_BLANK_LINES_IN_CODE;
            this.setDependentSpacingIfNecessary(this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE, (Computable<TextRange>)bodyRangeComputable, false, 1, this.mySettings.KEEP_LINE_BREAKS, blankLinesSetting);
            return;
        }
        if (this.shouldKeepCloseToRelatedMembers()) {
            this.setBlankLines(0, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            return;
        }
        boolean isMethod = this.needBlankLinesAroundDeclaration(methodTokenSet, delimiters);
        boolean isField = this.needBlankLinesAroundDeclaration(fieldTokenSet, delimiters);
        if (isField || isMethod) {
            this.setBlankLines(Math.max(isMethod ? blankLinesAroundMethod : 0, isField ? blankLinesAroundField : 0), this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.processBlock();
        }
    }

    private boolean needBlankLinesAroundDeclaration(@NotNull TokenSet declarations, @NotNull TokenSet delimiters) {
        if (declarations == null) {
            JSSpacingProcessor.$$$reportNull$$$0(4);
        }
        if (delimiters == null) {
            JSSpacingProcessor.$$$reportNull$$$0(5);
        }
        if (JSTokenTypes.COMMENTS.contains(this.type1) && !JSTokenTypes.COMMENTS.contains(this.type2)) {
            return false;
        }
        if (delimiters.contains(this.type2)) {
            return false;
        }
        if (declarations.contains(this.type2) || declarations.contains(this.type1)) {
            return true;
        }
        if (JSTokenTypes.COMMENTS.contains(this.type2) && FormatterUtil.isFollowedBy((ASTNode)this.myChild2, (TokenSet)declarations, (IElementType[])new IElementType[0])) {
            return true;
        }
        if (delimiters.contains(this.type1) && FormatterUtil.isPrecededBy((ASTNode)this.myChild1, (TokenSet)declarations)) {
            return !delimiters.contains(this.type2);
        }
        return false;
    }

    protected void processBlock() {
        this.processBlock(this.myJSCodeStyleSettings.BLANK_LINES_AROUND_FUNCTION);
    }

    protected void processBlock(int blankLinesAroundFunction) {
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type1) || JSTokenTypes.COMMENTS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type2) || this.type2 == JSTokenTypes.RBRACE) {
            if (JSSpacingProcessor.isInjectedJSHack(this.type1, this.type2) || JSSpacingProcessor.isInjectedJSHack(this.type2, this.type1)) {
                this.myResult = Spacing.getReadOnlySpacing();
            } else {
                boolean keepOneLine = false;
                ASTNode superParent = this.myParent.getTreeParent();
                if (superParent != null) {
                    boolean bl = keepOneLine = superParent.getPsi() instanceof JSFunction ? this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE : this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
                }
                if (keepOneLine && (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE)) {
                    int blankLinesSetting = this.mySettings.KEEP_BLANK_LINES_IN_CODE;
                    this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesSetting);
                } else if (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT != this.type2 && JSTokenTypes.RBRACE != this.type2) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_AFTER_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (JSStubElementTypes.IMPORT_STATEMENT != this.type1 && JSTokenTypes.LBRACE != this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_BEFORE_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2) {
                    this.myResult = this.getSpacingBetweenImports();
                } else if (JSStubElementTypes.USE_NAMESPACE_DIRECTIVE == this.type1 && JSStubElementTypes.USE_NAMESPACE_DIRECTIVE != this.type2 && JSTokenTypes.RBRACE != this.type2 || JSStubElementTypes.USE_NAMESPACE_DIRECTIVE != this.type1 && JSTokenTypes.LBRACE != this.type1 && JSStubElementTypes.USE_NAMESPACE_DIRECTIVE == this.type2) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (JSTokenTypes.LBRACE == this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                } else if ((JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.CLASSES.contains(this.type1)) && this.type2 == JSElementTypes.EMPTY_STATEMENT) {
                    this.setSingleSpace(false);
                } else {
                    if (JSTokenTypes.LBRACE != this.type1 && JSTokenTypes.RBRACE != this.type2) {
                        boolean isFunction = this.needBlankLinesAroundDeclaration(JSElementTypes.FUNCTION_DECLARATIONS, TokenSet.EMPTY);
                        boolean isClass = this.needBlankLinesAroundDeclaration(ES6_CLASSES, TokenSet.EMPTY);
                        if (!this.shouldKeepCloseToRelatedMembers() && isFunction || isClass) {
                            int minBlankLines = Math.max(isFunction ? blankLinesAroundFunction : 0, isClass ? this.mySettings.BLANK_LINES_AROUND_CLASS : 0);
                            this.setBlankLines(minBlankLines, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                            return;
                        }
                    }
                    this.myResult = this.isStatementWithLeadingSemicolon() ? Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
        }
    }

    protected boolean shouldKeepCloseToRelatedMembers() {
        JSFunction fun = JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type2) ? (JSFunction)this.myChild2.getPsi() : null;
        JSVariable var = JSElementTypes.VAR_STATEMENTS.contains(this.type1) ? (JSVariable)ArrayUtil.getFirstElement((Object[])((JSVarStatement)this.myChild1.getPsi()).getVariables()) : null;
        return var != null && fun != null && (fun.isGetProperty() || fun.isSetProperty()) && StringUtil.equals((CharSequence)JSRefactoringUtil.transformVarNameToAccessorName(var.getName(), this.myJSCodeStyleSettings), (CharSequence)fun.getName());
    }

    private Spacing getSpacingBetweenImports() {
        String fqn1 = ((JSImportStatement)this.myChild1.getPsi()).getImportText();
        String fqn2 = ((JSImportStatement)this.myChild2.getPsi()).getImportText();
        String rootPackage1 = fqn1 != null && fqn1.contains(".") ? fqn1.substring(0, fqn1.indexOf(".")) : null;
        String rootPackage2 = fqn2 != null && fqn2.contains(".") ? fqn2.substring(0, fqn2.indexOf(".")) : null;
        boolean lineBreak = rootPackage1 != null && rootPackage2 != null && !rootPackage1.equals(rootPackage2);
        return Spacing.createSpacing((int)0, (int)0, (int)(lineBreak ? 2 : 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static boolean isInjectedJSHack(IElementType type1, IElementType type2) {
        return type1 == JSTokenTypes.BAD_CHARACTER && JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(type2);
    }

    @Override
    public void visitFile(ASTNode node) {
        if (TypeScriptElementTypes.TYPESCRIPT_IMPORTS.contains(this.type1) && !TypeScriptElementTypes.TYPESCRIPT_IMPORTS.contains(this.type2) && !JSTokenTypes.COMMENTS.contains(this.type2)) {
            int minLines = this.mySettings.BLANK_LINES_AFTER_IMPORTS;
            if (ES6_CLASSES.contains(this.type2)) {
                minLines = Math.max(this.mySettings.BLANK_LINES_AROUND_CLASS, this.mySettings.BLANK_LINES_AFTER_IMPORTS);
            } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type2)) {
                minLines = Math.max(this.mySettings.BLANK_LINES_AROUND_METHOD, this.mySettings.BLANK_LINES_AFTER_IMPORTS);
            }
            this.setBlankLines(minLines, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.processBlock();
        }
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
        this.visitFunction(this.mySettings.METHOD_BRACE_STYLE);
    }

    private void visitFunction(int braceStyle) {
        if (this.type2 == JSTokenTypes.MULT && !JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1)) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_GENERATOR_MULT);
            return;
        }
        if (this.type1 == JSTokenTypes.MULT) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_GENERATOR_MULT);
            return;
        }
        if ((this.type1 == JSTokenTypes.GET_KEYWORD || this.type1 == JSTokenTypes.SET_KEYWORD) && JSKeywordSets.IDENTIFIER_NAMES.contains(this.type2)) {
            this.forceSingleSpace(true);
            return;
        }
        if (this.type1 == JSTokenTypes.FUNCTION_KEYWORD) {
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.type2)) {
                this.setSingleSpace(true);
            } else if (JSElementTypes.PARAMETER_LISTS.contains(this.type2)) {
                this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH);
            }
            if (this.type2 == TypeScriptElementTypes.TYPE_PARAMETER_LIST) {
                this.forceSingleSpace(true);
            }
        } else if (JSElementTypes.PARAMETER_LISTS.contains(this.type2)) {
            if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1)) {
                ASTNode firstChild = this.myChild2.getFirstChildNode();
                boolean startsWithLeftPar = firstChild != null && firstChild.getElementType() == JSTokenTypes.LPAR;
                this.setSingleSpace(!startsWithLeftPar || this.myJSCodeStyleSettings.SPACE_BEFORE_ASYNC_ARROW_LPAREN);
                return;
            }
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            this.setSpaceBeforeLBraceIfMultiline(braceStyle, this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
        } else if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1)) {
            ASTNode lastAttributeChild = this.myChild1.getLastChildNode();
            boolean space = lastAttributeChild != null && lastAttributeChild.getElementType() == JSTokenTypes.MULT || this.type2 == JSTokenTypes.MULT ? this.myJSCodeStyleSettings.SPACE_AFTER_GENERATOR_MULT : true;
            this.decoratorSpacing(0, space);
        } else if (this.type1 == JSTokenTypes.EQGT || this.type2 == JSTokenTypes.EQGT) {
            int spaces = this.myJSCodeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.appendSpacingForTypes();
            this.appendSpaceBeforeGenerics();
        }
    }

    protected void decoratorSpacing() {
        this.decoratorSpacing(1, true);
    }

    protected void decoratorSpacing(int minLineFeeds, boolean needSpace) {
        if (this.isAfterDecorator()) {
            int spaces = needSpace ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.forceSingleSpace(needSpace);
        }
    }

    private boolean isAfterDecorator() {
        ASTNode lastChildNode = this.myChild1.getLastChildNode();
        return (DialectDetector.isTypeScript(this.myParent.getPsi()) || DialectDetector.isES6(this.myParent.getPsi())) && lastChildNode != null && lastChildNode.getElementType() == JSStubElementTypes.ES6_DECORATOR;
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
        this.visitFunction(this.myJSCodeStyleSettings.FUNCTION_EXPRESSION_BRACE_STYLE);
    }

    @Override
    public void visitReferenceExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.NEW_KEYWORD) {
            this.setSingleSpace(true);
        } else {
            this.setSingleSpace(false);
        }
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    @Override
    public void visitIfStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.IF_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_IF_LBRACE, this.mySettings.BRACE_STYLE);
        } else if (this.type2 == JSTokenTypes.ELSE_KEYWORD) {
            this.setLineBreakSpace(this.mySettings.ELSE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_ELSE_KEYWORD);
        } else if (this.type1 == JSTokenTypes.ELSE_KEYWORD) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
                this.setBraceSpace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, null);
            } else if (this.type2 == JSElementTypes.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.forceSingleSpace();
                } else {
                    this.setLineBreakSpace(true, false);
                }
            } else if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(this.type2)) {
                this.setSingleSpace(true);
            }
        }
    }

    @Override
    public void visitCallExpression(ASTNode node) {
        if (this.type2 == JSElementTypes.ARGUMENT_LIST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
        this.appendSpaceBeforeGenerics();
    }

    @Override
    public void visitNewExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.NEW_KEYWORD) {
            this.setSingleSpace(true);
        } else if (this.type2 == JSElementTypes.ARGUMENT_LIST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
        this.appendSpaceBeforeGenerics();
    }

    @Override
    public void visitForStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(true);
        } else if (this.type2 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_SEMICOLON);
        }
        if (this.type1 == JSTokenTypes.FOR_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE);
        } else if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, (Computable<TextRange>)((Computable)() -> JSSpacingProcessor.getRangeInsideParentheses(node)), this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, 0, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, (Computable<TextRange>)((Computable)() -> JSSpacingProcessor.getRangeInsideParentheses(node)), this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, 0, this.mySettings.KEEP_LINE_BREAKS, 0);
        }
    }

    @Nullable
    private TextRange getClassBodyRange() {
        return JSSpacingProcessor.getRangeInside(this.myParent, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE);
    }

    @Nullable
    private static TextRange getRangeInsideParentheses(@NotNull ASTNode parent) {
        if (parent == null) {
            JSSpacingProcessor.$$$reportNull$$$0(6);
        }
        return JSSpacingProcessor.getRangeInside(parent, JSTokenTypes.LPAR, JSTokenTypes.RPAR);
    }

    @Nullable
    private static TextRange getRangeInside(@NotNull ASTNode parent, @NotNull IElementType lBraceType, @NotNull IElementType rBraceType) {
        if (parent == null) {
            JSSpacingProcessor.$$$reportNull$$$0(7);
        }
        if (lBraceType == null) {
            JSSpacingProcessor.$$$reportNull$$$0(8);
        }
        if (rBraceType == null) {
            JSSpacingProcessor.$$$reportNull$$$0(9);
        }
        ASTNode lBrace = null;
        ASTNode rBrace = null;
        for (ASTNode current = parent.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            if (current.getElementType() == lBraceType) {
                lBrace = current;
                continue;
            }
            if (current.getElementType() != rBraceType) continue;
            rBrace = current;
        }
        return lBrace != null && rBrace != null ? new TextRange(lBrace.getTextRange().getStartOffset(), rBrace.getTextRange().getEndOffset()) : null;
    }

    @Override
    protected void visitComputedName(ASTNode node) {
        if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
        super.visitComputedName(node);
    }

    @Override
    public void visitDoWhileStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.WHILE_KEYWORD) {
            if (this.mySettings.WHILE_ON_NEW_LINE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                int spaces = this.mySettings.SPACE_BEFORE_WHILE_KEYWORD ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.DO_KEYWORD) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_DO_LBRACE, this.mySettings.BRACE_STYLE);
        }
    }

    @Override
    public void visitForInStatement(ASTNode node) {
        if (JSTokenTypes.VAR_MODIFIERS.contains(this.type1) || JSTokenTypes.VAR_MODIFIERS.contains(this.type2)) {
            this.setSingleSpace(true);
        } else if (this.type1 == JSTokenTypes.FOR_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        }
    }

    @Override
    public void visitWhileStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.WHILE_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
    }

    @Override
    public void visitWithStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.WITH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            this.setSpaceBeforeBlockOrSimpleStatement(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
    }

    @Override
    public void visitTryStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.TRY_KEYWORD && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null);
        } else if (this.type2 == JSElementTypes.CATCH_BLOCK) {
            this.setLineBreakSpace(this.mySettings.CATCH_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_CATCH_KEYWORD);
        } else if (this.type2 == JSTokenTypes.FINALLY_KEYWORD) {
            this.setLineBreakSpace(this.mySettings.FINALLY_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD);
        } else if (this.type1 == JSTokenTypes.FINALLY_KEYWORD) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, this.mySettings.BRACE_STYLE, null);
        }
    }

    @Override
    public void visitCatchBlock(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.CATCH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild2.getTextRange().getStartOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        }
    }

    @Override
    public void visitSwitchStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.SWITCH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(this.type2) || this.type2 == JSTokenTypes.RBRACE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        }
    }

    @Override
    public void visitArgumentList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR && this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(false);
            return;
        }
        if (this.type1 == JSTokenTypes.LPAR) {
            this.myResult = JSSpacingProcessor.createDependentSpacingIfListWrapped(node, JSArgumentListImpl::getArguments, this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.myResult = JSSpacingProcessor.createDependentSpacingIfListWrapped(node, JSArgumentListImpl::getArguments, this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(false);
        }
    }

    @Override
    public void visitVarStatement(ASTNode node) {
        if (JSTokenTypes.VAR_MODIFIERS.contains(this.type1)) {
            this.setSingleSpace(true);
            return;
        }
        if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1) && (JSTokenTypes.VAR_MODIFIERS.contains(this.type2) || TypeScriptElementTypes.TYPESCRIPT_FIELDS.contains(this.type2))) {
            if (this.isAfterDecorator()) {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.forceSingleSpace();
            }
            return;
        }
        if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            return;
        }
        this.visitStatement(node);
    }

    private void forceSingleSpace() {
        this.forceSingleSpace(true);
    }

    protected void forceSingleSpace(boolean needSpace) {
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @Override
    public void visitVariable(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.type1 == JSTokenTypes.DOT_DOT_DOT && JSKeywordSets.IDENTIFIER_NAMES.contains(this.type2)) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_DOTS_IN_REST_PARAMETER);
        } else {
            this.appendSpacingForTypes();
        }
    }

    protected void appendSpacingForTypes() {
        if (this.type1 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_TYPE_COLON);
        } else if (this.type2 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_TYPE_COLON);
        }
    }

    protected void appendSpaceBeforeGenerics() {
        if (this.type2 == TypeScriptElementTypes.TYPE_PARAMETER_LIST || this.type2 == TypeScriptElementTypes.TYPE_ARGUMENT_LIST) {
            this.forceSingleSpace(false);
        }
    }

    @Override
    public void visitBinaryExpression(ASTNode node) {
        if (this.type2 == JSElementTypes.PREFIX_EXPRESSION || this.type1 == JSTokenTypes.INSTANCEOF_KEYWORD || this.type2 == JSTokenTypes.INSTANCEOF_KEYWORD) {
            this.setSingleSpace(true);
            return;
        }
        IElementType opSign = null;
        if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(this.type1)) {
            opSign = this.type1;
        } else if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(this.type2)) {
            opSign = this.type2;
        }
        if (opSign != null) {
            this.setSingleSpace(this.getSpaceAroundOption(opSign));
        }
    }

    @Override
    public void visitCommaExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.COMMA) {
            this.setSingleSpace(true);
        }
    }

    @Override
    public void visitConditionalExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.QUEST) {
            this.setSingleSpace(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.type2 == JSTokenTypes.QUEST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.type1 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.type2 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_COLON);
        }
    }

    public static boolean getSpaceAroundSign(IElementType opSign, CommonCodeStyleSettings settings) {
        if (opSign == JSTokenTypes.IN_KEYWORD) {
            return true;
        }
        boolean option = false;
        if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(opSign)) {
            option = settings.SPACE_AROUND_ADDITIVE_OPERATORS;
        } else if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(opSign) || JSTokenTypes.MULTMULT == opSign) {
            option = settings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS;
        } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(opSign)) {
            option = settings.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        } else if (JSTokenTypes.EQUALITY_OPERATIONS.contains(opSign)) {
            option = settings.SPACE_AROUND_EQUALITY_OPERATORS;
        } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(opSign)) {
            option = settings.SPACE_AROUND_RELATIONAL_OPERATORS;
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(opSign)) {
            option = settings.SPACE_AROUND_SHIFT_OPERATORS;
        } else if (opSign == JSTokenTypes.ANDAND || opSign == JSTokenTypes.OROR) {
            option = settings.SPACE_AROUND_LOGICAL_OPERATORS;
        } else if (opSign == JSTokenTypes.OR || opSign == JSTokenTypes.AND || opSign == JSTokenTypes.XOR) {
            option = settings.SPACE_AROUND_BITWISE_OPERATORS;
        } else if (opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.AS_KEYWORD) {
            option = true;
        }
        return option;
    }

    protected boolean getSpaceAroundOption(IElementType opSign) {
        return JSSpacingProcessor.getSpaceAroundSign(opSign, this.mySettings);
    }

    @Override
    public void visitPrefixExpression(ASTNode node) {
        this.setUnaryOperatorSpacing(this.type1);
    }

    @Override
    protected void visitYieldExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.MULT) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_GENERATOR_MULT);
        } else if (this.type2 == JSTokenTypes.MULT) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_GENERATOR_MULT);
        }
    }

    @Override
    public void visitPostfixExpression(ASTNode node) {
        this.setUnaryOperatorSpacing(this.type2);
    }

    protected void setUnaryOperatorSpacing(IElementType opType) {
        if (opType == JSTokenTypes.PLUS || opType == JSTokenTypes.MINUS || opType == JSTokenTypes.PLUSPLUS || opType == JSTokenTypes.MINUSMINUS || opType == JSTokenTypes.TILDE || opType == JSTokenTypes.EXCL) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
    }

    protected void setDependentSpacingIfNecessary(boolean useDependentSpacing, boolean needSpace, boolean keepLineBreaks, int keepBlankLines) {
        this.setDependentSpacingIfNecessary(useDependentSpacing, (Computable<TextRange>)((Computable)() -> this.myParent.getTextRange()), needSpace, 0, keepLineBreaks, keepBlankLines);
    }

    private void setDependentSpacingIfNecessary(boolean useDependentSpacing, Computable<TextRange> dependencyRangeComputable, boolean needSpace, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        TextRange dependencyRange;
        TextRange textRange = dependencyRange = useDependentSpacing ? (TextRange)dependencyRangeComputable.compute() : null;
        if (dependencyRange != null) {
            int spaces = needSpace ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependencyRange, (boolean)keepLineBreaks, (int)keepBlankLines);
        } else {
            int spaces = needSpace ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)minLineFeeds, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
    }

    private static Spacing createDependentSpacingIfListWrapped(@NotNull ASTNode root, @NotNull Function<ASTNode, ASTNode[]> childGetter, boolean useDependentSpacing, boolean needSpace, boolean keepLineBreaks, int keepBlankLines) {
        int spaces;
        if (root == null) {
            JSSpacingProcessor.$$$reportNull$$$0(10);
        }
        if (childGetter == null) {
            JSSpacingProcessor.$$$reportNull$$$0(11);
        }
        int n = spaces = needSpace ? 1 : 0;
        if (useDependentSpacing) {
            ASTNode[] expressions = childGetter.apply(root);
            ArrayList<TextRange> ranges = new ArrayList<TextRange>(expressions.length);
            for (int i = 0; i < expressions.length - 1; ++i) {
                int startOffset = expressions[i].getTextRange().getEndOffset();
                int endOffset = expressions[i + 1].getTextRange().getStartOffset();
                ranges.add(new TextRange(startOffset, endOffset + 1));
            }
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, ranges, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
    }

    protected void setSingleSpace(boolean needSpace) {
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private void setSpaceBeforeBlockOrSimpleStatement(boolean spaceBeforeLBrace, int braceStyle) {
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(spaceBeforeLBrace, braceStyle, dependentRange);
        } else if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(this.type2)) {
            this.setSingleSpace(true);
        }
    }

    protected void setSpaceBeforeLBraceIfMultiline(int braceStyleSetting, boolean spaceBeforeBraceSetting, boolean keepOnOneLine) {
        this.setSpaceBeforeLBraceIfMultiline(braceStyleSetting, spaceBeforeBraceSetting, keepOnOneLine, this.myParent.getTextRange());
    }

    protected void setSpaceBeforeLBraceIfMultiline(int braceStyleSetting, boolean spaceBeforeBraceSetting, boolean keepOnOneLine, @NotNull TextRange simpleBlockRange) {
        if (simpleBlockRange == null) {
            JSSpacingProcessor.$$$reportNull$$$0(12);
        }
        if (keepOnOneLine && braceStyleSetting != 1 && braceStyleSetting != 5) {
            int spaces = spaceBeforeBraceSetting ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)simpleBlockRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.setBraceSpace(spaceBeforeBraceSetting, braceStyleSetting, this.myChild1.getTextRange());
        }
    }

    protected void setBraceSpace(boolean needSpaceSetting, int braceStyleSetting, TextRange textRange) {
        int spaces;
        int n = spaces = needSpaceSetting ? 1 : 0;
        if (braceStyleSetting == 5 && textRange != null) {
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            int lineBreaks = braceStyleSetting == 1 || braceStyleSetting == 5 ? 0 : 1;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)lineBreaks, (boolean)false, (int)0);
        }
    }

    protected void setBlankLines(int minLineBreaksSetting, int maxBlankLines) {
        this.myResult = Spacing.createSpacing((int)0, (int)1, (int)(minLineBreaksSetting + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)maxBlankLines);
    }

    protected void setLineBreakSpace(boolean needLineBreak, boolean needSpace) {
        int breaks = needLineBreak || this.myChild1.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT ? 1 : 0;
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)breaks, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @Override
    public void visitElement(ASTNode node) {
        if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(node.getElementType())) {
            this.processReferenceList();
        } else if (node.getElementType() == JSStubElementTypes.NAMESPACE_DECLARATION) {
            if (this.type1 == JSTokenTypes.NAMESPACE_KEYWORD || this.type2 == JSTokenTypes.NAMESPACE_KEYWORD) {
                this.setSingleSpace(true);
            } else if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
                this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
            }
        } else if (node.getElementType() == JSStubElementTypes.ATTRIBUTE) {
            if (this.type1 == JSTokenTypes.COMMA) {
                this.setSingleSpace(this.mySettings.SPACE_AFTER_COMMA);
            } else if (this.type2 == JSTokenTypes.COMMA) {
                this.setSingleSpace(this.mySettings.SPACE_BEFORE_COMMA);
            } else {
                this.forceSingleSpace(false);
            }
        } else if (node.getElementType() == JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR) {
            this.forceSingleSpace(false);
        } else if (this.type1 == JSTokenTypes.DOT_DOT_DOT && (this.type2 == JSElementTypes.REFERENCE_EXPRESSION || JSElementTypes.BODY_VARIABLES.contains(this.type2))) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_DOTS_IN_REST_PARAMETER);
        }
    }

    private void processReferenceList() {
        if ((this.type1 == JSTokenTypes.EXTENDS_KEYWORD || this.type1 == JSTokenTypes.IMPLEMENTS_KEYWORD) && this.type2 == JSStubElementTypes.EXTENDS_LIST_MEMBER) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        } else {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitProperty(ASTNode node) {
        this.appendPropertySpacing();
    }

    @Override
    public void visitFunctionProperty(ASTNode node) {
        this.visitFunction(this.mySettings.METHOD_BRACE_STYLE);
    }

    @Override
    public void visitParenthesizedExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_PARENTHESES);
        }
    }

    @Override
    public void visitReturnStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.RETURN_KEYWORD) {
            int spaces = this.type2 == JSTokenTypes.SEMICOLON ? 0 : 1;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else {
            super.visitReturnStatement(node);
        }
    }

    protected void createCommaSpacing(@NotNull IElementType type1, @NotNull IElementType type2, int blankLinesToKeep) {
        if (type1 == null) {
            JSSpacingProcessor.$$$reportNull$$$0(13);
        }
        if (type2 == null) {
            JSSpacingProcessor.$$$reportNull$$$0(14);
        }
        this.createDelimiterSpacing(type1, type2, blankLinesToKeep, (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.COMMA));
    }

    protected void createDelimiterSpacing(@NotNull IElementType type1, @NotNull IElementType type2, int blankLinesToKeep, Condition<IElementType> isDelimiter) {
        if (type1 == null) {
            JSSpacingProcessor.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            JSSpacingProcessor.$$$reportNull$$$0(16);
        }
        if (isDelimiter.value((Object)type1)) {
            int spaces = this.mySettings.SPACE_AFTER_COMMA ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesToKeep);
        } else if (isDelimiter.value((Object)type2)) {
            int spaces = this.mySettings.SPACE_BEFORE_COMMA ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesToKeep);
        }
    }

    private boolean isStatementWithLeadingSemicolon() {
        boolean isStatement;
        boolean bl = isStatement = !(this.type1 != JSElementTypes.EXPRESSION_STATEMENT && this.type1 != JSStubElementTypes.VAR_STATEMENT && this.type1 != JSElementTypes.EMPTY_STATEMENT || this.type2 != JSElementTypes.EXPRESSION_STATEMENT && this.type2 != JSStubElementTypes.VAR_STATEMENT);
        if (!isStatement) {
            return false;
        }
        ASTNode lastGrandChild = this.myChild1.getLastChildNode();
        ASTNode prevGrandChild = lastGrandChild != null ? lastGrandChild.getTreePrev() : null;
        return lastGrandChild != null && lastGrandChild.getElementType() == JSTokenTypes.SEMICOLON && prevGrandChild != null && prevGrandChild.getElementType() == TokenType.WHITE_SPACE && prevGrandChild.textContains('\n') || this.type1 == JSElementTypes.EMPTY_STATEMENT;
    }

    private boolean isArrayBracketOnAnotherLine(IElementType bracketType) {
        if (bracketType == JSTokenTypes.LBRACKET) {
            return this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE;
        }
        if (bracketType == JSTokenTypes.RBRACKET) {
            return this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeStyleSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodTokenSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldTokenSet";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lBraceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childGetter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleBlockRange";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/JSSpacingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassBody";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "needBlankLinesAroundDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeInsideParentheses";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeInside";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createDependentSpacingIfListWrapped";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setSpaceBeforeLBraceIfMultiline";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommaSpacing";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "createDelimiterSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

