/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.completion.XmlAttributeReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlAttributeCompletionContributor
extends CompletionContributor {
    public static void insertBracesOrEmptyEqualSign(InsertionContext context, @NotNull JSCodeStyleSettings.JSXAttributeValuePresentation presentation) {
        boolean isEmpty;
        if (presentation == null) {
            ReactXmlAttributeCompletionContributor.$$$reportNull$$$0(0);
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = document.getCharsSequence();
        boolean hasAttributeValue = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"={") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        boolean bl = isEmpty = presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.NONE || !WebEditorOptions.getInstance().isInsertQuotesForAttributeValue();
        if (!hasAttributeValue) {
            String toInsert;
            String string = toInsert = isEmpty ? "=" : "={}";
            if (caretOffset >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + (isEmpty ? 1 : 2));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public ReactXmlAttributeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttribute()), new ReactAttributeCompletionProvider());
    }

    @NotNull
    private static InsertHandler<LookupElement> createInsertHandler(final @NotNull XmlTag tag) {
        if (tag == null) {
            ReactXmlAttributeCompletionContributor.$$$reportNull$$$0(1);
        }
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                XmlAttributeDescriptor descriptor2 = ReactXmlAttributeCompletionContributor.getAttributeDescriptor(item, tag);
                JSCodeStyleSettings.JSXAttributeValuePresentation presentation = ReactXmlExtension.getAttributeValue(descriptor2);
                if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES) {
                    XmlAttributeInsertHandler.INSTANCE.handleInsert(context, item);
                    return;
                }
                ReactXmlAttributeCompletionContributor.insertBracesOrEmptyEqualSign(context, presentation);
            }
        };
        if (insertHandler == null) {
            ReactXmlAttributeCompletionContributor.$$$reportNull$$$0(2);
        }
        return insertHandler;
    }

    @Nullable
    private static XmlAttributeDescriptor getAttributeDescriptor(LookupElement item, XmlTag tag) {
        XmlElementDescriptor descriptor2 = tag.getDescriptor();
        if (descriptor2 == null) {
            return null;
        }
        return descriptor2.getAttributeDescriptor(item.getLookupString(), tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertBracesOrEmptyEqualSign";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReactAttributeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private ReactAttributeCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
            PsiFile file;
            if (parameters == null) {
                ReactAttributeCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                ReactAttributeCompletionProvider.$$$reportNull$$$0(1);
            }
            if (!((file = parameters.getOriginalFile()) instanceof JSFile) || !DialectDetector.isJSX((PsiElement)file)) {
                return;
            }
            PsiElement elementOfCompletion = parameters.getPosition();
            PsiReference reference = elementOfCompletion.getContainingFile().findReferenceAt(parameters.getOffset());
            if (!(reference instanceof XmlAttributeReference)) {
                return;
            }
            XmlTag declarationTag = ((XmlAttributeReference)reference).getElement().getParent();
            if (ReactXmlExtension.nonJsxTag(declarationTag)) {
                return;
            }
            XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)((XmlAttributeReference)reference), (CompletionResultSet)result2, (InsertHandler)ReactXmlAttributeCompletionContributor.createInsertHandler(declarationTag));
            result2.stopHere();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor$ReactAttributeCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

