/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.TypeScriptIndexerNode;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptPsiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenerateMemberChooser
extends MemberChooser<JSChooserElementNode> {
    private final boolean myAllowEmptySelection;
    @Nullable
    private final JComponent myOptionsComponent;
    @NotNull
    private final Map<MemberKind, Boolean> myMembersShown;
    @NotNull
    private final Collection<JSChooserElementNode> myOriginalCandidates;

    public JSGenerateMemberChooser(@NotNull Collection<JSChooserElementNode> candidates, boolean allowEmptySelection, boolean allowMultipleSelection, @NotNull Project project, @Nullable JComponent optionsComponent) {
        if (candidates == null) {
            JSGenerateMemberChooser.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JSGenerateMemberChooser.$$$reportNull$$$0(1);
        }
        super((ClassMember[])candidates.toArray(new JSChooserElementNode[candidates.size()]), allowEmptySelection, allowMultipleSelection, project, false);
        this.myOriginalCandidates = candidates;
        this.myAllowEmptySelection = allowEmptySelection;
        this.myOptionsComponent = optionsComponent;
        this.myMembersShown = ContainerUtil.newHashMap();
        this.myMembersShown.put(MemberKind.Field, true);
        this.myMembersShown.put(MemberKind.Method, true);
        this.myMembersShown.put(MemberKind.Indexer, true);
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        boolean hasAtLeastTwo;
        super.fillToolbarActions(group);
        boolean hasIndexers = false;
        boolean hasMethods = false;
        boolean hasFields = false;
        for (JSChooserElementNode node : (JSChooserElementNode[])this.myElements) {
            if (node instanceof TypeScriptIndexerNode) {
                hasIndexers = true;
                continue;
            }
            if (!(node instanceof JSNamedElementNode)) continue;
            if (node.getPsiElement() instanceof JSFunctionItem) {
                hasMethods = true;
                continue;
            }
            hasFields = true;
        }
        boolean bl = hasAtLeastTwo = hasMethods && hasFields || hasMethods && hasIndexers || hasFields && hasIndexers;
        if (!hasAtLeastTwo) {
            return;
        }
        group.addSeparator();
        if (hasMethods) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Method));
        }
        if (hasFields) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Field));
        }
        if (hasIndexers) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Indexer));
        }
    }

    protected void init() {
        super.init();
        if (!this.myAllowEmptySelection) {
            this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    JSGenerateMemberChooser.this.setOKActionEnabled(JSGenerateMemberChooser.this.myTree.getSelectionCount() > 0);
                }
            });
        } else {
            this.setOKActionEnabled(true);
        }
    }

    protected JComponent createCenterPanel() {
        JComponent superComponent = super.createCenterPanel();
        JComponent optionsComponent = this.myOptionsComponent;
        if (optionsComponent == null) {
            return superComponent;
        }
        if (superComponent == null) {
            return optionsComponent;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)superComponent, "Center");
        panel.add((Component)optionsComponent, "South");
        return panel;
    }

    private JSChooserElementNode[] recomputeElements() {
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)this.myOriginalCandidates.size());
        for (JSChooserElementNode node : this.myOriginalCandidates) {
            if (node instanceof TypeScriptIndexerNode) {
                if (!this.myMembersShown.get((Object)MemberKind.Indexer).booleanValue()) continue;
                items.add(node);
                continue;
            }
            if (!(node instanceof JSNamedElementNode)) continue;
            if (node.getPsiElement() instanceof JSFunctionItem) {
                if (!this.myMembersShown.get((Object)MemberKind.Method).booleanValue()) continue;
                items.add(node);
                continue;
            }
            if (!this.myMembersShown.get((Object)MemberKind.Field).booleanValue()) continue;
            items.add(node);
        }
        return items.toArray(JSChooserElementNode.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "candidates";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/generation/JSGenerateMemberChooser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FilterMembersAction
    extends ToggleAction {
        @NotNull
        private final MemberKind myKind;

        public FilterMembersAction(MemberKind kind) {
            if (kind == null) {
                FilterMembersAction.$$$reportNull$$$0(0);
            }
            super(JSBundle.message((String)"generate.filter.button.tooltip", (Object[])new Object[]{kind.toString()}), JSBundle.message((String)"generate.filter.button.description", (Object[])new Object[]{kind.toString()}), kind.getIcon());
            this.myKind = kind;
            this.registerCustomShortcutSet(KeyEvent.getExtendedKeyCodeForChar(kind.toString().charAt(0)), 8, (JComponent)JSGenerateMemberChooser.this.myTree);
        }

        public boolean isSelected(AnActionEvent e) {
            return (Boolean)JSGenerateMemberChooser.this.myMembersShown.get((Object)this.myKind);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            JSGenerateMemberChooser.this.myMembersShown.put(this.myKind, state);
            JSGenerateMemberChooser.this.resetElements(JSGenerateMemberChooser.this.recomputeElements());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/lang/javascript/generation/JSGenerateMemberChooser$FilterMembersAction", "<init>"));
        }
    }

    public static enum MemberKind {
        Indexer,
        Method,
        Field;


        public String toString() {
            switch (this) {
                case Indexer: {
                    return JSBundle.message((String)"generate.filter.indexers", (Object[])new Object[0]);
                }
                case Method: {
                    return JSBundle.message((String)"generate.filter.methods", (Object[])new Object[0]);
                }
                case Field: {
                    return JSBundle.message((String)"generate.filter.fields", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            switch (this) {
                case Indexer: {
                    return JavaScriptPsiIcons.Members.TypeScript_index_signature;
                }
                case Method: {
                    return PlatformIcons.METHOD_ICON;
                }
                case Field: {
                    int w = PlatformIcons.FIELD_ICON.getIconWidth();
                    LayeredIcon icon = new LayeredIcon(2);
                    icon.setIcon(PlatformIcons.PROPERTY_ICON, 0, w / 3, 0);
                    icon.setIcon(PlatformIcons.FIELD_ICON, 1, -w / 3, 0);
                    return icon;
                }
            }
            return null;
        }
    }
}

