/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSDocBasedElementNode;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSClosureCompilerSyntaxInspection;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaScriptImplementMethodsHandler
extends BaseJSGenerateHandler {
    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        JSClass jsClass = (JSClass)clazz;
        for (JSClosureCompilerSyntaxInspection.MethodToImplement method : JavaScriptImplementMethodsHandler.getMethodsToImplement(jsClass)) {
            candidates.add(new JSDocBasedElementNode(method));
        }
    }

    @NotNull
    private static List<JSClosureCompilerSyntaxInspection.MethodToImplement> getMethodsToImplement(JSClass jsClass) {
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)jsClass);
        if (!(comment instanceof JSDocComment)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JavaScriptImplementMethodsHandler.$$$reportNull$$$0(0);
            }
            return list;
        }
        OrderedSet implementedInterfaces = new OrderedSet();
        OrderedSet classesInHierarchy = new OrderedSet();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)jsClass);
        JSClosureCompilerSyntaxInspection.collectHierarchyMembers(jsClass.getName(), (JSDocComment)comment, (OrderedSet<String>)implementedInterfaces, (OrderedSet<String>)classesInHierarchy, (Consumer<String>)((Consumer)s -> {}), Collections.emptySet());
        List<JSClosureCompilerSyntaxInspection.MethodToImplement> list = JSClosureCompilerSyntaxInspection.getNotImplementedMethods(jsClass.getName(), implementedInterfaces, classesInHierarchy, name -> JSClassResolver.getInstance().findNamespaceMembers((String)name, scope), t -> t);
        if (list == null) {
            JavaScriptImplementMethodsHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    protected String getTitleKey() {
        return "methods.to.implement.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.methods.to.implement", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        THashMap notImplementedNames = new THashMap();
        List<JSClosureCompilerSyntaxInspection.MethodToImplement> methodsToImplement = JavaScriptImplementMethodsHandler.getMethodsToImplement((JSClass)clazz);
        for (JSClosureCompilerSyntaxInspection.MethodToImplement methodToImplement : methodsToImplement) {
            notImplementedNames.put(methodToImplement.member.getName(), methodToImplement.buildParameterList());
        }
        return (BaseCreateMembersFix)JSFixFactory.getInstance().implementJSDocMethodsFix(((JSClass)clazz).getName(), (Map<String, String>)notImplementedNames);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface() && !DialectDetector.isActionScript(jsClass) && !DialectDetector.isTypeScript(jsClass);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/generation/JavaScriptImplementMethodsHandler", "getMethodsToImplement"));
    }
}

