/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemPresentation
implements ColoredItemPresentation {
    @NotNull
    private final JSPsiElementBase myElement;

    public JSItemPresentation(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSItemPresentation.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    public String getPresentableText() {
        String name = this.myElement.getName();
        return name != null ? name : "<anonymous>";
    }

    @Nullable
    public String getLocationString() {
        String qName;
        String packageName;
        PsiFile psiFile = this.myElement.getContainingFile();
        boolean showPathInformation = true;
        JSQualifiedName elementNamespace = this.myElement.getNamespace();
        if (elementNamespace != null) {
            StringBuilder presentation = new StringBuilder();
            String location = elementNamespace.getQualifiedName();
            if (!location.isEmpty()) {
                presentation.append(location);
                String fileName = JSItemPresentation.getFileName(psiFile, true, true);
                if (!StringUtil.isEmpty((String)fileName)) {
                    presentation.append(" (").append(fileName).append(')');
                }
                return presentation.toString();
            }
        } else if (this.myElement instanceof JSVariable || this.myElement instanceof JSFunction || this.myElement instanceof JSNamespaceDeclaration || this.myElement instanceof JSImplicitPrototypeElement) {
            PsiElement possibleClazz;
            Object object = possibleClazz = this.myElement instanceof JSImplicitPrototypeElement ? ((JSImplicitPrototypeElement)this.myElement).getOwnerClass() : JSResolveUtil.findParent((PsiElement)this.myElement);
            if (possibleClazz instanceof JSClass) {
                String fileName;
                String namespace;
                StringBuilder result2 = new StringBuilder();
                JSAttributeList attributeList = this.myElement instanceof JSAttributeListOwner ? ((JSAttributeListOwner)this.myElement).getAttributeList() : null;
                String qualifiedName = ((JSClass)possibleClazz).getQualifiedName();
                if (qualifiedName != null) {
                    result2.append(qualifiedName);
                }
                if (attributeList != null && (namespace = attributeList.getNamespace()) != null) {
                    result2.append(".").append(namespace);
                }
                if (!StringUtil.isEmpty((String)(fileName = JSItemPresentation.getFileName(psiFile, !DialectDetector.isActionScript((PsiElement)psiFile), true)))) {
                    result2.append(" (").append(fileName).append(')');
                }
                return result2.toString();
            }
            if (possibleClazz instanceof JSFile && DialectDetector.isActionScript(possibleClazz) || possibleClazz instanceof JSPackageStatement) {
                String s = this.myElement.getQualifiedName();
                String packageName2 = StringUtil.getPackageName((String)s);
                return packageName2.length() > 0 ? "(" + packageName2 + ")" : "";
            }
        } else if (this.myElement instanceof JSClass && (!StringUtil.isEmpty((String)(packageName = JSItemPresentation.representationFromQName(qName = this.myElement.getQualifiedName()))) || DialectDetector.isActionScript((PsiElement)this.myElement))) {
            return packageName;
        }
        if (this.myElement instanceof JSFunctionExpression && (qName = JSResolveUtil.getQNameToStartHierarchySearch(this.myElement)) != null) {
            return qName + " (" + JSItemPresentation.getFileName(psiFile, true, true) + ')';
        }
        return "(" + JSItemPresentation.getFileName(psiFile, true, true) + ")";
    }

    @NotNull
    private static String representationFromQName(String qName) {
        String packageName = qName != null ? StringUtil.getPackageName((String)qName) : "";
        String string = !StringUtil.isEmpty((String)packageName) ? "(" + packageName + ")" : "";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getFileName(PsiFile psiFile) {
        return JSItemPresentation.getFileName(psiFile, true);
    }

    public static String getFileName(PsiFile psiFile, boolean showLocation) {
        return JSItemPresentation.getFileName(psiFile, showLocation, false);
    }

    private static String getFileName(PsiFile psiFile, boolean showLibraryLocation, boolean showFilePath) {
        ProjectFileIndex projectFileIndex;
        VirtualFile file = psiFile.getOriginalFile().getViewProvider().getVirtualFile();
        VirtualFile root = null;
        if (showLibraryLocation && ((projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex()).isInLibraryClasses(file) || projectFileIndex.isInLibrarySource(file))) {
            List entriesForFile = projectFileIndex.getOrderEntriesForFile(file);
            for (int i = 0; i < entriesForFile.size(); ++i) {
                OrderEntry entry = (OrderEntry)entriesForFile.get(i);
                String s = null;
                if (entry instanceof LibraryOrderEntry) {
                    s = entry.getPresentableName();
                    int lastSlash = s.lastIndexOf(File.separatorChar);
                    if (lastSlash != -1) {
                        s = s.substring(lastSlash + 1);
                    }
                } else if (entry instanceof JdkOrderEntry) {
                    Sdk sdk = ((JdkOrderEntry)entry).getJdk();
                    s = sdk instanceof CompositeRootCollection ? ((CompositeRootCollection)sdk).getName(file) : ((JdkOrderEntry)entry).getJdkName();
                }
                if (s == null) continue;
                return s;
            }
            file = JSItemPresentation.getNameOfPhysicalFile(file);
        }
        if (showFilePath && (root = (projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex()).getSourceRootForFile(file)) == null) {
            root = projectFileIndex.getContentRootForFile(file);
        }
        String s = file.getName();
        if (JSResolveUtil.isFromPredefinedFile(psiFile)) {
            return s.substring(s.lastIndexOf(47) + 1);
        }
        if (root != null) {
            String relativePath;
            if (file instanceof VirtualFileWindow) {
                file = ((VirtualFileWindow)file).getDelegate();
            }
            if (!StringUtil.isEmpty((String)(relativePath = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)root, (char)'/')))) {
                s = s + ", " + relativePath;
            }
        }
        return s;
    }

    public static VirtualFile getNameOfPhysicalFile(VirtualFile file) {
        VirtualFile fileForJar;
        VirtualFileSystem fileSystem;
        if ("library.swf".equals(file.getName()) && (fileSystem = file.getFileSystem()) instanceof JarFileSystem && (fileForJar = ((JarFileSystem)fileSystem).getLocalByEntry(file)) != null) {
            file = fileForJar;
        }
        return file;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myElement.getIcon(3);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.myElement.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "representationFromQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

