/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousToNamedFunctionIntention
extends JavaScriptIntention {
    public AnonymousToNamedFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.named.function", (Object[])new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        return AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element) != null;
    }

    public static JSFunctionExpression getWrappingAnonymousFunction(@NotNull PsiElement element) {
        JSFunctionExpression functionExpression;
        if (element == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(2);
        }
        if ((functionExpression = AnonymousToNamedFunctionIntention.getFunctionExpression(element)) == null) {
            return null;
        }
        ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(functionExpression.getNode(), true);
        return nameNode == null ? functionExpression : null;
    }

    private static JSFunctionExpression getFunctionExpression(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(3);
        }
        if (!((file = element.getContainingFile()) instanceof JSFile) && PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionExpression) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(4);
        }
        return currentFile;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(6);
        }
        PsiFile containingFile = element.getContainingFile();
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class);
        if (functionExpression == null) {
            return;
        }
        String functionName = null;
        PsiElement parent = functionExpression.getParent();
        if (parent instanceof JSVariable && ((JSVariable)parent).isConst()) {
            functionName = functionExpression.getName();
        }
        if (StringUtil.isEmpty(functionName)) {
            GetFunctionNameDialog dialog;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                functionName = "foo";
            } else if (StringUtil.isEmpty((String)functionName) && (dialog = new GetFunctionNameDialog(containingFile, functionExpression.getName())).showAndGet()) {
                functionName = dialog.getFunctionName();
            }
        }
        if (functionName != null) {
            String theFunctionName = functionName;
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    AnonymousToNamedFunctionIntention.$$$reportNull$$$0(22);
                }
                if (element == null) {
                    AnonymousToNamedFunctionIntention.$$$reportNull$$$0(23);
                }
                AnonymousToNamedFunctionIntention.performRefactoring(project, editor, element, theFunctionName);
            });
        }
    }

    private static void performRefactoring(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element, @NotNull String functionName) throws IncorrectOperationException {
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(8);
        }
        if (functionName == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(9);
        }
        PsiFile containingFile = element.getContainingFile();
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class);
        assert (functionExpression != null);
        JSFunction function = AnonymousToNamedFunctionIntention.buildNewFunction(project, functionName, containingFile, functionExpression);
        AnonymousToNamedFunctionIntention.addNewFunctionAndReplaceExpression(project, editor, functionExpression, function, functionName);
    }

    @NotNull
    private static JSFunction buildNewFunction(@NotNull Project project, @NotNull String functionName, PsiFile containingFile, JSFunctionExpression functionExpression) {
        String parameters;
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(10);
        }
        if (functionName == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(11);
        }
        PsiElement returnTypeElement = functionExpression.getReturnTypeElement();
        boolean isArrowFunction = JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression);
        String attributesModifiersText = JSFunctionsHelper.getFunctionAttributesModifiersText((JSFunction)functionExpression);
        JSParameterList expressionParameterList = functionExpression.getParameterList();
        String string = parameters = isArrowFunction && expressionParameterList != null ? expressionParameterList.getText() : "()";
        if (!parameters.startsWith("(")) {
            parameters = "(" + parameters + ")";
        }
        String functionText = attributesModifiersText + (returnTypeElement == null ? "function " + functionName + parameters + " {}" : "function " + functionName + parameters + ": " + returnTypeElement.getText() + " {}");
        JSFunction function = (JSFunction)JSChangeUtil.createStatementFromTextWithContext(functionText, (PsiElement)functionExpression).getPsi(JSFunction.class);
        if (!isArrowFunction && expressionParameterList != null) {
            JSParameterList list = function.getParameterList();
            assert (list != null) : function.getText();
            list.replace((PsiElement)expressionParameterList);
        }
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSBlockStatement.class);
        JSBlockStatement functionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (functionExpressionBody == null) {
            JSExpression arrowFunctionBody = (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSExpression.class);
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)containingFile);
            String bodyText = isArrowFunction && arrowFunctionBody != null ? "{\nreturn " + arrowFunctionBody.getText() + semicolon + "\n}" : "{}";
            ASTNode blockNode = JSChangeUtil.createJSTreeFromTextWithContext(bodyText, (PsiElement)arrowFunctionBody);
            assert (blockNode != null) : bodyText;
            functionExpressionBody = (JSBlockStatement)blockNode.getPsi(JSBlockStatement.class);
        }
        JSChangeUtil.replaceStatement((JSStatement)functionBody, (JSStatement)functionExpressionBody);
        JSFunction jSFunction = function;
        if (jSFunction == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(12);
        }
        return jSFunction;
    }

    private static void addNewFunctionAndReplaceExpression(@NotNull Project project, Editor editor, @NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newPsiElementFunction, @NotNull String name) {
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(13);
        }
        if (functionExpression == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(14);
        }
        if (newPsiElementFunction == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(15);
        }
        if (name == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(16);
        }
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpression, (Class[])new Class[]{JSFunction.class, JSStatement.class});
        PsiElement directParent = functionExpression.getParent();
        if (directParent instanceof JSVariable && name.equals(((JSVariable)directParent).getName())) {
            JSSourceElement parent = anchor == null ? functionExpression.getContainingFile() : anchor;
            parent.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            directParent.delete();
        } else {
            JSFunction parent;
            if (anchor != null) {
                parent = anchor.getParent();
                newPsiElementFunction = (JSFunction)anchor.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            } else {
                parent = newPsiElementFunction;
                newPsiElementFunction = (JSFunction)functionExpression.getContainingFile().add((PsiElement)newPsiElementFunction);
            }
            AnonymousToNamedFunctionIntention.replaceFunctionExpressionWithReference(project, editor, functionExpression, newPsiElementFunction, (PsiElement)parent);
        }
    }

    private static void replaceFunctionExpressionWithReference(@NotNull Project project, @Nullable Editor editor, @NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newFunction, @NotNull PsiElement parent) {
        if (project == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(17);
        }
        if (functionExpression == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(18);
        }
        if (newFunction == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(20);
        }
        JSChangeUtil.addWs(parent.getNode(), newFunction.getNode(), "\n");
        ASTNode reference = JSChangeUtil.createExpressionFromText(project, newFunction.getName());
        assert (reference != null) : "Reference text " + newFunction.getName();
        JSExpression referenceExpression = (JSExpression)reference.getPsi(JSReferenceExpression.class);
        referenceExpression = JSChangeUtil.replaceExpression((JSExpression)functionExpression, referenceExpression);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)referenceExpression.getContainingFile(), referenceExpression.getTextRange().getStartOffset(), newFunction.getTextRange().getEndOffset());
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.anonymous.to.named.function", (Object[])new Object[0]);
        if (string == null) {
            AnonymousToNamedFunctionIntention.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPsiElementFunction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewFunction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingAnonymousFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildNewFunction";
                break;
            }
            case 12: 
            case 21: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNewFunctionAndReplaceExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceFunctionExpressionWithReference";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class GetFunctionNameDialog
    extends DialogWrapper {
        private final JTextField myTextField;
        private final PsiFile myPsiFile;
        private final String myDefaultName;

        protected GetFunctionNameDialog(PsiFile file, String defaultName) {
            super(file.getProject());
            this.myTextField = new JTextField();
            this.myPsiFile = file;
            this.myDefaultName = defaultName;
            this.setTitle(StringUtil.capitalizeWords((String)AnonymousToNamedFunctionIntention.this.getText(), (boolean)true));
            this.updateOkAction();
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(7, 2, 5, 2));
            JLabel label = new JLabel("Function name:");
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            panel.add((Component)label, "First");
            label.setLabelFor(this.myTextField);
            panel.add((Component)this.myTextField, "Last");
            this.myTextField.setPreferredSize(new Dimension(200, this.myTextField.getPreferredSize().height));
            if (this.myDefaultName != null) {
                this.myTextField.setText(this.myDefaultName);
                this.updateOkAction();
            }
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    GetFunctionNameDialog.this.updateOkAction();
                }
            });
            return panel;
        }

        private void updateOkAction() {
            String text = this.myTextField.getText();
            this.getOKAction().setEnabled(text.length() > 0 && this.isNameValid(text));
        }

        private boolean isNameValid(String text) {
            return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(this.myPsiFile.getLanguage())).isIdentifier(text, this.myPsiFile.getProject());
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField;
        }

        public String getFunctionName() {
            return this.myTextField.getText();
        }

        protected void doOKAction() {
            super.doOKAction();
        }
    }
}

