/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryRenamingManager;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JavaScriptLibraryMappings", storages={@Storage(value="jsLibraryMappings.xml")})
public class JSLibraryMappings
extends ScriptingLibraryMappings {
    static final String COMPONENT_NAME = "JavaScriptLibraryMappings";
    static final String EXCLUDED_PREDEFINED_LIBRARY = "excludedPredefinedLibrary";
    static final String INCLUDED_PREDEFINED_LIBRARY = "includedPredefinedLibrary";
    static final String PREDEFINED_LIBRARY_NAME = "name";
    private final Set<String> myExcludedPredefinedLibraryNames = new TreeSet<String>();
    private final Set<String> myIncludedPredefinedLibraryNames = new TreeSet<String>();
    private JSLibraryManager myLibraryManager;
    private JSPredefinedLibraryRenamingManager myPredefinedLibraryRenamingManager;

    public JSLibraryMappings(Project project) {
        super(project);
        this.setMissingPredefinedLibraries();
        ScriptingLibraryUtil.registerJSLibraryMappings((Project)project, (ScriptingLibraryMappings)this);
    }

    @NotNull
    protected JSLibraryManager getLibraryManager() {
        if (this.myLibraryManager == null) {
            this.myLibraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)this.getProject(), JSLibraryManager.class));
        }
        JSLibraryManager jSLibraryManager = this.myLibraryManager;
        if (jSLibraryManager == null) {
            JSLibraryMappings.$$$reportNull$$$0(0);
        }
        return jSLibraryManager;
    }

    public void loadState(Element state) {
        this.setMapping(null, null);
        this.myExcludedPredefinedLibraryNames.clear();
        List excludedLibraries = state.getChildren(EXCLUDED_PREDEFINED_LIBRARY);
        for (Element predefLibrary : excludedLibraries) {
            Attribute libName = predefLibrary.getAttribute(PREDEFINED_LIBRARY_NAME);
            if (libName == null) continue;
            String presentationName = this.getPredefinedLibraryPresentationName(libName.getValue());
            this.myExcludedPredefinedLibraryNames.add(presentationName);
        }
        List includedLibraries = state.getChildren(INCLUDED_PREDEFINED_LIBRARY);
        for (Element predefLibrary : includedLibraries) {
            Attribute libName = predefLibrary.getAttribute(PREDEFINED_LIBRARY_NAME);
            if (libName == null) continue;
            String presentationName = this.getPredefinedLibraryPresentationName(libName.getValue());
            this.myIncludedPredefinedLibraryNames.add(presentationName);
        }
        super.loadState(state);
        this.setMissingPredefinedLibraries();
    }

    public Element getState() {
        String serializationName;
        Element predefLibsElement;
        Element e = super.getState();
        assert (e != null);
        this.updateLibraryStates();
        for (String libName : this.myIncludedPredefinedLibraryNames) {
            predefLibsElement = new Element(INCLUDED_PREDEFINED_LIBRARY);
            serializationName = this.getPredefinedLibrarySerializationName(libName);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, serializationName));
            e.addContent(predefLibsElement);
        }
        for (String libName : this.myExcludedPredefinedLibraryNames) {
            predefLibsElement = new Element(EXCLUDED_PREDEFINED_LIBRARY);
            serializationName = this.getPredefinedLibrarySerializationName(libName);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, serializationName));
            e.addContent(predefLibsElement);
        }
        return e;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            JSLibraryMappings.$$$reportNull$$$0(1);
        }
        String presentationName = this.getRenamingManager().getPresentationNameBySerializationName(serializationName);
        String string = (String)ObjectUtils.notNull((Object)presentationName, (Object)serializationName);
        if (string == null) {
            JSLibraryMappings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            JSLibraryMappings.$$$reportNull$$$0(3);
        }
        String serializationName = this.getRenamingManager().getSerializationNameByPresentationName(presentationName);
        String string = (String)ObjectUtils.notNull((Object)serializationName, (Object)presentationName);
        if (string == null) {
            JSLibraryMappings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private JSPredefinedLibraryRenamingManager getRenamingManager() {
        JSPredefinedLibraryRenamingManager manager = this.myPredefinedLibraryRenamingManager;
        if (manager == null) {
            this.myPredefinedLibraryRenamingManager = manager = new JSPredefinedLibraryRenamingManager();
        }
        JSPredefinedLibraryRenamingManager jSPredefinedLibraryRenamingManager = manager;
        if (jSPredefinedLibraryRenamingManager == null) {
            JSLibraryMappings.$$$reportNull$$$0(5);
        }
        return jSPredefinedLibraryRenamingManager;
    }

    private void setMissingPredefinedLibraries() {
        JSLibraryManager libManager = this.getLibraryManager();
        for (ScriptingLibraryModel model : libManager.getPredefinedLibraries()) {
            String libraryName = model.getName();
            if (this.myIncludedPredefinedLibraryNames.contains(libraryName)) {
                this.associate(null, libraryName, true);
                continue;
            }
            List mappings = this.getMappingsByLibraryName(libraryName);
            if (!mappings.isEmpty() || this.myExcludedPredefinedLibraryNames.contains(libraryName)) continue;
            List defaultMappings = model.getDefaultMappings();
            for (VirtualFile file : defaultMappings) {
                this.associate(file, libraryName, true);
            }
        }
    }

    private void updateLibraryStates() {
        this.myExcludedPredefinedLibraryNames.clear();
        this.myIncludedPredefinedLibraryNames.clear();
        for (ScriptingLibraryModel model : this.getLibraryManager().getPredefinedLibraries()) {
            List mappings;
            List defaultMappings = model.getDefaultMappings();
            if (defaultMappings.equals(mappings = this.getMappingsByLibraryName(model.getName()))) continue;
            if (mappings.isEmpty()) {
                this.myExcludedPredefinedLibraryNames.add(model.getName());
                continue;
            }
            if (!defaultMappings.isEmpty() || !JSLibraryMappings.isAssociatedWithProject((List)mappings)) continue;
            this.myIncludedPredefinedLibraryNames.add(model.getName());
        }
    }

    @NotNull
    public static JSLibraryMappings getInstance(@NotNull Project project) {
        if (project == null) {
            JSLibraryMappings.$$$reportNull$$$0(6);
        }
        JSLibraryMappings jSLibraryMappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        if (jSLibraryMappings == null) {
            JSLibraryMappings.$$$reportNull$$$0(7);
        }
        return jSLibraryMappings;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file, @NotNull Set<VirtualFile> includedFiles, @NotNull Set<VirtualFile> excludedFiles) {
        Set<VirtualFile> customLibs;
        if (file == null) {
            JSLibraryMappings.$$$reportNull$$$0(8);
        }
        if (includedFiles == null) {
            JSLibraryMappings.$$$reportNull$$$0(9);
        }
        if (excludedFiles == null) {
            JSLibraryMappings.$$$reportNull$$$0(10);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(includedFiles);
        files.addAll(this.getLibraryManager().getRequiredLibraryFilesForResolve());
        HashSet<VirtualFile> syntheticLibraryRoots = new HashSet<VirtualFile>();
        this.forEachLibraryInScopeForFile(file, model -> {
            if (model instanceof ScriptingLibraryModelBackedBySyntheticLibrary) {
                syntheticLibraryRoots.add(((ScriptingLibraryModelBackedBySyntheticLibrary)model).getLibraryRoot());
            } else {
                model.addSignificantFiles((Collection)files);
            }
        });
        VirtualFile globalTypesRoot = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (globalTypesRoot != null) {
            syntheticLibraryRoots.add(globalTypesRoot);
        }
        files.removeAll(excludedFiles);
        Project project = this.getProject();
        GlobalSearchScope scope = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, files);
        if (!syntheticLibraryRoots.isEmpty()) {
            GlobalSearchScope syntheticLibrariesScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray(syntheticLibraryRoots)).intersectWith(ProjectScope.getLibrariesScope((Project)project));
            scope = scope.union((SearchScope)syntheticLibrariesScope);
        }
        if (!(customLibs = TypeScriptLibraryProvider.getService(project).getAllCustomLibraries()).isEmpty()) {
            scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.filesScope((Project)project, customLibs)));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            JSLibraryMappings.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLibraryMappings.$$$reportNull$$$0(12);
        }
        GlobalSearchScope globalSearchScope = this.getLibraryScopeForFile(file, Collections.emptySet(), Collections.emptySet());
        if (globalSearchScope == null) {
            JSLibraryMappings.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryManager";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenamingManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScopeForFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScopeForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

