/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import icons.JavaScriptLanguageIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSScriptingContextProvider
extends LangScriptingContextProvider {
    private static final Logger LOG = Logger.getInstance(JSScriptingContextProvider.class);

    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(0);
        }
        return javascriptLanguage;
    }

    public PersistentLibraryKind getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }

    public ScriptingLibraryManager getLibraryManager(Project project) {
        return (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
    }

    public boolean acceptsExtension(String fileExt) {
        if (fileExt != null) {
            for (String extension : JSFileReference.IMPLICIT_EXTENSIONS) {
                if (!fileExt.regionMatches(true, 0, extension, 1, fileExt.length())) continue;
                return true;
            }
        }
        return false;
    }

    public ScriptingLibraryMappings getLibraryMappings(Project project) {
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        assert (mappings != null);
        return mappings;
    }

    public boolean isCompact(@NotNull VirtualFile file) {
        if (file == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(1);
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    @Nullable
    public String getLibraryTypeName(OrderRootType rootType) {
        if (rootType == OrderRootType.CLASSES) {
            return "Release";
        }
        if (rootType == OrderRootType.SOURCES) {
            return "Debug";
        }
        return null;
    }

    public String getDefaultDocUrl(@NotNull ScriptingFrameworkDescriptor framework) {
        String baseKey;
        if (framework == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(2);
        }
        if ((baseKey = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
            return JSExternalLibraryDocBundle.getBaseUrl(baseKey);
        }
        return null;
    }

    @Nullable
    public ScriptingFrameworkDescriptor detectFramework(@NotNull VirtualFile file) {
        if (file == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(3);
        }
        return JSProjectUtil.detectFramework(file.getUrl());
    }

    @Nullable
    public String getOfflineDocUrl(String defaultDocUrl) {
        String baseKey = JSExternalLibraryDocBundle.getBaseURLKey(defaultDocUrl);
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getOfflineDocUrl(baseKey);
        }
        return null;
    }

    public void downloadOfflineDoc(@NotNull Project project, @NotNull String offlineDocUrl, @Nullable Component notificationAreaComponent, @NotNull Consumer<File> onDownloadedFile) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(4);
        }
        if (offlineDocUrl == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(5);
        }
        if (onDownloadedFile == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(6);
        }
        JSScriptingContextProvider.doDownload(project, Collections.singletonList(offlineDocUrl), "Downloading documentation", notificationAreaComponent, (Consumer<List<File>>)((Consumer)files -> {
            if (onDownloadedFile == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(43);
            }
            onDownloadedFile.consume(ContainerUtil.getFirstItem((List)files));
        }));
    }

    private static void doDownload(@NotNull Project project, @NotNull List<String> urls, @NotNull String progressTitle, @Nullable Component notificationAreaComponent, @NotNull Consumer<List<File>> downloadedFilesConsumer) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(7);
        }
        if (urls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(8);
        }
        if (progressTitle == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(9);
        }
        if (downloadedFilesConsumer == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(10);
        }
        JSScriptingContextProvider.doDownload(project, urls, progressTitle, notificationAreaComponent, downloadedFilesConsumer, new JSDownloadManager(null));
    }

    public static void doDownload(final @NotNull Project project, final @NotNull List<String> urls, @NotNull String progressTitle, final @Nullable Component notificationAreaComponent, final @NotNull Consumer<List<File>> downloadedFilesConsumer, final @NotNull JSDownloadManager downloadManager) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(11);
        }
        if (urls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(12);
        }
        if (progressTitle == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(13);
        }
        if (downloadedFilesConsumer == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(14);
        }
        if (downloadManager == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final ModalityState modalityState = ModalityState.current();
        Task.Backgroundable task = new Task.Backgroundable(project, progressTitle, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList result2 = ContainerUtil.newArrayList();
                ArrayList failedUrls = ContainerUtil.newArrayList();
                StepProgressIndicator stepIndicator = new StepProgressIndicator(indicator, urls.size());
                for (String url : urls) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    File file = JSScriptingContextProvider.doDownloadUrl(indicator, downloadManager, url);
                    stepIndicator.onStepDone();
                    if (file != null) {
                        result2.add(file);
                        continue;
                    }
                    failedUrls.add(url);
                    break;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (urls == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (downloadedFilesConsumer == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (notificationAreaComponent != null) {
                        JSScriptingContextProvider.notifyAboutDownload(project, notificationAreaComponent, urls, failedUrls);
                    }
                    if (failedUrls.isEmpty()) {
                        downloadedFilesConsumer.consume((Object)result2);
                    } else {
                        downloadedFilesConsumer.consume(Collections.emptyList());
                    }
                }, modalityState);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "urls";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "downloadedFilesConsumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    @Nullable
    private static File doDownloadUrl(@Nullable ProgressIndicator progressIndicator, JSDownloadManager downloadManager, @NotNull String url) {
        if (url == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(16);
        }
        downloadManager.setProgressIndicator(progressIndicator);
        JSDownloadManager.JSDownloadException exception = null;
        boolean tryAgain = true;
        while (tryAgain) {
            downloadManager.download(url, JSExternalLibraryDocBundle.getOfflineDocExt(url));
            exception = downloadManager.getLastException();
            if (exception == null) {
                String targetFilePath = downloadManager.getTargetFilePath();
                return targetFilePath != null ? new File(targetFilePath) : null;
            }
            tryAgain = IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Cannot download " + url + ". " + exception.getReason()));
        }
        LOG.info(exception);
        return null;
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> getDownloadableLibraryDescriptors(Project project) {
        URL localUrl = JSDownloadManager.class.getResource("jslibraries.xml");
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions("javascript", new URL[]{localUrl});
        if (downloadableFileSetVersions == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(17);
        }
        return downloadableFileSetVersions;
    }

    public void filterExistingLibraries(@NotNull Project project, @NotNull List<? extends DownloadableFileSetDescription> descriptions) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(18);
        }
        if (descriptions == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(19);
        }
        JSScriptingContextProvider.doFilterExistingLibraries(project, descriptions);
    }

    private static <T extends DownloadableFileSetDescription> void doFilterExistingLibraries(@NotNull Project project, @NotNull List<T> descriptions) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(20);
        }
        if (descriptions == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(41);
            }
            if (descriptions == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(42);
            }
            if (project.isDisposed()) {
                return;
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            ArrayList<DownloadableFileSetDescription> toRemove = new ArrayList<DownloadableFileSetDescription>();
            for (DownloadableFileSetDescription description : descriptions) {
                String ideLibName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
                if (libraryManager.getLibraryByName(ideLibName) == null) continue;
                toRemove.add(description);
            }
            descriptions.removeAll(toRemove);
        });
    }

    public void downloadLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(22);
        }
        if (description == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (description == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(35);
            }
            if (project == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(36);
            }
            try {
                List urls = ContainerUtil.mapNotNull((Collection)description.getFiles(), DownloadableFileDescription::getDownloadUrl);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        JSScriptingContextProvider.$$$reportNull$$$0(37);
                    }
                    if (description == null) {
                        JSScriptingContextProvider.$$$reportNull$$$0(38);
                    }
                    JSScriptingContextProvider.doDownload(project, ContainerUtil.newArrayList((Iterable)ContainerUtil.newLinkedHashSet((Iterable)urls)), "Downloading library", notificationAreaComponent, (Consumer<List<File>>)((Consumer)downloadedFiles -> {
                        boolean created;
                        if (project == null) {
                            JSScriptingContextProvider.$$$reportNull$$$0(39);
                        }
                        if (description == null) {
                            JSScriptingContextProvider.$$$reportNull$$$0(40);
                        }
                        if ((created = this.createLibrary(project, description, (List<File>)downloadedFiles)) && onLibraryCreated != null) {
                            onLibraryCreated.run();
                        }
                    }));
                }, modalityState);
            }
            catch (Exception e) {
                LOG.warn("Cannot determine library URLs, no library created", (Throwable)e);
            }
        });
    }

    private boolean createLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @NotNull List<File> libraryFiles) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(24);
        }
        if (description == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(25);
        }
        if (libraryFiles == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (libraryFiles.isEmpty()) {
            return false;
        }
        return (Boolean)WriteAction.compute(() -> {
            String baseUrl;
            List files;
            if (libraryFiles == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(32);
            }
            if (description == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(33);
            }
            if (project == null) {
                JSScriptingContextProvider.$$$reportNull$$$0(34);
            }
            if ((files = ContainerUtil.mapNotNull((Collection)libraryFiles, file -> VfsUtil.findFileByIoFile((File)file, (boolean)true))).isEmpty()) {
                return false;
            }
            String libName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libName);
            if (library != null) {
                return false;
            }
            ScriptingFrameworkDescriptor framework = this.detectFramework((VirtualFile)files.iterator().next());
            String[] docUrls = ArrayUtil.EMPTY_STRING_ARRAY;
            if (framework != null && (baseUrl = this.getDefaultDocUrl(framework)) != null) {
                docUrls = new String[]{baseUrl};
            }
            ScriptingLibraryModel libModel = libraryManager.createLibrary(libName, VfsUtilCore.toVirtualFileArray((Collection)files), VirtualFile.EMPTY_ARRAY, docUrls, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
            if (framework != null) {
                libModel.setFrameworkDescriptor(framework);
            }
            libraryManager.commitChanges();
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            mappings.associate(null, libName);
            return true;
        });
    }

    private static void notifyAboutDownload(@NotNull Project project, @NotNull Component notificationAreaComponent, @NotNull List<String> allUrls, @NotNull List<String> failedUrls) {
        String info;
        List<String> urls;
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(27);
        }
        if (notificationAreaComponent == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(28);
        }
        if (allUrls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(29);
        }
        if (failedUrls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(30);
        }
        if (allUrls.isEmpty()) {
            return;
        }
        boolean success = failedUrls.isEmpty();
        List<String> list = urls = success ? allUrls : failedUrls;
        if (urls.size() == 1) {
            info = urls.get(0);
        } else {
            List topUrls = ContainerUtil.getFirstItems(urls, (int)10);
            info = StringUtil.join((Collection)topUrls, url -> "<div>" + url + "</div>", (String)"");
            if (topUrls.size() < urls.size()) {
                info = info + "<div><a href='view_all'>... and " + (urls.size() - topUrls.size()) + " more</a></div>";
            }
        }
        final String titleHtml = "<b>" + (success ? "Successfully downloaded" : "Failed to download") + "</b><br/>";
        MessageType type = success ? MessageType.INFO : MessageType.ERROR;
        final JEditorPane viewer = SwingHelper.createHtmlViewer((boolean)false, null, (Color)type.getPopupBackground(), null);
        viewer.setFocusable(true);
        SwingHelper.setHtml((JEditorPane)viewer, (String)(titleHtml + info), null);
        viewer.setBorder(null);
        viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                String info = StringUtil.join((Collection)urls, url -> "<div>" + url + "</div>", (String)"");
                viewer.setText(titleHtml + info);
                viewer.setCaretPosition(0);
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)viewer);
        scrollPane.setBorder(null);
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)scrollPane);
        builder.setShowCallout(false).setCloseButtonEnabled(true).setDisposable((Disposable)project);
        Rectangle bounds = notificationAreaComponent.getBounds();
        Point p = new Point(bounds.width / 2, bounds.height - JBUI.scale((int)40));
        RelativePoint point = new RelativePoint(notificationAreaComponent, p);
        Balloon balloon = builder.createBalloon();
        balloon.show(point, Balloon.Position.below);
    }

    public ScriptingFrameworkDescriptor[] getSupportedFrameworks(Project project) {
        Set<String> keys = JSExternalLibraryDocBundle.getBasePatternKeys();
        ArrayList<ScriptingFrameworkDescriptor> descriptors = new ArrayList<ScriptingFrameworkDescriptor>();
        for (String key : keys) {
            String name = JSExternalLibraryDocBundle.getLibraryName(key);
            descriptors.add(new ScriptingFrameworkDescriptor(name, null));
        }
        Collections.sort(descriptors, (d1, d2) -> {
            int nameResult;
            int n = nameResult = d1.getFrameworkName() != null ? d1.getFrameworkName().compareToIgnoreCase(d2.getFrameworkName()) : -1;
            if (nameResult != 0) {
                return nameResult;
            }
            return d1.getFrameworkVersion() != null ? d1.getFrameworkVersion().compareTo(d2.getFrameworkVersion()) : -1;
        });
        return descriptors.toArray(new ScriptingFrameworkDescriptor[descriptors.size()]);
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = JavaScriptLanguageIcons.Library.JsLibrary;
        if (icon == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(31);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDocUrl";
                break;
            }
            case 6: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDownloadedFile";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedFilesConsumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 19: 
            case 21: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 23: 
            case 25: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationAreaComponent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUrls";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadableLibraryDescriptors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCompact";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocUrl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "downloadOfflineDoc";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doDownload";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadUrl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingLibraries";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doFilterExistingLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "downloadLibrary";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutDownload";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLibrary$6";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadLibrary$4";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFilterExistingLibraries$1";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadOfflineDoc$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StepProgressIndicator
    extends ProgressIndicatorBase {
        private final int myTotalSteps;
        private final AtomicInteger myFinishedSteps;
        private final ProgressIndicatorEx myRealIndicator;
        private boolean myUpdatingRealIndicatorFraction;

        public StepProgressIndicator(@NotNull ProgressIndicator realIndicator, int totalSteps) {
            if (realIndicator == null) {
                StepProgressIndicator.$$$reportNull$$$0(0);
            }
            this.myFinishedSteps = new AtomicInteger(0);
            this.myUpdatingRealIndicatorFraction = false;
            this.myTotalSteps = totalSteps;
            this.myRealIndicator = (ProgressIndicatorEx)ObjectUtils.tryCast((Object)realIndicator, ProgressIndicatorEx.class);
            if (this.myRealIndicator != null) {
                this.myRealIndicator.addStateDelegate((ProgressIndicatorEx)this);
            }
        }

        public void setFraction(double stepFraction) {
            if (!this.myUpdatingRealIndicatorFraction) {
                stepFraction = Math.min(Math.max(stepFraction, 0.0), 1.0);
                double fraction = ((double)this.myFinishedSteps.get() + stepFraction) / (1.0 * (double)this.myTotalSteps);
                super.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = true;
                this.myRealIndicator.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = false;
            }
        }

        public void onStepDone() {
            this.myFinishedSteps.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realIndicator", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$StepProgressIndicator", "<init>"));
        }
    }
}

