/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private boolean myIsFix;
    private final EslintLanguageServiceClient myLanguageService;

    public EsLintExternalRunner(boolean isOnTheFly, boolean isFix, EslintLanguageServiceClient service) {
        this.myIsOnTheFly = isOnTheFly;
        this.myIsFix = isFix;
        this.myLanguageService = service;
    }

    @Nullable
    private static EslintSessionData createSessionData(@NotNull Project project, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile) {
        VirtualFile workingDir;
        if (project == null) {
            EsLintExternalRunner.$$$reportNull$$$0(0);
        }
        if (fileToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(1);
        }
        if (fileContentToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(2);
        }
        if ((workingDir = EsLintExternalRunner.guessWorkingDirectory(project, fileToLint)) == null) {
            LOG.debug("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.debug(String.format("No parent directory for file %s", fileToLint.getPath()));
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        VirtualFile eslintIgnoreFile;
        if (project == null) {
            EsLintExternalRunner.$$$reportNull$$$0(3);
        }
        if (fileToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(4);
        }
        VirtualFile eslintIgnoreFileDir = (eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileToLint, ".eslintignore")) != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private JSLinterAnnotationResult<EslintState> eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> possibleConfigs) {
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(5);
        }
        if (sessionData == null) {
            EsLintExternalRunner.$$$reportNull$$$0(6);
        }
        if (possibleConfigs == null) {
            EsLintExternalRunner.$$$reportNull$$$0(7);
        }
        long startNanoTime = System.nanoTime();
        if (!EslintUtil.lintThisFileType(input.getProject(), input.getPsiFile(), possibleConfigs, input.getState())) {
            return null;
        }
        JSLinterAnnotationResult<EslintState> result2 = this.runProcess(input, sessionData, possibleConfigs);
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNanoTime);
        String report = "found " + result2.getErrors().size() + " problems";
        LOG.debug(String.format("Done in %d ms, %s", durationMillis, report));
        return result2;
    }

    @NotNull
    private JSLinterAnnotationResult<EslintState> runProcess(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> possibleConfigs) {
        VirtualFile config2;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(8);
        }
        if (sessionData == null) {
            EsLintExternalRunner.$$$reportNull$$$0(9);
        }
        if (possibleConfigs == null) {
            EsLintExternalRunner.$$$reportNull$$$0(10);
        }
        VirtualFile bestGuessConfig = (config2 = sessionData.getSpecifiedConfigFile()) != null ? config2 : (VirtualFile)ContainerUtil.getFirstItem(possibleConfigs);
        Future<Pair<String, List<JSLinterError>>> future = this.myIsFix ? this.myLanguageService.highlightAndFix(sessionData.getFileToLint(), config2, input.getState().getExtraOptions()) : this.myLanguageService.highlight(sessionData.getFileToLint(), config2, sessionData.getFileToLintContent(), input.getState().getExtraOptions());
        ResultWithError<Pair<String, List<JSLinterError>>> result2 = JSLanguageServiceUtil.awaitLanguageService(future, this.myLanguageService);
        String error = result2.getError() != null ? result2.getError() : (result2.getResult() == null ? "Can not get result from language service" : (String)result2.getResult().getFirst());
        Pair<String, List<JSLinterError>> pair = result2.getResult();
        if (error != null) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(error);
            IntentionAction detailsAction = pair == null ? null : JSLinterUtil.createDetailsAction(input.getProject(), sessionData.getFileToLint(), null, output, JavaScriptLanguageIcons.FileTypes.Eslint);
            JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, EsLintExternalRunner.createFileLevelAnnotation(error, detailsAction), bestGuessConfig);
            if (jSLinterAnnotationResult == null) {
                EsLintExternalRunner.$$$reportNull$$$0(11);
            }
            return jSLinterAnnotationResult;
        }
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(input, pair != null ? (List)pair.getSecond() : Collections.emptyList(), bestGuessConfig);
        if (jSLinterAnnotationResult == null) {
            EsLintExternalRunner.$$$reportNull$$$0(12);
        }
        return jSLinterAnnotationResult;
    }

    public static JSLinterFileLevelAnnotation createFileLevelAnnotation(String error, @Nullable IntentionAction detailsAction) {
        String[] strings;
        JSLinterFileLevelAnnotation annotation = detailsAction == null ? new JSLinterFileLevelAnnotation(error) : new JSLinterFileLevelAnnotation(error, detailsAction);
        for (String string : strings = StringUtil.filterEmptyStrings((String[])StringUtil.splitByLines((String)error))) {
            if (FileUtil.isAbsolute((String)(string = string.trim())) || string.endsWith(":") && FileUtil.isAbsolute((String)string.substring(0, string.length() - 1)) || string.startsWith("Oops! Something went wrong! :(")) continue;
            annotation.setShortMessage(string);
            break;
        }
        return annotation.withIcon(JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    public JSLinterAnnotationResult<EslintState> execute(@NotNull JSLinterInput<EslintState> input) {
        VirtualFile specifiedConfigFile;
        String additionalRulesError;
        EslintState state;
        VirtualFile fileToLint;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(13);
        }
        if (!(fileToLint = input.getVirtualFile()).isValid() || fileToLint.getParent() == null) {
            return null;
        }
        Project project = input.getProject();
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(project, "eslint", state = input.getState());
        if (error != null) {
            return JSLinterAnnotationResult.create(input, error, null);
        }
        if (!StringUtil.isEmptyOrSpaces((String)state.getAdditionalRulesDirPath()) && (additionalRulesError = JSLinterUtil.checkPath(state.getAdditionalRulesDirPath(), true, "Additional rules directory").getError()) != null) {
            return EsLintExternalRunner.errorForText(input, additionalRulesError);
        }
        if (state.isCustomConfigFileUsed()) {
            ResultWithError<VirtualFile> result2 = JSLinterUtil.checkPath(state.getCustomConfigFilePath(), false, "ESLint configuration file");
            if (result2.getError() != null) {
                return EsLintExternalRunner.errorForText(input, result2.getError());
            }
            specifiedConfigFile = result2.getResult();
        } else {
            specifiedConfigFile = null;
        }
        EslintSessionData sessionData = (EslintSessionData)ReadAction.compute(() -> {
            if (input == null) {
                EsLintExternalRunner.$$$reportNull$$$0(17);
            }
            if (project.isDisposed()) {
                return null;
            }
            if (this.myIsOnTheFly) {
                EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
            }
            return EsLintExternalRunner.createSessionData(project, fileToLint, input.getFileContent(), specifiedConfigFile);
        });
        if (sessionData == null) {
            return null;
        }
        SmartList possibleConfigs = new SmartList();
        boolean runGranted = (Boolean)ReadAction.compute(() -> this.lambda$execute$1(project, (List)possibleConfigs, sessionData));
        if (runGranted) {
            return this.eslint(input, sessionData, (List<VirtualFile>)possibleConfigs);
        }
        LOG.debug("ESLint postponed because of unsaved configs");
        return null;
    }

    @NotNull
    private static JSLinterAnnotationResult<EslintState> errorForText(@NotNull JSLinterInput<EslintState> input, @NotNull String text) {
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(14);
        }
        if (text == null) {
            EsLintExternalRunner.$$$reportNull$$$0(15);
        }
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(text), null);
        if (jSLinterAnnotationResult == null) {
            EsLintExternalRunner.$$$reportNull$$$0(16);
        }
        return jSLinterAnnotationResult;
    }

    private /* synthetic */ Boolean lambda$execute$1(Project project, List possibleConfigs, EslintSessionData sessionData) throws RuntimeException {
        if (project.isDisposed()) {
            return false;
        }
        possibleConfigs.addAll(sessionData.findConfigs());
        return !this.myIsOnTheFly || EslintUnsavedConfigManager.getInstance(project).requestSaveIfNeeded(possibleConfigs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentToLint";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionData";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleConfigs";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "errorForText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSessionData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "eslint";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "errorForText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

