/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class JavaScriptClassContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        HashSet<String> result2 = new HashSet<String>();
        JavaScriptClassContributor.collectAllMxmlClassesNames(project, result2);
        Collection jsClasses = StubIndex.getInstance().getAllKeys(JSClassIndex.KEY, project);
        for (String jsClass : jsClasses) {
            if (jsClass.length() > 0 && jsClass.charAt(0) == '^') {
                jsClass = jsClass.substring(1);
            }
            result2.add(jsClass.substring(jsClass.lastIndexOf(46) + 1));
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static void collectAllMxmlClassesNames(Project project, Collection<String> result2) {
        FileType type = JavaScriptSupportLoader.getMxmlFileType();
        if (type == null) {
            return;
        }
        for (VirtualFile mxmlFile : FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))) {
            result2.add(mxmlFile.getNameWithoutExtension());
        }
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        Collection<? extends NavigationItem> result2 = JavaScriptClassContributor.getItemsByNameStatic(name, project, includeNonProjectItems);
        if (result2.size() == 0) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                JavaScriptClassContributor.$$$reportNull$$$0(1);
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        NavigationItem[] navigationItemArray = result2.toArray(new NavigationItem[result2.size()]);
        if (navigationItemArray == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(2);
        }
        return navigationItemArray;
    }

    public static Collection<? extends NavigationItem> getItemsByNameStatic(String name, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? ProjectScope.getAllScope((Project)project) : ProjectScope.getProjectScope((Project)project);
        Collection<JSQualifiedNamedElement> psiClasses = JSResolveUtil.findElementsByName(name, project, scope);
        Iterator<JSQualifiedNamedElement> q = psiClasses.iterator();
        while (q.hasNext()) {
            JSQualifiedNamedElement element = q.next();
            if (element instanceof XmlBackedJSClass || element instanceof JSNamespaceDeclaration) continue;
            q.remove();
        }
        ArrayList<JSQualifiedNamedElement> result2 = new ArrayList<JSQualifiedNamedElement>(psiClasses);
        ArrayList<JSQualifiedNamedElement> minorImportanceClasses = new ArrayList<JSQualifiedNamedElement>(psiClasses);
        ArrayList<JSQualifiedNamedElement> namespaces = new ArrayList<JSQualifiedNamedElement>(psiClasses);
        JSClassIndex.processElements(name, project, scope, (Processor<JSPsiElementBase>)((Processor)base -> {
            Collection resultCollection = result2;
            if (base instanceof JSImplicitElement) {
                JSImplicitElement.Type type = ((JSImplicitElement)base).getType();
                if (type == JSImplicitElement.Type.Namespace) {
                    resultCollection = namespaces;
                } else if (((JSImplicitElement)base).hasMinorImportance()) {
                    resultCollection = minorImportanceClasses;
                }
            }
            resultCollection.add(base);
            return true;
        }));
        if (!result2.isEmpty()) {
            return result2;
        }
        if (!minorImportanceClasses.isEmpty() || !namespaces.isEmpty()) {
            THashSet replacedImplicitElements = new THashSet();
            for (JSPsiElementBase implicitElement : ContainerUtil.concat((Iterable[])new Iterable[]{namespaces, minorImportanceClasses})) {
                GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)implicitElement.getContainingFile().getVirtualFile());
                Collection<JSPsiElementBase> matchedElements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(implicitElement.getQualifiedName(), fileScope);
                replacedImplicitElements.addAll(matchedElements);
            }
            replacedImplicitElements.removeAll(minorImportanceClasses);
            replacedImplicitElements.removeAll(namespaces);
            return !replacedImplicitElements.isEmpty() ? replacedImplicitElements : minorImportanceClasses;
        }
        return Collections.emptySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/navigation/JavaScriptClassContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

