/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)JSChangeUtil.class.getName());
    @NonNls
    private static final String DUMMY = "dummy.";
    @NonNls
    public static final String VAR_PREFIX = "var";
    @NonNls
    public static final String LET_PREFIX = "let";
    private static final Set<String> WELL_KNOWN = ContainerUtil.set((Object[])new String[]{"require", "define", "module", "exports", "window", "global", "arguments", "document", "navigator", "screen", "history", "location", "console"});

    private JSChangeUtil() {
    }

    public static ASTNode createNameIdentifier(Project project, @NotNull String name, @Nullable IElementType type) {
        if (name == null) {
            JSChangeUtil.$$$reportNull$$$0(0);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            return JSChangeUtil.createNameIdentifier(project, name, (JSLanguageDialect)null);
        }
        if (type == JSTokenTypes.STRING_LITERAL && !StringUtil.isQuotedString((String)name)) {
            return JSChangeUtil.createExpressionFromText(project, "\"" + name + "\"").getFirstChildNode();
        }
        return JSChangeUtil.createExpressionFromText(project, name).getFirstChildNode();
    }

    public static ASTNode createPropertyNameWithContext(@NotNull String name, @NotNull ASTNode nameNode) {
        if (name == null) {
            JSChangeUtil.$$$reportNull$$$0(1);
        }
        if (nameNode == null) {
            JSChangeUtil.$$$reportNull$$$0(2);
        }
        IElementType type = nameNode.getElementType();
        Project project = nameNode.getPsi().getProject();
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(nameNode.getPsi());
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            return JSChangeUtil.createNameIdentifier(project, name, dialect);
        }
        if (type == JSTokenTypes.STRING_LITERAL && !StringUtil.isQuotedString((String)name)) {
            char quote = nameNode.getText().charAt(0);
            return JSChangeUtil.createExpressionWithContext(quote + name + quote, nameNode.getPsi()).getFirstChildNode();
        }
        return JSChangeUtil.createExpressionWithContext(name, nameNode.getPsi()).getFirstChildNode();
    }

    public static ASTNode createNameIdentifier(Project project, String name, @Nullable JSLanguageDialect dialect) {
        JSExpressionStatement expressionStatement = (JSExpressionStatement)JSChangeUtil.createJSTreeFromTextImpl(project, String.format("({%s:1});", name), dialect);
        assert (expressionStatement != null);
        JSParenthesizedExpression parenthesized = (JSParenthesizedExpression)expressionStatement.getExpression();
        assert (parenthesized != null);
        JSObjectLiteralExpression literalExpression = (JSObjectLiteralExpression)parenthesized.getInnerExpression();
        assert (literalExpression != null);
        return literalExpression.getFirstProperty().getNameIdentifier().getNode();
    }

    public static ASTNode createNameIdentifierWithContext(String name, PsiElement context) {
        return JSChangeUtil.createNameIdentifier(context.getProject(), name, DialectDetector.languageDialectOfElement(context));
    }

    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createExpressionFromText(project, text, null);
    }

    @Nullable
    public static <PsiT> PsiT createExpressionPsiWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> psiClass) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            JSChangeUtil.$$$reportNull$$$0(4);
        }
        if ((node = JSChangeUtil.createExpressionWithContext(text, context)) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), psiClass);
    }

    @Nullable
    public static ASTNode createExpressionWithContext(@NonNls String text, @NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(5);
        }
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        return JSChangeUtil.createExpressionFromText(context.getProject(), text, dialect, isAsyncContext);
    }

    private static boolean isAsyncContext(@Nullable PsiElement context) {
        return context != null && ES6PsiUtil.isAsyncContext((JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSFunction.class}));
    }

    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsyncContext) {
        ASTNode node = JSChangeUtil.tryCreateExpressionInternal(project, text, dialect, isAsyncContext);
        if (node == null) {
            LOG.error("Wasn't parsed as expression in " + (Object)((Object)dialect), new Attachment[]{new Attachment("text.txt", text)});
        }
        return node;
    }

    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        return JSChangeUtil.createExpressionFromText(project, text, dialect, false);
    }

    private static ASTNode tryCreateExpressionInternal(Project project, @NotNull @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsyncContext) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(6);
        }
        text = "{\n(" + text + ")\n}";
        PsiElement element = JSChangeUtil.createJSTreeFromText(project, text, dialect, isAsyncContext);
        assert (element instanceof JSBlockStatement) : "\"" + text + "\" was not parsed as BlockStatement in " + (Object)((Object)dialect);
        JSStatement[] statements = ((JSBlockStatement)element).getStatements();
        JSStatement jSStatement = element = statements.length > 0 ? statements[0] : null;
        if (!(element instanceof JSExpressionStatement)) {
            LOG.error("Unexpected expression parse in " + (Object)((Object)dialect), new Attachment[]{new Attachment("text.txt", text)});
            return null;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)element;
        JSExpression expr = (JSExpression)expressionStatement.getFirstChild();
        if (expr instanceof JSParenthesizedExpression) {
            expr = ((JSParenthesizedExpression)expr).getInnerExpression();
        }
        if (expr == null) {
            return null;
        }
        return expr.getNode();
    }

    @Nullable
    public static ASTNode tryCreateExpressionWithContext(@NonNls String text, @NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(7);
        }
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        return JSChangeUtil.tryCreateExpressionInternal(context.getProject(), text, DialectDetector.languageDialectOfElement(context), isAsyncContext);
    }

    @Nullable
    public static ASTNode createStatementFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createStatementFromText(project, text, null);
    }

    public static JSVarStatement createVarStatement(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(9);
        }
        return JSChangeUtil.createStatementPsiFromTextWithContext(text, context, JSVarStatement.class);
    }

    @Nullable
    public static <PsiT> PsiT createStatementPsiFromTextWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> clazz) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(10);
        }
        if (clazz == null) {
            JSChangeUtil.$$$reportNull$$$0(11);
        }
        if ((node = JSChangeUtil.createStatementFromTextWithContext(text, context)) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), clazz);
    }

    @Nullable
    public static <PsiT> PsiT createClassMemberPsiFromTextWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> clazz) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(12);
        }
        if (clazz == null) {
            JSChangeUtil.$$$reportNull$$$0(13);
        }
        if ((node = JSChangeUtil.createClassMemberFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context))) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), clazz);
    }

    @Nullable
    public static ASTNode createStatementFromTextWithContext(@NonNls String text, @NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(14);
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        return JSChangeUtil.createStatementFromText(context.getProject(), text, dialect, isAsyncContext);
    }

    @Nullable
    public static ASTNode createStatementFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        return JSChangeUtil.createStatementFromText(project, text, dialect, false);
    }

    @Nullable
    public static ASTNode createStatementFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsync) {
        PsiElement element = JSChangeUtil.createJSTreeFromText(project, text, dialect, isAsync);
        JSSourceElement stmt = element instanceof JSSourceElement ? (JSSourceElement)element : null;
        return stmt != null ? stmt.getNode() : null;
    }

    private static PsiElement createJSTreeFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsync) {
        return isAsync ? JSChangeUtil.createAsyncJSTreeFromTextImpl(project, text, dialect) : JSChangeUtil.createJSTreeFromTextImpl(project, text, dialect);
    }

    @Nullable
    private static PsiElement createJSTreeFromTextImpl(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        PsiFile dummyFile = JSChangeUtil.createJSFileFromText(project, text, dialect);
        return dummyFile.getFirstChild();
    }

    @Nullable
    private static PsiElement createAsyncJSTreeFromTextImpl(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        String asyncContext = "async function dummy() {" + text + "}";
        PsiFile dummyFile = JSChangeUtil.createJSFileFromText(project, asyncContext, dialect);
        PsiElement child = dummyFile.getFirstChild();
        if (!(child instanceof JSFunction)) {
            return null;
        }
        JSFunction function = (JSFunction)child;
        JSSourceElement[] body = function.getBody();
        if (body.length != 1) {
            return null;
        }
        return body[0].getFirstChild().getNextSibling();
    }

    public static PsiFile createJSFileFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        JSLanguageDialect language = dialect != null ? dialect : JavascriptLanguage.INSTANCE;
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        assert (def != null);
        String ext = dialect == null ? "js" : dialect.getFileExtension();
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY + ext, (Language)language, (CharSequence)text, false, true);
        assert (dummyFile instanceof JSFile);
        return dummyFile;
    }

    @Deprecated
    @NotNull
    public static PsiElement createCommaPsiElement(@NotNull Project project) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(15);
        }
        ASTNode text = JSChangeUtil.createJSTreeFromText(project, "dummy,dummy");
        ASTNode node = text.getFirstChildNode();
        ASTNode commaNode = node.findChildByType(JSTokenTypes.COMMA);
        assert (commaNode != null);
        PsiElement psiElement = commaNode.getPsi();
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createCommaPsiElement(@NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(17);
        }
        PsiElement psiElement = JSChangeUtil.createTokenElement(context, JSTokenTypes.COMMA, ",");
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    public static ASTNode createJSTreeFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createJSTreeFromText(project, text, null);
    }

    @Nullable
    public static ASTNode createJSTreeFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect languageDialect) {
        PsiElement element = JSChangeUtil.createJSTreeFromTextImpl(project, text, languageDialect);
        if (element != null) {
            return element.getNode();
        }
        return null;
    }

    @Nullable
    public static ASTNode createJSTreeFromTextWithContext(String text, @NotNull PsiElement context) {
        PsiElement element;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(19);
        }
        return (element = JSChangeUtil.createJSTreeFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context), JSChangeUtil.isAsyncContext(context))) != null ? element.getNode() : null;
    }

    public static JSExpression replaceExpression(JSExpression oldExpr, JSExpression newExpr) {
        if (JSUtils.isNeedParenthesis(oldExpr, newExpr)) {
            ASTNode parenthesized = JSChangeUtil.createExpressionWithContext("(a)", (PsiElement)oldExpr);
            JSParenthesizedExpression parenthPsi = (JSParenthesizedExpression)parenthesized.getPsi();
            parenthesized.replaceChild(parenthPsi.getInnerExpression().getNode(), newExpr.getNode().copyElement());
            oldExpr.getParent().getNode().replaceChild(oldExpr.getNode(), parenthesized);
            return parenthPsi;
        }
        ASTNode newNode = newExpr.getNode().copyElement();
        oldExpr.getParent().getNode().replaceChild(oldExpr.getNode(), newNode);
        return (JSExpression)newNode.getPsi();
    }

    public static JSElement replaceElement(@NotNull JSElement oldElement, @NotNull JSElement newElement) {
        if (oldElement == null) {
            JSChangeUtil.$$$reportNull$$$0(20);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(21);
        }
        ASTNode newNode = newElement.getNode().copyElement();
        oldElement.getParent().getNode().replaceChild(oldElement.getNode(), newNode);
        return (JSElement)newNode.getPsi();
    }

    public static JSStatement replaceStatement(@NotNull JSStatement oldElement, @NotNull JSStatement newElement) {
        if (oldElement == null) {
            JSChangeUtil.$$$reportNull$$$0(22);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(23);
        }
        return (JSStatement)JSChangeUtil.replaceElement((JSElement)oldElement, (JSElement)newElement);
    }

    public static void doIdentifierReplacement(PsiElement parent, PsiElement identifier, String name) {
        JSChangeUtil.doIdentifierReplacement(parent.getNode(), identifier.getNode(), name, parent.getProject());
    }

    public static void doIdentifierReplacement(ASTNode parentNode, ASTNode identifierNode, String name, Project project) {
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(project, name, DialectDetector.languageDialectOfElement(identifierNode.getPsi()));
        parentNode.replaceChild(identifierNode, nameElement);
    }

    public static PsiElement doAddBefore(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (!JSChangeUtil.isSourceElementOrComment(element) && !(element instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddBefore(jsElement, element, anchor);
    }

    public static PsiElement doDoAddBeforePure(PsiElement parentElement, PsiElement elementToInsert, @Nullable PsiElement anchor) throws IncorrectOperationException {
        ASTNode elementNode = elementToInsert.getNode();
        if (elementNode == null) {
            throw new IncorrectOperationException("node should not be null");
        }
        ASTNode copiedElementNode = elementNode.copyElement();
        ASTNode parentNode = parentElement.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        parentNode.addChild(copiedElementNode, anchorNode);
        return copiedElementNode.getPsi();
    }

    public static PsiElement doDoAddBefore(PsiElement parentElement, PsiElement elementToInsert, @Nullable PsiElement anchor) throws IncorrectOperationException {
        ASTNode elementNode = elementToInsert.getNode();
        if (elementNode == null) {
            throw new IncorrectOperationException("node should not be null");
        }
        ASTNode copiedElementNode = elementNode.copyElement();
        ASTNode parentNode = parentElement.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        anchorNode = JSChangeUtil.insertWhitespaceIfNeeded(anchorNode, elementNode, parentNode, anchorNode);
        parentNode.addChild(copiedElementNode, anchorNode);
        return copiedElementNode.getPsi();
    }

    private static ASTNode insertWhitespaceIfNeeded(ASTNode anchorNode, ASTNode elementNode, ASTNode parentNode, ASTNode insertionPlaceNode) throws IncorrectOperationException {
        ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(parentNode.getPsi().getLanguage());
        TokenSet comments = parserDef.getCommentTokens();
        TokenSet whitespaces = parserDef.getWhitespaceTokens();
        if (anchorNode != null && (!whitespaces.contains(anchorNode.getElementType()) && !whitespaces.contains(elementNode.getElementType()) || comments.contains(anchorNode.getElementType()) || comments.contains(elementNode.getElementType()) || elementNode.getPsi() instanceof PsiComment) || anchorNode == null && parentNode.getFirstChildNode() == null) {
            String commentString = " ";
            if (anchorNode != null && comments.contains(anchorNode.getElementType()) || comments.contains(elementNode.getElementType()) || elementNode.getPsi() instanceof PsiComment) {
                commentString = "\n";
            }
            anchorNode = JSChangeUtil.addWs(parentNode, insertionPlaceNode, commentString);
        }
        return anchorNode;
    }

    @NotNull
    public static ASTNode addWs(@NotNull ASTNode parentNode, @Nullable ASTNode anchorBefore, @NotNull String commentString) {
        if (parentNode == null) {
            JSChangeUtil.$$$reportNull$$$0(24);
        }
        if (commentString == null) {
            JSChangeUtil.$$$reportNull$$$0(25);
        }
        ASTNode wsNode = PsiParserFacade.SERVICE.getInstance((Project)parentNode.getPsi().getProject()).createWhiteSpaceFromText(commentString).getNode();
        parentNode.addChild(wsNode, anchorBefore);
        ASTNode aSTNode = wsNode;
        if (aSTNode == null) {
            JSChangeUtil.$$$reportNull$$$0(26);
        }
        return aSTNode;
    }

    public static boolean isStatementContainer(PsiElement jsElement) {
        return jsElement instanceof JSBlockStatement || jsElement instanceof JSEmbeddedContent || jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule;
    }

    public static boolean isSourceElementOrComment(PsiElement jsElement) {
        return jsElement instanceof JSSourceElement || jsElement instanceof PsiComment;
    }

    public static PsiElement doAddAfter(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (!JSChangeUtil.isSourceElementOrComment(element) && !(element instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddAfter(jsElement, element, anchor);
    }

    public static PsiElement doDoAddAfter(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        ASTNode parentNode = jsElement.getNode();
        ASTNode node = element.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : parentNode.getLastChildNode();
        anchorNode = JSChangeUtil.insertWhitespaceIfNeeded(anchorNode, node, parentNode, anchorNode != null ? anchorNode.getTreeNext() : null);
        ASTNode nodeCopy = node.copyElement();
        if (anchor == null) {
            parentNode.addChild(nodeCopy);
        } else {
            parentNode.addChild(nodeCopy, anchorNode.getTreeNext());
        }
        ASTNode nextAfter = nodeCopy.getTreeNext();
        JSChangeUtil.insertWhitespaceIfNeeded(nextAfter, node, parentNode, nextAfter);
        return nodeCopy.getPsi();
    }

    public static PsiElement doAddRangeBefore(PsiElement parent, PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        PsiElement resultElement;
        PsiElement psiElement = resultElement = JSChangeUtil.doAddBefore(parent, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(parent, first, psiElement);
        }
        return resultElement;
    }

    public static PsiElement doAddRangeAfter(PsiElement jsElement, PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        PsiElement resultElement;
        PsiElement psiElement = resultElement = JSChangeUtil.doAddAfter(jsElement, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(jsElement, first, psiElement);
        }
        return resultElement;
    }

    public static boolean isBlockStatementContainer(JSElement jsElement) {
        return jsElement instanceof JSIfStatement || jsElement instanceof JSLoopStatement;
    }

    public static PsiElement blockDoAddRangeBefore(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(27);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeBefore(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddRangeAfter(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(28);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeAfter(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddAfter(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(29);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addAfter(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static PsiElement blockDoAddBefore(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(30);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addBefore(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static <T extends JSSourceElement> T addSourceElement(@NotNull JSSourceElement statement, T toAdd, boolean before) throws IncorrectOperationException {
        ASTNode treeParent;
        if (statement == null) {
            JSChangeUtil.$$$reportNull$$$0(31);
        }
        if (!((treeParent = statement.getNode().getTreeParent()).getElementType() == JSElementTypes.BLOCK_STATEMENT || treeParent.getElementType() instanceof JSFileElementType || treeParent.getElementType() instanceof JSClassElementType || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(treeParent.getElementType()))) {
            if (before) {
                return (T)((JSSourceElement)treeParent.getPsi().addBefore(toAdd, (PsiElement)statement));
            }
            return (T)((JSSourceElement)treeParent.getPsi().addAfter(toAdd, (PsiElement)statement));
        }
        ASTNode copy = toAdd.getNode().copyElement();
        ASTNode anchorBefore = before ? statement.getNode() : statement.getNode().getTreeNext();
        treeParent.addChild(copy, anchorBefore);
        return (T)((JSSourceElement)copy.getPsi());
    }

    public static void addComments(@NotNull List<PsiElement> commentsAndWs, @NotNull PsiElement newElement) {
        if (commentsAndWs == null) {
            JSChangeUtil.$$$reportNull$$$0(32);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(33);
        }
        for (PsiElement element : commentsAndWs) {
            if (element instanceof PsiWhiteSpace) {
                JSChangeUtil.addWs(newElement.getParent().getNode(), newElement.getNode(), JSChangeUtil.zipNewLines(element.getText()));
                continue;
            }
            JSChangeUtil.doDoAddBeforePure(newElement.getParent(), element, newElement);
        }
    }

    private static String zipNewLines(String text) {
        boolean inNewLine = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                if (inNewLine) continue;
                sb.append(ch);
                inNewLine = true;
                continue;
            }
            sb.append(ch);
            inNewLine = false;
        }
        return sb.toString();
    }

    @NotNull
    public static String generateNewVarName(@NotNull String varNameCandidate, @NotNull PsiElement scopeElement) {
        if (varNameCandidate == null) {
            JSChangeUtil.$$$reportNull$$$0(34);
        }
        if (scopeElement == null) {
            JSChangeUtil.$$$reportNull$$$0(35);
        }
        Set<String> existingNames = JSChangeUtil.collectExistingNames(scopeElement);
        varNameCandidate = StringUtil.isEmptyOrSpaces((String)(varNameCandidate = varNameCandidate.replace('-', '_'))) || !Character.isLetter(varNameCandidate.charAt(0)) && '_' != varNameCandidate.charAt(0) ? "generated" : varNameCandidate;
        for (int i = 0; i < 1000 && existingNames.contains(varNameCandidate); ++i) {
            varNameCandidate = varNameCandidate + i;
        }
        String string = varNameCandidate;
        if (string == null) {
            JSChangeUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static Set<String> collectExistingNames(PsiElement topElement) {
        HashSet<String> names = new HashSet<String>();
        Collection elements = PsiTreeUtil.findChildrenOfType((PsiElement)topElement, JSNamedElement.class);
        for (JSNamedElement element : elements) {
            String name = element.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public static PsiElement getScopeElementInFile(@NotNull PsiElement element) {
        PsiFile topElement;
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(37);
        }
        if (!((topElement = element.getContainingFile()) instanceof JSFile)) {
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class);
            return embeddedContent != null ? embeddedContent : topElement;
        }
        return topElement;
    }

    public static String getVariablePrefix(@Nullable PsiElement context) {
        if (context == null) {
            return VAR_PREFIX;
        }
        return JSChangeUtil.getVariablePrefix(DialectDetector.dialectOfElement(context));
    }

    public static String getVariablePrefix(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS) ? LET_PREFIX : VAR_PREFIX;
    }

    public static boolean isWellKnownPredefined(@NonNls @NotNull String text) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(38);
        }
        return WELL_KNOWN.contains(text.toLowerCase());
    }

    @Nullable
    public static JSElement getFunctionBody(@NotNull JSFunction function) {
        JSBlockStatement targetBlock;
        if (function == null) {
            JSChangeUtil.$$$reportNull$$$0(39);
        }
        if ((targetBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class)) != null) {
            return targetBlock;
        }
        PsiElement child = function.getFirstChild();
        while (child != null) {
            if (!((child = PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{JSParameterList.class, JSAttributeList.class, PsiComment.class, PsiWhiteSpace.class, LeafPsiElement.class})) instanceof JSElement)) continue;
            return child instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)child).getInnerExpression() : (JSElement)child;
        }
        return null;
    }

    @NotNull
    public static JSParenthesizedExpression wrapInParentheses(@NotNull JSExpression expression) {
        if (expression == null) {
            JSChangeUtil.$$$reportNull$$$0(40);
        }
        ASTNode text = JSChangeUtil.createExpressionWithContext("(1)", (PsiElement)expression);
        assert (text != null);
        JSParenthesizedExpression brackets = (JSParenthesizedExpression)text.getPsi(JSParenthesizedExpression.class);
        JSChangeUtil.replaceExpression(brackets.getInnerExpression(), expression);
        JSParenthesizedExpression jSParenthesizedExpression = brackets;
        if (jSParenthesizedExpression == null) {
            JSChangeUtil.$$$reportNull$$$0(41);
        }
        return jSParenthesizedExpression;
    }

    public static JSFunctionExpression createArrowFunctionWithSameParameters(@NotNull Project project, @NotNull JSFunction sourceFunction, @Nullable String shortBodyText) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(42);
        }
        if (sourceFunction == null) {
            JSChangeUtil.$$$reportNull$$$0(43);
        }
        JSParameterList parameterList = sourceFunction.getParameterList();
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)sourceFunction);
        JSAttributeList attributes = sourceFunction.getAttributeList();
        String attributesModifiersText = attributes != null && !StringUtil.isEmptyOrSpaces((String)attributes.getText()) ? attributes.getText() : "";
        boolean shortParameterSyntax = parameterList != null && parameterList.getParameters().length == 1;
        String text = String.format("%s %s => %s", attributesModifiersText, shortParameterSyntax ? parameterList.getParameters()[0].getName() : "()", shortBodyText != null ? shortBodyText : "{}");
        ASTNode astNode = JSChangeUtil.createExpressionFromText(project, text, dialect);
        assert (astNode != null);
        JSFunctionExpression arrowFunction = (JSFunctionExpression)astNode.getPsi(JSFunctionExpression.class);
        if (parameterList != null && !shortParameterSyntax) {
            JSChangeUtil.replaceElement((JSElement)arrowFunction.getParameterList(), (JSElement)parameterList);
        }
        return arrowFunction;
    }

    @NotNull
    public static List<PsiComment> getCommentsInBetween(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            JSChangeUtil.$$$reportNull$$$0(44);
        }
        if (right == null) {
            JSChangeUtil.$$$reportNull$$$0(45);
        }
        SmartList comments = new SmartList();
        for (PsiElement current = left.getNextSibling(); current != null && !right.equals(current); current = current.getNextSibling()) {
            if (current instanceof PsiComment) {
                comments.add((PsiComment)current.copy());
                continue;
            }
            if (PsiTreeUtil.processElements((PsiElement)current, arg_0 -> JSChangeUtil.lambda$getCommentsInBetween$0(right, (List)comments, arg_0))) continue;
            SmartList smartList = comments;
            if (smartList == null) {
                JSChangeUtil.$$$reportNull$$$0(46);
            }
            return smartList;
        }
        SmartList smartList = comments;
        if (smartList == null) {
            JSChangeUtil.$$$reportNull$$$0(47);
        }
        return smartList;
    }

    public static void deletePartOfCommaExpression(@NotNull JSAssignmentExpression element, @NotNull Consumer<PsiComment> commentConsumer) {
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(48);
        }
        if (commentConsumer == null) {
            JSChangeUtil.$$$reportNull$$$0(49);
        }
        assert (element.getParent() instanceof JSCommaExpression);
        Consumer adapter = e -> {
            if (commentConsumer == null) {
                JSChangeUtil.$$$reportNull$$$0(71);
            }
            if (e instanceof PsiComment) {
                commentConsumer.consume((Object)((PsiComment)e));
            }
        };
        PsiElement forwardComma = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)JSTokenTypes.COMMA, (Consumer)adapter);
        PsiElement backwardComma = PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)JSTokenTypes.COMMA, (Consumer)adapter);
        if (forwardComma != null) {
            PsiElement nextNonSpace = PsiTreeUtil.skipWhitespacesForward((PsiElement)forwardComma);
            PsiElement rightBound = nextNonSpace == null ? forwardComma : nextNonSpace.getPrevSibling();
            element.getParent().deleteChildRange((PsiElement)(backwardComma != null ? backwardComma.getNextSibling() : element), rightBound);
        } else if (backwardComma != null) {
            element.getParent().deleteChildRange(backwardComma, (PsiElement)element);
        }
    }

    public static void removeRangeWithRemovalOfCommas(ASTNode myNode, ASTNode parent) {
        ASTNode from = myNode;
        ASTNode to = myNode.getTreeNext();
        boolean seenComma = false;
        if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
            to = to.getTreeNext();
        }
        if (to != null && to.getElementType() == JSTokenTypes.COMMA) {
            to = to.getTreeNext();
            seenComma = true;
            if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
                to = to.getTreeNext();
            }
        }
        if (!seenComma) {
            ASTNode treePrev = from.getTreePrev();
            if (treePrev != null && treePrev.getElementType() == JSTokenTypes.WHITE_SPACE) {
                treePrev = treePrev.getTreePrev();
            }
            if (treePrev != null && treePrev.getElementType() == JSTokenTypes.COMMA) {
                from = treePrev;
            }
            if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
                to = to.getTreeNext();
            }
        }
        parent.removeRange(from, to);
    }

    public static ASTNode createClassMemberFromText(Project project, String text, @Nullable JSLanguageDialect dialect) {
        return JSChangeUtil.createClassMemberFromText(project, text, dialect, JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS);
    }

    public static PsiElement createObjectLiteralPropertyFromText(@NotNull String text, @NotNull PsiElement context) {
        PsiElement objectLiteralPsi;
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(50);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(51);
        }
        text = "z = { " + text + " }";
        ASTNode node = JSChangeUtil.createJSTreeFromTextWithContext(text, context);
        assert (node != null && node.getPsi() instanceof JSExpressionStatement) : "\"" + text + "\" was not parsed as JSExpressionStatement";
        ASTNode assignment = node.findChildByType(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
        assert (assignment != null && assignment.getPsi() instanceof JSAssignmentExpression) : "\"" + text + "\" was not parsed as JSAssignmentExpression";
        ASTNode objectLiteral = assignment.findChildByType(JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
        PsiElement psiElement = objectLiteralPsi = objectLiteral == null ? null : objectLiteral.getPsi();
        assert (objectLiteralPsi instanceof JSObjectLiteralExpression);
        return ((JSObjectLiteralExpression)objectLiteralPsi).getProperties()[0];
    }

    public static ASTNode createClassMemberFromText(Project project, String text, @Nullable JSLanguageDialect dialect, @NotNull TokenSet classMembers) {
        if (classMembers == null) {
            JSChangeUtil.$$$reportNull$$$0(52);
        }
        text = "class Foo {" + text + "}";
        ASTNode node = JSChangeUtil.createJSTreeFromText(project, text, dialect);
        assert (node.getPsi() instanceof JSClass) : "\"" + text + "\" was not parsed as JSClass";
        return node.findChildByType(classMembers);
    }

    public static void rebindIfThereAreUsages(@NotNull PsiElement variable, @NotNull PsiElement topElement, @NotNull Convertor<Collection<PsiReference>, PsiElement> replaceCreator, @Nullable Processor<PsiReference> conversionFilter) {
        if (variable == null) {
            JSChangeUtil.$$$reportNull$$$0(53);
        }
        if (topElement == null) {
            JSChangeUtil.$$$reportNull$$$0(54);
        }
        if (replaceCreator == null) {
            JSChangeUtil.$$$reportNull$$$0(55);
        }
        Collection references = ReferencesSearch.search((PsiElement)variable, (SearchScope)GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile())).findAll();
        if ((references = ContainerUtil.filter((Collection)references, reference -> {
            if (topElement == null) {
                JSChangeUtil.$$$reportNull$$$0(70);
            }
            return reference instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)topElement, (PsiElement)((PsiElement)reference), (boolean)true);
        })).isEmpty()) {
            return;
        }
        PsiElement target = (PsiElement)replaceCreator.convert((Object)references);
        if (target == null) {
            return;
        }
        JSNamedElement replaceTarget = JSChangeUtil.correctRebindTarget(target);
        for (PsiReference ref : references) {
            if (!(ref instanceof PsiElement) || !PsiTreeUtil.isAncestor((PsiElement)topElement, (PsiElement)((PsiElement)ref), (boolean)true) || ref.getElement().getParent() == variable || conversionFilter != null && !conversionFilter.process((Object)ref)) continue;
            if (replaceTarget instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)replaceTarget).getNamespace() != null) {
                JSExpressionStatement expressionStatement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(replaceTarget.getProject(), replaceTarget.getText() + ";").getPsi(JSExpressionStatement.class);
                ((PsiElement)ref).replace((PsiElement)expressionStatement.getExpression());
                continue;
            }
            ref.bindToElement((PsiElement)replaceTarget);
        }
    }

    public static void rebindVariableUsages(@NotNull PsiElement variable, @NotNull PsiElement createdReferenceTarget, @NotNull PsiElement topElement) {
        if (variable == null) {
            JSChangeUtil.$$$reportNull$$$0(56);
        }
        if (createdReferenceTarget == null) {
            JSChangeUtil.$$$reportNull$$$0(57);
        }
        if (topElement == null) {
            JSChangeUtil.$$$reportNull$$$0(58);
        }
        JSNamedElement element = JSChangeUtil.correctRebindTarget(createdReferenceTarget);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)variable, (SearchScope)GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile())).findAll()) {
            if (!(ref instanceof PsiElement) || !PsiTreeUtil.isAncestor((PsiElement)topElement, (PsiElement)((PsiElement)ref), (boolean)true) || ref.getElement().getParent() == variable) continue;
            ref.bindToElement((PsiElement)element);
        }
    }

    private static JSNamedElement correctRebindTarget(@NotNull PsiElement createdReferenceTarget) {
        JSNamedElement element;
        if (createdReferenceTarget == null) {
            JSChangeUtil.$$$reportNull$$$0(59);
        }
        if (!(createdReferenceTarget instanceof JSNamedElement)) {
            JSVarStatement varStatement = (JSVarStatement)JSChangeUtil.createStatementFromText(createdReferenceTarget.getProject(), "var " + createdReferenceTarget.getText() + ";").getPsi(JSVarStatement.class);
            assert (varStatement != null);
            element = varStatement.getVariables()[0];
        } else {
            element = (JSNamedElement)createdReferenceTarget;
        }
        return element;
    }

    public static PsiElement deepResolve(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSChangeUtil.$$$reportNull$$$0(60);
        }
        JSReferenceExpression reference = expression;
        block0: for (int i = 0; i < 10; ++i) {
            PsiElement resolved = JSChangeUtil.insistinglyResolve(reference);
            while (resolved != null) {
                if (!((resolved = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolved)) instanceof JSInitializerOwner)) {
                    JSPsiElementBase exportedFromFile;
                    if (resolved instanceof JSFile && (exportedFromFile = JSResolveUtil.getExportedElement((JSFile)resolved)) != null) {
                        resolved = exportedFromFile;
                        continue;
                    }
                    return resolved;
                }
                JSExpression initializer = ((JSInitializerOwner)resolved).getInitializer();
                if (initializer instanceof JSReferenceExpression) {
                    reference = (JSReferenceExpression)initializer;
                    continue block0;
                }
                return initializer;
            }
        }
        return null;
    }

    @NotNull
    public static PsiElement createTokenElement(@NotNull PsiElement context, @NotNull IElementType tokenType, @NotNull CharSequence text) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(61);
        }
        if (tokenType == null) {
            JSChangeUtil.$$$reportNull$$$0(62);
        }
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(63);
        }
        LeafElement leaf = ASTFactory.leaf((IElementType)tokenType, (CharSequence)text);
        FileElement holder = DummyHolderFactory.createHolder((PsiManager)context.getManager(), (PsiElement)context).getTreeElement();
        holder.rawAddChildren((TreeElement)leaf);
        PsiElement psi = leaf.getPsi();
        assert (psi != null);
        PsiElement psiElement = psi;
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(64);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement insistinglyResolve(JSReferenceExpression expression) {
        ResolveResult[] results;
        PsiElement resolved = expression.resolve();
        if (resolved == null && (results = expression.multiResolve(false)).length == 1) {
            String problemKey;
            ResolveResult result2 = results[0];
            if (result2.getElement() == null) {
                return null;
            }
            if (result2 instanceof JSResolveResult && ("javascript.element.need.to.be.imported".equals(problemKey = ((JSResolveResult)result2).getResolveProblemKey()) || "javascript.element.need.to.be.exported".equals(problemKey))) {
                return result2.getElement();
            }
            if (result2.isValidResult()) {
                return result2.getElement();
            }
        }
        return resolved;
    }

    public static <T extends PsiElement> T createStatementSafe(@NotNull Project project, @NotNull String text, @NotNull Class<T> clazz) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(65);
        }
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(66);
        }
        if (clazz == null) {
            JSChangeUtil.$$$reportNull$$$0(67);
        }
        ASTNode ast = JSChangeUtil.createStatementFromText(project, text);
        assert (ast != null);
        return (T)ast.getPsi(clazz);
    }

    public static PsiElement getMeaningfulElementAtCaret(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiElement at;
        if (file == null) {
            JSChangeUtil.$$$reportNull$$$0(68);
        }
        if (editor == null) {
            JSChangeUtil.$$$reportNull$$$0(69);
        }
        if ((at = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        Condition spaceOrComment = el -> el instanceof PsiWhiteSpace || el instanceof PsiComment;
        if (spaceOrComment.value((Object)at)) {
            at = PsiTreeUtil.findFirstParent((PsiElement)at, (Condition)Conditions.not((Condition)spaceOrComment));
        }
        return at;
    }

    private static /* synthetic */ boolean lambda$getCommentsInBetween$0(@NotNull PsiElement right, List comments, PsiElement element) {
        if (right == null) {
            JSChangeUtil.$$$reportNull$$$0(72);
        }
        if (element.equals(right)) {
            return false;
        }
        if (element instanceof PsiComment) {
            comments.add((PsiComment)element);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 26: 
            case 36: 
            case 41: 
            case 46: 
            case 47: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 26: 
            case 36: 
            case 41: 
            case 46: 
            case 47: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameNode";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 51: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 8: 
            case 38: 
            case 50: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 13: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 42: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 18: 
            case 26: 
            case 36: 
            case 41: 
            case 46: 
            case 47: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSChangeUtil";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 21: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentString";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsAndWs";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNameCandidate";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFunction";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 45: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 49: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentConsumer";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembers";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 54: 
            case 58: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCreator";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdReferenceTarget";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSChangeUtil";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommaPsiElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addWs";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewVarName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInParentheses";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsInBetween";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNameIdentifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyNameWithContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionPsiWithContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionWithContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateExpressionInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateExpressionWithContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createVarStatement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStatementPsiFromTextWithContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createClassMemberPsiFromTextWithContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromTextWithContext";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCommaPsiElement";
                break;
            }
            case 16: 
            case 18: 
            case 26: 
            case 36: 
            case 41: 
            case 46: 
            case 47: 
            case 64: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createJSTreeFromTextWithContext";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addWs";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddRangeBefore";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddRangeAfter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddAfter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddBefore";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addSourceElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addComments";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateNewVarName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getScopeElementInFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isWellKnownPredefined";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionBody";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "wrapInParentheses";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createArrowFunctionWithSameParameters";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsInBetween";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "deletePartOfCommaExpression";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createObjectLiteralPropertyFromText";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createClassMemberFromText";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "rebindIfThereAreUsages";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "rebindVariableUsages";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "correctRebindTarget";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "deepResolve";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createTokenElement";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createStatementSafe";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulElementAtCaret";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rebindIfThereAreUsages$2";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deletePartOfCommaExpression$1";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCommentsInBetween$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 26: 
            case 36: 
            case 41: 
            case 46: 
            case 47: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class BlockAddContext {
        final JSBlockStatement newlyAddedBlock;
        final PsiElement codeBlockAnchor;

        BlockAddContext(@NotNull PsiElement _anchor) throws IncorrectOperationException {
            if (_anchor == null) {
                BlockAddContext.$$$reportNull$$$0(0);
            }
            ASTNode codeBlockNode = JSChangeUtil.createStatementFromText(_anchor.getProject(), "{ a }");
            this.newlyAddedBlock = (JSBlockStatement)_anchor.replace(codeBlockNode.getPsi());
            JSStatement artificiallyAddedBlockAnchor = this.newlyAddedBlock.getStatements()[0];
            CodeEditUtil.replaceChild((ASTNode)this.newlyAddedBlock.getNode(), (ASTNode)artificiallyAddedBlockAnchor.getNode(), (ASTNode)_anchor.getNode());
            this.codeBlockAnchor = _anchor;
        }

        abstract PsiElement doAddElement(PsiElement ... var1) throws IncorrectOperationException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil$BlockAddContext", "<init>"));
        }
    }
}

