/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.FindReferenceUtil;
import com.intellij.lang.javascript.psi.impl.JSNewExpressionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NonNls;

public class JSFunctionVisitor
extends JSElementVisitor {
    private static final Logger logger = Logger.getInstance((String)JSFunctionVisitor.class.getName());

    public void visitElement(PsiElement element) {
        if (element instanceof JSFunction) {
            this.visitJSFunctionDeclaration((JSFunction)element);
        } else if (element instanceof JSReferenceExpression) {
            PsiElement firstChild;
            if (element == element.getParent().getChildren()[0] && (firstChild = element.getParent().getFirstChild()) != null && firstChild.toString().indexOf(JSTokenTypes.NEW_KEYWORD.toString()) >= 0) {
                this.visitJSNewExpression(new JSNewExpressionImpl(element.getParent().getNode()));
            }
        } else if (element instanceof XmlFile) {
            this.processFile((XmlFile)element);
        }
        super.visitElement(element);
        for (PsiElement childElement : element.getChildren()) {
            childElement.accept((PsiElementVisitor)this);
        }
    }

    public void visitJSNewExpression(JSNewExpression newExpression) {
    }

    private void processFile(XmlFile file) {
        int count = 0;
        long start = System.currentTimeMillis();
        for (JSElement element : JSFunctionVisitor.getEmbeddedJSElements(file)) {
            this.visitElement((PsiElement)element);
            ++count;
        }
        logger.info("Processed inspection " + ((Object)((Object)this)).getClass().getSimpleName() + " on file " + file.getName() + " (" + count + " blocks) in " + (System.currentTimeMillis() - start) + " ms.");
    }

    static Iterable<JSElement> getEmbeddedJSElements(final XmlFile file) {
        return new Iterable<JSElement>(){

            @Override
            public Iterator<JSElement> iterator() {
                return new EmbeddedJSElementIterator(file);
            }
        };
    }

    private static class EmbeddedJSElementIterator
    implements Iterator<JSElement> {
        @NonNls
        private static final String SCRIPT_START = "<SCRIPT";
        @NonNls
        private static final String SCRIPT_END = "</SCRIPT>";
        @NonNls
        private static final String HTML_TAG_END = ">";
        final XmlFile file;
        final String fileText;
        int scriptStartIndex;
        int scriptEndIndex;
        JSElement next;

        public EmbeddedJSElementIterator(XmlFile file) {
            this.file = file;
            this.fileText = file.getText();
            this.scriptEndIndex = -SCRIPT_END.length();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public JSElement next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            JSElement next = this.next;
            this.findNext();
            return next;
        }

        private void findNext() {
            if (this.next != null && !(this.next instanceof JSEmbeddedContent)) {
                this.next = (JSElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.next, JSElement.class);
                if (this.next != null) {
                    return;
                }
            }
            do {
                if (this.scriptStartIndex >= 0) {
                    this.scriptStartIndex = this.fileText.indexOf(SCRIPT_START, this.scriptEndIndex + SCRIPT_END.length());
                }
                if (this.scriptStartIndex < 0) {
                    this.next = null;
                    return;
                }
                int offset = this.scriptStartIndex >= 0 ? this.fileText.indexOf(HTML_TAG_END, this.scriptStartIndex + SCRIPT_START.length()) + 1 : 0;
                int n = this.scriptEndIndex = offset > 0 ? this.fileText.indexOf(SCRIPT_END, offset) : -1;
                if (this.scriptEndIndex < 0) {
                    this.scriptStartIndex = -1;
                    return;
                }
                PsiElement psiElement = this.file.findElementAt(offset);
                if (psiElement instanceof PsiWhiteSpace) {
                    psiElement = PsiTreeUtil.getNextSiblingOfType((PsiElement)psiElement, JSElement.class);
                }
                if (!(psiElement instanceof JSElement)) continue;
                this.next = FindReferenceUtil.getFarthestAncestor(psiElement, JSElement.class);
            } while (this.next == null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

