/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericParameterApplierImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypesEvaluator {
    private static JSGenericTypesEvaluator INSTANCE = new JSGenericTypesEvaluator();
    public static final JSGenericTypesEvaluator NO_OP = new JSGenericTypesEvaluator(){

        @Override
        @Nullable
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter, int paramToSkip) {
            return type;
        }

        @Override
        @NotNull
        public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, JSExpression methodExpression) {
            if (type == null) {
                1.$$$reportNull$$$0(0);
            }
            if (qualifier == null) {
                1.$$$reportNull$$$0(1);
            }
            JSType jSType = type;
            if (jSType == null) {
                1.$$$reportNull$$$0(2);
            }
            return jSType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateGenericsFromQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final Key<MultiMap<String, JSType>> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");
    public static final Key<Boolean> ourSuspendGenericEvaluation = Key.create((String)"generic.suspend.evaluation");

    protected JSGenericTypesEvaluator() {
    }

    public static JSGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, -1);
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, int paramToSkip) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, null, paramToSkip);
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, reporter, -1);
    }

    @Nullable
    @Contract(value="!null, _, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        JSExpression qualifier;
        JSFunctionItem functionItem;
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression)) != null) {
            resolvedFunction = functionItem;
        }
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            type = this.evaluateGenericsFromQualifier(type, qualifier, (JSExpression)((JSReferenceExpression)methodExpression));
        }
        if (methodExpression != null && resolvedFunction != null) {
            if (methodExpression.getParent() instanceof JSCallExpression) {
                JSTypeSubstitutor substitutor = this.inferGenericTypesForCall(resolvedFunction, (JSCallExpression)methodExpression.getParent(), reporter, paramToSkip);
                type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor, reporter);
            }
            if (methodExpression.getParent() instanceof ES6TaggedTemplateExpression) {
                ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)methodExpression.getParent();
                JSTypeSubstitutor substitutor = this.inferGenericTypesForTaggedTemplateCall(resolvedFunction, taggedTemplate, reporter, paramToSkip);
                type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor, reporter);
            }
        }
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            type = this.evaluateGenericsFromQualifier(type, qualifier, (JSExpression)((JSReferenceExpression)methodExpression));
        }
        return type;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallExpression expression) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (JSTypeUtils.hasTypeArguments(expression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.getSubstitutorForDefaultParameters(typeParametersOwner);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(5);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(6);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSType type = JSGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            substitutor.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSAnyType.get((PsiElement)parameter, true) : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)defaultType);
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        return !(type instanceof JSAnyType) && !(type instanceof JSSpecialNamedTypeImpl) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSVoidType);
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(resolvedFunction, callExpression, reporter, -1);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll((Map)JSGenericTypesEvaluator.getDefaultTypeSubstitutor(resolvedFunction, callExpression));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSExpression[] arguments = callExpression.getArguments();
            List<JSType> parameterTypes = JSGenericTypesEvaluator.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 0, arguments.length);
            MultiMap<String, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, paramToSkip, resolvedFunction);
            result2.putAll((Map)JSGenericTypesEvaluator.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor inferGenericTypesForTaggedTemplateCall(@NotNull PsiElement resolvedFunction, @NotNull ES6TaggedTemplateExpression template, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        if (template == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll((Map)JSGenericTypesEvaluator.getSubstitutorForDefaultParameters(resolvedFunction));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSStringTemplateExpression templateExpression = template.getTemplateExpression();
            JSExpression[] arguments = templateExpression != null ? templateExpression.getArguments() : JSExpression.EMPTY_ARRAY;
            List<JSType> parameterTypes = JSGenericTypesEvaluator.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 1, arguments.length);
            int callArgumentToSkip = paramToSkip - 1;
            MultiMap<String, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, callArgumentToSkip, resolvedFunction);
            result2.putAll((Map)JSGenericTypesEvaluator.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull JSParameterItem[] parameters, int formalParametersToSkip, int argumentsLength) {
        int i;
        if (parameters == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        List parameterTypes = ContainerUtil.newSmartList();
        JSType restParameterType = null;
        for (i = 0; i < parameters.length; ++i) {
            if (i < formalParametersToSkip) continue;
            JSParameterItem parameter = parameters[i];
            JSType parameterType = parameter.getType();
            parameterTypes.add(parameterType);
            if (!parameter.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        List list = parameterTypes;
        if (list == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(MultiMap<String, JSType> map, @NotNull PsiElement context, @Nullable GenericErrorReporter reporter) {
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        JSTypeSubstitutor result2 = JSGenericTypesEvaluator.intersectGenerics(map, context, reporter);
        for (Map.Entry entry : map.entrySet()) {
            Collection types;
            String key = (String)entry.getKey();
            if (!result2.containsKey((Object)key) || (types = (Collection)entry.getValue()) == null || !types.stream().allMatch(t -> t instanceof JSLiteralType)) continue;
            result2.put((Object)key, (Object)new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), ContainerUtil.newArrayList((Iterable)types)));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutor intersectGenerics(MultiMap<String, JSType> map, @Nullable PsiElement context, @Nullable GenericErrorReporter reporter) {
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        ProcessingContext processingContext = context == null ? null : JSTypeComparingCacheService.getProcessingContextWithCache(context);
        for (Map.Entry entry : map.entrySet()) {
            JSType type;
            Collection value = (Collection)entry.getValue();
            assert (value.size() > 0);
            if (value.size() == 1) {
                result2.put(entry.getKey(), ContainerUtil.getFirstItem((Collection)value));
                continue;
            }
            Collection types = (Collection)entry.getValue();
            boolean hasImplicitly = false;
            for (JSType type2 : types) {
                if (type2 != null && type2.getSource().isStrict()) continue;
                hasImplicitly = true;
                break;
            }
            if ((type = JSGenericTypesEvaluator.intersectTypes(types, processingContext)) != null) {
                result2.put(entry.getKey(), (Object)type);
                continue;
            }
            if (reporter != null && hasImplicitly) continue;
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    private static JSType intersectTypes(@NotNull Collection<JSType> types, @Nullable ProcessingContext context) {
        if (types == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        List typesForSearch = ContainerUtil.skipNulls((Collection)ContainerUtil.newArrayList(types));
        JSType firstNamed = null;
        for (JSType type : types) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isStrict()) continue;
            boolean result2 = true;
            for (JSType jsType : typesForSearch) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, context)) continue;
                result2 = false;
                break;
            }
            if (!result2) continue;
            return type;
        }
        return null;
    }

    @NotNull
    protected MultiMap<String, JSType> inferGenericArgumentsFromCall(List<JSType> parameterTypes, JSExpression[] arguments, int callArgumentToSkip, PsiElement resolvedFunction) {
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.length; ++i) {
            if (i == callArgumentToSkip) continue;
            if (i >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(i);
            if (paramType instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSExpression argument = arguments[i];
            JSType exprType = TypeScriptGenericTypesEvaluator.getParameterExpressionType(argument);
            if (exprType != null && exprType.getSource().isTypeScript()) {
                exprType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(argument, exprType);
            }
            JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType, resolvedFunction);
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        return multiMap;
    }

    protected static MultiMap<String, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType, null);
        return genericArguments;
    }

    protected static void matchGenericTypes(@NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @Nullable PsiElement invokedElement) {
        if (processingContext == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        if (paramType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        JSType returnType = null;
        if (invokedElement instanceof JSFunctionItem) {
            returnType = ((JSFunctionItem)invokedElement).getReturnType();
        }
        List<JSGenericParameterImpl> topLevelParamGenerics = JSGenericTypesEvaluator.getTopLevelGenerics(paramType);
        List<JSGenericParameterImpl> topLevelReturnGenerics = JSGenericTypesEvaluator.getTopLevelGenerics(returnType);
        paramType = JSTypeUtils.applyCompositeMapping(paramType, (Function<JSType, JSType>)((Function)type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)((Object)type);
            return new JSGenericParameterApplierImpl(genericParameter, topLevelParamGenerics.stream().anyMatch(p -> p.isEquivalentTo(genericParameter, null)) && topLevelReturnGenerics.stream().noneMatch(p -> p.isEquivalentTo(genericParameter, null)));
        }));
        paramType.isDirectlyAssignableType(exprType, processingContext);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        ArrayList topLevelGenerics = ContainerUtil.newArrayList();
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (t instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)((Object)t));
            }
            return true;
        }), paramType);
        ArrayList arrayList = topLevelGenerics;
        if (arrayList == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, JSExpression methodExpression) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                List<String> genericParameters = javaScriptGenericParameters;
                type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
                    if (type1 instanceof JSTypeImpl && genericParameters.contains(type1.getTypeText())) {
                        return new JSGenericParameterImpl(type1.getTypeText(), type1.getSource());
                    }
                    return type1;
                }));
            }
        }
        if (javaScriptGenericParameters != null && JSTypeUtils.hasGenericParameter(type) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(34);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(35);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(36);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(37);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(43);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
            typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(44);
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getTypeArgumentsMap(JSType genericType, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            return JSTypeSubstitutor.EMPTY;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
        }
        return typeArguments;
    }

    @Contract(value="null -> false")
    public static boolean isGenericProcessingInProgress(@Nullable ProcessingContext context) {
        return context != null && context.get(ourGenericArgumentsMapKey) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GenericErrorReporter {
        public void error(String var1);
    }
}

