/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new JSTypeHelper();

    protected JSTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(1);
        }
        final String lOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(lOpType, true);
        String rOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true);
        if (lOpQualifiedName == null || rOpQualifiedName == null) {
            return lOpQualifiedName == rOpQualifiedName;
        }
        PsiFile context = rOpType.getSource().getScope();
        if ("Iterable".equals(lOpQualifiedName) && JSTypeHelper.isBuiltInIterable(rOpQualifiedName)) {
            return true;
        }
        if (context == null) {
            return lOpQualifiedName.equals(rOpQualifiedName);
        }
        if (JSInheritanceUtil.isParentClass(lOpQualifiedName, rOpQualifiedName, (PsiElement)context)) {
            return true;
        }
        boolean result2 = JSTypeEvaluateManager.iterateTypeHierarchy((PsiElement)context, rOpQualifiedName, new JSTypeEvaluateManager.NamespaceProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean process(String serializedType, VirtualFile file) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                if (this.visited.add(qName)) {
                    return !lOpQualifiedName.equals(qName);
                }
                return true;
            }
        });
        return !result2;
    }

    private static boolean isBuiltInIterable(String rOpQualifiedName) {
        return "Set".equals(rOpQualifiedName) || "WeakSet".equals(rOpQualifiedName) || "Array".equals(rOpQualifiedName);
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        JSGenericParameterImpl genericParameter;
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(2);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(3);
        }
        if ((rOpType instanceof JSPrimitiveFunctionType || rOpType instanceof JSFunctionTypeImpl) && lOpType.inheritsFunction()) {
            return true;
        }
        if (rOpType instanceof JSNamedType) {
            return this.areNamedTypesAssignable(lOpType, (JSNamedType)rOpType, processingContext);
        }
        if (rOpType instanceof JSGenericTypeImpl) {
            return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
        }
        if (rOpType instanceof JSNullType) {
            return true;
        }
        if (rOpType instanceof JSArrayTypeImpl) {
            return this.isAssignableToNamedType(lOpType, ((JSArrayTypeImpl)rOpType).asGenericType(), processingContext);
        }
        if (rOpType instanceof JSRecordType) {
            return this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext).isAssignable();
        }
        if (rOpType instanceof JSGenericParameterImpl && (genericParameter = (JSGenericParameterImpl)rOpType).getConstraintType() != null) {
            return lOpType.isDirectlyAssignableType(genericParameter, processingContext);
        }
        return false;
    }

    protected JSTypeCastUtil.AssignableResult substituteLeftTypeAndCheckAssignable(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        JSRecordType lOpResolvedType;
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(4);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(5);
        }
        if (lOpType.isJavaScript() && !lOpType.isStrict()) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        Object object = lOpResolvedType = lOpType.isJavaScript() ? lOpType.asRecordType() : lOpType.substitute();
        if (lOpResolvedType == JSTypeCastUtil.NO_RECORD_TYPE) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(lOpType, rOpType, processingContext, arg_0 -> JSTypeHelper.lambda$substituteLeftTypeAndCheckAssignable$0((JSType)lOpResolvedType, lOpType, rOpType, arg_0), JSTypeCastUtil.toStrictAssignable(true));
    }

    private static /* synthetic */ JSTypeCastUtil.AssignableResult lambda$substituteLeftTypeAndCheckAssignable$0(JSType lOpResolvedType, @NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, ProcessingContext ctx) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(6);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(7);
        }
        if (lOpResolvedType != lOpType) {
            return JSTypeCastUtil.toStrictAssignable(lOpResolvedType.isDirectlyAssignableType(rOpType, ctx));
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areNamedTypesAssignable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignableToNamedType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteLeftTypeAndCheckAssignable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$substituteLeftTypeAndCheckAssignable$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

