/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeInfo {
    private static JSContextLevel GLOBAL_CONTEXT_LEVEL = new JSContextLevel(new JSNamespaceImpl(null, JSContext.UNKNOWN, true), 0);
    private static int MAX_POSSIBLE_RELATIVE_LEVEL = 30;
    @NotNull
    public final List<JSContextLevel> myContextLevels = new ArrayList<JSContextLevel>();
    @Nullable
    public Collection<JSRecordType> myRecordTypes;
    private boolean myTypeWasProcessed;
    @NotNull
    private GlobalStatusHint myContextGlobalStatusHint = GlobalStatusHint.UNKNOWN;
    private boolean myForcedUnknownContext;

    protected void addType(String[] qualifiedTypeNameComponents) {
        this.addType(qualifiedTypeNameComponents, false, JSContext.UNKNOWN, true);
    }

    protected void addType(String[] qualifiedTypeNameComponents, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (qualifiedTypeNameComponents.length == 0) {
            return;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromComponents(Arrays.asList(qualifiedTypeNameComponents));
        this.addType(new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared), isTopClassInHierarchy);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(0);
        }
        this.addType(namespace, isTopClassInHierarchy, null);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiElement localScope) {
        JSQualifiedName qualifiedName;
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(1);
        }
        if ((qualifiedName = namespace.getQualifiedName()) == null && !namespace.isExplicitlyDeclared()) {
            return;
        }
        if (qualifiedName == null) {
            if (localScope == null) {
                this.addGlobalType();
            }
            return;
        }
        int relativeLevel = this.getRelativeLevel(isTopClassInHierarchy, qualifiedName);
        this.myContextLevels.add(new JSContextLevel(namespace, relativeLevel, localScope));
    }

    private int getRelativeLevel(boolean isTopClassInHierarchy, @NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            JSTypeInfo.$$$reportNull$$$0(2);
        }
        if (qualifiedName.getParent() == null && "Object".equals(qualifiedName.getName())) {
            return MAX_POSSIBLE_RELATIVE_LEVEL;
        }
        if (qualifiedName.getParent() == null && "Function".equals(qualifiedName.getName())) {
            return MAX_POSSIBLE_RELATIVE_LEVEL - 1;
        }
        return isTopClassInHierarchy || this.myContextLevels.isEmpty() ? 0 : this.myContextLevels.get((int)(this.myContextLevels.size() - 1)).myRelativeLevel + 1;
    }

    public void addGlobalType() {
        this.myContextLevels.add(GLOBAL_CONTEXT_LEVEL);
    }

    public void addBaseObjectType() {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Object", null);
        JSNamespaceImpl namespace = new JSNamespaceImpl(name, JSContext.INSTANCE, false);
        this.myContextLevels.add(new JSContextLevel(namespace, MAX_POSSIBLE_RELATIVE_LEVEL));
    }

    public boolean isEmpty() {
        return this.myContextLevels.isEmpty();
    }

    public void setTypeWasProcessed() {
        this.myTypeWasProcessed = true;
    }

    public boolean typeWasProcessed() {
        return !this.myContextLevels.isEmpty() || this.myTypeWasProcessed;
    }

    public boolean hasExplicitNamespace() {
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (contextLevel.myRelativeLevel != 0 || !contextLevel.myNamespace.isExplicitlyDeclared()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchedNamespace(@Nullable JSQualifiedName namespace, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSTypeInfo.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            return this.myContextLevels.size() == 0 || this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
        }
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (!ComparatorUtil.equalsNullable((Object)namespace, (Object)contextLevel.myNamespace.getQualifiedName()) || !jsContext.isCompatibleWith(contextLevel.myNamespace.getJSContext())) continue;
            return true;
        }
        return false;
    }

    public void addRecordType(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeInfo.$$$reportNull$$$0(4);
        }
        if (this.myRecordTypes == null) {
            this.myRecordTypes = new SmartList();
        }
        this.myRecordTypes.add(recordType);
    }

    public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiElement localScope) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(5);
        }
        this.addType(namespace, isTopClassInHierarchy, localScope);
    }

    public final void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(6);
        }
        this.addNamespace(namespace, isTopClassInHierarchy, null);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared, @Nullable PsiFile jsModule) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(7);
        }
        JSQualifiedNameImpl qualifiedName = StringUtil.isQuotedString((String)type) ? JSQualifiedNameImpl.create(type, null) : JSQualifiedNameImpl.fromNamepath(type);
        JSNamespaceImpl namespace = new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared);
        this.addNamespace(namespace, isTopClassInHierarchy, (PsiElement)jsModule);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(8);
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, isExplicitlyDeclared, null);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(9);
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, true);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(10);
        }
        this.buildIndexListFromQNameAndCorrectQName(type, false, JSContext.UNKNOWN);
    }

    final void addAllParentScopes(@NotNull String qName) {
        if (qName == null) {
            JSTypeInfo.$$$reportNull$$$0(11);
        }
        int lastIndexOfDot = qName.length();
        while (lastIndexOfDot > 0) {
            qName = qName.substring(0, lastIndexOfDot);
            this.buildIndexListFromQNameAndCorrectQName(qName);
            lastIndexOfDot = qName.lastIndexOf(".");
        }
        this.addGlobalType();
    }

    public boolean isGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
    }

    public boolean isNonGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.NONGLOBAL;
    }

    @NotNull
    private GlobalStatusHint getGlobalStatusHint() {
        if (this.myForcedUnknownContext) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(12);
            }
            return globalStatusHint;
        }
        boolean onlyGlobal = true;
        boolean onlyNonGlobal = true;
        boolean hasGlobal = false;
        boolean hasNonGlobal = false;
        boolean topLevelIsGlobal = false;
        for (JSContextLevel level : this.myContextLevels) {
            GlobalStatusHint contextLevelHint = JSTypeInfo.getContextLevelGlobalStatusHint(level);
            onlyGlobal &= contextLevelHint == GlobalStatusHint.GLOBAL || topLevelIsGlobal && level.myRelativeLevel > 0;
            onlyNonGlobal &= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            hasGlobal |= contextLevelHint == GlobalStatusHint.GLOBAL;
            hasNonGlobal |= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            if (level.myRelativeLevel != 0) continue;
            topLevelIsGlobal = contextLevelHint == GlobalStatusHint.GLOBAL;
        }
        if (onlyGlobal && (hasGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.GLOBAL)) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(13);
            }
            return globalStatusHint;
        }
        if (hasNonGlobal && onlyNonGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.NONGLOBAL && !hasGlobal) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(14);
            }
            return globalStatusHint;
        }
        GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(15);
        }
        return globalStatusHint;
    }

    @NotNull
    public GlobalStatusHint getContextGlobalStatusHint() {
        GlobalStatusHint globalStatusHint = this.myContextGlobalStatusHint;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(16);
        }
        return globalStatusHint;
    }

    private static GlobalStatusHint getContextLevelGlobalStatusHint(@NotNull JSContextLevel level) {
        if (level == null) {
            JSTypeInfo.$$$reportNull$$$0(17);
        }
        if (level == GLOBAL_CONTEXT_LEVEL) {
            return GlobalStatusHint.GLOBAL;
        }
        JSQualifiedName qName = level.myNamespace.getQualifiedName();
        if (qName != null) {
            if (qName.getParent() == null && BaseJSSymbolProcessor.isNamedGlobalType(qName.getName(), level.myNamespace.getJSContext())) {
                return GlobalStatusHint.GLOBAL;
            }
            return GlobalStatusHint.NONGLOBAL;
        }
        return GlobalStatusHint.UNKNOWN;
    }

    public void setContextGlobalStatusHint(@NotNull GlobalStatusHint contextGlobalStatusHint) {
        if (contextGlobalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(18);
        }
        this.myContextGlobalStatusHint = contextGlobalStatusHint;
        if (contextGlobalStatusHint == GlobalStatusHint.GLOBAL) {
            this.addGlobalType();
        }
    }

    public void setForcedUnknownContext() {
        this.myForcedUnknownContext = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextGlobalStatusHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalStatusHint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextGlobalStatusHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLevel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchedNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRecordType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildIndexListFromQNameAndCorrectQName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAllParentScopes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContextLevelGlobalStatusHint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setContextGlobalStatusHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum GlobalStatusHint {
        GLOBAL,
        NONGLOBAL,
        UNKNOWN;

    }
}

