/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.NullableEnumStructureElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedData {
    private static final EnumStructureElement<JSFile.ModuleStatus> MODULE_STATUS_FLAG = new EnumStructureElement<JSFile.ModuleStatus>(JSFile.ModuleStatus.class);
    private static final NullableEnumStructureElement<JSTestFileType> TEST_FILE_FLAG = new NullableEnumStructureElement<JSTestFileType>(JSTestFileType.class);
    private static final BooleanStructureElement HAS_ES6_SYNTAX_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REFERENCES_IMPORT_IN_DEFAULT_EXPORT = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(MODULE_STATUS_FLAG, TEST_FILE_FLAG, HAS_ES6_SYNTAX_FLAG, REFERENCES_IMPORT_IN_DEFAULT_EXPORT);
    private byte myFlags;
    private Set<String> myReferencedPaths;
    @Nullable
    private StringRef myExportsInnerAlias;

    public void applyModuleStatus(@NotNull JSFile.ModuleStatus moduleStatus) {
        JSFile.ModuleStatus prevModuleStatus;
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(0);
        }
        if ((prevModuleStatus = this.getModuleStatus()) == JSFile.ModuleStatus.ES6 || prevModuleStatus == JSFile.ModuleStatus.COMMONJS && moduleStatus == JSFile.ModuleStatus.MAYBE_COMMONJS) {
            return;
        }
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, moduleStatus, this.myFlags);
    }

    public void setTestFileType(@Nullable JSTestFileType testFileType) {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, testFileType, this.myFlags);
    }

    public void setHasES6Syntax() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, true, this.myFlags);
    }

    public void setReferencedPaths(Set<String> referencedPaths) {
        this.myReferencedPaths = referencedPaths;
    }

    @NotNull
    public JSFile.ModuleStatus getModuleStatus() {
        JSFile.ModuleStatus moduleStatus = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, this.myFlags);
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(1);
        }
        return moduleStatus;
    }

    @Nullable
    public JSTestFileType getTestFileType() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, this.myFlags);
    }

    public boolean hasES6Syntax() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, this.myFlags);
    }

    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> set = this.myReferencedPaths != null ? this.myReferencedPaths : Collections.emptySet();
        if (set == null) {
            JSFileCachedData.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void addReferencedPath(String filePath) {
        if (this.myReferencedPaths == null) {
            this.myReferencedPaths = new THashSet();
        }
        this.myReferencedPaths.add(filePath);
    }

    @Nullable
    public String getExportsInnerAlias() {
        return StringRef.toString((StringRef)this.myExportsInnerAlias);
    }

    public void setExportsInnerAlias(@Nullable JSType exportsInnerAlias) {
        this.myExportsInnerAlias = exportsInnerAlias != null ? StringRef.fromString((String)exportsInnerAlias.getTypeText(JSType.TypeTextFormat.SERIALIZED)) : null;
    }

    public boolean referencesImportInDefaultExport() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, REFERENCES_IMPORT_IN_DEFAULT_EXPORT, this.myFlags);
    }

    public void setReferencesImportInDefaultExport() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, REFERENCES_IMPORT_IN_DEFAULT_EXPORT, true, this.myFlags);
    }

    public void serialize(@NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(3);
        }
        dataStream.writeByte((int)this.myFlags);
        Set<String> referencedPaths = this.getReferencedPaths();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)referencedPaths.size());
        for (String referencedFile : referencedPaths) {
            dataStream.writeUTFFast(referencedFile);
        }
        dataStream.writeName(StringRef.toString((StringRef)this.myExportsInnerAlias));
    }

    public static JSFileCachedData deserialize(StubInputStream dataStream) throws IOException {
        JSFileCachedData cachedData = new JSFileCachedData();
        cachedData.myFlags = dataStream.readByte();
        int referencedFilesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        THashSet referencedPaths = new THashSet(referencedFilesCount);
        for (int i = 0; i < referencedFilesCount; ++i) {
            String referencedFile = dataStream.readUTFFast();
            referencedPaths.add(referencedFile);
        }
        cachedData.setReferencedPaths((Set<String>)referencedPaths);
        cachedData.myExportsInnerAlias = dataStream.readName();
        return cachedData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyModuleStatus";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

