/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayTypeImpl
extends JSTypeBaseImpl
implements JSArrayType,
JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @Nullable
    private JSGenericTypeImpl myNamedArray;

    @Override
    @NotNull
    public JSGenericTypeImpl asGenericType() {
        if (this.myNamedArray != null) {
            JSGenericTypeImpl jSGenericTypeImpl = this.myNamedArray;
            if (jSGenericTypeImpl == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(0);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = this.myNamedArray = JSArrayType.GenericArrayBuilder.getGenericType(this, this.myType);
        if (jSGenericTypeImpl == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(1);
        }
        return jSGenericTypeImpl;
    }

    public JSArrayTypeImpl(@Nullable JSType type, @NotNull JSTypeSource typeSource) {
        if (typeSource == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource);
        this.myType = type != null ? type : JSAnyType.get((PsiElement)typeSource.getScope(), false);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            if ("Array" == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(3);
            }
            return "Array";
        }
        boolean wrapInBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
        StringBuilder builder = new StringBuilder();
        if (wrapInBrackets) {
            builder.append("(");
        }
        builder.append(this.myType.getTypeText(format));
        if (wrapInBrackets) {
            builder.append(")");
        }
        builder.append("[]");
        String string = builder.toString();
        if (string == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getTypeId() {
        String string = "#array#" + this.myType.getTypeId();
        if (string == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType("Array", (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(6);
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.myType.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).getType(), processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)elementType;
            if (JSArrayTypeImpl.isGenericArray(genericType)) {
                return this.myType.isDirectlyAssignableType(genericType.getArguments().get(0), processingContext);
            }
            return this.asGenericType().isDirectlyAssignableType(elementType, processingContext);
        }
        if (elementType instanceof JSPrimitiveArrayType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(7);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(8);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.asGenericType().isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(9);
        }
        return assignableResult3;
    }

    public static boolean isGenericArray(JSGenericTypeImpl genericType) {
        return genericType.getType() instanceof JSPrimitiveArrayType && genericType.getArguments().size() == 1;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(10);
        }
        if (type instanceof JSArrayTypeImpl && this.myType.isEquivalentTo(((JSArrayTypeImpl)type).getType(), processingContext, allowResolve)) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            if (JSArrayTypeImpl.isGenericArray((JSGenericTypeImpl)type)) {
                return this.myType.isEquivalentTo(((JSGenericTypeImpl)type).getArguments().get(0), processingContext, allowResolve);
            }
            return this.asGenericType().isEquivalentTo(type, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newComponentType;
        JSType oldComponentType;
        if (childTransform == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(12);
        }
        if ((oldComponentType = this.getType()) == (newComponentType = JSTypeUtils.transformTypeHierarchySafe(oldComponentType, childTransform))) {
            JSArrayTypeImpl jSArrayTypeImpl = this;
            if (jSArrayTypeImpl == null) {
                JSArrayTypeImpl.$$$reportNull$$$0(13);
            }
            return jSArrayTypeImpl;
        }
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(newComponentType, this.getSource());
        if (jSArrayTypeImpl == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(14);
        }
        return jSArrayTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(15);
        }
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(this.getType(), source);
        if (jSArrayTypeImpl == null) {
            JSArrayTypeImpl.$$$reportNull$$$0(16);
        }
        return jSArrayTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "asGenericType";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSArrayTypeImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

