/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl {
    private final boolean myStrict;

    public JSTupleTypeImpl(JSTypeSource source, Collection<JSType> _types, boolean strict) {
        super(source, _types);
        this.myStrict = strict;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("," == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        return ",";
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String superTypeText = "[" + super.getTypeText(format) + "]";
        String string = format == JSType.TypeTextFormat.SERIALIZED ? "#tuple" + (this.myStrict ? "!" : "") + superTypeText : superTypeText;
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            return "*";
        }
        return super.getNestedTypePresentation(format, t);
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(2);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(3);
        }
        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(newSource, transformedTypes, this.myStrict);
        if (jSTupleTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        return jSTupleTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        if (this.myStrict && elementType instanceof JSTupleTypeImpl) {
            List<JSType> elementTypes = ((JSTupleTypeImpl)elementType).getTypes();
            List<JSType> currentTypes = this.getTypes();
            if (elementTypes.size() < currentTypes.size()) {
                return false;
            }
            for (int i = 0; i < currentTypes.size(); ++i) {
                JSType nestedElement;
                JSType nestedCurrent = currentTypes.get(i);
                if (nestedCurrent.isDirectlyAssignableType(nestedElement = elementTypes.get(i), processingContext)) continue;
                return false;
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        if (index < 0) {
            return null;
        }
        List<JSType> types = this.getTypes();
        if (index >= types.size()) {
            return null;
        }
        return types.get(index);
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        if (length > this.getTypes().size()) {
            return null;
        }
        List<JSType> newTypes = this.getTypes().subList(length, this.getTypes().size());
        return new JSTupleTypeImpl(this.getSource(), newTypes, this.myStrict);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(7);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        return assignableResult3;
    }

    public JSType toArrayType(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types = this.getTypes();
        Collection providers = types.stream().map(el -> () -> el).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        return new JSArrayTypeImpl(commonType, source);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.toArrayType(true);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = super.asRecordTypeNoCache();
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(parent.getTypeMembers());
        List<JSType> types = this.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            members.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(String.valueOf(i), types.get(i), false));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(parent.getSource(), members);
        if (jSRecordTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(10);
        }
        return jSRecordTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

