/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIndexedAccessJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSEvaluableType,
JSTypeWithIncompleteSubstitution {
    @NotNull
    private final JSType myOwner;
    @NotNull
    private final JSType myParameterType;

    public TypeScriptIndexedAccessJSTypeImpl(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        if (owner == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myOwner = owner;
        this.myParameterType = parameterType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        JSType owner;
        boolean shouldWrap;
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder result2 = new StringBuilder();
        if (isSerialized) {
            result2.append("#indt");
            result2.append("(");
        }
        if (shouldWrap = JSTypeUtils.isNeedWrapTypeForSerialization(owner = this.getOwner())) {
            result2.append("(");
        }
        result2.append(owner.getTypeText(format));
        if (shouldWrap) {
            result2.append(")");
        }
        result2.append(isSerialized ? "," : "[");
        JSType type = this.getParameterType();
        result2.append(type.getTypeText(format));
        result2.append(isSerialized ? "" : "]");
        if (isSerialized) {
            result2.append(")");
        }
        String string = result2.toString();
        if (string == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getTypeId() {
        String string = "#indexer#" + this.getOwner().getTypeId() + "[" + this.getParameterType().getTypeId() + "]";
        if (string == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(5);
        }
        JSType newOwner = JSTypeUtils.transformTypeHierarchySafe(this.getOwner(), childTransform);
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(newOwner, newParameterType, this.getSource());
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(6);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(7);
        }
        if ((substitute = this.substitute()) != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof TypeScriptIndexedAccessJSTypeImpl && this.getParameterType() instanceof JSGenericParameterImpl && ((TypeScriptIndexedAccessJSTypeImpl)elementType).getParameterType() instanceof JSGenericParameterImpl) {
            JSType thisOwner = this.getOwner();
            JSType otherOwner = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
            return thisOwner.isDirectlyAssignableType(otherOwner, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(8);
        }
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(this.getOwner(), this.getParameterType(), source);
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(9);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(10);
        }
        if (type instanceof TypeScriptIndexedAccessJSTypeImpl) {
            TypeScriptIndexedAccessJSTypeImpl indexedAccessJSType = (TypeScriptIndexedAccessJSTypeImpl)type;
            return indexedAccessJSType.getOwner().isEquivalentTo(this.getOwner(), context, allowResolve) && indexedAccessJSType.getParameterType().isEquivalentTo(this.getParameterType(), context, allowResolve);
        }
        return false;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.substituteWithPreventingRecursion(false);
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.substituteWithPreventingRecursion(true);
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteWithPreventingRecursion(boolean complete) {
        JSType type = (JSType)RecursionManager.doPreventingRecursion((Object)this.getTypeId(), (boolean)false, () -> this.substituteImpl(complete));
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = type == null ? this : type;
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(13);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @NotNull
    private JSType substituteImpl(boolean complete) {
        JSRecordType.IndexSignature indexer;
        JSType type;
        JSType owner = this.getOwner();
        JSType ownerType = JSTypeUtils.getValuableType(owner);
        JSType parameterType = this.getParameterType();
        if (!complete && (JSTypeUtils.hasGenericParameter(ownerType) || JSTypeUtils.hasGenericParameter(parameterType))) {
            TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = this;
            if (typeScriptIndexedAccessJSTypeImpl == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(14);
            }
            return typeScriptIndexedAccessJSTypeImpl;
        }
        Collection<String> parameterStrings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(parameterType);
        HashSet strings = new HashSet(parameterStrings);
        JSRecordType recordType = ownerType.asRecordType();
        List result2 = ContainerUtil.newSmartList();
        if (!strings.isEmpty()) {
            for (String name : strings) {
                JSResolvedTypeInfo info;
                JSType type2;
                JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(name);
                if (propertySignature == null || (type2 = propertySignature.getType()) == null) continue;
                boolean addedModifiedType = false;
                if (ownerType instanceof JSTypeImpl && (info = ((JSTypeImpl)ownerType).resolveType()) != null && info.isEnum() && propertySignature instanceof TypeScriptEnumField) {
                    result2.add(((JSTypeImpl)JSNamedType.createType(type2.getTypeText() + "." + name, type2.getSource(), JSTypeContext.INSTANCE, false)).copyWithStrictness(false));
                    addedModifiedType = true;
                }
                if (addedModifiedType) continue;
                result2.add(type2);
            }
            if (result2.size() != 0) {
                JSCompositeTypeImpl jSCompositeTypeImpl = result2.size() == 1 ? (JSType)result2.get(0) : new JSCompositeTypeImpl(this.getSource(), result2);
                if (jSCompositeTypeImpl == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(15);
                }
                return jSCompositeTypeImpl;
            }
        }
        if ((type = TypeScriptLiteralKeyUtil.getTypeFromComputedNameProperty(ownerType, parameterType)) != null) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        JSRecordType.IndexSignatureKind expectedIndexer = JSRecordType.IndexSignatureKind.UNKNOWN;
        if (this.isAssignableToCommonType(parameterType, "number") || parameterType instanceof JSForInStringType) {
            expectedIndexer = JSRecordType.IndexSignatureKind.NUMERIC;
        } else if (this.isAssignableToCommonType(parameterType, "string") || parameterType instanceof JSCompositeTypeImpl && ((JSCompositeTypeImpl)parameterType).getTypes().stream().allMatch(t -> this.isAssignableToCommonType((JSType)t, "string") || this.isAssignableToCommonType((JSType)t, "number"))) {
            expectedIndexer = JSRecordType.IndexSignatureKind.STRING;
        }
        if (expectedIndexer != JSRecordType.IndexSignatureKind.UNKNOWN && (indexer = recordType.findIndexer(expectedIndexer)) != null) {
            JSType jSType = indexer.getMemberType();
            if (jSType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
        if (jSAnyType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(18);
        }
        return jSAnyType;
    }

    private boolean isAssignableToCommonType(@NotNull JSType parameterType, @NotNull String typeName) {
        JSType commonType;
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(19);
        }
        if (typeName == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(20);
        }
        return (commonType = JSSpecialNamedTypeImpl.getSpecialType(typeName, this.getSource(), JSTypeContext.INSTANCE, false)) != null && commonType.isDirectlyAssignableType(parameterType, null);
    }

    @NotNull
    public static Collection<String> getParameterStrings(@NotNull JSType parameterType) {
        TypeScriptEnumField field;
        JSResolvedTypeInfo info;
        JSType type;
        JSType typeDef;
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(21);
        }
        if (parameterType instanceof JSTypeImpl && (typeDef = ((JSTypeImpl)parameterType).getTypedef()) != null) {
            parameterType = typeDef;
        }
        if ((type = JSTypeUtils.getValuableType(parameterType)) instanceof JSStringLiteralTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSStringLiteralTypeImpl)type).getLiteral());
            if (list == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSNumberLiteralTypeImpl)type).getValueAsString());
            if (list == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (type instanceof JSTypeImpl && (info = ((JSTypeImpl)type).resolveType()) != null && info.isEnumLiteral() && (field = info.getDeclarationOfType(TypeScriptEnumField.class)) != null) {
            EnumConstantValue value = field.getConstantValue();
            String stringValue = value.getStringValue();
            if (stringValue != null) {
                List list = ContainerUtil.createMaybeSingletonList((Object)stringValue);
                if (list == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(24);
                }
                return list;
            }
            Double numericValue = value.getNumericValue();
            if (numericValue != null) {
                List list = ContainerUtil.createMaybeSingletonList((Object)value.getSerializedString());
                if (list == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(25);
                }
                return list;
            }
        }
        if (type instanceof JSCompositeTypeImpl) {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            for (JSType jsType : ((JSCompositeTypeImpl)type).getTypes()) {
                result2.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(jsType));
            }
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(26);
            }
            return linkedHashSet;
        }
        if (type instanceof JSIntersectionTypeImpl) {
            HashSet strings = new HashSet();
            for (JSType constituent : ((JSIntersectionTypeImpl)type).getTypes()) {
                if (strings.isEmpty()) {
                    strings.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
                    continue;
                }
                strings.retainAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
            }
            HashSet hashSet = strings;
            if (hashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(27);
            }
            return hashSet;
        }
        JSType substitute = parameterType.substitute();
        if (substitute != parameterType) {
            Collection<String> collection = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(substitute);
            if (collection == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(28);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.getOwner().accept(visitor);
        this.getParameterType().accept(visitor);
    }

    @NotNull
    public JSType getOwner() {
        JSType jSType = this.myOwner;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteWithPreventingRecursion";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteImpl";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterStrings";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToCommonType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParameterStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

