/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.util.DeclarationUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable JSStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSReturnStatement || statement instanceof JSThrowStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return true;
        }
        if (statement instanceof JSForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((JSForStatement)statement);
        }
        if (statement instanceof JSForInStatement) {
            return ControlFlowUtils.foreachStatementMayReturnNormally((JSForInStatement)statement);
        }
        if (statement instanceof JSWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((JSWhileStatement)statement);
        }
        if (statement instanceof JSDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayReturnNormally((JSDoWhileStatement)statement);
        }
        if (statement instanceof JSBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)statement);
        }
        if (statement instanceof JSLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((JSLabeledStatement)statement);
        }
        if (statement instanceof JSIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((JSIfStatement)statement);
        }
        if (statement instanceof JSTryStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((JSTryStatement)statement);
        }
        if (statement instanceof JSSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((JSSwitchStatement)statement);
        }
        if (statement instanceof JSWithStatement) {
            return ControlFlowUtils.withStatementMayReturnNormally((JSWithStatement)statement);
        }
        return true;
    }

    private static boolean withStatementMayReturnNormally(JSWithStatement jsWithStatement) {
        JSStatement body = jsWithStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(body);
    }

    private static boolean doWhileStatementMayReturnNormally(@NotNull JSDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(0);
        }
        JSExpression test = loopStatement.getCondition();
        JSStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement);
    }

    private static boolean whileStatementMayReturnNormally(@NotNull JSWhileStatement loopStatement) {
        JSExpression test;
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(1);
        }
        return !ControlFlowUtils.isTrue(test = loopStatement.getCondition()) || ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull JSForStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(2);
        }
        JSExpression test = loopStatement.getCondition();
        if (ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement)) {
            return true;
        }
        if (test == null) {
            return false;
        }
        return !ControlFlowUtils.isTrue(test);
    }

    private static boolean foreachStatementMayReturnNormally(@NotNull JSForInStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(3);
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(4);
        }
        if (ControlFlowUtils.statementIsBreakTarget((JSStatement)switchStatement)) {
            return true;
        }
        JSCaseClause[] caseClauses = switchStatement.getCaseClauses();
        if (caseClauses.length == 0) {
            return true;
        }
        boolean hasDefaultCase = false;
        for (JSCaseClause clause : caseClauses) {
            if (!clause.isDefault()) continue;
            hasDefaultCase = true;
        }
        if (!hasDefaultCase) {
            return true;
        }
        JSCaseClause lastClause = caseClauses[caseClauses.length - 1];
        JSStatement[] statements = lastClause.getStatements();
        if (statements.length == 0) {
            return true;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean tryStatementMayReturnNormally(@NotNull JSTryStatement tryStatement) {
        JSStatement finallyBlock;
        if (tryStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(5);
        }
        if ((finallyBlock = tryStatement.getFinallyStatement()) != null && !ControlFlowUtils.statementMayCompleteNormally(finallyBlock)) {
            return false;
        }
        JSStatement tryBlock = tryStatement.getStatement();
        if (ControlFlowUtils.statementMayCompleteNormally(tryBlock)) {
            return true;
        }
        JSCatchBlock[] allCatchBlocks = tryStatement.getAllCatchBlocks();
        if (allCatchBlocks.length == 0) {
            return false;
        }
        for (JSCatchBlock c : allCatchBlocks) {
            if (!ControlFlowUtils.statementMayCompleteNormally(c.getStatement())) continue;
            return true;
        }
        return tryStatement.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull JSIfStatement ifStatement) {
        JSStatement thenBranch;
        if (ifStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(6);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch = ifStatement.getThen())) {
            return true;
        }
        JSStatement elseBranch = ifStatement.getElse();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull JSLabeledStatement labeledStatement) {
        JSStatement statement;
        if (labeledStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(7);
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement = labeledStatement.getStatement()) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable JSBlockStatement block) {
        JSStatement[] statements;
        if (block == null) {
            return true;
        }
        for (JSStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(8);
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean elementContainsReturn(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(9);
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean elementContainsReturnOrYield(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(10);
        }
        ReturnFinder finder = new ReturnFinder(){

            public void visitJSYieldExpression(JSYieldExpression statement) {
                this.m_found = true;
            }
        };
        element.accept((PsiElementVisitor)finder);
        return finder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(11);
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean isInLoop(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(12);
        }
        return ControlFlowUtils.isInForStatementBody(element) || ControlFlowUtils.isInForeachStatementBody(element) || ControlFlowUtils.isInWhileStatementBody(element) || ControlFlowUtils.isInDoWhileStatementBody(element);
    }

    public static boolean isInFinallyBlock(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(13);
        }
        JSElement currentElement = element;
        JSTryStatement tryStatement;
        while ((tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JSTryStatement.class, (boolean)true, (Class[])new Class[]{JSFunction.class})) != null) {
            JSStatement finallyBlock = tryStatement.getFinallyStatement();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(14);
        }
        JSElement currentElement = element;
        JSTryStatement tryStatement;
        while ((tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JSTryStatement.class)) != null) {
            JSStatement catchStatement;
            JSCatchBlock catchBlock = tryStatement.getCatchBlock();
            if (catchBlock != null && PsiTreeUtil.isAncestor((PsiElement)(catchStatement = catchBlock.getStatement()), (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    private static boolean isInWhileStatementBody(@NotNull JSElement element) {
        JSWhileStatement whileStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(15);
        }
        if ((whileStatement = (JSWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSWhileStatement.class)) == null) {
            return false;
        }
        JSStatement body = whileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInDoWhileStatementBody(@NotNull JSElement element) {
        JSDoWhileStatement doWhileStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(16);
        }
        if ((doWhileStatement = (JSDoWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDoWhileStatement.class)) == null) {
            return false;
        }
        JSStatement body = doWhileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForStatementBody(@NotNull JSElement element) {
        JSForStatement forStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(17);
        }
        if ((forStatement = (JSForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSForStatement.class)) == null) {
            return false;
        }
        JSStatement body = forStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForeachStatementBody(@NotNull JSElement element) {
        JSForInStatement foreachStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(18);
        }
        if ((foreachStatement = (JSForInStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSForInStatement.class)) == null) {
            return false;
        }
        JSStatement body = foreachStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static JSStatement stripBraces(@NotNull JSStatement branch) {
        if (branch == null) {
            ControlFlowUtils.$$$reportNull$$$0(19);
        }
        if (branch instanceof JSBlockStatement) {
            JSBlockStatement block = (JSBlockStatement)branch;
            JSStatement[] statements = block.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull JSStatement containingStatement, @NotNull JSStatement statement) {
        if (containingStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(20);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(21);
        }
        JSStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            JSElement container = ControlFlowUtils.getContainingStatement((JSElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof JSBlockStatement ? !ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck) : container instanceof JSSwitchStatement && !ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSSwitchStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull JSBlockStatement body, @NotNull JSStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(22);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(23);
        }
        JSStatement statementToCheck = statement;
        while (statementToCheck != null) {
            JSElement container = ControlFlowUtils.getContainingStatement((JSElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSBlockStatement) {
                if (!ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)container, JSStatement.class);
                continue;
            }
            if (container instanceof JSSwitchStatement) {
                if (!ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = container;
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(24);
        }
        return element instanceof JSLoopStatement;
    }

    @Nullable
    private static JSElement getContainingStatement(@NotNull JSElement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(25);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSStatement.class);
    }

    private static boolean statementIsLastInBlock(@NotNull JSBlockStatement block, @NotNull JSStatement statement) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(26);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(27);
        }
        return ControlFlowUtils.statementIsLastInStatements(statement, block.getStatements());
    }

    private static boolean statementIsLastInSwitch(@NotNull JSSwitchStatement switchStatement, @NotNull JSStatement statement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(28);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(29);
        }
        return ControlFlowUtils.statementIsLastInStatements(statement, switchStatement.getStatements());
    }

    private static boolean statementIsLastInStatements(JSStatement statement, JSStatement[] statements) {
        for (int i = statements.length - 1; i >= 0; --i) {
            JSStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof JSEmptyStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean isFalse(@Nullable JSExpression test) {
        if (test == null) {
            return false;
        }
        String text = test.getText();
        return "false".equals(text);
    }

    public static boolean isTrue(@Nullable JSExpression test) {
        if (test == null) {
            return false;
        }
        String text = test.getText();
        return "true".equals(text);
    }

    public static boolean isInExitStatement(@NotNull JSExpression expression) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(30);
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull JSExpression expression) {
        JSReturnStatement returnStatement;
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(31);
        }
        return (returnStatement = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSReturnStatement.class)) != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull JSExpression expression) {
        JSThrowStatement throwStatement;
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(32);
        }
        return (throwStatement = (JSThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSThrowStatement.class)) != null;
    }

    @Nullable
    public static JSFunction resolveMethod(JSCallExpression expression) {
        JSExpression methodExpression;
        JSExpression jSExpression = methodExpression = expression == null ? null : expression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            PsiElement referent = ((JSReferenceExpression)methodExpression).resolve();
            return referent instanceof JSFunction ? (JSFunction)referent : null;
        }
        return null;
    }

    @Nullable
    public static JSVariable resolveVariable(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSReferenceExpression) {
            PsiElement variable = ((JSReferenceExpression)expression).resolve();
            return variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        if (expression instanceof JSDefinitionExpression) {
            JSExpression referentExpression = ((JSDefinitionExpression)expression).getExpression();
            PsiReference reference = referentExpression == null ? null : referentExpression.getReference();
            PsiElement variable = reference == null ? null : reference.resolve();
            return variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        return null;
    }

    public static void appendStatementsInSequence(StringBuilder buffer, JSStatement statement1, JSStatement statement2) {
        if (statement1 == null) {
            buffer.append(' ').append(statement2.getText());
        } else if (statement2 == null) {
            buffer.append(' ').append(statement1.getText());
        } else {
            buffer.append('{');
            ControlFlowUtils.appendStatementStripped(buffer, statement1);
            ControlFlowUtils.appendStatementStripped(buffer, statement2);
            buffer.append('}');
        }
    }

    private static void appendStatementStripped(StringBuilder buffer, JSStatement statement) {
        if (statement instanceof JSBlockStatement) {
            for (JSStatement child : ((JSBlockStatement)statement).getStatements()) {
                buffer.append(child.getText());
            }
        } else {
            buffer.append(statement.getText());
        }
    }

    public static boolean canBeMerged(JSStatement statement1, JSStatement statement2) {
        if (!ControlFlowUtils.statementMayCompleteNormally(statement1)) {
            return false;
        }
        Set<String> statement1Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement1);
        if (ControlFlowUtils.containsConflictingDeclarations(statement1Declarations, statement2)) {
            return false;
        }
        Set<String> statement2Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement2);
        return !ControlFlowUtils.containsConflictingDeclarations(statement2Declarations, statement1);
    }

    public static boolean containsConflictingDeclarations(JSBlockStatement block, JSBlockStatement parentBlock) {
        JSStatement[] statements = block.getStatements();
        HashSet<JSVariable> declaredVars = new HashSet<JSVariable>();
        for (JSStatement statement : statements) {
            if (!(statement instanceof JSVarStatement)) continue;
            JSVarStatement declaration = (JSVarStatement)statement;
            for (JSVariable var : declaration.getVariables()) {
                declaredVars.add(var);
            }
        }
        for (JSVariable variable : declaredVars) {
            if (!ControlFlowUtils.conflictingDeclarationExists(variable.getName(), parentBlock, block)) continue;
            return true;
        }
        return false;
    }

    private static boolean conflictingDeclarationExists(String name, JSBlockStatement parentBlock, JSBlockStatement exceptBlock) {
        ConflictingDeclarationVisitor visitor = new ConflictingDeclarationVisitor(name, exceptBlock);
        parentBlock.accept((PsiElementVisitor)visitor);
        return visitor.hasConflictingDeclaration();
    }

    private static Set<String> calculateTopLevelDeclarations(JSStatement statement) {
        HashSet<String> out = new HashSet<String>();
        if (statement instanceof JSVarStatement) {
            ControlFlowUtils.addDeclarations((JSVarStatement)statement, out);
        } else if (statement instanceof JSBlockStatement) {
            for (JSStatement subStatement : ((JSBlockStatement)statement).getStatements()) {
                if (!(subStatement instanceof JSVarStatement)) continue;
                ControlFlowUtils.addDeclarations((JSVarStatement)subStatement, out);
            }
        }
        return out;
    }

    private static void addDeclarations(JSVarStatement statement, Set<String> declaredVars) {
        for (JSVariable variable : statement.getVariables()) {
            declaredVars.add(variable.getName());
        }
    }

    private static boolean containsConflictingDeclarations(Set<String> declarations, JSStatement statement) {
        DeclarationUtils.DeclarationConflictVisitor visitor = new DeclarationUtils.DeclarationConflictVisitor(declarations);
        statement.accept((PsiElementVisitor)visitor);
        return visitor.hasConflict();
    }

    public static boolean statementContainsExitingBreak(@Nullable JSStatement statement) {
        if (statement == null) {
            return false;
        }
        ExitingBreakFinder breakFinder = new ExitingBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 8: 
            case 11: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingStatement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileStatementMayReturnNormally";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementMayReturnNormally";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementMayReturnNormally";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "foreachStatementMayReturnNormally";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementMayReturnNormally";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementMayReturnNormally";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementMayReturnNormally";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "labeledStatementMayCompleteNormally";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsBreakTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "elementContainsReturn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "elementContainsReturnOrYield";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsContinueTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isInLoop";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFinallyBlock";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isInCatchBlock";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isInWhileStatementBody";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isInDoWhileStatementBody";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isInForStatementBody";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isInForeachStatementBody";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "stripBraces";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "statementCompletesWithStatement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "blockCompletesWithStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isLoop";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingStatement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsLastInBlock";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsLastInSwitch";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isInExitStatement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isInReturnStatementArgument";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "isInThrowStatementArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExitingBreakFinder
    extends JSRecursiveElementVisitor {
        private boolean found;

        private ExitingBreakFinder() {
        }

        private boolean breakFound() {
            return this.found;
        }

        public void visitJSReferenceExpression(JSReferenceExpression exp) {
        }

        public void visitJSBreakStatement(JSBreakStatement breakStatement) {
            if (breakStatement.getLabel() != null) {
                return;
            }
            this.found = true;
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement statement) {
        }

        public void visitJSForStatement(JSForStatement statement) {
        }

        public void visitJSForInStatement(JSForInStatement statement) {
        }

        public void visitJSWhileStatement(JSWhileStatement statement) {
        }

        public void visitJSSwitchStatement(JSSwitchStatement statement) {
        }
    }

    private static class ConflictingDeclarationVisitor
    extends JSRecursiveElementVisitor {
        private final String variableName;
        private final JSBlockStatement exceptBlock;
        private boolean hasConflictingDeclaration;

        ConflictingDeclarationVisitor(String variableName, JSBlockStatement exceptBlock) {
            this.variableName = variableName;
            this.exceptBlock = exceptBlock;
        }

        public void visitJSElement(JSElement element) {
            if (!this.hasConflictingDeclaration) {
                super.visitJSElement(element);
            }
        }

        public void visitJSBlock(JSBlockStatement block) {
            if (!this.hasConflictingDeclaration && !block.equals(this.exceptBlock)) {
                super.visitJSBlock(block);
            }
        }

        public void visitJSVariable(JSVariable variable) {
            if (!this.hasConflictingDeclaration) {
                super.visitJSVariable(variable);
                String name = variable.getName();
                this.hasConflictingDeclaration = name != null && name.equals(this.variableName);
            }
        }

        public boolean hasConflictingDeclaration() {
            return this.hasConflictingDeclaration;
        }
    }

    private static class ContinueFinder
    extends JSRecursiveElementVisitor {
        private boolean m_found;
        private final JSStatement m_target;

        private ContinueFinder(@NotNull JSStatement target) {
            if (target == null) {
                ContinueFinder.$$$reportNull$$$0(0);
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        public void visitJSContinueStatement(@NotNull JSContinueStatement continueStatement) {
            if (continueStatement == null) {
                ContinueFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitJSContinueStatement(continueStatement);
            JSStatement exitedStatement = continueStatement.getStatementToContinue();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ContinueFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSContinueStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BreakFinder
    extends JSRecursiveElementVisitor {
        private boolean m_found;
        private final JSStatement m_target;

        private BreakFinder(@NotNull JSStatement target) {
            if (target == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitJSBreakStatement(@NotNull JSBreakStatement breakStatement) {
            JSStatement prevStatement;
            if (breakStatement == null) {
                BreakFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitJSBreakStatement(breakStatement);
            JSStatement exitedStatement = breakStatement.getStatementToBreak();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false) && ((prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)breakStatement, JSStatement.class)) == null || ControlFlowUtils.statementMayCompleteNormally(prevStatement))) {
                this.m_found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils$BreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnFinder
    extends JSRecursiveElementVisitor {
        protected boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        public void visitJSReturnStatement(@NotNull JSReturnStatement returnStatement) {
            if (returnStatement == null) {
                ReturnFinder.$$$reportNull$$$0(0);
            }
            this.m_found = true;
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitJSFunctionDeclaration(JSFunction node) {
        }

        public void visitES6FunctionProperty(ES6FunctionProperty functionProperty) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ReturnFinder", "visitJSReturnStatement"));
        }
    }
}

