/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ArrayListSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtil {
    private VariableAccessUtil() {
    }

    public static boolean variableIsAssignedFrom(JSVariable variable, JSElement context) {
        VariableAssignedFromVisitor visitor = new VariableAssignedFromVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(JSVariable variable, JSElement context) {
        VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsUsedAsObjectProperty(JSVariable variable, JSElement context) {
        VariableUsedAsObjectPropertyVisitor visitor = new VariableUsedAsObjectPropertyVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsedAsObjectProperty();
    }

    public static boolean variableIsUsedInArrayLiteral(JSVariable variable, JSElement context) {
        VariableUsedInArrayLiteralVisitor visitor = new VariableUsedInArrayLiteralVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    public static boolean variableIsAssigned(JSVariable variable, JSElement context) {
        return VariableAccessUtil.variableIsAssigned(variable, context, Collections.emptySet(), Collections.emptySet());
    }

    public static boolean variableIsAssigned(JSVariable variable, JSElement context, Set<JSVariable> notUpdatedSymbols) {
        return VariableAccessUtil.variableIsAssigned(variable, context, notUpdatedSymbols, Collections.emptySet());
    }

    private static boolean variableIsAssigned(JSVariable variable, JSElement context, Set<JSVariable> notUpdatedSymbols, Set<JSVariable> candidateSymbols) {
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, context, notUpdatedSymbols, candidateSymbols);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsReturned(JSVariable variable, JSElement context) {
        VariableReturnedVisitor visitor = new VariableReturnedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReturned();
    }

    public static boolean arrayContentsAreAccessed(JSVariable variable, JSElement context) {
        ArrayContentsAccessedVisitor visitor = new ArrayContentsAccessedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAccessed();
    }

    public static boolean arrayContentsAreAssigned(JSVariable variable, JSElement context) {
        ArrayContentsAssignedVisitor visitor = new ArrayContentsAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean mayEvaluateToVariable(@Nullable JSExpression expression, @NotNull JSVariable variable) {
        if (variable == null) {
            VariableAccessUtil.$$$reportNull$$$0(0);
        }
        String variableName = variable.getName();
        JSExpression expr = expression;
        if (variableName == null) {
            return false;
        }
        while (true) {
            if (expr == null) {
                return false;
            }
            if (expr instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expr;
                JSExpression lOperand = binaryExpression.getLOperand();
                if (VariableAccessUtil.mayEvaluateToVariable(lOperand, variable)) {
                    return true;
                }
                expr = binaryExpression.getROperand();
                continue;
            }
            if (expr instanceof JSParenthesizedExpression) {
                expr = ((JSParenthesizedExpression)expr).getInnerExpression();
                continue;
            }
            if (expr instanceof JSConditionalExpression) {
                JSConditionalExpression conditional = (JSConditionalExpression)expr;
                return VariableAccessUtil.mayEvaluateToVariable(conditional.getThen(), variable) || VariableAccessUtil.mayEvaluateToVariable(conditional.getElse(), variable);
            }
            if (expr instanceof JSDefinitionExpression) {
                expr = ((JSDefinitionExpression)expr).getExpression();
                continue;
            }
            if (!(expr instanceof JSSpreadExpression)) break;
            expr = ((JSSpreadExpression)expr).getExpression();
        }
        if (expr instanceof JSReferenceExpression) {
            PsiElement referent = ((JSReferenceExpression)expr).resolve();
            return referent != null && referent.equals(variable);
        }
        return false;
    }

    public static Set<JSVariable> getUsedVariables(PsiElement context) {
        UsedVariableVisitor visitor = new UsedVariableVisitor();
        context.accept((PsiElementVisitor)visitor);
        return visitor.getVariables();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/util/VariableAccessUtil", "mayEvaluateToVariable"));
    }

    private static class UsedVariableVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final Set<JSVariable> variables = new HashSet<JSVariable>();

        public void visitJSReferenceExpression(@NotNull JSReferenceExpression ref) {
            if (ref == null) {
                UsedVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReferenceExpression(ref);
            PsiElement referent = ref.resolve();
            if (referent instanceof JSVariable) {
                this.variables.add((JSVariable)referent);
            }
        }

        @NotNull
        public Set<JSVariable> getVariables() {
            Set<JSVariable> set = this.variables;
            if (set == null) {
                UsedVariableVisitor.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$UsedVariableVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$UsedVariableVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSReferenceExpression";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ArrayContentsAssignedVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private boolean assigned;

        public ArrayContentsAssignedVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                ArrayContentsAssignedVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            if (assignment == null) {
                ArrayContentsAssignedVisitor.$$$reportNull$$$0(1);
            }
            if (!this.assigned) {
                super.visitJSAssignmentExpression(assignment);
                this.checkExpression(null, assignment.getLOperand());
            }
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                ArrayContentsAssignedVisitor.$$$reportNull$$$0(2);
            }
            if (!this.assigned) {
                super.visitJSPrefixExpression(expression);
                this.checkExpression(expression.getOperationSign(), expression.getExpression());
            }
        }

        public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
            if (expression == null) {
                ArrayContentsAssignedVisitor.$$$reportNull$$$0(3);
            }
            if (!this.assigned) {
                super.visitJSPostfixExpression(expression);
                this.checkExpression(expression.getOperationSign(), expression.getExpression());
            }
        }

        private void checkExpression(IElementType tokenType, JSExpression expression) {
            if (tokenType != null && !tokenType.equals(JSTokenTypes.PLUSPLUS) && !tokenType.equals(JSTokenTypes.MINUSMINUS)) {
                return;
            }
            if (!(expression instanceof JSIndexedPropertyAccessExpression)) {
                return;
            }
            JSExpression arrayExpression = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
            while (arrayExpression instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression accessExpression = (JSIndexedPropertyAccessExpression)arrayExpression;
                arrayExpression = accessExpression.getQualifier();
            }
            if (arrayExpression instanceof JSReferenceExpression) {
                String referencedName = ((JSReferenceExpression)arrayExpression).getReferencedName();
                this.assigned = referencedName != null && referencedName.equals(this.variable.getName());
            }
        }

        public boolean isAssigned() {
            return this.assigned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$ArrayContentsAssignedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPostfixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ArrayContentsAccessedVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private boolean accessed;

        public ArrayContentsAccessedVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                ArrayContentsAccessedVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                ArrayContentsAccessedVisitor.$$$reportNull$$$0(1);
            }
            if (!this.accessed) {
                super.visitJSForInStatement(statement);
                this.checkQualifier(statement.getCollectionExpression());
            }
        }

        public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression accessExpression) {
            if (accessExpression == null) {
                ArrayContentsAccessedVisitor.$$$reportNull$$$0(2);
            }
            if (!this.accessed) {
                super.visitJSIndexedPropertyAccessExpression(accessExpression);
                PsiElement parent = accessExpression.getParent();
                if (!(parent instanceof JSAssignmentExpression) && !((JSAssignmentExpression)parent).getLOperand().equals(accessExpression)) {
                    this.checkQualifier(accessExpression.getQualifier());
                }
            }
        }

        private void checkQualifier(JSExpression qualifier) {
            if (qualifier instanceof JSReferenceExpression) {
                PsiElement referent = ((JSReferenceExpression)qualifier).resolve();
                this.accessed = referent != null && referent.equals(this.variable);
            }
        }

        public boolean isAccessed() {
            return this.accessed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$ArrayContentsAccessedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIndexedPropertyAccessExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableUsedInArrayLiteralVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final JSVariable variable;
        private boolean used;

        public VariableUsedInArrayLiteralVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariableUsedInArrayLiteralVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
            if (!this.used) {
                super.visitJSArrayLiteralExpression(node);
                for (JSExpression expression : node.getExpressions()) {
                    if (!VariableAccessUtil.mayEvaluateToVariable(expression, this.variable)) continue;
                    this.used = true;
                    break;
                }
            }
        }

        public boolean isUsed() {
            return this.used;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableUsedInArrayLiteralVisitor", "<init>"));
        }
    }

    private static class VariableUsedAsObjectPropertyVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final JSVariable variable;
        private boolean myUsedAsObjectProperty;

        public VariableUsedAsObjectPropertyVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariableUsedAsObjectPropertyVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
            if (!this.myUsedAsObjectProperty) {
                super.visitJSObjectLiteralExpression(node);
                for (JSProperty property : node.getProperties()) {
                    if (!VariableAccessUtil.mayEvaluateToVariable(property.getValue(), this.variable)) continue;
                    this.myUsedAsObjectProperty = true;
                    break;
                }
            }
        }

        public boolean isUsedAsObjectProperty() {
            return this.myUsedAsObjectProperty;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableUsedAsObjectPropertyVisitor", "<init>"));
        }
    }

    private static class VariablePassedAsArgumentVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final JSVariable variable;
        private boolean passed;

        public VariablePassedAsArgumentVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariablePassedAsArgumentVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSArgumentList(@NotNull JSArgumentList argumentList) {
            if (argumentList == null) {
                VariablePassedAsArgumentVisitor.$$$reportNull$$$0(1);
            }
            if (!this.passed) {
                super.visitJSArgumentList(argumentList);
                for (JSExpression argument : argumentList.getArguments()) {
                    if (!VariableAccessUtil.mayEvaluateToVariable(argument, this.variable)) continue;
                    this.passed = true;
                    break;
                }
            }
        }

        public boolean isPassed() {
            return this.passed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentList";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariablePassedAsArgumentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSArgumentList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableReturnedVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final JSVariable variable;
        private boolean returned;

        public VariableReturnedVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariableReturnedVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSReturnStatement(@NotNull JSReturnStatement returnStatement) {
            if (returnStatement == null) {
                VariableReturnedVisitor.$$$reportNull$$$0(1);
            }
            if (!this.returned) {
                super.visitJSReturnStatement(returnStatement);
                this.returned = VariableAccessUtil.mayEvaluateToVariable(returnStatement.getExpression(), this.variable);
            }
        }

        public boolean isReturned() {
            return this.returned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableReturnedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableAssignedFromVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private boolean assignedFrom;

        public VariableAssignedFromVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        public void visitJSElement(@NotNull JSElement element) {
            if (element == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(1);
            }
            if (!this.assignedFrom) {
                super.visitJSElement(element);
            }
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            if (assignment == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(2);
            }
            if (!this.assignedFrom) {
                super.visitJSAssignmentExpression(assignment);
                this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(assignment.getROperand(), this.variable);
            }
        }

        public void visitJSVarStatement(@NotNull JSVarStatement statement) {
            if (statement == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(3);
            }
            if (!this.assignedFrom) {
                super.visitJSVarStatement(statement);
                for (JSVariable declaredVariable : statement.getVariables()) {
                    JSExpression initializer = declaredVariable.getInitializer();
                    if (initializer == null) continue;
                    this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(initializer, this.variable);
                }
            }
        }

        public void visitJSVariable(JSVariable var) {
            if (!this.assignedFrom) {
                super.visitJSVariable(var);
                this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(var.getInitializer(), this.variable);
            }
        }

        public boolean isAssignedFrom() {
            return this.assignedFrom;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableAssignedFromVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVarStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableAssignedVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private final JSElement context;
        private Set<JSVariable> notUpdatedSymbols;
        private final Set<JSVariable> candidateSymbols;
        private boolean assigned;

        public VariableAssignedVisitor(@NotNull JSVariable variable, @NotNull JSElement context, @NotNull Set<JSVariable> notUpdatedSymbols) {
            if (variable == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(1);
            }
            if (notUpdatedSymbols == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(2);
            }
            this.variable = variable;
            this.context = context;
            this.notUpdatedSymbols = notUpdatedSymbols;
            this.candidateSymbols = new ArrayListSet();
            this.candidateSymbols.add(variable);
        }

        private VariableAssignedVisitor(@NotNull JSVariable variable, @NotNull JSElement context, @NotNull Set<JSVariable> notUpdatedSymbols, @NotNull Set<JSVariable> candidateSymbols) {
            if (variable == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(3);
            }
            if (context == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(4);
            }
            if (notUpdatedSymbols == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(5);
            }
            if (candidateSymbols == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(6);
            }
            this.variable = variable;
            this.context = context;
            this.notUpdatedSymbols = notUpdatedSymbols;
            this.candidateSymbols = candidateSymbols;
        }

        public void visitJSElement(JSElement element) {
            if (!this.assigned) {
                super.visitJSElement(element);
            }
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression assignment) {
            if (!this.assigned) {
                super.visitJSAssignmentExpression(assignment);
                JSExpression arg = assignment.getLOperand();
                if (VariableAccessUtil.mayEvaluateToVariable(arg, this.variable)) {
                    JSExpression rOperand = assignment.getROperand();
                    Set<Object> usedVariables = rOperand != null ? VariableAccessUtil.getUsedVariables((PsiElement)rOperand) : Collections.emptySet();
                    ArrayListSet newCandidateSet = new ArrayListSet();
                    newCandidateSet.addAll(this.candidateSymbols);
                    newCandidateSet.add(this.variable);
                    for (JSVariable jSVariable : usedVariables) {
                        if (newCandidateSet.contains(jSVariable) || VariableAccessUtil.variableIsAssigned(jSVariable, this.context, this.notUpdatedSymbols, (Set)newCandidateSet)) continue;
                        if (this.notUpdatedSymbols.isEmpty()) {
                            this.notUpdatedSymbols = new ArrayListSet();
                        }
                        this.notUpdatedSymbols.add(jSVariable);
                    }
                    this.assigned = true;
                } else {
                    this.assigned = false;
                }
            }
        }

        public void visitJSPrefixExpression(JSPrefixExpression prefixExpression) {
            if (!this.assigned) {
                super.visitJSPrefixExpression(prefixExpression);
                IElementType tokenType = prefixExpression.getOperationSign();
                if (!tokenType.equals(JSTokenTypes.PLUSPLUS) && !tokenType.equals(JSTokenTypes.MINUSMINUS)) {
                    return;
                }
                JSExpression operand = prefixExpression.getExpression();
                this.assigned = VariableAccessUtil.mayEvaluateToVariable(operand, this.variable);
            }
        }

        public void visitJSPostfixExpression(JSPostfixExpression postfixExpression) {
            if (!this.assigned) {
                super.visitJSPostfixExpression(postfixExpression);
                IElementType tokenType = postfixExpression.getOperationSign();
                if (!tokenType.equals(JSTokenTypes.PLUSPLUS) && !tokenType.equals(JSTokenTypes.MINUSMINUS)) {
                    return;
                }
                JSExpression operand = postfixExpression.getExpression();
                this.assigned = VariableAccessUtil.mayEvaluateToVariable(operand, this.variable);
            }
        }

        public boolean isAssigned() {
            return this.assigned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notUpdatedSymbols";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "candidateSymbols";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableAssignedVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

