/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionInplaceIntroducer
extends AbstractInplaceIntroducer<JSNamedElement, PsiElement> {
    private final JSExtractFunctionHandler myHandler;
    private final DefaultJSExtractFunctionSettings mySettings;
    private final JSExtractFunctionHandler.ContextInfo myContextInfo;
    private final SmartPsiElementPointer<PsiElement> scopePointer;
    private PsiFile myFile;
    @Nullable
    private String myOriginalDocumentText;
    @Nullable
    private TextRange myOriginalSelection;

    public JSFunctionInplaceIntroducer(@NotNull JSExtractFunctionHandler extractFunctionHandler, @NotNull DefaultJSExtractFunctionSettings settings, @NotNull JSExtractFunctionHandler.ContextInfo contextInfo, @NotNull JSExtractFunctionHandler.IntroductionScope introductionScope) {
        if (extractFunctionHandler == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (contextInfo == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(2);
        }
        if (introductionScope == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(3);
        }
        super(contextInfo.project, contextInfo.editor, null, null, (PsiElement[])JSElement.EMPTY_ARRAY, JSExtractFunctionHandler.REFACTORING_NAME, (FileType)JavaScriptFileType.INSTANCE);
        this.myWholePanel.add(this.getPreviewComponent());
        this.myHandler = extractFunctionHandler;
        this.mySettings = settings;
        this.myContextInfo = contextInfo;
        this.scopePointer = SmartPointerManager.getInstance((Project)contextInfo.project).createSmartPsiElementPointer(introductionScope.parent);
    }

    @Nullable
    public PsiElement getIntroductionScope() {
        return this.scopePointer.getElement();
    }

    protected String getActionName() {
        return "ExtractMethod";
    }

    @Nullable
    protected JSNamedElement createFieldToStartTemplateOn(boolean replaceAll, @NotNull String[] names) {
        if (names == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(4);
        }
        this.myOriginalDocumentText = this.myEditor.getDocument().getText();
        this.myOriginalSelection = new TextRange(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
        JSExtractFunctionHandler.Result result2 = (JSExtractFunctionHandler.Result)WriteAction.compute(() -> this.myHandler.doRefactoring(this.myContextInfo, this.mySettings));
        if (result2 == null) {
            return null;
        }
        JSNamedElement declaration = result2.getDeclaration();
        JSReferenceExpression reference = result2.getReference();
        assert (declaration != null) : "expected declaration to be valid";
        assert (reference != null) : "expected reference to be valid";
        this.myLocalVariable = declaration;
        this.myFile = ((JSNamedElement)this.myLocalVariable).getContainingFile();
        this.myLocalMarker = this.createMarker((PsiElement)this.myLocalVariable);
        this.myExpr = reference.getReferenceNameElement();
        this.myExprMarker = this.createMarker(this.myExpr);
        return (JSNamedElement)this.myLocalVariable;
    }

    @NotNull
    protected String[] suggestNames(boolean replaceAll, @Nullable JSNamedElement variable) {
        String[] stringArray = new String[]{"extracted"};
        if (stringArray == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    protected void performIntroduce() {
    }

    public boolean isReplaceAllOccurrences() {
        return false;
    }

    protected int getCaretOffset() {
        PsiElement expr = this.myExpr;
        if (expr != null && expr.isValid()) {
            return expr.getTextRange().getStartOffset();
        }
        return super.getCaretOffset();
    }

    public void finish(boolean success) {
        if (!this.myFinished) {
            super.finish(success);
        }
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    protected void saveSettings(@NotNull JSNamedElement variable) {
        if (variable == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myFile;
    }

    @Nullable
    protected JSNamedElement getVariable() {
        if (this.myLocalMarker == null) {
            return null;
        }
        if (!this.myFile.isValid()) {
            return null;
        }
        PsiElement element = this.myFile.getContainingFile().findElementAt(this.myLocalMarker.getStartOffset());
        return (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSNamedElement.class, (boolean)false);
    }

    protected RangeMarker createMarker(PsiElement element) {
        RangeMarker marker = super.createMarker(element);
        marker.setGreedyToRight(true);
        marker.setGreedyToRight(true);
        return marker;
    }

    protected void performCleanup() {
        JSNamedElement variable = this.getVariable();
        if (variable != null) {
            this.revertStateOnFailure();
        }
    }

    protected boolean isIdentifier(String newName, Language language) {
        return super.isIdentifier(newName, language);
    }

    protected void restoreState(@NotNull JSNamedElement psiField) {
        if (psiField == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(7);
        }
    }

    private void revertStateOnFailure() {
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            if (this.myOriginalDocumentText != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document document = this.myEditor.getDocument();
                document.replaceString(0, document.getTextLength(), (CharSequence)this.myOriginalDocumentText);
                documentManager.commitDocument(document);
            }
            if (this.myOriginalSelection != null) {
                this.myEditor.getSelectionModel().setSelection(this.myOriginalSelection.getStartOffset(), this.myOriginalSelection.getEndOffset());
            }
            this.myExpr = null;
            this.myExprMarker = null;
        });
    }

    public JSElement restoreExpression(@NotNull PsiFile containingFile, @NotNull JSNamedElement variable, @NotNull RangeMarker marker, @Nullable String exprText) {
        if (containingFile == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(8);
        }
        if (variable == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(9);
        }
        if (marker == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(10);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractFunctionHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSFunctionInplaceIntroducer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSFunctionInplaceIntroducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

