/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractSuper.ES6ExtractSuperParameters;
import com.intellij.lang.javascript.refactoring.extractSuper.ES6ExtractSuperProcessor;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractInterfaceHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperClassHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExtractSuperDialog
extends RefactoringDialog {
    @Nullable
    private JRadioButton myExtractAndTurnRefsRB;
    private final String myRefactoringName;
    protected final JSClass mySourceClass;
    protected final List<JSMemberInfo> myMemberInfos;
    private final boolean myIsExtractInterface;
    @Nullable
    private JRadioButton myRbExtractSuperclass;
    private JTextField mySourceClassField;
    private JLabel myClassNameLabel;
    private JTextField myExtractedSuperNameField;
    protected TextFieldWithHistoryWithBrowseButton myDestinationFileField;

    public ES6ExtractSuperDialog(@NotNull JSClass sourceClass, @Nullable JSElement selectedElement, boolean isExtractInterface) {
        if (sourceClass == null) {
            ES6ExtractSuperDialog.$$$reportNull$$$0(0);
        }
        super(sourceClass.getProject(), true);
        this.myRefactoringName = isExtractInterface ? JSExtractInterfaceHandler.REFACTORING_NAME : JSExtractSuperClassHandler.REFACTORING_NAME;
        this.mySourceClass = sourceClass;
        this.myMemberInfos = JSMemberInfo.selectMembers(sourceClass, selectedElement, (MemberInfoBase.Filter<JSAttributeListOwner>)((MemberInfoBase.Filter)t -> !isExtractInterface || !JSPsiImplUtils.hasModifier(t, JSAttributeList.ModifierType.STATIC)));
        this.myIsExtractInterface = isExtractInterface;
        this.init();
    }

    protected void init() {
        this.setTitle(this.myRefactoringName);
        this.mySourceClassField = this.createSourceClassField();
        this.myDestinationFileField = ES6MoveModuleMembersDialog.createDestinationFileField((PsiElement)this.mySourceClass);
        PsiFile containingFile = this.mySourceClass.getContainingFile();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
        if (file != null) {
            this.myDestinationFileField.setText(StringUtil.notNullize((String)file.getPresentableUrl()));
        }
        this.myExtractedSuperNameField = new JTextField();
        this.myExtractedSuperNameField.setText(StringUtil.notNullize((String)this.mySourceClass.getName()));
        super.init();
        this.updateDialog();
    }

    @Nullable
    protected JComponent createActionComponent() {
        if (DialectDetector.isJavaScript((PsiElement)this.mySourceClass)) {
            return null;
        }
        Box box = Box.createHorizontalBox();
        String s = StringUtil.decapitalize((String)this.getEntityName());
        this.myRbExtractSuperclass = new JRadioButton();
        this.myRbExtractSuperclass.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{s}));
        box.add(this.myRbExtractSuperclass);
        box.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbExtractSuperclass);
        this.myExtractAndTurnRefsRB = new JRadioButton(JSBundle.message((String)"extract.0.turn.refs", (Object[])new Object[]{StringUtil.decapitalize((String)this.getEntityName())}));
        buttonGroup.add(this.myExtractAndTurnRefsRB);
        box.add((Component)this.myExtractAndTurnRefsRB, 1);
        this.myExtractAndTurnRefsRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ES6ExtractSuperDialog.this.updateDialog();
            }
        });
        this.myRbExtractSuperclass.setSelected(true);
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ES6ExtractSuperDialog.this.updateDialog();
            }
        };
        this.myRbExtractSuperclass.addItemListener(listener2);
        return box;
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(this.getTopLabelText()), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add(_panel);
        JComponent actionComponent = this.createActionComponent();
        if (actionComponent != null) {
            box.add(Box.createVerticalStrut(10));
            box.add(actionComponent);
            box.add(Box.createVerticalStrut(10));
        }
        this.myClassNameLabel = new JLabel();
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        JLabel destinationFileLabel = new JLabel();
        destinationFileLabel.setText(JSBundle.message((String)"es6.extract.super.destination.label", (Object[])new Object[0]));
        _panel.add((Component)destinationFileLabel, "North");
        _panel.add((Component)this.myDestinationFileField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    public String getExtractedSuperName() {
        return this.myExtractedSuperNameField.getText().trim();
    }

    protected void doAction() {
        String extractedSuperName = this.getExtractedSuperName();
        if (extractedSuperName != null && extractedSuperName.isEmpty()) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage(this.getExtractedSuperNameNotSpecifiedMessage());
            return;
        }
        String nameError = this.validateName(extractedSuperName);
        if (nameError != null) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage(nameError);
            return;
        }
        if (StringUtil.equals((CharSequence)extractedSuperName, (CharSequence)this.mySourceClass.getName())) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage("Different name expected");
            return;
        }
        Ref errorString = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                String validationMessage = ES6MoveModuleMembersDialog.checkOrCreateFile(this.myProject, this.myDestinationFileField.getText(), this.getTitle());
                if (!StringUtil.isNotEmpty((String)validationMessage)) {
                    errorString.set((Object)validationMessage);
                }
            }
            catch (IncorrectOperationException e) {
                errorString.set((Object)e.getMessage());
                this.myDestinationFileField.requestFocusInWindow();
            }
        }, JSBundle.message((String)"es6.move.module.members.refactoring.create.file", (Object[])new Object[0]), null);
        if (errorString.get() != null) {
            this.showErrorMessage((String)errorString.get());
            return;
        }
        this.invokeRefactoring(this.createProcessor());
        this.closeOKAction();
    }

    private void showErrorMessage(String s) {
        if (StringUtil.isNotEmpty((String)s)) {
            CommonRefactoringUtil.showErrorMessage((String)this.myRefactoringName, (String)s, (String)this.getHelpId(), (Project)this.myProject);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return this.myIsExtractInterface ? RefactoringBundle.message((String)"no.interface.name.specified") : RefactoringBundle.message((String)"no.superclass.name.specified");
    }

    protected String getTopLabelText() {
        return this.myIsExtractInterface ? RefactoringBundle.message((String)"extract.interface.from") : RefactoringBundle.message((String)"extract.superclass.from");
    }

    protected BaseRefactoringProcessor createProcessor() {
        ES6ExtractSuperParameters parameters = new ES6ExtractSuperParameters(this.mySourceClass, (JSMemberInfo[])ArrayUtil.toObjectArray(this.getSelectedMemberInfos(), JSMemberInfo.class), this.getExtractedSuperName(), this.myDestinationFileField.getText(), 2, this.getMode(), !this.myIsExtractInterface);
        return new ES6ExtractSuperProcessor(parameters);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String message = this.myIsExtractInterface ? JSBundle.message((String)"es6.extract.super.members.in.interface", (Object[])new Object[0]) : JSBundle.message((String)"es6.extract.super.members.in.superclass", (Object[])new Object[0]);
        String abstractColumnHeader = this.myIsExtractInterface ? null : RefactoringBundle.message((String)"make.abstract");
        JSMemberSelectionPanel memberSelectionPanel = new JSMemberSelectionPanel(message, this.myMemberInfos, abstractColumnHeader);
        MyMemberInfoModel model = new MyMemberInfoModel(this.mySourceClass);
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)model);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)model);
        model.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        panel.add((Component)memberSelectionPanel, "Center");
        return panel;
    }

    protected String getHelpId() {
        return DialectDetector.isTypeScript((PsiElement)this.mySourceClass) ? (this.myIsExtractInterface ? "reference.typescript.extract.interface" : "reference.typescript.extract.superclass") : "reference.javascript.extract.superclass";
    }

    protected String getClassNameLabelText() {
        return this.myIsExtractInterface ? RefactoringBundle.message((String)"interface.name.prompt") : RefactoringBundle.message((String)"superclass.name");
    }

    protected String getEntityName() {
        return this.myIsExtractInterface ? RefactoringBundle.message((String)"extractSuperInterface.interface") : RefactoringBundle.message((String)"ExtractSuperClass.superclass");
    }

    protected JTextField createSourceClassField() {
        JTextField result2 = new JTextField(this.mySourceClass.getName());
        result2.setEnabled(false);
        result2.setEditable(false);
        return result2;
    }

    @Nullable
    protected String validateName(String name) {
        if (name != null && name.isEmpty()) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!JSUtils.isValidClassName(name, false)) {
            return JSBundle.message((String)"0.is.not.a.legal.name", (Object[])new Object[]{name});
        }
        return null;
    }

    public Collection<JSMemberInfo> getSelectedMemberInfos() {
        return Arrays.asList(JSMemberInfo.getSelected(this.myMemberInfos, this.mySourceClass, (Condition<JSMemberInfo>)Conditions.alwaysTrue()));
    }

    protected JSExtractSuperMode getMode() {
        if (this.myRbExtractSuperclass != null && this.myRbExtractSuperclass.isSelected()) {
            return JSExtractSuperMode.ExtractSuper;
        }
        if (this.myExtractAndTurnRefsRB != null && this.myExtractAndTurnRefsRB.isSelected()) {
            return JSExtractSuperMode.ExtractSuperTurnRefs;
        }
        return JSExtractSuperMode.ExtractSuper;
    }

    protected void updateDialog() {
        this.myClassNameLabel.setText(this.getClassNameLabelText());
        this.getPreviewAction().setEnabled(this.getMode() != JSExtractSuperMode.ExtractSuper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperDialog", "<init>"));
    }

    private class MyMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        public MyMemberInfoModel(JSClass aClass) {
            super(aClass, null, false, JSInterfaceContainmentVerifier.create(ES6ExtractSuperDialog.this.myMemberInfos));
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (ES6ExtractSuperDialog.this.myIsExtractInterface) {
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperDialog$MyMemberInfoModel", "checkForProblems"));
        }
    }
}

