/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.FindReferenceUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRefactoringUtil {
    public static final String _PROTO = "__proto__";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil");

    @Nullable
    public static JSPsiElementBase tryBuildInterfaceSignature(@NotNull JSElementBase member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (member instanceof JSVariable) {
            return JSRefactoringUtil.buildInterfaceProperty((JSVariable)member);
        }
        if (member instanceof JSFunction) {
            return JSRefactoringUtil.buildInterfaceSignature((JSFunction)member);
        }
        return null;
    }

    @NotNull
    public static TypeScriptPropertySignature buildInterfaceProperty(@NotNull JSVariable member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(1);
        }
        assert (!DialectDetector.isActionScript((PsiElement)member));
        JSVariable copy = member.getParent() instanceof JSVarStatement ? ((JSVarStatement)member.getParent().copy()).getVariables()[0] : (JSVariable)member.copy();
        JSRefactoringUtil.specifyInferredReturnTypeExplicitly((JSNamedElement)copy, copy.getTypeElement());
        JSRefactoringUtil.removeInitializer(copy);
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(copy.getAttributeList(), member.getProject());
        attributeListWrapper.removeAccessModifier();
        attributeListWrapper.applyTo((JSAttributeListOwner)copy);
        TypeScriptPropertySignature typeScriptPropertySignature = JSRefactoringUtil.buildInterfacePropertyFromText((JSElement)member, copy.getText());
        if (typeScriptPropertySignature == null) {
            JSRefactoringUtil.$$$reportNull$$$0(2);
        }
        return typeScriptPropertySignature;
    }

    @NotNull
    public static TypeScriptPropertySignature buildInterfacePropertyFromText(@NotNull JSElement context, @NotNull String propertyText) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (propertyText == null) {
            JSRefactoringUtil.$$$reportNull$$$0(4);
        }
        TypeScriptInterface clazz = (TypeScriptInterface)JSRefactoringUtil.buildClassOrInterface(context, (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class), "interface", propertyText);
        TypeScriptPropertySignature typeScriptPropertySignature = (TypeScriptPropertySignature)clazz.getBody().getTypeMembers()[0];
        if (typeScriptPropertySignature == null) {
            JSRefactoringUtil.$$$reportNull$$$0(5);
        }
        return typeScriptPropertySignature;
    }

    @NotNull
    public static JSFunction buildAbstractMethodSignature(@NotNull JSFunction method) {
        if (method == null) {
            JSRefactoringUtil.$$$reportNull$$$0(6);
        }
        JSFunction jSFunction = JSRefactoringUtil.buildFunctionSignature(method, "class", (Consumer<JSAttributeListWrapper>)((Consumer)attributes -> attributes.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, true)));
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(7);
        }
        return jSFunction;
    }

    @NotNull
    public static JSFunction buildInterfaceSignature(@NotNull JSFunction method) {
        if (method == null) {
            JSRefactoringUtil.$$$reportNull$$$0(8);
        }
        JSFunction jSFunction = JSRefactoringUtil.buildFunctionSignature(method, "interface", (Consumer<JSAttributeListWrapper>)((Consumer)attributes -> attributes.removeAccessModifier()));
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(9);
        }
        return jSFunction;
    }

    @NotNull
    private static JSFunction buildFunctionSignature(@NotNull JSFunction originalMethod, String classKeyword, @NotNull Consumer<JSAttributeListWrapper> configureAttributeList) {
        if (originalMethod == null) {
            JSRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (configureAttributeList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(11);
        }
        JSClass containingClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)originalMethod, JSClass.class);
        JSFunction signature = (JSFunction)originalMethod.copy();
        JSRefactoringUtil.specifyInferredReturnTypeExplicitly((JSNamedElement)signature, signature.getReturnTypeElement());
        JSSourceElement[] body = signature.getBody();
        assert (body.length < 2);
        if (body.length > 0) {
            body[0].delete();
        }
        if (signature.getLastChild() instanceof PsiWhiteSpace) {
            signature.getLastChild().delete();
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(signature.getAttributeList(), originalMethod.getProject());
        wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
        wrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, false);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, false);
        configureAttributeList.consume((Object)wrapper);
        wrapper.applyTo((JSAttributeListOwner)signature);
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)signature);
        if (dialect != null && dialect.isTypeScript) {
            for (JSParameter parameter : signature.getParameterVariables()) {
                JSRefactoringUtil.removeInitializer((JSVariable)parameter);
            }
        }
        JSClass clazz = JSRefactoringUtil.buildClassOrInterface((JSElement)originalMethod, containingClass, classKeyword, signature.getText());
        JSFunction jSFunction = (JSFunction)ObjectUtils.assertNotNull((Object)clazz.findFunctionByName(signature.getName()));
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(12);
        }
        return jSFunction;
    }

    @NotNull
    private static JSClass buildClassOrInterface(@NotNull JSElement context, @Nullable JSClass clazz, @NotNull String classKeyword, @NotNull String memberText) {
        TypeScriptTypeParameterList typeParameterList;
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (classKeyword == null) {
            JSRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (memberText == null) {
            JSRefactoringUtil.$$$reportNull$$$0(15);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile());
        StringBuilder builder = new StringBuilder();
        builder.append(classKeyword);
        builder.append(" Foo ");
        TypeScriptTypeParameterList typeScriptTypeParameterList = typeParameterList = clazz instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)clazz).getTypeParameterList() : null;
        if (typeParameterList != null) {
            builder.append(typeParameterList.getText());
        }
        builder.append("{");
        builder.append(memberText);
        builder.append(semicolon);
        builder.append("}");
        String text = builder.toString();
        JSClass jSClass = (JSClass)ObjectUtils.assertNotNull((Object)JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)context, JSClass.class));
        if (jSClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(16);
        }
        return jSClass;
    }

    private static void removeInitializer(@NotNull JSVariable variable) {
        JSExpression initializer;
        PsiElement eqSign;
        if (variable == null) {
            JSRefactoringUtil.$$$reportNull$$$0(17);
        }
        PsiElement psiElement = eqSign = (initializer = variable.getInitializer()) != null ? JSPsiImplUtils.findPrevCodeElement((PsiElement)initializer) : null;
        if (initializer != null && eqSign != null && eqSign.getNode().getElementType() == JSTokenTypes.EQ) {
            variable.deleteChildRange(eqSign, (PsiElement)initializer);
        }
    }

    private static void specifyInferredReturnTypeExplicitly(@NotNull JSNamedElement member, @Nullable PsiElement typeDeclaration) {
        DialectOptionHolder dialect;
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(18);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)member)) != null && dialect.isTypeScript && typeDeclaration == null && !TypeScriptPsiUtil.returnTypeAnnotationForbidden((JSElement)member)) {
            JSType inferredType = (JSType)ObjectUtils.coalesce((Object)TypeFromUsageDetector.detectTypeFromUsage((PsiElement)member), (Object)((Object)JSAnyType.get((PsiElement)member, true)));
            JSRefactoringUtil.setType((JSElement)member, TypeScriptUtil.getShortestTypeNameInContext(inferredType, (PsiElement)member));
        }
    }

    @Nullable
    public static String removeFromReferenceList(@NotNull JSReferenceList refList, @NotNull JSClass aClass, @NotNull Collection<FormatFixer> formatters) {
        JSReferenceExpression ref;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (aClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (formatters == null) {
            JSRefactoringUtil.$$$reportNull$$$0(21);
        }
        if ((ref = JSRefactoringUtil.findReferenceToClass(refList, aClass)) != null) {
            String refText = ref.getText();
            if (XmlBackedJSClassImpl.isImplementsAttribute((JSFile)refList.getContainingFile())) {
                ((XmlBackedJSClassImpl)JSResolveUtil.findParentClass((JSFile)refList.getContainingFile())).removeFromImplementsList(refText);
            } else {
                formatters.add(FormatFixer.create(JSRefactoringUtil.getElementToFormat((PsiElement)ref), FormatFixer.Mode.FirstLinebreak));
                ref.delete();
            }
            return refText;
        }
        return null;
    }

    @Nullable
    private static JSReferenceExpression findReferenceToClass(@NotNull JSReferenceList refList, @NotNull JSClass aClass) {
        String name;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(23);
        }
        if ((name = aClass.getQualifiedName()) == null) {
            return null;
        }
        return JSRefactoringUtil.findReferenceToClass(refList, name);
    }

    @Nullable
    private static JSReferenceExpression findReferenceToClass(@NotNull JSReferenceList refList, @NotNull String name) {
        JSExpression[] expressions;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(25);
        }
        if ((expressions = refList.getExpressions()).length == 0) {
            return null;
        }
        for (JSExpression expression : expressions) {
            String typeName;
            if (!(expression instanceof JSReferenceExpression) || !name.equals(typeName = JSImportHandlingUtil.resolveTypeName(expression.getText(), (PsiElement)refList))) continue;
            return (JSReferenceExpression)expression;
        }
        return null;
    }

    public static void addToSupersList(@NotNull JSClass clazz, @Nullable String refText, boolean isInterface) {
        JSReferenceList newReferenceList;
        JSReferenceList existing;
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (refText == null) {
            return;
        }
        if (clazz instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)clazz).addToImplementsList(refText);
            return;
        }
        boolean addToExtends = clazz.isInterface() || !isInterface;
        JSReferenceList jSReferenceList = existing = addToExtends ? clazz.getExtendsList() : clazz.getImplementsList();
        if (existing != null && JSRefactoringUtil.findReferenceToClass(existing, refText) != null) {
            return;
        }
        String text = "class Foo " + (addToExtends ? "extends " : "implements ") + refText;
        JSClass c = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)clazz, JSClass.class);
        if (c == null) {
            return;
        }
        JSReferenceList jSReferenceList2 = newReferenceList = addToExtends ? c.getExtendsList() : c.getImplementsList();
        if (newReferenceList == null) {
            return;
        }
        if (existing != null) {
            if (existing.getExpressions().length > 0) {
                existing.addAfter(JSChangeUtil.createCommaPsiElement((PsiElement)existing), existing.getLastChild());
            }
            existing.addAfter((PsiElement)newReferenceList.getExpressions()[0], existing.getLastChild());
        } else {
            TypeScriptTypeParameterList typeParameterList = clazz instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)clazz).getTypeParameterList() : null;
            List candidates = ContainerUtil.list((Object[])new PsiElement[]{clazz.getExtendsList(), typeParameterList, clazz.getNameIdentifier(), clazz.getFirstChild()});
            clazz.addAfter((PsiElement)newReferenceList, (PsiElement)ObjectUtils.coalesce((Iterable)candidates));
        }
    }

    public static void makeQualified(@NotNull JSReferenceExpression refExpr, @Nullable JSQualifiedNamedElement to, boolean force) {
        if (refExpr == null) {
            JSRefactoringUtil.$$$reportNull$$$0(27);
        }
        JSExpression qualifier = refExpr.getQualifier();
        if (to != null) {
            if (qualifier == null) {
                qualifier = (JSExpression)JSChangeUtil.createExpressionFromText(refExpr.getProject(), "IntellijIDEARulezz.IntellijIDEARulezz").getPsi();
                qualifier = (JSExpression)refExpr.addRangeBefore(qualifier.getFirstChild(), qualifier.getFirstChild().getNextSibling(), refExpr.getFirstChild());
            }
            if (force || qualifier instanceof JSReferenceExpression) {
                if (qualifier instanceof JSReferenceExpression) {
                    JSRefactoringUtil.makeQualified((JSReferenceExpression)qualifier, null, false);
                    JSReferenceExpressionImpl.bindToElement((JSReferenceExpression)qualifier, to.getQualifiedName(), (PsiNamedElement)to, true);
                } else {
                    JSRefactoringUtil.makeQualified(refExpr, null, false);
                    JSRefactoringUtil.makeQualified(refExpr, to, false);
                }
            }
        } else if (qualifier != null) {
            refExpr.deleteChildRange((PsiElement)qualifier, qualifier.getNextSibling());
        }
    }

    public static boolean isChildOfAny(PsiElement element, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrWillBeInTargetClass(PsiElement place, Collection<? extends PsiElement> membersToMove, @Nullable JSClass targetClass, boolean includeSubclasses) {
        if (JSRefactoringUtil.isChildOfAny(place, membersToMove)) {
            return true;
        }
        JSClass clazz = JSResolveUtil.getClassOfContext(place);
        if (clazz == null || targetClass == null) {
            return false;
        }
        return targetClass.equals(clazz) || includeSubclasses && JSInheritanceUtil.isParentClass(clazz, targetClass);
    }

    public static JSVarStatement getVarStatementCopy(@NotNull JSVariable member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(28);
        }
        int index = 0;
        for (JSVariable variable : (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)member.getParent(), JSVariable.class)) {
            if (member == variable) break;
            ++index;
        }
        JSVarStatement result2 = (JSVarStatement)member.getParent().copy();
        JSVariable[] newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result2, JSVariable.class);
        JSVariable newVar = newVars[index];
        while (newVars.length > 1) {
            if (newVars[0] != newVar) {
                newVars[0].delete();
            } else {
                newVars[1].delete();
            }
            newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result2, JSVariable.class);
        }
        return result2;
    }

    @Nullable
    private static JSMemberUsageInfo getUsage(JSAttributeListOwner member, PsiReference psiReference, Collection<JSAttributeListOwner> membersToMove, JSClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (!(ref instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ref;
        JSExpression qualifier = refExpr.getQualifier();
        if (JSRefactoringUtil.isOrWillBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
            if (!JSRefactoringUtil.isChildOfAny((PsiElement)refExpr, membersToMove)) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).isReferenceTo((PsiElement)JSUtils.getMemberContainingClass((PsiElement)member))) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            return null;
        }
        return new JSMemberUsageInfo(member, refExpr, targetClass, psiReference);
    }

    public static UsageInfo[] getUsages(Collection<JSAttributeListOwner> members, JSClass targetClass) {
        ArrayList<JSMemberUsageInfo> usagesList = new ArrayList<JSMemberUsageInfo>();
        for (JSAttributeListOwner member : members) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                JSMemberUsageInfo usage = JSRefactoringUtil.getUsage(member, psiReference, members, targetClass);
                if (usage == null) continue;
                usagesList.add(usage);
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(new UsageInfo[usagesList.size()]);
        usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        return usageInfos;
    }

    @Nullable
    public static JSNamespaceDeclaration getNamespace(PsiElement element) {
        PsiElement namespace;
        JSReferenceExpression namespaceRef;
        JSAttributeList attributeList;
        if (element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && (namespaceRef = attributeList.getNamespaceElement()) != null && (namespace = namespaceRef.resolve()) instanceof JSNamespaceDeclaration) {
            return (JSNamespaceDeclaration)namespace;
        }
        return null;
    }

    public static void postProcess(@Nullable PsiElement sourceClassOrFile, JSQualifiedNamedElement targetClass, Collection<PsiFile> filesWithExternalUsages, Collection<String> importsInTargetFile, Collection<String> namespacesInTargetFile, List<FormatFixer> postponedFormatters, boolean allowFormat, boolean forceOptimizeImports) {
        String targetFqn;
        String targetPackageName;
        if (sourceClassOrFile != null) {
            PsiFile sourceFile = sourceClassOrFile instanceof JSClass ? (sourceClassOrFile instanceof XmlBackedJSClass ? sourceClassOrFile.getParent().getContainingFile() : sourceClassOrFile.getContainingFile()) : (PsiFile)sourceClassOrFile;
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(sourceFile));
        }
        if ((targetPackageName = StringUtil.getPackageName((String)(targetFqn = targetClass.getQualifiedName()))).length() > 0) {
            for (PsiFile file : filesWithExternalUsages) {
                Object place = file instanceof JSFile ? JSPsiImplUtils.findPackageStatement((JSFile)file) : XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
                if (place == null) continue;
                String placeFqn = place.getQualifiedName();
                if (placeFqn == null || !targetPackageName.equals(StringUtil.getPackageName((String)placeFqn))) {
                    ImportUtils.insertImportStatements((PsiElement)place, Collections.singletonList(targetFqn));
                }
                postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
            }
        }
        postponedFormatters.addAll(JSRefactoringUtil.addUseNamespaceDirectives(targetClass, namespacesInTargetFile));
        if (!importsInTargetFile.isEmpty() || forceOptimizeImports) {
            PsiFile file = targetClass.getContainingFile();
            ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
        }
        if (allowFormat) {
            JSRefactoringUtil.format(postponedFormatters);
        }
    }

    public static Collection<FormatFixer> addUseNamespaceDirectives(JSQualifiedNamedElement targetClass, Collection<String> namespaces) {
        JSUseNamespaceDirective[] existing;
        if (namespaces.isEmpty()) {
            return Collections.emptyList();
        }
        JSQualifiedNamedElement container = targetClass;
        if (container.getParent() instanceof JSPackageStatement) {
            container = (JSElement)container.getParent();
        }
        if ((existing = (JSUseNamespaceDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)container, JSUseNamespaceDirective.class)) != null) {
            for (JSUseNamespaceDirective directive : existing) {
                PsiElement resolved;
                JSReferenceExpression ref = directive.getNamespaceReference();
                if (ref == null || !((resolved = ref.resolve()) instanceof JSNamespaceDeclaration)) continue;
                String qName = ((JSNamespaceDeclaration)resolved).getQualifiedName();
                Iterator<String> i = namespaces.iterator();
                while (i.hasNext()) {
                    if (!qName.equals(i.next())) continue;
                    i.remove();
                    if (!namespaces.isEmpty()) continue;
                    return Collections.emptyList();
                }
            }
        }
        ArrayList<String> sortedNamespaces = new ArrayList<String>(namespaces);
        Collections.sort(sortedNamespaces, (o1, o2) -> -StringUtil.getShortName((String)o1).compareTo(StringUtil.getShortName((String)o2)));
        PsiElement anchor = JSRefactoringUtil.getImportDirectiveAnchor((JSElement)container);
        PsiElement firstAdded = null;
        PsiElement lastAdded = null;
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        for (String namespace : sortedNamespaces) {
            String text = "use namespace " + namespace + JSCodeStyleSettings.getSemicolon((PsiElement)targetClass.getContainingFile());
            PsiElement newDirective = JSChangeUtil.createJSTreeFromText(targetClass.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement added = container.addBefore(newDirective, anchor);
            if (firstAdded == null) {
                firstAdded = added;
            }
            lastAdded = added;
            anchor = added;
        }
        formatters.add(FormatFixer.create(firstAdded, lastAdded, FormatFixer.Mode.Reformat));
        return formatters;
    }

    private static PsiElement getImportDirectiveAnchor(JSElement targetClass) {
        PsiElement anchor = targetClass instanceof XmlBackedJSClassImpl ? ((XmlBackedJSClassImpl)targetClass).findFirstScriptTag().getFirstChild() : ImportUtils.findLBrace(targetClass);
        while (anchor instanceof PsiWhiteSpace || anchor instanceof JSImportStatement || !(anchor instanceof JSSourceElement)) {
            anchor = anchor.getNextSibling();
        }
        return anchor;
    }

    public static void format(List<FormatFixer> postponedFormatters) {
        postponedFormatters = FormatFixer.merge(postponedFormatters);
        FormatFixer.fixAll(postponedFormatters);
    }

    public static PsiElement getElementToFormat(PsiElement element) {
        JSReferenceListMember member;
        if (element instanceof JSVariable && ((JSVarStatement)element.getParent()).getVariables().length == 1) {
            element = element.getParent();
        } else if (element instanceof JSReferenceExpression && element.getParent() instanceof JSReferenceListMember && ((JSReferenceList)(member = (JSReferenceListMember)element.getParent()).getParent()).getExpressions().length == 1) {
            element = member.getParent();
        }
        return element;
    }

    public static JSFunction buildImplementationMethod(JSFunction method, JSClass targetClass) {
        MultiMap types = MultiMap.createSet();
        for (String type : BaseCreateMembersFix.getFunctionTypes(method)) {
            String resovled = JSImportHandlingUtil.resolveTypeName(type, (PsiElement)method);
            if (type.indexOf(46) == -1 && resovled.equals(type)) continue;
            types.putValue((Object)JSResolveUtil.getShortTypeName(type, false), (Object)resovled);
        }
        ImplementMethodsFix fix = new ImplementMethodsFix(targetClass);
        String text = fix.buildFunctionText(method, (MultiMap<String, String>)types);
        PsiElement element = JSChangeUtil.createJSTreeFromText(method.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
        return (JSFunction)element;
    }

    public static void addRemovalFormatters(JSClass sourceClass, Collection<? extends PsiElement> movedMembers, Condition<JSFunction> withMethodsAsdoc, Condition<JSVariable> withFieldsAsdoc, List<FormatFixer> result2) {
        ArrayList<PsiElement> removed = new ArrayList<PsiElement>();
        for (PsiElement psiElement : movedMembers) {
            PsiElement comment;
            if ((psiElement instanceof JSFunction && !withMethodsAsdoc.value((Object)((JSFunction)psiElement)) || psiElement instanceof JSVariable && !withFieldsAsdoc.value((Object)((JSVariable)psiElement))) && (comment = JSRefactoringUtil.findDocComment(psiElement)) != null) {
                removed.add(comment);
            }
            removed.add(JSRefactoringUtil.getElementToFormat(psiElement));
        }
        if (sourceClass instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)sourceClass).processInjectedFiles((Processor<JSFile>)((Processor)jsFile -> {
                JSRefactoringUtil.processParent((PsiElement)jsFile, movedMembers, result2, removed);
                return true;
            }));
        } else {
            JSRefactoringUtil.processParent((PsiElement)sourceClass, movedMembers, result2, removed);
        }
    }

    private static void processParent(PsiElement parent, Collection<? extends PsiElement> movedMembers, List<FormatFixer> result2, Collection<PsiElement> removed) {
        PsiElement from = null;
        PsiElement to = null;
        for (PsiElement e = parent.getFirstChild(); e != null; e = e.getNextSibling()) {
            boolean elementWillBeRemoved;
            if (e instanceof JSVarStatement) {
                elementWillBeRemoved = true;
                for (JSVariable var : ((JSVarStatement)e).getVariables()) {
                    if (movedMembers.contains(var)) continue;
                    elementWillBeRemoved = false;
                    break;
                }
            } else {
                elementWillBeRemoved = removed.contains(e);
            }
            if (elementWillBeRemoved) {
                if (from == null) {
                    from = e;
                }
                to = e;
                continue;
            }
            if (e instanceof PsiWhiteSpace || from == null) continue;
            result2.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
            to = null;
            from = null;
        }
        if (from != null) {
            result2.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
        }
    }

    public static void deleteWithNoPostponedFormatting(PsiElement toDelete) {
        PostprocessReformattingAspect.getInstance((Project)toDelete.getProject()).disablePostprocessFormattingInside(() -> toDelete.delete());
    }

    public static PsiElement findDocComment(PsiElement element) {
        PsiElement elementForWhichPreviousCommentWillBeSearched = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(element, null);
        if (elementForWhichPreviousCommentWillBeSearched == null) {
            return null;
        }
        PsiComment comment = JSDocumentationUtils.findDocComment(elementForWhichPreviousCommentWillBeSearched);
        return comment instanceof JSDocComment ? comment : null;
    }

    @Nullable
    private static String checkCanCreateFile(PsiDirectory directory, String className) {
        for (VirtualFile file : directory.getVirtualFile().getChildren()) {
            if (!className.equals(file.getNameWithoutExtension()) || !FileTypeManager.getInstance().isFileOfType(file, (FileType)JavaScriptSupportLoader.JAVASCRIPT) && !JavaScriptSupportLoader.isMxmlOrFxgFile(file)) continue;
            return JSBundle.message((String)"directory.already.contains.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), file.getName()});
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, Boolean> getMemberInsertionAnchor(@NotNull PsiElement membersHolder, @NotNull Condition<PsiElement> isFunction, @NotNull Condition<PsiElement> isField, @NotNull Condition<PsiElement> toSkip, boolean forField) {
        PsiElement result2;
        if (membersHolder == null) {
            JSRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (isFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (isField == null) {
            JSRefactoringUtil.$$$reportNull$$$0(31);
        }
        if (toSkip == null) {
            JSRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (membersHolder instanceof XmlBackedJSClassImpl) {
            result2 = ((XmlBackedJSClassImpl)membersHolder).createOrGetFirstScriptTag().getFirstChild();
        } else {
            ASTNode lBrace = membersHolder.getNode().findChildByType(JSTokenTypes.LBRACE);
            PsiElement psiElement = result2 = lBrace != null ? lBrace.getPsi() : null;
        }
        if (result2 == null) {
            return null;
        }
        PsiElement e = result2;
        while (e != null) {
            if (toSkip.value((Object)e)) {
                result2 = e;
            } else if (isFunction.value((Object)e)) {
                if (forField) {
                    return Pair.create((Object)e, (Object)true);
                }
                result2 = e;
            } else if (isField.value((Object)e)) {
                result2 = e;
            }
            e = JSRefactoringUtil.skipWhitespaces(e, true);
        }
        PsiElement next = JSRefactoringUtil.skipWhitespaces(result2, true);
        if (next == null) {
            return null;
        }
        if (next.getNode().getElementType() == JSTokenTypes.RBRACE) {
            return Pair.create((Object)next, (Object)true);
        }
        return Pair.create((Object)result2, (Object)false);
    }

    @Nullable
    public static PsiElement skipWhitespaces(PsiElement element, boolean forward) {
        PsiElement psiElement = element = forward ? element.getNextSibling() : element.getPrevSibling();
        while (element instanceof PsiWhiteSpace) {
            element = forward ? element.getNextSibling() : element.getPrevSibling();
        }
        return element;
    }

    public static PsiElement addMemberToTargetClass(@NotNull JSClass clazz, @NotNull PsiElement element) {
        Condition toSkip;
        Condition fieldFilter;
        Condition functionFilter;
        JSClass membersHolder;
        Pair<PsiElement, Boolean> anchor;
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(34);
        }
        if ((anchor = JSRefactoringUtil.getMemberInsertionAnchor((PsiElement)(membersHolder = clazz instanceof TypeScriptInterface ? ((TypeScriptInterface)clazz).getBody() : clazz), (Condition<PsiElement>)(functionFilter = e -> {
            if (clazz == null) {
                JSRefactoringUtil.$$$reportNull$$$0(57);
            }
            return clazz instanceof TypeScriptInterface ? e instanceof TypeScriptTypeMember && !(e instanceof TypeScriptPropertySignature) : e instanceof JSFunction;
        }), (Condition<PsiElement>)(fieldFilter = e -> e instanceof JSVarStatement || e instanceof TypeScriptPropertySignature), (Condition<PsiElement>)(toSkip = e -> {
            if (clazz == null) {
                JSRefactoringUtil.$$$reportNull$$$0(56);
            }
            if (clazz instanceof TypeScriptInterface) {
                IElementType elementType = e.getNode().getElementType();
                return elementType == JSTokenTypes.COMMA || elementType == JSTokenTypes.SEMICOLON;
            }
            return false;
        }), fieldFilter.value((Object)element))) == null) {
            return membersHolder.add(element);
        }
        if (((Boolean)anchor.second).booleanValue()) {
            return membersHolder.addBefore(element, (PsiElement)anchor.first);
        }
        return membersHolder.addAfter(element, (PsiElement)anchor.first);
    }

    public static void handleDocCommentAndFormat(PsiElement newImmediateMember, List<FormatFixer> postponedFormatters) {
        PsiElement reformatTo = newImmediateMember.getNextSibling() instanceof PsiWhiteSpace ? newImmediateMember.getNextSibling() : newImmediateMember;
        postponedFormatters.add(FormatFixer.create(newImmediateMember, reformatTo, FormatFixer.Mode.Reformat));
    }

    @Nullable
    public static PsiElement createTypeElement(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            JSRefactoringUtil.$$$reportNull$$$0(35);
        }
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(36);
        }
        PsiElement element = JSChangeUtil.createStatementFromTextWithContext("var x:" + type, context).getPsi();
        return ((JSVarStatement)element).getVariables()[0].getTypeElement();
    }

    public static void setType(@NotNull JSElement declaration, @Nullable String type) {
        if (declaration == null) {
            JSRefactoringUtil.$$$reportNull$$$0(37);
        }
        if (declaration instanceof JSFunction) {
            JSRefactoringUtil.setType(declaration, type, ((JSFunction)declaration).getReturnTypeElement(), (PsiElement)((JSFunction)declaration).getParameterList());
        }
        if (declaration instanceof JSTypeDeclarationOwner) {
            PsiElement anchor = declaration instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)declaration).getNameIdentifier() : (declaration instanceof JSDestructuringElement ? ((JSDestructuringElement)declaration).getTarget() : null);
            JSRefactoringUtil.setType(declaration, type, ((JSTypeDeclarationOwner)declaration).getTypeElement(), anchor);
        }
    }

    private static void setType(@NotNull JSElement target, @Nullable String type, @Nullable PsiElement existingTypeElement, @Nullable PsiElement insertionAnchor) {
        DialectOptionHolder dialect;
        if (target == null) {
            JSRefactoringUtil.$$$reportNull$$$0(38);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)target)) == null || !dialect.isECMA4 && !dialect.isTypeScript) {
            return;
        }
        if (StringUtil.isEmpty((String)type)) {
            if (existingTypeElement != null) {
                PsiElement deleteFrom = existingTypeElement.getPrevSibling();
                while (deleteFrom instanceof PsiWhiteSpace) {
                    deleteFrom = deleteFrom.getPrevSibling();
                }
                target.deleteChildRange(deleteFrom, existingTypeElement);
            }
        } else {
            PsiElement newTypeElement = (PsiElement)ObjectUtils.assertNotNull((Object)JSRefactoringUtil.createTypeElement(type, (PsiElement)target));
            if (existingTypeElement != null) {
                existingTypeElement.replace(newTypeElement);
            } else {
                target.addRangeAfter(newTypeElement.getPrevSibling(), newTypeElement, insertionAnchor);
            }
        }
    }

    public static boolean isResolvableType(String typeText, PsiElement context, boolean allowEmpty, boolean allowEllipsis) {
        if (StringUtil.isEmpty((String)typeText)) {
            return allowEmpty;
        }
        if ("void".equals(typeText) || "*".equals(typeText) || allowEllipsis && "...".equals(typeText)) {
            return true;
        }
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
        if (signature != null) {
            if (!"Vector".equals(signature.elementType)) {
                return false;
            }
            typeText = signature.genericType;
        }
        return JSResolveUtil.findType(typeText, context, true) != null;
    }

    public static boolean isValidIdentifier(String name, Project project) {
        return !"as".equals(name) && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE)).isIdentifier(name, project);
    }

    @Nullable
    public static PsiDirectory chooseOrCreateDirectoryForClass(@NotNull Project project, @Nullable Module module, GlobalSearchScope scope, @NotNull String packageName, @Nullable String className, @Nullable PsiDirectory baseDir, ThreeState chooseFlag) {
        if (project == null) {
            JSRefactoringUtil.$$$reportNull$$$0(39);
        }
        if (packageName == null) {
            JSRefactoringUtil.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (className != null) {
            String qName = StringUtil.getQualifiedName((String)packageName, (String)className);
            PsiElement clazz = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qName, scope);
            if (clazz != null) {
                String message = JSBundle.message((String)"item.already.exists", (Object[])new Object[]{StringUtil.capitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)((JSNamedElement)clazz)).humanReadableKey(), (Object[])new Object[0])), qName});
                Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
                return null;
            }
        }
        Ref error = new Ref();
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                JSRefactoringUtil.$$$reportNull$$$0(54);
            }
            if (packageName == null) {
                JSRefactoringUtil.$$$reportNull$$$0(55);
            }
            try {
                result2.set((Object)PlatformPackageUtil.findOrCreateDirectoryForPackage((Project)project, (Module)module, (GlobalSearchScope)scope, (String)packageName, (PsiDirectory)baseDir, (boolean)true, (ThreeState)chooseFlag));
                if (result2.isNull()) {
                    error.set((Object)"");
                    return;
                }
                if (className != null) {
                    error.set((Object)JSRefactoringUtil.checkCanCreateFile((PsiDirectory)result2.get(), className));
                }
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e.getMessage());
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (!error.isNull() && ((String)error.get()).length() > 0) {
            Messages.showErrorDialog((Project)project, (String)((String)error.get()), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return (PsiDirectory)result2.get();
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @Nullable Editor editor, String title) {
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(41);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)element.getProject(), (PsiElement)element)) {
            return false;
        }
        if (JSProjectUtil.isInLibrary(element)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"cannot.modify.library.code", (Object[])new Object[0])), (String)StringUtil.capitalizeWords((String)title, (boolean)true), null);
            return false;
        }
        return true;
    }

    public static void addConstructorUsages(JSClass clazz, Collection<UsageInfo> result2) {
        JSFunction constructor = clazz.getConstructor();
        if (constructor != null) {
            ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope()).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                if (!(element instanceof JSReferenceExpression)) {
                    return true;
                }
                result2.add(new ConstructorUsageInfo((JSReferenceExpression)element, clazz));
                return true;
            });
        }
    }

    public static SearchScope getElementSearchScope(PsiElement element) {
        return new LocalSearchScope((PsiElement)element.getContainingFile());
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformVarNameToAccessorName(@Nullable String s, Project project) {
        return JSRefactoringUtil.transformVarNameToAccessorName(s, (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class));
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformVarNameToAccessorName(@Nullable String s, JSCodeStyleSettings codeStyleSettings) {
        if (s == null) {
            return null;
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)codeStyleSettings.FIELD_PREFIX)) {
            s = s.substring(codeStyleSettings.FIELD_PREFIX.length());
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)("\"" + codeStyleSettings.FIELD_PREFIX))) {
            s = "\"" + s.substring(codeStyleSettings.FIELD_PREFIX.length() + 1);
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)("'" + codeStyleSettings.FIELD_PREFIX))) {
            s = "'" + s.substring(codeStyleSettings.FIELD_PREFIX.length() + 1);
        }
        s = s.startsWith("\"") ? "\"" + codeStyleSettings.PROPERTY_PREFIX + s.substring(1) : (s.startsWith("'") ? "'" + codeStyleSettings.PROPERTY_PREFIX + s.substring(1) : codeStyleSettings.PROPERTY_PREFIX + s);
        return s;
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformAccessorNameToPropertyName(@Nullable String varName, Project project) {
        if (varName == null) {
            return null;
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCustomSettings(JSCodeStyleSettings.class);
        varName = StringUtil.trimStart((String)varName, (String)settings.PROPERTY_PREFIX);
        varName = settings.FIELD_PREFIX + varName;
        return varName;
    }

    public static List<PsiElement> mergeDeclarationAndAssignment(JSVarStatement varStatement) {
        ArrayList<PsiElement> modified = new ArrayList<PsiElement>();
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)varStatement);
        boolean hasType = holder != null && (holder.isECMA4 || holder.isTypeScript);
        SmartList toRemove = new SmartList();
        JSVariable[] variables = varStatement.getVariables();
        List<JSVariable> mergeable = Arrays.stream(variables).filter(v -> !v.hasInitializer()).collect(Collectors.toList());
        if (mergeable.isEmpty()) {
            return Collections.emptyList();
        }
        NewLineEraser varStatementEraser = new NewLineEraser((PsiElement)varStatement);
        SmartList erasers = new SmartList();
        boolean allVariablesConverted = mergeable.size() == variables.length;
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)varStatement);
        mergeable.forEach(arg_0 -> JSRefactoringUtil.lambda$mergeDeclarationAndAssignment$11(hasType, varStatement, (List)erasers, allVariablesConverted, modified, commentsMover, (List)toRemove, arg_0));
        toRemove.forEach(v -> v.delete());
        if (allVariablesConverted || !commentsMover.hasAfterComments()) {
            varStatementEraser.process();
        }
        erasers.forEach(eraser -> eraser.process());
        if (varStatement.isValid()) {
            modified.add((PsiElement)varStatement);
        }
        modified.forEach(s -> JSElementFactory.reformat(s));
        return modified;
    }

    public static boolean isModuleExportsOrExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "exports"));
    }

    public static boolean isModuleExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports");
    }

    public static void reformatElementWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (expression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(43);
        }
        JSRefactoringUtil.createFixerForReformatWithoutBody(statement, expression).fixFormat();
    }

    public static FormatFixer createFixerForReformatWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        PsiComment firstChild;
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(44);
        }
        if (expression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(45);
        }
        ASTNode leftBrace = JSRefactoringUtil.getLeftBrace(expression);
        PsiComment jsDoc = JSDocumentationUtils.findDocComment(statement);
        Object object = firstChild = jsDoc instanceof JSDocComment ? jsDoc : statement.getFirstChild();
        if (firstChild != null && leftBrace != null) {
            return FormatFixer.create((PsiElement)firstChild, leftBrace.getPsi(), FormatFixer.Mode.ReformatExactRange);
        }
        return FormatFixer.create(statement, FormatFixer.Mode.Reformat);
    }

    @Nullable
    public static ASTNode getLeftBrace(PsiElement element) {
        JSBlockStatement blockStatement;
        ASTNode leftBrace = element.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (leftBrace == null && (blockStatement = (JSBlockStatement)PsiTreeUtil.findChildOfType((PsiElement)element, JSBlockStatement.class)) != null) {
            leftBrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
        }
        return leftBrace;
    }

    public static void deleteSiblingWhitespace(PsiElement element, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling = element;
        if (deleteBefore) {
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = element;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
    }

    @NotNull
    public static JSElement classDeclarationFromClassExpression(@NotNull Project project, @NotNull JSClass clazz, @NotNull String name, boolean isExport) {
        if (project == null) {
            JSRefactoringUtil.$$$reportNull$$$0(46);
        }
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(47);
        }
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(48);
        }
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, (isExport ? "export " : "") + "class " + name + "{}", DialectDetector.languageDialectOfElement((PsiElement)clazz));
        assert (astNode != null);
        JSClass createdClass = (JSClass)astNode.getPsi(JSClass.class);
        ASTNode brace = createdClass.getNode().findChildByType(JSTokenTypes.RBRACE);
        assert (brace != null);
        ASTNode[] children = clazz.getNode().getChildren(null);
        boolean afterBracket = false;
        for (ASTNode child : children) {
            if (afterBracket) {
                if (child.getElementType() == JSTokenTypes.RBRACE) break;
                createdClass.addBefore(child.getPsi().copy(), brace.getPsi());
                continue;
            }
            if (child.getElementType() != JSTokenTypes.LBRACE) continue;
            afterBracket = true;
        }
        JSClass jSClass = createdClass;
        if (jSClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(49);
        }
        return jSClass;
    }

    @NotNull
    public static JSElement functionDeclarationFromFunctionExpression(@NotNull Project project, @NotNull JSFunction function, @NotNull String name, boolean isExport) {
        if (project == null) {
            JSRefactoringUtil.$$$reportNull$$$0(50);
        }
        if (function == null) {
            JSRefactoringUtil.$$$reportNull$$$0(51);
        }
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(52);
        }
        String text = String.format("%s%s function%s %s(){}", isExport ? "export " : "", JSFunctionsHelper.getFunctionAttributesModifiersText(function), function.isGenerator() ? "*" : "", name);
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text.trim(), DialectDetector.languageDialectOfElement((PsiElement)function));
        assert (astNode != null);
        JSFunction createdFunction = (JSFunction)astNode.getPsi(JSFunction.class);
        assert (createdFunction != null);
        JSFunctionsHelper.copyFunctionFilling(function, createdFunction);
        JSFunction jSFunction = createdFunction;
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(53);
        }
        return jSFunction;
    }

    private static /* synthetic */ void lambda$mergeDeclarationAndAssignment$11(boolean hasType, JSVarStatement varStatement, List erasers, boolean allVariablesConverted, List modified, CommentsMover commentsMover, List toRemove, JSVariable variable) {
        JSExpressionStatement assignmentStatement;
        Iterator<PsiElement> referenceIterator;
        JSReferenceExpression firstReference;
        String typePrefix = null;
        if (hasType && variable.getType() != null) {
            typePrefix = ":" + variable.getType().getTypeText(JSType.TypeTextFormat.CODE);
        }
        if (!variable.hasInitializer() && (firstReference = (JSReferenceExpression)((referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator()).hasNext() ? referenceIterator.next() : null)) != null && firstReference.getParent() instanceof JSDefinitionExpression && (assignmentStatement = (JSExpressionStatement)firstReference.getParent().getParent().getParent()) != null && assignmentStatement.getParent().equals(varStatement.getParent())) {
            String assignmentText = ((JSAssignmentExpression)firstReference.getParent().getParent()).getROperand().getText();
            String newText = String.format("%s %s%s=%s%s", varStatement.getVarKeyword().getText(), firstReference.getReferenceName(), StringUtil.notNullize((String)typePrefix), assignmentText, JSCodeStyleSettings.getSemicolon((PsiElement)varStatement.getContainingFile()));
            NewLineEraser eraser = new NewLineEraser((PsiElement)assignmentStatement);
            erasers.add(eraser);
            JSStatement statement = JSElementFactory.replaceStatement((JSStatement)assignmentStatement, newText, true);
            if (statement == null) {
                return;
            }
            if (allVariablesConverted && modified.isEmpty()) {
                Set<JSStatement> elements = Collections.singleton(statement);
                commentsMover.move(elements, elements);
            }
            eraser.registerEquivalent((PsiElement)statement);
            modified.add(statement);
            toRemove.add(variable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 49: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 49: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil";
                break;
            }
            case 3: 
            case 13: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configureAttributeList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKeyword";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refList";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatters";
                break;
            }
            case 25: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 33: 
            case 47: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersHolder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isFunction";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isField";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 39: 
            case 46: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInterfaceProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInterfacePropertyFromText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAbstractMethodSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInterfaceSignature";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassOrInterface";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "classDeclarationFromClassExpression";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "functionDeclarationFromFunctionExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryBuildInterfaceSignature";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfaceProperty";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 49: 
            case 53: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfacePropertyFromText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildAbstractMethodSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfaceSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionSignature";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildClassOrInterface";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeInitializer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "specifyInferredReturnTypeExplicitly";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeFromReferenceList";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceToClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addToSupersList";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "makeQualified";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVarStatementCopy";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMemberInsertionAnchor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addMemberToTargetClass";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "chooseOrCreateDirectoryForClass";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkReadOnlyStatus";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "reformatElementWithoutBody";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createFixerForReformatWithoutBody";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "classDeclarationFromClassExpression";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "functionDeclarationFromFunctionExpression";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$chooseOrCreateDirectoryForClass$8";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMemberToTargetClass$7";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMemberToTargetClass$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 49: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MergeDeclarationAndInitializationPredicate
    implements JSElementPredicate {
        @Nullable
        private MultiMap<String, PsiReference> myReferenceMap;

        public MergeDeclarationAndInitializationPredicate setReferenceMap(@Nullable MultiMap<String, PsiReference> referenceMap) {
            this.myReferenceMap = referenceMap;
            return this;
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeDeclarationAndInitializationPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement varStatement = (JSVarStatement)element;
            if (ErrorUtil.containsError((PsiElement)varStatement)) {
                return false;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                PsiElement parent;
                JSReferenceExpression firstReference;
                if (variable.hasInitializer() || (firstReference = this.getFirstReference(variable)) == null || !((parent = firstReference.getParent()) instanceof JSDefinitionExpression) || !(parent.getParent() instanceof JSAssignmentExpression) || !(parent.getParent().getParent() instanceof JSExpressionStatement)) continue;
                PsiElement expression = parent.getParent().getParent();
                return expression.getParent() != null && expression.getParent().equals(varStatement.getParent());
            }
            return false;
        }

        @Nullable
        private JSReferenceExpression getFirstReference(JSVariable variable) {
            if (this.myReferenceMap != null) {
                Collection references = this.myReferenceMap.get((Object)variable.getName());
                if (!references.isEmpty()) {
                    ArrayList list = new ArrayList(references);
                    Optional<PsiReference> min = list.stream().filter(reference -> {
                        PsiElement refElement = reference.getElement();
                        return refElement instanceof JSReferenceExpression && refElement.isValid() && refElement.getTextRange().getStartOffset() > variable.getTextRange().getEndOffset();
                    }).min(Comparator.comparingInt(o -> o.getElement().getTextRange().getStartOffset()));
                    return min.isPresent() ? (JSReferenceExpression)min.get() : null;
                }
                return null;
            }
            Iterator<PsiElement> referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator();
            return (JSReferenceExpression)(referenceIterator.hasNext() ? referenceIterator.next() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil$MergeDeclarationAndInitializationPredicate", "satisfiedBy"));
        }
    }

    public static class ConstructorUsageInfo
    extends UsageInfo {
        private final JSClass mySubject;

        public ConstructorUsageInfo(JSReferenceExpression ref, JSClass subject) {
            super((PsiElement)ref);
            this.mySubject = subject;
        }

        public JSClass getSubject() {
            return this.mySubject;
        }

        public JSReferenceExpression getElement() {
            return (JSReferenceExpression)super.getElement();
        }
    }
}

