/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceQueueImpl
implements JSLanguageServiceQueue {
    public static final String CANNOT_START_LANGUAGE_SERVICE_PROCESS = "Cannot start language service process";
    public static final String TIMEOUT_ON_STARTING_SERVICE_PROCESS = "Timeout on starting language service process";
    public static final String CAN_NOT_GET_RESULT_FROM_LANGUAGE_SERVICE = "Can not get result from language service";
    public static final String LANGUAGE_SERVICE_EXECUTION_TIMEOUT = "Language service execution timeout";
    @NotNull
    private final Object myLock;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    private final JSLanguageServiceProtocol myProtocol;
    @NotNull
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    private volatile JSLanguageServiceQueue.State myState;
    @Nullable
    private volatile BackgroundableProcessIndicator myIndicator;
    private volatile String myStartErrorMessage;
    private volatile boolean myDisposed;
    @Nullable
    private ProcessHandler myProcessHandler;

    public JSLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(2);
        }
        if (cacheData == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(3);
        }
        this.myLock = new Object();
        this.myState = JSLanguageServiceQueue.State.STARTING;
        this.myDisposed = false;
        this.myReporter = reporter;
        LowMemoryWatcher.register(this::resetCaches, (Disposable)this);
        this.myCacheData = cacheData;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myProtocol = protocol;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + reporter.getServiceName()));
        Disposer.register((Disposable)project, (Disposable)this);
        this.init();
    }

    @Override
    @NotNull
    public final JSLanguageServiceQueue.State getState() {
        JSLanguageServiceQueue.State state = this.myState;
        if (state == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(4);
        }
        return state;
    }

    private void init() {
        LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(() -> {
            BackgroundableProcessIndicator indicator = this.createIndicator();
            Object object = this.myLock;
            synchronized (object) {
                if (this.getState() == JSLanguageServiceQueue.State.DISPOSED && indicator != null) {
                    JSLanguageServiceQueueImpl.disposeIndicator(indicator);
                } else {
                    this.myIndicator = indicator;
                }
            }
            if (indicator != null && !indicator.isCanceled()) {
                indicator.start();
            }
            try {
                LOGGER.debug("Start service in thread pool");
                this.startService();
                object = this.myLock;
                synchronized (object) {
                    if (LOGGER.isDebugEnabled() && this.myProcessHandler != null) {
                        LOGGER.debug("Language service successfully started");
                    }
                }
            }
            catch (Throwable e) {
                this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Exception on starting language service", e);
            }
            finally {
                this.createUI();
            }
        });
        this.myExecutorService.submit(() -> {
            try {
                ProcessHandler processHandler;
                Object object = this.myLock;
                synchronized (object) {
                    processHandler = this.myProcessHandler;
                }
                if (processHandler != null && this.getState() == JSLanguageServiceQueue.State.STARTING) {
                    if (this.myProtocol.awaitReadyNotification(processHandler)) {
                        this.myState = JSLanguageServiceQueue.State.STARTED;
                    } else {
                        this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                        if (this.myStartErrorMessage == null) {
                            this.myStartErrorMessage = this.myProtocol.getInitializeError();
                        }
                        String errorText = this.myStartErrorMessage == null ? TIMEOUT_ON_STARTING_SERVICE_PROCESS : this.myStartErrorMessage;
                        UIUtil.invokeLaterIfNeeded(() -> this.myReporter.logError(errorText));
                        this.stop(false);
                    }
                }
            }
            catch (Throwable e) {
                this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Exception on starting language service", e);
            }
            finally {
                BackgroundableProcessIndicator indicator = this.myIndicator;
                if (indicator != null) {
                    indicator.processFinish();
                    JSLanguageServiceQueueImpl.disposeIndicator(indicator);
                }
            }
        });
    }

    private BackgroundableProcessIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return null;
        }
        return (BackgroundableProcessIndicator)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed() || !this.myProject.isOpen() || !this.isValid()) {
                return null;
            }
            return new BackgroundableProcessIndicator(this.myProject, "Starting " + this.myReporter.getServiceName() + " Service", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false);
        });
    }

    private void createUI() {
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ProcessHandler handler;
            Object object = this.myLock;
            synchronized (object) {
                handler = this.myProcessHandler;
                if (this.myProject.isDisposed() || this.myDisposed) {
                    return;
                }
            }
            if (handler != null && this.myProcessConnector != null) {
                this.myProcessConnector.connectToProcessHandler(handler);
            }
            if (handler == null || !this.isValid()) {
                this.myReporter.logError(this.getStartErrorOrTimeout());
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myProtocol.connect();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myProtocol.getInitializeError();
                    return;
                }
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDERR) {
                            JSLanguageServiceQueue.LOGGER.debug("Stderr output: " + event.getText());
                            return;
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            JSLanguageServiceQueue.LOGGER.trace("Stdout output: " + event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        JSLanguageServiceQueueImpl.this.processTerminated();
                        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                            JSLanguageServiceQueue.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT) {
                    this.stop(false);
                }
            }
        }
    }

    protected void processTerminated() {
        if (this.myState == JSLanguageServiceQueue.State.STARTED || this.myState == JSLanguageServiceQueue.State.STARTING) {
            this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
        }
    }

    private static String getExceptionMessage(@NotNull Throwable e) {
        if (e == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(5);
        }
        return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.stop(true);
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(7);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (input == null) {
                    JSLanguageServiceQueueImpl.$$$reportNull$$$0(26);
                }
                if (processor == null) {
                    JSLanguageServiceQueueImpl.$$$reportNull$$$0(27);
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeWithCacheImpl(input, processor);
                    return t;
                }
                catch (Throwable err) {
                    LOGGER.error(err.getMessage(), err);
                }
                finally {
                    this.endAction();
                }
                return null;
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    private <T> T executeWithCacheImpl(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(9);
        }
        long startTime = System.currentTimeMillis();
        Object valueFromCache = this.myCacheData.getValueFromCache(input);
        if (valueFromCache != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Used service cache " + input);
            }
            return processor.processFromCache(input, valueFromCache);
        }
        JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
        if (objectToSend == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip processing: " + input);
            }
            return null;
        }
        this.startAction(input);
        JSLanguageServiceAnswer answer = this.await(input, objectToSend);
        if (answer == null || answer.isEmpty() || this.myState != JSLanguageServiceQueue.State.STARTED) {
            LOGGER.debug("There is no result");
            this.myCacheData.putCacheValue(input, answer, null);
            return null;
        }
        T result2 = processor.process(input, objectToSend, answer);
        this.myCacheData.putCacheValue(input, answer, result2);
        if (LOGGER.isDebugEnabled()) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.debug("Total process queue command " + input.getCommand() + " time, millis: " + totalTime);
        }
        return result2;
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(11);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (command == null) {
                    JSLanguageServiceQueueImpl.$$$reportNull$$$0(24);
                }
                if (processor == null) {
                    JSLanguageServiceQueueImpl.$$$reportNull$$$0(25);
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeImpl(command, processor);
                    return t;
                }
                finally {
                    this.endAction();
                }
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public <T> T executeImpl(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(13);
        }
        long startTime = System.currentTimeMillis();
        JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (serviceObject == null) {
            return null;
        }
        this.startAction(command);
        JSLanguageServiceAnswer answer = this.await(command, serviceObject);
        if (this.myState != JSLanguageServiceQueue.State.STARTED) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        T process = processor.process(serviceObject, answer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Total process queue " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
        }
        return process;
    }

    @Override
    public void executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<JSLanguageServiceAnswer> answerConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(14);
        }
        this.executeNoBlocking(command, answerConsumer, null);
    }

    @Override
    public final void executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<JSLanguageServiceAnswer> answerConsumer, @Nullable Consumer<JSLanguageServiceObject> serviceObjectConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(15);
        }
        try {
            this.myExecutorService.submit(() -> {
                if (command == null) {
                    JSLanguageServiceQueueImpl.$$$reportNull$$$0(23);
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return;
                }
                this.startAction(command);
                try {
                    this.executeNoBlockingImpl(command, answerConsumer, serviceObjectConsumer);
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOGGER.error(throwable.getMessage(), throwable);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
        }
    }

    private void executeNoBlockingImpl(final @NotNull JSLanguageServiceCommand command, final @Nullable Consumer<JSLanguageServiceAnswer> consumer, @Nullable Consumer<JSLanguageServiceObject> afterAwait) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(16);
        }
        final long startTime = System.currentTimeMillis();
        JSLanguageServiceObject data = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (data == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Send data for: " + command.getCommand());
        }
        this.sendData(command, data, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (JSLanguageServiceQueueImpl.this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return;
                }
                JSLanguageServiceQueueImpl.this.endAction();
                if (message != null) {
                    consumer.consume((Object)message);
                    if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                        long processingTime = System.currentTimeMillis() - startTime;
                        JSLanguageServiceQueue.LOGGER.debug("Total process queue non-blocking command " + command.getCommand() + " time, millis: " + processingTime);
                    }
                }
            }
        });
        if (afterAwait != null) {
            afterAwait.consume((Object)data);
        }
    }

    @Nullable
    private JSLanguageServiceAnswer await(JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        if (data == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(17);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start await \"" + command.getCommand() + "\"");
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference ref = new AtomicReference();
            Object cancellationToken = this.sendData(command, data, new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    ref.set(message);
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                this.myProtocol.cancelCommand(cancellationToken);
                LOGGER.warn("JavaScript Language Service: IDE-side timeout waiting answer for " + command.getCommand());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Language Service answer was received: " + command.getCommand());
            }
            return (JSLanguageServiceAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    protected Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(18);
        }
        if (data == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(19);
        }
        return this.myProtocol.sendCommand(command, data, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean awaitPoolTermination) {
        boolean inTest = ApplicationManager.getApplication().isUnitTestMode();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageServiceQueue.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageServiceQueue.State.DISPOSED;
            JSLanguageServiceQueueImpl.disposeIndicator(this.myIndicator);
            this.myExecutorService.shutdown();
            if (!inTest) {
                this.myExecutorService.shutdownNow();
                try {
                    this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Disposer.dispose((Disposable)this.myCacheData);
            Disposer.dispose((Disposable)this.myProtocol);
            this.resetCaches();
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated() && !this.myProcessHandler.isProcessTerminating()) {
                    if (awaitPoolTermination && inTest) {
                        final Semaphore semaphore = new Semaphore();
                        semaphore.down();
                        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                semaphore.up();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl$4", "processTerminated"));
                            }
                        });
                        this.myProcessHandler.destroyProcess();
                        semaphore.waitFor(TimeUnit.SECONDS.toMillis(20L));
                    } else {
                        this.myProcessHandler.destroyProcess();
                    }
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProcessConnector != null) {
                        this.myProcessConnector.disconnectFromProcessHandler();
                    }
                });
            }
        }
        if (awaitPoolTermination && inTest) {
            this.shutdownAndAwaitTermination(this.myExecutorService);
        }
    }

    void shutdownAndAwaitTermination(@NotNull ExecutorService pool) {
        if (pool == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(20);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(3L, TimeUnit.MINUTES)) {
                    LOGGER.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void startAction(@NotNull JSLanguageServiceCommand command) {
        String text;
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(21);
        }
        if (StringUtil.isEmpty((String)(text = command.getPresentableText(this.myProject)))) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    private void endAction() {
        if (this.getState() == JSLanguageServiceQueue.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private static void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                Disposer.dispose((Disposable)indicator);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceQueue.State state = this.myState;
        return state != JSLanguageServiceQueue.State.DISPOSED && state != JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
    }

    private String getStartErrorOrTimeout() {
        return (String)ObjectUtils.coalesce((Object)this.getStartErrorMessage(), (Object)TIMEOUT_ON_STARTING_SERVICE_PROCESS);
    }

    @Override
    public String getStartErrorMessage() {
        return (String)ObjectUtils.coalesce((Object)this.myProtocol.getInitializeError(), (Object)this.myStartErrorMessage);
    }

    @NotNull
    protected JSLanguageServiceProtocol getProtocol() {
        JSLanguageServiceProtocol jSLanguageServiceProtocol = this.myProtocol;
        if (jSLanguageServiceProtocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(22);
        }
        return jSLanguageServiceProtocol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheData";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCache";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCacheImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlocking";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlockingImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "await";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sendData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shutdownAndAwaitTermination";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeNoBlocking$9";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$8";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeWithCache$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

