/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.inspections.JSValidateTypesInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.DefaultTypeProvider;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSTypeChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;

    public JSTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSTypeChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public final void registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.myReporter.registerProblem(place, message, highlightType, this.getValidateTypesInspectionId(), fixes);
    }

    public final void checkExpressionIsAssignableToType(JSExpression expr, String type, String problemKey, @Nullable PsiElement elementToChangeTypeOf, boolean widenLiteralTypes) {
        if ("*".equals(type) || type == null) {
            return;
        }
        this.checkExpressionIsAssignableToType(expr, JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)expr)), problemKey, elementToChangeTypeOf, widenLiteralTypes);
    }

    public final void checkExpressionIsAssignableToType(JSExpression expr, @Nullable JSType jsType, String problemKey, @Nullable PsiElement elementToChangeTypeOf, boolean widenLiteralTypes) {
        this.checkExpressionIsAssignableToType(expr, jsType, null, problemKey, elementToChangeTypeOf, null, widenLiteralTypes);
    }

    public boolean checkExpressionIsAssignableToType(JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, String problemKey, @Nullable PsiElement elementToChangeTypeOf, @Nullable ProcessingContext context, boolean widenLiteralTypes) {
        PsiElement typeOfTarget;
        String typeOfImmediateTarget;
        if (this.canSkipTypeChecking(expr, jsType)) {
            return true;
        }
        PsiFile containingFile = expr.getContainingFile();
        JSType expressionJSType = this.getExpressionTypeForChecking(expr, widenLiteralTypes);
        if (expressionJSType == null) {
            return true;
        }
        if (this.skipByExpressionType(expr, expressionJSType)) {
            return true;
        }
        boolean typeScript = DialectDetector.isTypeScript((PsiElement)containingFile);
        if (!typeScript && expressionJSType instanceof JSNamedType && ((JSNamedType)expressionJSType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        if (typeScript && !expressionJSType.getSource().isStrict()) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile(containingFile);
        if (JSResolveUtil.isAssignableJSType(jsType, expressionJSType, context)) {
            boolean ecma;
            String expressionType = expressionJSType.getResolvedTypeText();
            boolean bl = ecma = holder != null && holder.isECMA4;
            if (ecma && jsType != null && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(expr, jsType.getTypeText(), expressionType)) {
                this.registerExpressionNotAssignableToType(expr, typeOwner, JSBundle.message((String)"javascript.expression.type.implicitly.coerced.to.unrelated.type", (Object[])new Object[]{jsType.getResolvedTypeText(), expressionType}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                return false;
            }
            return true;
        }
        PsiElement expressionTypeSource = expressionJSType.getSource().getSourceElement();
        if (expressionTypeSource instanceof JSObjectLiteralExpression && !(expr.getParent() instanceof JSArgumentList) && !(expr.getParent() instanceof JSReturnStatement) && !(expr.getParent() instanceof JSFunctionExpression) && ((JSObjectLiteralExpression)expressionTypeSource).getProperties().length == 0 && JSTypeUtils.getValuableType(jsType) instanceof JSRecordType) {
            return true;
        }
        JSExpression exprToCheckForProxy = expr;
        if (exprToCheckForProxy instanceof JSCallExpression) {
            exprToCheckForProxy = ((JSCallExpression)exprToCheckForProxy).getMethodExpression();
            if (expr instanceof JSNewExpression && exprToCheckForProxy instanceof JSArrayLiteralExpression) {
                exprToCheckForProxy = null;
            }
        }
        if (exprToCheckForProxy instanceof JSReferenceExpression) {
            exprToCheckForProxy = ((JSReferenceExpression)exprToCheckForProxy).getQualifier();
        }
        if (exprToCheckForProxy != null && !(exprToCheckForProxy instanceof JSLiteralExpression) && (typeOfImmediateTarget = JSResolveUtil.getQualifiedExpressionType(exprToCheckForProxy, containingFile)) != null && (typeOfTarget = JSResolveUtil.findType(typeOfImmediateTarget, (PsiElement)exprToCheckForProxy, true)) instanceof JSClass) {
            if ("XML".equals(typeOfImmediateTarget) || "XMLList".equals(typeOfImmediateTarget) || DialectDetector.isJavaScript((PsiElement)containingFile) && typeOfTarget instanceof XmlBackedJSClass && expr instanceof JSThisExpression) {
                return true;
            }
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement parentClass = resolver.findClassByQName("flash.utils.Proxy", typeOfTarget.getResolveScope());
            if (parentClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)typeOfTarget, (JSClass)parentClass, false)) {
                return true;
            }
        }
        Collection<LocalQuickFix> fixes = JSTypeChecker.getFixes(expr, jsType, elementToChangeTypeOf, containingFile, expressionJSType, holder);
        this.registerExpressionNotAssignableToType(expr, typeOwner, JSBundle.message((String)problemKey, (Object[])new Object[]{jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionJSType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)expr), fixes.toArray(new LocalQuickFix[fixes.size()]));
        return false;
    }

    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        if (expr == null) {
            JSTypeChecker.$$$reportNull$$$0(1);
        }
        return false;
    }

    protected void registerExpressionNotAssignableToType(JSExpression expr, @Nullable PsiElement typeOwner, String message, ProblemHighlightType problemHighlightType, LocalQuickFix ... fixes) {
        this.registerProblem((PsiElement)expr, message, problemHighlightType, fixes);
    }

    @Nullable
    private JSType getExpressionTypeForChecking(@Nullable JSExpression expr, boolean widenLiteralTypes) {
        JSType expressionJSType = this.getExpressionType(expr);
        if (expr != null && widenLiteralTypes) {
            JSType contextual = JSDialectSpecificHandlersFactory.findExpectedType(expr, JSExpectedTypeKind.CONTEXTUAL);
            return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(expressionJSType, contextual);
        }
        return expressionJSType;
    }

    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(expr);
        return JSCompositeTypeImpl.optimizeTypeIfComposite(evaluatedType);
    }

    protected boolean canSkipTypeChecking(JSExpression expr, @Nullable JSType jsType) {
        if (jsType == null || expr == null || JSTypeCastUtil.isAlwaysAssignableType(jsType)) {
            return true;
        }
        if (jsType instanceof JSNamedType && ((JSNamedType)jsType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        return !jsType.getSource().isEcma() && !jsType.getSource().isStrict() && !JSTypeUtils.hasFunctionType(jsType);
    }

    @NotNull
    private static Collection<LocalQuickFix> getFixes(JSExpression expr, @NotNull JSType declaredJSType, final @Nullable PsiElement elementToChangeTypeOf, PsiFile containingFile, JSType expressionJSType, @Nullable DialectOptionHolder holder) {
        String type;
        if (declaredJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(2);
        }
        final String expressionType = expressionJSType.getResolvedTypeText();
        boolean ecma = holder != null && holder.isECMA4;
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String string = type = ecma ? declaredJSType.getResolvedTypeText() : declaredJSType.getTypeText(JSType.TypeTextFormat.CODE);
        if (holder != null && (holder.isTypeScript && declaredJSType instanceof JSNamedType || holder.isECMA4)) {
            LocalQuickFix insertCastFix = ValidateTypesUtil.jsInsertCastFix(type, holder);
            fixes.add(insertCastFix);
            if (holder.isTypeScript) {
                if (declaredJSType.isDirectlyAssignableType(expressionJSType, null) || expressionJSType.isDirectlyAssignableType(declaredJSType, null)) {
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, TypeGuardSurroundKind.IfStatement, null, false, true));
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, TypeGuardSurroundKind.Ternary, null, false, true));
                }
                if (expressionJSType instanceof JSCompositeTypeImpl) {
                    List<JSType> types = ((JSCompositeTypeImpl)expressionJSType).getTypes();
                    boolean hasNullOrUndefined = false;
                    boolean hasOurType = false;
                    boolean hasOtherTypes = false;
                    for (JSType part : types) {
                        if (part.isEquivalentTo(declaredJSType, null, true)) {
                            hasOurType = true;
                            continue;
                        }
                        if (part instanceof JSNullType || part instanceof JSUndefinedType) {
                            hasNullOrUndefined = true;
                            continue;
                        }
                        hasOtherTypes = true;
                    }
                    if (hasNullOrUndefined && hasOurType && !hasOtherTypes) {
                        fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, new JSNullType(expressionJSType.getSource()), TypeGuardSurroundKind.IfStatement, null, true, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(Collections.singletonList(declaredJSType))));
                    }
                }
            }
        }
        if (holder != null && holder.isTypeScript && expr instanceof JSObjectLiteralExpression) {
            fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, declaredJSType));
        }
        ContainerUtil.addIfNotNull(fixes, (Object)ValidateTypesUtil.tryCreateInheritanceFix(type, expressionType, (PsiElement)expr));
        if (elementToChangeTypeOf instanceof JSVariable) {
            PsiComment docComment = null;
            if (elementToChangeTypeOf instanceof JSParameter) {
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)elementToChangeTypeOf, JSFunction.class);
                if (function != null) {
                    if (ecma) {
                        DefaultTypeProvider typeProvider = new DefaultTypeProvider(){

                            @Override
                            public String fun(JSParameterListElement parameter) {
                                return parameter == elementToChangeTypeOf ? expressionType : super.fun(parameter);
                            }
                        };
                        LocalQuickFix fix = ValidateTypesUtil.changeSignatureFix(function, typeProvider, null);
                        fixes.add(fix);
                    } else if (elementToChangeTypeOf.getContainingFile() == containingFile && (docComment = JSDocumentationUtils.findDocComment(elementToChangeTypeOf)) == null) {
                        docComment = JSDocumentationUtils.findFunctionComment(function);
                    }
                }
            } else if (ecma) {
                JSVariable var = (JSVariable)elementToChangeTypeOf;
                if (!(expressionJSType instanceof JSVoidType)) {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)var, expressionType, "javascript.fix.change.type"));
                }
            } else {
                docComment = JSDocumentationUtils.findDocComment(elementToChangeTypeOf);
            }
            if (!ecma && declaredJSType.getSource().isStrict() && docComment != null) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)((JSVariable)elementToChangeTypeOf), (PsiElement)docComment, expressionJSType));
            }
        } else if (elementToChangeTypeOf instanceof JSFunction) {
            JSFunction function = (JSFunction)elementToChangeTypeOf;
            if (ecma) {
                if (JSInheritanceUtil.participatesInHierarchy(function)) {
                    LocalQuickFix fix = ValidateTypesUtil.changeSignatureFix(function, new DefaultTypeProvider(), expressionType);
                    fixes.add(fix);
                } else {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)function, expressionType, "javascript.fix.set.method.return.type"));
                }
            } else {
                JSType typeToUse;
                PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)function);
                JSType jSType = typeToUse = ES6PsiUtil.isAsyncContext(function) ? JSTypeUtils.wrapInPromiseType(expressionJSType) : expressionJSType;
                if (comment != null) {
                    fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)function, (PsiElement)comment, typeToUse));
                }
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSTypeChecker.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        this.checkExpressionIsAssignableToType(expr, p.getType(), problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null), true);
    }

    public void checkTypesInReturnStatement(@NotNull JSElement returnStatementOrShorthandArrowFunctionExpression) {
        JSType actualType;
        JSExpression expression;
        JSFunction fun;
        if (returnStatementOrShorthandArrowFunctionExpression == null) {
            JSTypeChecker.$$$reportNull$$$0(4);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSFunction.class)) == null) {
            return;
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)fun);
        if (returnType == null) {
            return;
        }
        if (returnStatementOrShorthandArrowFunctionExpression instanceof JSReturnStatement) {
            expression = ((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression).getExpression();
            if (expression == null) {
                this.checkEmptyReturnStatement((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression, fun, returnType);
                return;
            }
        } else {
            expression = (JSExpression)returnStatementOrShorthandArrowFunctionExpression;
        }
        if (returnType instanceof JSVoidType && (actualType = JSResolveUtil.getExpressionJSType(expression)) != null && !(actualType instanceof JSVoidType)) {
            this.registerProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSBundle.message((String)"javascript.cannot.return.expression.from.function.with.void.result.type", (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression), ValidateTypesUtil.removeASTNodeFix((PsiElement)expression, "javascript.cannot.return.expression.from.function.with.void.result.type.fix"), ValidateTypesUtil.changeTypeFix((JSNamedElement)fun, actualType.getTypeText(JSType.TypeTextFormat.CODE), "javascript.fix.set.method.return.type"));
            return;
        }
        if (ES6PsiUtil.isAsyncContext(fun)) {
            returnType = this.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        this.checkExpressionIsAssignableToType(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    private void checkEmptyReturnStatement(@NotNull JSReturnStatement node, @NotNull JSFunction function, @NotNull JSType returnType) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(5);
        }
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(6);
        }
        if (returnType == null) {
            JSTypeChecker.$$$reportNull$$$0(7);
        }
        if (!ValidateTypesUtil.emptyReturnIsAcceptable(function, returnType)) {
            String message = JSBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            ProblemHighlightType highlightType = ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node);
            this.registerProblem((PsiElement)node, message, highlightType, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected JSType getAsyncFunctionReturnTypeForValidation(@NotNull JSFunction function, @NotNull JSType declaredType) {
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(8);
        }
        if (declaredType == null) {
            JSTypeChecker.$$$reportNull$$$0(9);
        }
        declaredType = JSTypeUtils.getValuableType(declaredType);
        JSType componentType = JSTypeUtils.getPromiseComponentTypeOrNull(declaredType);
        JSTypeSource typeSource = declaredType.getSource();
        if (componentType != null) {
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(typeSource, declaredType, componentType);
            if (jSCompositeTypeImpl == null) {
                JSTypeChecker.$$$reportNull$$$0(10);
            }
            return jSCompositeTypeImpl;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(typeSource, declaredType, JSAnyType.get((PsiElement)function, typeSource.isStrict()));
        if (jSCompositeTypeImpl == null) {
            JSTypeChecker.$$$reportNull$$$0(11);
        }
        return jSCompositeTypeImpl;
    }

    protected String getValidateTypesInspectionId() {
        return JSValidateTypesInspection.SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredJSType";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatementOrShorthandArrowFunctionExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipByExpressionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInReturnStatement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkEmptyReturnStatement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

