/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.JSTypeInspectionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class TypeScriptTypeInspectionVisitor
extends JSTypeInspectionVisitor {
    @NotNull
    private final TypeScriptAnnotatorCheckerProvider myProvider;

    public TypeScriptTypeInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull TypeScriptAnnotatorCheckerProvider provider2) {
        if (holder == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(1);
        }
        super(holder);
        this.myProvider = provider2;
    }

    private void validateFunctionReturnTypeElement(JSFunction function) {
        JSSourceElement[] body;
        PsiElement typeElement = function.getReturnTypeElement();
        JSType returnType = function.getReturnType();
        boolean isGenerator = function.isGenerator();
        if (!(typeElement == null || ES6PsiUtil.isAsyncContext(function) || isGenerator || returnType instanceof JSVoidType || returnType instanceof JSAnyType || (body = function.getBody()).length <= 0 || ControlFlowUtils.elementContainsReturn((JSElement)body[0]) || !(body[0] instanceof JSStatement) || !ControlFlowUtils.statementMayCompleteNormally((JSStatement)body[0]))) {
            this.getTypeChecker(typeElement).registerProblem(typeElement, JSBundle.message((String)"javascript.validation.message.return.statement.required", (Object[])new Object[0]), TypeScriptUtil.getProblemHighlightTypeForType(returnType), new LocalQuickFix[0]);
            return;
        }
        if (isGenerator && returnType != null) {
            if (typeElement != null) {
                JSType componentType = JSTypeUtils.getIterableComponentType(returnType);
                if (componentType == null) {
                    this.getTypeChecker(typeElement).registerProblem(typeElement, JSBundle.message((String)"typescript.validation.generators.incorrect.type.annotation", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(returnType), new LocalQuickFix[0]);
                } else {
                    JSType iterableRawType = JSNamedType.createExplicitlyDeclaredType("IterableIterator", typeElement);
                    JSGenericTypeImpl iterableIteratorGeneric = new JSGenericTypeImpl(iterableRawType.getSource(), iterableRawType, componentType);
                    if (!returnType.isDirectlyAssignableType((JSType)iterableIteratorGeneric, null)) {
                        this.getTypeChecker(typeElement).registerProblem(typeElement, JSBundle.message((String)"typescript.validation.generators.incorrect.type.annotation.iterable", (Object[])new Object[]{iterableIteratorGeneric.getTypeText(JSType.TypeTextFormat.PRESENTABLE), returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(returnType), new LocalQuickFix[0]);
                    }
                }
            } else {
                boolean noBody;
                boolean bl = noBody = function.getBody().length == 0;
                if (noBody) {
                    return;
                }
                JSType elementType = returnType instanceof JSGenericTypeImpl ? (JSType)ContainerUtil.getFirstItem(((JSGenericTypeImpl)returnType).getArguments()) : null;
                PsiElement identifier = TypeScriptTypeInspectionVisitor.getIdentifierElement(function);
                if ((elementType instanceof JSAnyType || elementType instanceof JSUndefinedType) && !elementType.getSource().isStrict()) {
                    this.getTypeChecker(identifier).registerProblem(identifier, JSBundle.message((String)"typescript.validation.generators.no.yield", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }
        }
        if (typeElement != null && function.isConstructor() && function.getParent() instanceof JSClass) {
            this.getTypeChecker(typeElement).registerProblem(typeElement, JSBundle.message((String)"js.constructor.cant.have.return.type", (Object[])new Object[0]), null, new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static PsiElement getIdentifierElement(JSFunction function) {
        PsiElement identifier = null;
        if (function instanceof JSFunctionExpression) {
            JSQualifiedNamedElement to = ((JSFunctionExpression)function).getElementAssignedTo();
            if (to != null) {
                identifier = to.getNameIdentifier();
            }
        } else {
            identifier = function.getNameIdentifier();
        }
        if (identifier == null && function instanceof JSComputedPropertyNameOwner) {
            identifier = ((JSComputedPropertyNameOwner)function).getComputedPropertyName();
        }
        if (identifier == null) {
            identifier = function;
        }
        PsiElement psiElement = identifier;
        if (psiElement == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (getter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(4);
        }
        if ((retType = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(retType))) == null || setterType == null || retType instanceof JSNullType || retType instanceof JSUndefinedType) {
            return;
        }
        super.validateSetter(setter, getter, param, setterType, retType);
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        this.validateFunctionReturnTypeElement((JSFunction)node);
        super.visitJSFunctionExpression(node);
    }

    @Override
    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(6);
        }
        this.validateFunctionReturnTypeElement(function);
        super.checkFunctionDeclaration(function);
    }

    public void visitJSYieldExpression(JSYieldExpression expression) {
        JSType expressionComponentType;
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        JSExpression subExpression = expression.getExpression();
        if (subExpression == null) {
            return;
        }
        PsiNamedElement containerParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, TypeScriptModule.class, JSFunction.class, ES6Decorator.class});
        JSTypeEvaluationResult typeResult = JSTypeEvaluator.getExpressionType(subExpression);
        if (expression.isIterable()) {
            JSType expressionType;
            JSType jSType = expressionType = typeResult == null ? null : typeResult.getType();
            if (expressionType == null || !TypeScriptTypeInspectionVisitor.validateYieldIterableType(expressionType, expression)) {
                this.getTypeChecker((PsiElement)expression).registerProblem((PsiElement)subExpression, JSBundle.message((String)"typescript.validation.generators.yield.not.iterable", (Object[])new Object[0]), TypeScriptUtil.getProblemHighlightTypeForType(expressionType), new LocalQuickFix[0]);
                return;
            }
            expressionComponentType = JSTypeUtils.getIterableComponentType(expressionType);
        } else {
            JSType jSType = expressionComponentType = typeResult == null ? null : typeResult.getType();
        }
        if (!(containerParent instanceof JSFunction)) {
            return;
        }
        JSFunction function = (JSFunction)containerParent;
        if (function.getReturnTypeElement() == null) {
            return;
        }
        JSType returnType = function.getReturnType();
        if (returnType == null) {
            return;
        }
        JSType componentType = JSTypeUtils.getIterableComponentType(returnType);
        if (componentType != null && expressionComponentType != null && !componentType.isDirectlyAssignableType(expressionComponentType, null)) {
            this.getTypeChecker((PsiElement)subExpression).registerProblem((PsiElement)subExpression, JSBundle.message((String)"typescript.validation.generators.yield.not.assignable.to.return", (Object[])new Object[]{expressionComponentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), componentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), TypeScriptUtil.getProblemHighlightTypeForType(expressionComponentType), new LocalQuickFix[0]);
        }
    }

    private static boolean validateYieldIterableType(JSType jsType, JSYieldExpression expression) {
        JSType iterableType = JSNamedType.createExplicitlyDeclaredType("Iterable", (PsiElement)expression);
        JSGenericTypeImpl type = new JSGenericTypeImpl(iterableType.getSource(), iterableType, JSAnyType.get((PsiElement)expression, true));
        return type.isDirectlyAssignableType(jsType, null);
    }

    @Override
    public void visitJSCallExpression(JSCallExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        if (!this.checkIsCallable(node)) {
            return;
        }
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            PsiElement resolve = ((JSReferenceExpression)methodExpression).resolve();
            if (resolve != null) {
                this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, resolve);
            }
        } else if (methodExpression instanceof JSSuperExpression && JSClassUtils.canHaveClasses((PsiElement)node)) {
            PsiElement element;
            PsiReference psiReference = methodExpression.getReference();
            PsiElement psiElement = element = psiReference != null ? psiReference.resolve() : null;
            if (element != null) {
                this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, element);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, (PsiElement)methodExpression);
        }
    }

    @NotNull
    private JSProblemReporter<Void> getProblemReporter(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(7);
        }
        JSProblemReporter<Void> baseReporter = JSAnalysisHandlersFactory.forElement(context).getProblemReporter(this.myHolder);
        JSProblemReporter<Void> jSProblemReporter = this.myProvider.getTypeCheckProblemReporter(baseReporter);
        if (jSProblemReporter == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(8);
        }
        return jSProblemReporter;
    }

    @Override
    protected JSTypeChecker getTypeChecker(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(9);
        }
        return this.myProvider.getTypeChecker(this.getProblemReporter(context));
    }

    @Override
    @NotNull
    protected JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(10);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = this.myProvider.getSignatureChecker(this.getProblemReporter(context));
        if (jSFunctionSignatureChecker == null) {
            TypeScriptTypeInspectionVisitor.$$$reportNull$$$0(11);
        }
        return jSFunctionSignatureChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/TypeScriptTypeInspectionVisitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptTypeInspectionVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemReporter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProblemReporter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

