/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetDefinitionCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptSignatureHelpCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceEvents {
    @NotNull
    private final Project myProject;

    public static TypeScriptLanguageServiceEvents getService(Project project) {
        return (TypeScriptLanguageServiceEvents)ServiceManager.getService((Project)project, TypeScriptLanguageServiceEvents.class);
    }

    public TypeScriptLanguageServiceEvents(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceEvents.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public Future<TypeScriptSignatureHelpResponse> getSignatureHelp(VirtualFile file, Editor editor, int offset) {
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, editor.getDocument(), offset);
        JSLanguageServiceCommandProcessor<TypeScriptSignatureHelpResponse> processor = (serviceObject, answer) -> {
            JsonObject element = answer.getElement();
            JsonObject body = element.getAsJsonObject("body");
            if (body == null) {
                return null;
            }
            return (TypeScriptSignatureHelpResponse)JSLanguageServiceQueue.GSON.fromJson((JsonElement)body, TypeScriptSignatureHelpResponse.class);
        };
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(this.myProject, file);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        return service.sendCommand(new TypeScriptSignatureHelpCommand(args), processor);
    }

    @Nullable
    public Future<TypeScriptResponseCommon.FileSpan[]> getDeclaration(@NotNull PsiElement sourceElement, @NotNull Document document) {
        VirtualFile file;
        if (sourceElement == null) {
            TypeScriptLanguageServiceEvents.$$$reportNull$$$0(1);
        }
        if (document == null) {
            TypeScriptLanguageServiceEvents.$$$reportNull$$$0(2);
        }
        if ((file = sourceElement.getContainingFile().getVirtualFile()) == null) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(this.myProject, file);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        int offset = sourceElement.getTextRange().getStartOffset();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, document, offset);
        TypeScriptGetDefinitionCommand command = new TypeScriptGetDefinitionCommand(args);
        return service.sendCommand(command, (serviceObject, answer) -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get("body");
            if (jsonElement == null) {
                return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
            }
            TypeScriptResponseCommon.FileSpan[] result2 = (TypeScriptResponseCommon.FileSpan[])JSLanguageServiceQueue.GSON.fromJson(jsonElement, TypeScriptResponseCommon.FileSpan[].class);
            if (result2 != null) {
                return result2;
            }
            return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

