/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSameSignatureCallParametersContributor {
    @NotNull
    public static final InsertHandler<LookupElement> PARAM_LIST_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            int startOffset = context.getTailOffset();
            int endOffset = CharArrayUtil.shiftForwardUntil((CharSequence)context.getDocument().getImmutableCharSequence(), (int)startOffset, (String)")");
            context.getDocument().deleteString(startOffset, endOffset);
        }
    };

    @Nullable
    private static ResolveResult[] resolveCandidates(@NotNull JSCallExpression callExpression, @NotNull JSExpression methodExpression) {
        if (callExpression == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(1);
        }
        boolean isNewCall = callExpression instanceof JSNewExpression;
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] candidates = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (isNewCall) {
                if (candidates.length != 1) {
                    return null;
                }
                if (!candidates[0].isValidResult()) {
                    return null;
                }
                PsiElement classElement = candidates[0].getElement();
                if (!(classElement instanceof JSClass)) {
                    return null;
                }
                JSFunction constructor = ((JSClass)classElement).getConstructor();
                if (!(constructor instanceof TypeScriptFunction)) {
                    return null;
                }
                return (ResolveResult[])TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)constructor).stream().filter(s -> s instanceof TypeScriptFunction && !((TypeScriptFunction)s).isOverloadImplementation()).map(c -> new JSResolveResult((PsiElement)c)).toArray(ResolveResult[]::new);
            }
            return candidates;
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiReference reference = methodExpression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement parentElement = reference.resolve();
            if (!(parentElement instanceof TypeScriptFunction)) {
                return null;
            }
            return (ResolveResult[])TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)parentElement).stream().filter(s -> s instanceof TypeScriptFunction && !((TypeScriptFunction)s).isOverloadImplementation()).map(c -> new JSResolveResult((PsiElement)c)).toArray(ResolveResult[]::new);
        }
        return null;
    }

    @Nullable
    public static List<LookupElement> getSameSignatureCallItems(@NotNull JSReferenceExpression location) {
        PsiElement parent;
        if (location == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(2);
        }
        if (!((parent = location.getParent()) instanceof JSArgumentList)) {
            return null;
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        if (arguments.length != 1 || arguments[0] != location) {
            return null;
        }
        PsiElement call = parent.getParent();
        if (!(call instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)call).getMethodExpression();
        ResolveResult[] candidates = TypeScriptSameSignatureCallParametersContributor.resolveCandidates((JSCallExpression)call, methodExpression);
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        ArrayList matches = ContainerUtil.newArrayList();
        JSFunction container = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)call, JSFunction.class);
        while (container != null) {
            JSParameterList parameterList = container.getParameterList();
            if (parameterList != null) {
                for (ResolveResult candidate : candidates) {
                    Ref invertedOrder;
                    JSFunction from;
                    JSFunction candidateFunction;
                    JSParameterList candidateFunctionParameterList;
                    PsiElement candidateElement;
                    if (!candidate.isValidResult() || !((candidateElement = candidate.getElement()) instanceof JSFunction) || (candidateFunctionParameterList = (candidateFunction = (JSFunction)candidateElement).getParameterList()) == null || parameterList.getParameters().length <= 1 || candidateFunctionParameterList.getParameters().length <= 1 || (from = TypeScriptSameSignatureCallParametersContributor.getMethodToTakeParametersFrom(methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList, (Ref<Boolean>)(invertedOrder = Ref.create((Object)false)))) == null) continue;
                    matches.add(TypeScriptSameSignatureCallParametersContributor.createParametersLookupElement(parameterList.getParameters(), from.getParameters(), (Boolean)invertedOrder.get()));
                }
            }
            container = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)container, JSFunction.class);
        }
        return matches.size() == 0 ? null : matches;
    }

    @NotNull
    private static LookupElement createParametersLookupElement(@NotNull JSParameterListElement[] parameters, @NotNull JSParameterListElement[] fromParameters, boolean inverted) {
        if (parameters == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(3);
        }
        if (fromParameters == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(4);
        }
        String lookupString = StringUtil.join((Object[])(inverted ? fromParameters : parameters), psiParameter -> psiParameter.getName(), (String)", ");
        int w = PlatformIcons.PARAMETER_ICON.getIconWidth();
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 0, 2 * w / 5, 0);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 1);
        LookupElementBuilder element = LookupElementBuilder.create((String)lookupString).withIcon((Icon)icon);
        element = element.withInsertHandler(PARAM_LIST_INSERT_HANDLER);
        LookupElement lookupElement = JSCompletionUtil.withJSLookupPriority((LookupElement)element, JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY_EXOTIC);
        if (lookupElement == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(5);
        }
        return lookupElement;
    }

    @Nullable
    private static JSFunction getMethodToTakeParametersFrom(@NotNull JSExpression methodExpression, @NotNull JSFunction container, @NotNull JSFunction candidateFunction, @NotNull JSParameterList parameterList, @NotNull JSParameterList candidateFunctionParameterList, @NotNull Ref<Boolean> invertedOrder) {
        if (methodExpression == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(6);
        }
        if (container == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(7);
        }
        if (candidateFunction == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(8);
        }
        if (parameterList == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(9);
        }
        if (candidateFunctionParameterList == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(10);
        }
        if (invertedOrder == null) {
            TypeScriptSameSignatureCallParametersContributor.$$$reportNull$$$0(11);
        }
        if (methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSSuperExpression) {
            return candidateFunction;
        }
        HashMap requiredNames = ContainerUtil.newHashMap();
        JSParameterListElement[] parameters = parameterList.getParameters();
        JSParameterListElement[] callParams = candidateFunctionParameterList.getParameters();
        if (callParams.length > parameters.length) {
            return null;
        }
        boolean checkNames = container.isConstructor();
        boolean sameTypes = true;
        for (int i = 0; i < callParams.length; ++i) {
            JSParameterListElement callParam = callParams[i];
            JSParameterListElement parameter = parameters[i];
            JSType callParamType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(callParam.getType(), methodExpression, (PsiElement)candidateFunction);
            requiredNames.put(callParam.getName(), callParamType);
            JSType parameterType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(parameter.getType(), methodExpression, (PsiElement)candidateFunction);
            if (!(checkNames && !Comparing.equal((String)parameter.getName(), (String)callParam.getName()) || callParamType == null && parameterType != null || parameterType == null && callParamType != null) && (callParamType == null || callParamType.isEquivalentTo(parameterType, null, true))) continue;
            sameTypes = false;
        }
        if (sameTypes && callParams.length == parameters.length) {
            return candidateFunction;
        }
        invertedOrder.set((Object)true);
        for (JSParameterListElement parameter : parameters) {
            JSType type = (JSType)requiredNames.remove(parameter.getName());
            JSType parameterType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(parameter.getType(), methodExpression, (PsiElement)container);
            if (type == null || type.isEquivalentTo(parameterType, null, true)) continue;
            return null;
        }
        return requiredNames.isEmpty() ? candidateFunction : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/completion/TypeScriptSameSignatureCallParametersContributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunctionParameterList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptSameSignatureCallParametersContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createParametersLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSameSignatureCallItems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createParametersLookupElement";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMethodToTakeParametersFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

