/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionImpl;
import com.intellij.lang.javascript.types.JSAttributeListElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class TypedJSSpacingProcessor
extends JSSpacingProcessor {
    private static TokenSet FIELD_LIKE_INTERFACE_MEMBERS = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.PROPERTY_SIGNATURE});
    private static TokenSet METHOD_LIKE_INTERFACE_MEMBERS = TokenSet.andNot((TokenSet)TypeScriptElementTypes.TYPE_MEMBERS, (TokenSet)FIELD_LIKE_INTERFACE_MEMBERS);
    private static TokenSet OBJECT_TYPE_DELIMITERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.SEMICOLON, JSTokenTypes.COMMA});

    public TypedJSSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings settings, Language dialect, JSCodeStyleSettings dialectSettings) {
        super(parent, child1, child2, settings, dialect, dialectSettings);
    }

    @Override
    public void visitClass(ASTNode node) {
        if (this.type1 == TypeScriptElementTypes.TYPE_PARAMETER_LIST && JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(this.type2)) {
            this.setSingleSpace(true);
        } else {
            super.visitClass(node);
        }
    }

    @Override
    protected boolean shouldKeepCloseToRelatedMembers() {
        PsiElement psi;
        if (this.type1 == JSStubElementTypes.TYPESCRIPT_FUNCTION && (psi = this.myChild1.getPsi()) instanceof JSFunction && TypeScriptFunctionImpl.hasNextOverloadDeclaration((JSFunction)psi)) {
            return true;
        }
        return super.shouldKeepCloseToRelatedMembers();
    }

    @Override
    public void visitGlobalModuleExport(ASTNode node) {
        if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(this.type1) && this.type2 == JSTokenTypes.EXPORT_KEYWORD) {
            this.decoratorSpacing();
        }
        super.visitGlobalModuleExport(node);
    }

    @Override
    protected void visitFlowJSTypeCast(ASTNode node) {
        this.appendSpacingForTypes();
        if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(false);
        }
        super.visitFlowJSTypeCast(node);
    }

    @Override
    protected void visitTypeScriptTypeArgumentList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LT || this.type2 == JSTokenTypes.GT) {
            this.forceSingleSpace(false);
        }
        this.createCommaSpacing(this.type1, this.type2, 0);
    }

    @Override
    protected void visitTypeScriptTypeParameterList(ASTNode node) {
        this.visitTypeScriptTypeArgumentList(node);
    }

    @Override
    protected void visitDestructuringElement(ASTNode node) {
        this.appendSpacingForTypes();
        super.visitDestructuringElement(node);
    }

    @Override
    protected void visitTypeScriptTypeParameter(ASTNode node) {
        if (this.type1 == JSTokenTypes.EXTENDS_KEYWORD || this.type2 == JSTokenTypes.EXTENDS_KEYWORD) {
            this.forceSingleSpace(true);
        }
        super.visitTypeScriptTypeParameter(node);
    }

    @Override
    public void visitTypeScriptInterface(ASTNode node) {
        if (this.type2 == TypeScriptElementTypes.OBJECT_TYPE) {
            this.setSpaceBeforeLBraceIfMultiline(this.mySettings.CLASS_BRACE_STYLE, this.myJSCodeStyleSettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.type1 instanceof JSAttributeListElementType && this.type2 == JSTokenTypes.INTERFACE_KEYWORD) {
            this.decoratorSpacing();
        }
        if (this.type1 == JSTokenTypes.INTERFACE_KEYWORD) {
            this.forceSingleSpace(true);
        } else {
            this.appendSpaceBeforeGenerics();
            this.processClassOrInterface();
        }
    }

    @Override
    public void visitObjectType(ASTNode node) {
        boolean isInterface;
        boolean bl = isInterface = this.myParent.getTreeParent().getElementType() == JSStubElementTypes.TYPESCRIPT_INTERFACE;
        if (TypeScriptElementTypes.TYPE_MEMBERS.contains(this.type1) && OBJECT_TYPE_DELIMITERS.contains(this.type2)) {
            this.forceSingleSpace(false);
            return;
        }
        if (isInterface) {
            this.processClassBody(METHOD_LIKE_INTERFACE_MEMBERS, FIELD_LIKE_INTERFACE_MEMBERS, OBJECT_TYPE_DELIMITERS, this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE, this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE);
        } else {
            this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_OBJECT_TYPE_BRACES, (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.LBRACE || elementType == JSTokenTypes.LBRACE_OR), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.RBRACE || elementType == JSTokenTypes.OR_RBRACE), (Condition<IElementType>)((Condition)elementType -> elementType == JSTokenTypes.COMMA || elementType == JSTokenTypes.SEMICOLON));
        }
    }

    @Override
    protected void visitTypeScriptEnum(ASTNode node) {
        if (this.type1 == JSTokenTypes.ENUM_KEYWORD) {
            this.forceSingleSpace(true);
        } else if (this.type2 == JSTokenTypes.LBRACE) {
            this.setSpaceBeforeLBraceIfMultiline(this.mySettings.CLASS_BRACE_STYLE, this.mySettings.SPACE_BEFORE_CLASS_LBRACE, true);
        } else if (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitTypeMember(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == TypeScriptElementTypes.INDEX_SIGNATURE && (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET)) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
        if (TypeScriptElementTypes.CALLABLE_TYPE_MEMBERS.contains(type)) {
            this.visitFunctionDeclaration(node);
        }
        if (this.type2 == JSTokenTypes.QUEST) {
            this.forceSingleSpace(false);
        }
        this.appendSpaceBeforeGenerics();
        this.appendSpacingForTypes();
    }

    @Override
    protected void visitTypeScriptType(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == TypeScriptElementTypes.FUNCTION_TYPE) {
            if (this.type1 == JSTokenTypes.EQGT || this.type2 == JSTokenTypes.EQGT) {
                int spaces = this.myJSCodeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (type == TypeScriptElementTypes.TUPLE_TYPE) {
            this.forceSpacesInBrackets(this.mySettings.SPACE_WITHIN_BRACKETS);
        } else if (TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE == type && (this.type1 == JSTokenTypes.OR || this.type1 == JSTokenTypes.AND || this.type2 == JSTokenTypes.OR || this.type2 == JSTokenTypes.AND)) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACES_WITHIN_UNION_TYPES);
        } else if (type == TypeScriptElementTypes.TYPEOF_TYPE && this.type1 == JSTokenTypes.TYPEOF_KEYWORD || type == TypeScriptElementTypes.TYPE_OPERATOR_TYPE && this.type1 == JSTokenTypes.KEYOF_KEYWORD) {
            this.forceSingleSpace(true);
        } else if (type == TypeScriptElementTypes.MAPPED_TYPE) {
            this.visitMappedType(node);
        } else if (type == TypeScriptElementTypes.PARENTHESIZED_TYPE) {
            if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
                this.setSingleSpace(this.mySettings.SPACE_WITHIN_PARENTHESES);
            }
        } else {
            this.appendSpaceBeforeGenerics();
            super.visitTypeScriptType(node);
        }
    }

    private void visitMappedType(ASTNode node) {
        if (this.type1 == JSTokenTypes.READONLY_KEYWORD) {
            this.forceSingleSpace(true);
        } else if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            this.forceSingleSpace(false);
        }
        if (this.type2 == JSTokenTypes.QUEST || this.type2 == JSTokenTypes.SEMICOLON) {
            this.forceSingleSpace(false);
        } else {
            this.setSpaceInBraces(node, 0, 1);
            this.appendSpacingForTypes();
        }
    }

    @Override
    protected void visitMappedTypeParameter(ASTNode node) {
        if (this.type1 == JSTokenTypes.IN_KEYWORD || this.type2 == JSTokenTypes.IN_KEYWORD) {
            this.forceSingleSpace(true);
        }
    }

    @Override
    protected void visitTypeAlias(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else {
            this.appendSpaceBeforeGenerics();
            super.visitTypeAlias(node);
        }
    }

    @Override
    public void visitTypeScriptModule(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            this.setSpaceBeforeLBraceIfMultiline(this.mySettings.CLASS_BRACE_STYLE, this.myJSCodeStyleSettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        } else if (this.type1 instanceof JSAttributeListElementType && (this.type2 == JSTokenTypes.MODULE_KEYWORD || this.type2 == JSTokenTypes.NAMESPACE_KEYWORD)) {
            this.decoratorSpacing();
        }
        if (this.type1 == JSTokenTypes.MODULE_KEYWORD || this.type1 == JSTokenTypes.NAMESPACE_KEYWORD) {
            this.forceSingleSpace(true);
        } else {
            this.processBlock();
        }
    }
}

