/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.SideEffectsVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentWithOperatorAssignmentJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("assignment.replaceable.with.operator.assignment.display.name", new Object[0]);
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            ReplaceAssignmentWithOperatorAssignmentJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("assignment.replaceable.with.operator.assignment.error.string", ReplaceAssignmentWithOperatorAssignmentJSInspection.calculateReplacementExpression((JSAssignmentExpression)args[0]));
    }

    private static String calculateReplacementExpression(JSAssignmentExpression expression) {
        JSBinaryExpression rhs = (JSBinaryExpression)expression.getROperand();
        JSExpression lhs = expression.getLOperand();
        assert (rhs != null);
        IElementType sign = rhs.getOperationSign();
        JSExpression rhsRhs = rhs.getROperand();
        assert (rhsRhs != null);
        String signText = ReplaceAssignmentWithOperatorAssignmentJSInspection.getTextForOperator(sign);
        return lhs.getText() + ' ' + signText + "= " + rhsRhs.getText();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ReplaceAssignmentWithOperatorAssignmentFix((JSAssignmentExpression)location);
    }

    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (JSTokenTypes.PLUS.equals(operator)) {
            return "+";
        }
        if (JSTokenTypes.MINUS.equals(operator)) {
            return "-";
        }
        if (JSTokenTypes.MULT.equals(operator)) {
            return "*";
        }
        if (JSTokenTypes.DIV.equals(operator)) {
            return "/";
        }
        if (JSTokenTypes.PERC.equals(operator)) {
            return "%";
        }
        if (JSTokenTypes.XOR.equals(operator)) {
            return "^";
        }
        if (JSTokenTypes.AND.equals(operator)) {
            return "&";
        }
        if (JSTokenTypes.OR.equals(operator)) {
            return "|";
        }
        if (JSTokenTypes.LTLT.equals(operator)) {
            return "<<";
        }
        if (JSTokenTypes.LTLTEQ.equals(operator)) {
            return "<<=";
        }
        if (JSTokenTypes.GTGT.equals(operator)) {
            return ">>";
        }
        if (JSTokenTypes.GTGTGT.equals(operator)) {
            return ">>>";
        }
        return "unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/assignment/ReplaceAssignmentWithOperatorAssignmentJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            if (assignment == null) {
                ReplaceAssignmentWithOperatorAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSAssignmentExpression(assignment);
            IElementType sign = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(sign)) {
                return;
            }
            JSExpression lhs = assignment.getLOperand();
            JSExpression rhs = assignment.getROperand();
            if (rhs == null || lhs == null) {
                return;
            }
            if (!(rhs instanceof JSBinaryExpression)) {
                return;
            }
            JSBinaryExpression binaryRhs = (JSBinaryExpression)rhs;
            if (binaryRhs.getROperand() == null) {
                return;
            }
            IElementType operationSign = binaryRhs.getOperationSign();
            if (operationSign == JSTokenTypes.ANDAND || operationSign == JSTokenTypes.OROR) {
                return;
            }
            JSExpression lOperand = binaryRhs.getLOperand();
            if (new SideEffectsVisitor().check(lhs)) {
                return;
            }
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(lhs, lOperand)) {
                return;
            }
            this.registerError((PsiElement)assignment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/sixrr/inspectjs/assignment/ReplaceAssignmentWithOperatorAssignmentJSInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitJSAssignmentExpression"));
        }
    }

    private static class ReplaceAssignmentWithOperatorAssignmentFix
    extends InspectionJSFix {
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(JSAssignmentExpression expression) {
            JSBinaryExpression rhs = (JSBinaryExpression)expression.getROperand();
            assert (rhs != null);
            IElementType sign = rhs.getOperationSign();
            String signText = ReplaceAssignmentWithOperatorAssignmentJSInspection.getTextForOperator(sign);
            this.m_name = InspectionJSBundle.message("replace.with.operator.assign.fix", signText);
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                ReplaceAssignmentWithOperatorAssignmentFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSAssignmentExpression expression = (JSAssignmentExpression)descriptor2.getPsiElement();
            String newExpression = ReplaceAssignmentWithOperatorAssignmentJSInspection.calculateReplacementExpression(expression);
            ReplaceAssignmentWithOperatorAssignmentFix.replaceExpression((JSExpression)expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/sixrr/inspectjs/assignment/ReplaceAssignmentWithOperatorAssignmentJSInspection$ReplaceAssignmentWithOperatorAssignmentFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

